/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin;

import java.text.Format;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.format.FormatFactory;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.format.FormatTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.url.UrlService;
import kd.fi.gl.cache.CacheHelper;
import kd.fi.gl.cache.CacheModule;
import kd.fi.gl.cache.DistributeCache;
import kd.fi.gl.closeperiod.ClosePeriodUtils;
import kd.fi.gl.exception.GLErrorCode;
import kd.fi.gl.exception.GLException;
import kd.fi.gl.util.GLApp;

public class PeriodclosedetailsPlugin
extends AbstractFormPlugin
implements ItemClickListener,
ClickListener,
ProgresssListener {
    private static final String FAIL_ENTRY_KEY = "entryentity_err";
    private static final String FAIL_CARD_KEY_MESSAGE_CARD = "message_card";
    private static final String FAIL_CARD_KEY_FORMQUERY_CARD = "formquery_card";
    private static final String FAIL_CARD_KEY_FORMNUMBER_CARD = "formnumber_card";
    private static final String BTN_HANDLE = "handlebtn";
    private static final String BTN_DETAILS = "detailsbtn";
    private static final String CUSTOM_PARAMS_KEY_MODEL = "model";
    private static final String PAGE_CACHE_ORG_ID = "orgId";
    private static final String PAGE_CACHE_ACCOUNTBOOKS = "accountbooks";
    private static final String PAGE_CACHE_PERIOD = "period";
    private static final String AI_RECONCILIATION_RST_FST = "ai_reconciliation_rst_fst";
    private static final String FMR_RECONCILIATION_RST_FST = "frm_reconciliation_rst_fst";
    private DistributeCache cache = CacheHelper.getDistributeCache((CacheModule)CacheModule.periodClose);

    public void initialize() {
        super.initialize();
        ProgressBar bar = (ProgressBar)this.getControl("clockprogress");
        bar.addProgressListener((ProgresssListener)this);
        bar.start();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"buttonap", BTN_HANDLE, BTN_DETAILS});
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object source = evt.getSource();
        if (source instanceof Control) {
            Control control = (Control)source;
            String key = control.getKey();
            EntryGrid billList = (EntryGrid)this.getControl(FAIL_ENTRY_KEY);
            int[] selectRows = billList.getEntryState().getSelectedRows();
            if (selectRows.length <= 0 || selectRows[0] == -1) {
                return;
            }
            DynamicObject dyn = this.getModel().getEntryRowEntity(FAIL_ENTRY_KEY, selectRows[0]);
            if (dyn == null) {
                return;
            }
            String periodStr = this.getPageCache().get(PAGE_CACHE_PERIOD);
            Long periodId = StringUtils.isBlank((CharSequence)periodStr) ? 0L : Long.parseLong(periodStr);
            String formNumber = dyn.getString(FAIL_CARD_KEY_FORMNUMBER_CARD);
            String queryContitions = dyn.getString(FAIL_CARD_KEY_FORMQUERY_CARD);
            if (key.equals(BTN_HANDLE)) {
                if ("gl_voucherbreakpoint".equals(formNumber)) {
                    String bookStr = this.getPageCache().get(PAGE_CACHE_ACCOUNTBOOKS);
                    String orgStr = this.getPageCache().get(PAGE_CACHE_ORG_ID);
                    if (StringUtils.isNotBlank((CharSequence)bookStr) && StringUtils.isNotBlank((CharSequence)orgStr)) {
                        ClosePeriodUtils.createVoucherBreakPoingOnCloseDetail((Long)Long.valueOf(bookStr), (Long)Long.valueOf(orgStr), (Long)periodId, (IFormView)this.getView());
                    }
                } else if (AI_RECONCILIATION_RST_FST.equals(formNumber) || FMR_RECONCILIATION_RST_FST.equals(formNumber)) {
                    HashMap<String, String> customParams = new HashMap<String, String>(1);
                    customParams.put(CUSTOM_PARAMS_KEY_MODEL, queryContitions);
                    ClosePeriodUtils.createFormOnCloseDetail((String)formNumber, customParams, (IFormView)this.getView());
                } else if ("gl_voucher".equals(formNumber)) {
                    QFilter filter = null;
                    try {
                        filter = QFilter.fromSerializedString((String)queryContitions);
                    }
                    catch (Exception e) {
                        throw new GLException(GLErrorCode.common, new Object[]{ResManager.loadKDString((String)"\u8df3\u8f6c\u51ed\u8bc1\u5217\u8868\u7684\u8fc7\u6ee4\u6761\u4ef6\u4e0d\u5b58\u5728\u3002", (String)"PeriodclosedetailsPlugin_0", (String)"fi-gl-formplugin", (Object[])new Object[0])});
                    }
                    ClosePeriodUtils.createVoucherListOnCloseDetail((QFilter)filter, (Long)periodId, (IFormView)this.getView());
                } else {
                    ClosePeriodUtils.createJumpInterfaceOnCloseDetail((String)formNumber, (String)queryContitions, (IFormView)this.getView());
                }
            } else if (key.equals(BTN_DETAILS)) {
                if (AI_RECONCILIATION_RST_FST.equals(formNumber) || FMR_RECONCILIATION_RST_FST.equals(formNumber)) {
                    HashMap<String, String> customParams = new HashMap<String, String>(1);
                    customParams.put(CUSTOM_PARAMS_KEY_MODEL, queryContitions);
                    ClosePeriodUtils.createFormOnCloseDetail((String)formNumber, customParams, (IFormView)this.getView());
                } else {
                    this.getView().showMessage(dyn.getString(FAIL_CARD_KEY_MESSAGE_CARD));
                }
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("periodclosebtn".equals(itemKey)) {
            String accountId = this.getPageCache().get("accountId");
            QFilter filter = new QFilter("id", "=", (Object)Long.valueOf(accountId));
            QFilter[] filters = new QFilter[]{filter};
            DynamicObject[] accountingentityColl = BusinessDataServiceHelper.load((String)"gl_closestate", (String)"id, company, thisclosetime, linestate,entryentity.checkitem, entryentity.checkstate, entryentity.formquery, entryentity.formnumber, entryentity.message, entryentity.menuid", (QFilter[])filters);
            if (accountingentityColl != null && accountingentityColl.length > 0) {
                accountingentityColl[0].set("linestate", (Object)"2");
                SaveServiceHelper.save((DynamicObject[])accountingentityColl);
                this.getView().returnDataToParent(accountingentityColl[0].getDynamicObject("company").getPkValue());
            }
            this.getView().close();
        }
    }

    public void createNewData(BizDataEventArgs e) {
        super.createNewData(e);
        this.setCurDate();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long period = this.initCheckItemCard();
        if (period == null || period == 0L) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"periodclosebtn"});
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7ed3\u8d26\u64cd\u4f5c\u672a\u6267\u884c\u5b8c\u6210\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"PeriodclosedetailsPlugin_9", (String)GLApp.instance.formpluginModule(), (Object[])new Object[0]));
            return;
        }
        this.setCurPeriod(period);
        int rowcount_err = this.getModel().getEntryRowCount(FAIL_ENTRY_KEY);
        int rowcount_suc = this.getModel().getEntryRowCount("entryentity_suc");
        if (rowcount_err == 0) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"default_mid"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"errcheckflex"});
        }
        if (rowcount_suc == 0) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"default_but"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"succheckflex"});
        }
        if (this.getView().getFormShowParameter().getCustomParam("checkItems") != null) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"periodclosebtn"});
        }
    }

    private Map<String, String> getMenuInfo(String menuId) {
        ArrayList<String> menuIDList = new ArrayList<String>(1);
        menuIDList.add(menuId);
        List<Map<String, String>> list = this.getMenuInfo(menuIDList);
        return list.isEmpty() ? new HashMap() : list.get(0);
    }

    private List<Map<String, String>> getMenuInfo(List<String> menuIdList) {
        ArrayList<Map<String, String>> menuInfoList = new ArrayList<Map<String, String>>(menuIdList.size());
        return menuInfoList;
    }

    private void setCurPeriod(Long period) {
        QFilter filter = new QFilter("id", "=", (Object)period);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObjectCollection periodColl = QueryServiceHelper.query((String)"bd_period", (String)"id,begindate,enddate,periodyear,periodnumber", (QFilter[])filters);
        int periodyear = (Integer)((DynamicObject)periodColl.get(0)).get("periodyear");
        int periodnumber = (Integer)((DynamicObject)periodColl.get(0)).get("periodnumber");
        Label periodLabe = (Label)this.getControl("periodlabe");
        Label yearLabe = (Label)this.getControl("yearlabe");
        periodLabe.setText(String.format(ResManager.loadKDString((String)"%s\u671f", (String)"PeriodclosedetailsPlugin_1", (String)"fi-gl-formplugin", (Object[])new Object[0]), "" + periodnumber));
        yearLabe.setText(String.format(ResManager.loadKDString((String)"%s\u5e74", (String)"PeriodclosedetailsPlugin_2", (String)"fi-gl-formplugin", (Object[])new Object[0]), "" + periodyear));
    }

    public String getWeek(Date date) {
        Lang lang = RequestContext.get().getLang();
        Locale locale = Locale.US;
        if (Lang.zh_CN.equals((Object)lang)) {
            locale = Locale.CHINA;
        } else if (Lang.zh_TW.equals((Object)lang)) {
            locale = Locale.TAIWAN;
        }
        return new SimpleDateFormat("EEEE", locale).format(date);
    }

    public Date strToDate(String strDate) {
        SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
        ParsePosition pos = new ParsePosition(0);
        Date strtodate = formatter.parse(strDate, pos);
        return strtodate;
    }

    public void onProgress(ProgressEvent arg0) {
        this.setCurDate();
    }

    private void setCurDate() {
        Date date = new Date();
        Long userID = Long.valueOf(RequestContext.get().getUserId());
        FormatObject formatObject = InteServiceHelper.getUserFormat((Long)userID);
        Format formatter2 = FormatFactory.get((FormatTypes)FormatTypes.Date).getFormat(formatObject);
        SimpleDateFormat formatter = new SimpleDateFormat("HH:mm");
        String hms = formatter.format(date);
        String hms2 = formatter2.format(date);
        String day = this.getWeek(date);
        Label timeLabe = (Label)this.getControl("timelabe");
        Label dateLabe = (Label)this.getControl("datelabe");
        timeLabe.setText(hms);
        dateLabe.setText(hms2 + "  " + day);
    }

    private Long initCheckItemCard() {
        DynamicObject sd;
        DynamicObjectCollection checkItemColl;
        String s = this.cache.get(this.getView().getFormShowParameter().getCustomParams().get("closeKey") + "");
        if (StringUtils.isBlank((CharSequence)s)) {
            return 0L;
        }
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map map = parameter.getCustomParams();
        Object obj = map.get("accountId");
        this.getPageCache().put("accountId", String.valueOf(obj));
        QFilter filter = new QFilter("id", "=", (Object)Long.parseLong(obj.toString()));
        QFilter[] filters = new QFilter[]{filter};
        DynamicObjectCollection closestateColl = QueryServiceHelper.query((String)"gl_closestate", (String)"id, company, subsysformnum, accountbooks, period, thisclosetime,closedetails", (QFilter[])filters);
        if (closestateColl.size() == 0) {
            return null;
        }
        Long companyid = ((DynamicObject)closestateColl.get(0)).getLong("company");
        Object curPeriod = this.getView().getFormShowParameter().getCustomParam("curperiod");
        Long period = StringUtils.isBlank((Object)curPeriod) ? ((DynamicObject)closestateColl.get(0)).getLong(PAGE_CACHE_PERIOD) : Long.parseLong(curPeriod.toString());
        if (StringUtils.isEmpty((CharSequence)s)) {
            String string = s = map.get("checkItems") == null ? "" : map.get("checkItems").toString();
        }
        if ((checkItemColl = (sd = (DynamicObject)DataEntitySerializer.deSerializerFromString((String)s, (IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bd_closecheckitem"))).getDynamicObjectCollection("entryentity")).size() == 0) {
            return null;
        }
        this.getPageCache().put(PAGE_CACHE_ACCOUNTBOOKS, ((DynamicObject)closestateColl.get(0)).getString(PAGE_CACHE_ACCOUNTBOOKS));
        this.getPageCache().put(PAGE_CACHE_ORG_ID, String.valueOf(companyid));
        this.getPageCache().put(PAGE_CACHE_PERIOD, String.valueOf(period));
        QFilter comFilter = new QFilter("id", "=", (Object)companyid);
        QFilter[] comFilters = new QFilter[]{comFilter};
        DynamicObject companyObj = QueryServiceHelper.queryOne((String)"bos_org", (String)"id, name", (QFilter[])comFilters);
        String companyName = companyObj.getString("name");
        Long thisclosetime = ((DynamicObject)closestateColl.get(0)).getLong("thisclosetime");
        String time = PeriodclosedetailsPlugin.converLongTimeToStr(thisclosetime);
        int itemNum = checkItemColl.size();
        int errNum = 0;
        int sucNum = 0;
        for (int i = 0; i < checkItemColl.size(); ++i) {
            DynamicObject checkItemObj = (DynamicObject)checkItemColl.get(i);
            String checkstate = checkItemObj.getString("checkstate");
            if ("0".equals(checkstate)) {
                this.genErrItemCard(checkItemObj);
                ++errNum;
                continue;
            }
            if (!"1".equals(checkstate)) continue;
            this.genSucItemCard(checkItemObj);
            ++sucNum;
        }
        this.setLabe(companyName, time, itemNum + "", errNum + "", sucNum + "");
        return period;
    }

    private void genErrItemCard(DynamicObject closestateObj) {
        String rootUrl;
        String checkname = closestateObj.getString("checkitem");
        String formquery = closestateObj.getString("formquery");
        String formnumber = closestateObj.getString("formnumber");
        String message = closestateObj.getString("message");
        String menuid = closestateObj.getString("menuid");
        Map<String, String> map = this.getMenuInfo(menuid);
        String url = map.get("icon");
        String url3 = map.get("picon");
        if (kd.bos.util.StringUtils.isEmpty((String)url)) {
            url = url3;
        }
        if ((rootUrl = UrlService.getDomainContextUrl()).endsWith("/")) {
            rootUrl = rootUrl.substring(0, rootUrl.length() - 1);
        }
        menuid = menuid.startsWith("/") ? rootUrl + menuid : rootUrl + "/" + menuid;
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("checkname_err", new Object[0]);
        vs.addField(FAIL_CARD_KEY_FORMQUERY_CARD, new Object[0]);
        vs.addField(FAIL_CARD_KEY_FORMNUMBER_CARD, new Object[0]);
        vs.addField(FAIL_CARD_KEY_MESSAGE_CARD, new Object[0]);
        vs.addField("icon_err", new Object[0]);
        vs.addRow(new Object[]{checkname, formquery, formnumber, message, menuid});
        model.batchCreateNewEntryRow(FAIL_ENTRY_KEY, vs);
        model.endInit();
        this.getView().updateView(FAIL_ENTRY_KEY);
    }

    private void genSucItemCard(DynamicObject closestateObj) {
        String rootUrl;
        String checkname = closestateObj.getString("checkitem");
        String menuid = closestateObj.getString("menuid");
        Map<String, String> map = this.getMenuInfo(menuid);
        String url = map.get("icon");
        String url3 = map.get("picon");
        if (kd.bos.util.StringUtils.isEmpty((String)url)) {
            url = url3;
        }
        if ((rootUrl = UrlService.getDomainContextUrl()).endsWith("/")) {
            rootUrl = rootUrl.substring(0, rootUrl.length() - 1);
        }
        menuid = menuid.startsWith("/") ? rootUrl + menuid : rootUrl + "/" + menuid;
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("checkname_suc", new Object[0]);
        vs.addField("icon_suc", new Object[0]);
        vs.addRow(new Object[]{checkname, menuid});
        model.batchCreateNewEntryRow("entryentity_suc", vs);
        model.endInit();
        this.getView().updateView("entryentity_suc");
    }

    public Map<String, String> mapStringToMap(String str) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            String[] strs;
            str = str.substring(1, str.length() - 1);
            for (String string : strs = str.split(",")) {
                String key = string.split("=")[0];
                String value = "";
                try {
                    value = string.split("=")[1];
                    if ("!".equals(value) || "<".equals(value) || ">".equals(value)) {
                        value = value + "=";
                    }
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    value = "=";
                }
                map.put(key.trim(), value.trim());
            }
        }
        catch (Exception e) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8fc7\u6ee4\u6761\u4ef6\u6709\u8bef\uff0c\u6253\u5f00\u8868\u5355\u5931\u8d25\u3002", (String)"PeriodclosedetailsPlugin_3", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        }
        return map;
    }

    private void setLabe(String companyName, String time, String itemNum, String errNum, String sucNum) {
        Label orgindex = (Label)this.getControl("orgindex");
        orgindex.setText(companyName);
        Label timeconsuminglabel = (Label)this.getControl("timeconsuminglabel");
        timeconsuminglabel.setText(time);
        Label errorlabe = (Label)this.getControl("errorlabe");
        errorlabe.setText(String.format(ResManager.loadKDString((String)"\u5171\u68c0\u67e5%1$s\u9879\u5185\u5bb9\uff0c\u4ee5\u4e0b%2$s\u9879\u6709\u95ee\u9898", (String)"PeriodclosedetailsPlugin_4", (String)"fi-gl-formplugin", (Object[])new Object[0]), itemNum, errNum));
        Label suclabe = (Label)this.getControl("suclabe");
        suclabe.setText(String.format(ResManager.loadKDString((String)"\u4ee5\u4e0b%s\u9879\u65e0\u95ee\u9898", (String)"PeriodclosedetailsPlugin_7", (String)"fi-gl-formplugin", (Object[])new Object[0]), sucNum));
    }

    public static String converLongTimeToStr(long time) {
        int ss = 1000;
        int mi = ss * 60;
        int hh = mi * 60;
        long hour = time / (long)hh;
        long minute = (time - hour * (long)hh) / (long)mi;
        long second = (time - hour * (long)hh - minute * (long)mi) / (long)ss;
        String strHour = hour < 10L ? "0" + hour : "" + hour;
        String strMinute = minute < 10L ? "0" + minute : "" + minute;
        String strSecond = second < 10L ? "0" + second : "" + second;
        return strHour + ":" + strMinute + ":" + strSecond;
    }
}

