/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ITimeService;
import kd.bos.service.IUserService;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.bd.util.BatchProcessUtil;
import kd.fi.gl.accountref.utils.BalanceTransferUtils;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.cache.CacheHelper;
import kd.fi.gl.cache.CacheModule;
import kd.fi.gl.cache.DistributeCache;
import kd.fi.gl.common.Task;
import kd.fi.gl.reciprocal.ReciprocalUtils;
import kd.fi.gl.service.GLThreadService;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.PermissonType;

public class ReciprocalAutoWriteOffPlugin
extends AbstractFormPlugin
implements ClickListener,
ProgresssListener {
    private DistributeCache cache = CacheHelper.getDistributeCache((CacheModule)CacheModule.writeoff);
    private static final String select_fileds = "number,name,useorg,account,currency,verifiorder,reverordersamedire,noverifibusinoempty,moneyequacanverfi,excluunpostvoucher";
    private static final String ORG = "org";
    private static final String BOOK_TYPE = "booktype";
    private Map<Long, String> accountMap = new HashMap<Long, String>();
    private static final String WRITEOFF = "writeoff";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{WRITEOFF});
        ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
        bar.addProgressListener((ProgresssListener)this);
        this.filterOrg();
        this.filterBookType();
        this.filterPeriod("startperiod");
        this.filterPeriod("endperiod");
        this.filterAccount();
    }

    private void filterAccount() {
        BasedataEdit account = (BasedataEdit)this.getControl("account");
        account.addBeforeF7SelectListener(evt -> {
            ListShowParameter sp = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter listFilterParameter = sp.getListFilterParameter();
            List qFilters = listFilterParameter.getQFilters();
            Long orgId = 0L;
            if (this.getPageCache().get(ORG) != null) {
                orgId = Long.valueOf(this.getPageCache().get(ORG));
            }
            QFilter orgfilter = null;
            if (orgId > 0L) {
                orgfilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)orgId);
                qFilters.add(orgfilter);
            }
            QFilter isLeafQfilter = new QFilter("isleaf", "=", (Object)"1");
            QFilter reciQfFilter = new QFilter("accheck", "=", (Object)"1");
            Long booktypeId = Long.valueOf(this.getPageCache().get(BOOK_TYPE) == null ? "0" : this.getPageCache().get(BOOK_TYPE));
            DynamicObject accontbook = this.queryAccountBook(orgId, booktypeId);
            Long accounttableid = 0L;
            if (accontbook != null) {
                accounttableid = accontbook.getLong("accounttableid");
                this.getPageCache().put("accounttableid", accounttableid.toString());
            }
            QFilter accounttableFilter = new QFilter("accounttable", "=", (Object)accounttableid);
            qFilters.add(isLeafQfilter);
            qFilters.add(reciQfFilter);
            qFilters.add(accounttableFilter);
            QFilter refAcctFilter = new QFilter("enddate", "=", (Object)BalanceTransferUtils.getEndDate());
            qFilters.add(ReciprocalUtils.queryEndInitActFilter(Collections.singleton(orgId), (Long)booktypeId));
            qFilters.add(refAcctFilter);
        });
    }

    private void filterPeriod(String key) {
        BasedataEdit period = (BasedataEdit)this.getControl(key);
        period.addBeforeF7SelectListener(evt -> {
            ListShowParameter sp = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter listFilterParameter = sp.getListFilterParameter();
            List qFilters = listFilterParameter.getQFilters();
            qFilters.add(this.getPeriodQfilter());
            DynamicObject periodObj = (DynamicObject)this.getModel().getValue(key);
            if (periodObj != null) {
                sp.setSelectedRow(periodObj.getPkValue());
            }
        });
    }

    private QFilter getPeriodQfilter() {
        Long orgId = 0L;
        if (this.getPageCache().get(ORG) != null) {
            orgId = Long.valueOf(this.getPageCache().get(ORG));
        }
        Long booktypeId = 0L;
        if (this.getPageCache().get(BOOK_TYPE) != null) {
            booktypeId = Long.valueOf(this.getPageCache().get(BOOK_TYPE));
        }
        DynamicObject accontbook = this.queryAccountBook(orgId, booktypeId);
        Long periodtypeid = 0L;
        Long startperiodid = 0L;
        if (accontbook != null) {
            periodtypeid = accontbook.getLong("periodtypeid");
            startperiodid = accontbook.getLong("startperiodid");
        }
        QFilter periodTypefilter = new QFilter("periodtype", "=", (Object)periodtypeid);
        QFilter startPeriodFilter = new QFilter("id", ">=", (Object)startperiodid);
        DynamicObjectCollection periods = QueryServiceHelper.query((String)"bd_period", (String)"id", (QFilter[])new QFilter[]{periodTypefilter, startPeriodFilter}, (String)"id asc");
        ArrayList<Long> periodList = new ArrayList<Long>();
        for (DynamicObject dyn : periods) {
            periodList.add(dyn.getLong("id"));
        }
        return new QFilter("id", "in", periodList);
    }

    private void filterBookType() {
        BasedataEdit booktype = (BasedataEdit)this.getControl(BOOK_TYPE);
        booktype.addBeforeF7SelectListener(evt -> {
            ListShowParameter sp = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter listFilterParameter = sp.getListFilterParameter();
            List qFilters = listFilterParameter.getQFilters();
            DynamicObject orgDynamicObject = (DynamicObject)this.getModel().getValue(ORG);
            Long orgid = 0L;
            if (orgDynamicObject != null) {
                orgid = orgDynamicObject.getLong("id");
            }
            List bookType = AccSysUtil.getAllBookTypeByOrg((long)orgid);
            qFilters.add(new QFilter("id", "in", (Object)bookType));
        });
    }

    private void filterOrg() {
        BasedataEdit org = (BasedataEdit)this.getControl(ORG);
        org.addBeforeF7SelectListener(evt -> {
            ListShowParameter sp = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter listFilterParameter = sp.getListFilterParameter();
            List qFilters = listFilterParameter.getQFilters();
            qFilters.add(new QFilter("id", "in", this.getAllOrg()));
        });
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"processlable", "leftbrackets", "haswriteoffcount", "percent", "allcount", "rightbrackets"});
        this.setDefaultValue();
    }

    private void setDefaultValue() {
        List<Long> orgList = this.getAllOrg();
        Long orgId = 0L;
        if (orgList != null && !orgList.isEmpty()) {
            orgId = orgList.get(0);
            long defaultOrgId = AccSysUtil.getDefaultOrgId((String)this.getView().getEntityId(), (boolean)false, (PermissonType)PermissonType.VIEW);
            if (orgList.contains(defaultOrgId)) {
                orgId = defaultOrgId;
            }
            this.getModel().setValue(ORG, (Object)orgId);
            this.getPageCache().put(ORG, orgId + "");
        }
        Long booktypeId = this.setBookTypeByOrgid(orgId);
        this.getPageCache().put(BOOK_TYPE, booktypeId + "");
        this.setPeriodByOrgAndBooktype(orgId, booktypeId);
        this.setDeafaultAccount();
    }

    private void setDeafaultAccount() {
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        Long orgId = 0L;
        if (this.getPageCache().get(ORG) != null) {
            orgId = Long.valueOf(this.getPageCache().get(ORG));
        }
        QFilter orgfilter = null;
        if (orgId > 0L) {
            orgfilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)orgId);
            list.add(orgfilter);
        }
        QFilter isLeafQfilter = new QFilter("isleaf", "=", (Object)"1");
        QFilter reciQfFilter = new QFilter("accheck", "=", (Object)"1");
        Long booktypeId = Long.valueOf(this.getPageCache().get(BOOK_TYPE) == null ? "0" : this.getPageCache().get(BOOK_TYPE));
        DynamicObject accontbook = this.queryAccountBook(orgId, booktypeId);
        Long accounttableid = 0L;
        if (accontbook != null) {
            accounttableid = accontbook.getLong("accounttableid");
            this.getPageCache().put("accounttableid", accounttableid.toString());
        }
        QFilter accounttableFilter = new QFilter("accounttable", "=", (Object)accounttableid);
        QFilter qdate = new QFilter("enddate", ">=", (Object)GLUtil.getEndDate());
        list.add(qdate);
        list.add(isLeafQfilter);
        list.add(reciQfFilter);
        list.add(accounttableFilter);
        list.add(ReciprocalUtils.queryEndInitActFilter(Collections.singleton(orgId), (Long)booktypeId));
        DynamicObjectCollection dyns = QueryServiceHelper.query((String)"bd_accountview", (String)"id", (QFilter[])list.toArray(new QFilter[0]), (String)"number asc");
        if (dyns != null && !dyns.isEmpty()) {
            this.getModel().setValue("account", (Object)new Long[]{((DynamicObject)dyns.get(0)).getLong("id")});
        } else {
            this.getModel().setValue("account", null);
        }
    }

    private void setPeriodByOrgAndBooktype(Long orgId, Long booktypeId) {
        DynamicObject accontbook = this.queryAccountBook(orgId, booktypeId);
        if (accontbook != null) {
            this.getModel().setValue("startperiod", (Object)accontbook.getString("curperiodid"));
            this.getModel().setValue("endperiod", (Object)accontbook.getString("curperiodid"));
        }
    }

    private Long setBookTypeByOrgid(Long orgId) {
        Long booktypeid = 0L;
        List books = AccSysUtil.getAllBookTypeByOrg((long)orgId);
        if (books != null && !books.isEmpty()) {
            booktypeid = (Long)books.get(0);
            this.getModel().setValue(BOOK_TYPE, (Object)booktypeid);
            if (AccSysUtil.getAllBookTypeCount() == 1) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{BOOK_TYPE});
            } else {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{BOOK_TYPE});
            }
        }
        return booktypeid;
    }

    private DynamicObject queryAccountBook(Long orgId, Long booktypeId) {
        QFilter orgQFilter = new QFilter(ORG, "=", (Object)orgId);
        QFilter bookTypeQfFilter = new QFilter("bookstype", "=", (Object)booktypeId);
        String selectFields = "accounttable.id accounttableid,periodtype.id periodtypeid,startperiod.id startperiodid,curperiod.id curperiodid";
        DynamicObject accontbook = QueryServiceHelper.queryOne((String)"gl_accountbook", (String)selectFields, (QFilter[])new QFilter[]{orgQFilter, bookTypeQfFilter});
        return accontbook;
    }

    private List<Long> getAllOrg() {
        ArrayList<Long> orgList = new ArrayList<Long>();
        List acctOrgPkList = AccSysUtil.getAcctOrgPkList((String)"gl_reci_autowriteoff", (boolean)false, (PermissonType)PermissonType.VIEW);
        DynamicObjectCollection dyns = BatchProcessUtil.batchQueryDynColl((Collection)acctOrgPkList, batchData -> QueryServiceHelper.query((String)"gl_accountbook", (String)"org.id orgId,org.number,org.name orgname", (QFilter[])new QFilter[]{new QFilter(ORG, "in", batchData)}, (String)"org.number"));
        for (DynamicObject dyn : dyns) {
            orgList.add(dyn.getLong("orgId"));
        }
        List<Long> reciInitOrgList = this.getReciInitOrgList();
        orgList.retainAll(reciInitOrgList);
        return orgList;
    }

    private List<Long> getReciInitOrgList() {
        ArrayList<Long> reciInitOrgList = new ArrayList();
        String sql = "select distinct(forgid) org from t_gl_reci_init_state";
        reciInitOrgList = (List)DB.query((DBRoute)DBRoute.of((String)"gl"), (String)sql, null, rs -> {
            ArrayList<Long> list = new ArrayList<Long>(10);
            while (rs.next()) {
                list.add(rs.getLong(ORG));
            }
            return list;
        });
        return reciInitOrgList;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String keyName = e.getProperty().getName();
        Object value = e.getChangeSet()[0].getNewValue();
        if (value != null) {
            switch (keyName) {
                case "org": {
                    this.changeOrg();
                    break;
                }
                case "booktype": {
                    this.changeBookType();
                    break;
                }
                case "startperiod": {
                    long sp = ((DynamicObject)value).getLong("id");
                    long ep = (Long)this.getModel().getValue("endperiod_id");
                    if (ep != 0L && ep >= sp) break;
                    this.getModel().setValue("endperiod", (Object)sp);
                    break;
                }
                case "endperiod": {
                    long endPeriod = ((DynamicObject)value).getLong("id");
                    long startPeriod = (Long)this.getModel().getValue("startperiod_id");
                    if (startPeriod != 0L && startPeriod <= endPeriod) break;
                    this.getModel().setValue("startperiod", (Object)endPeriod);
                    break;
                }
            }
        }
    }

    private void changeBookType() {
        Long orgId = 0L;
        if (this.getPageCache().get(ORG) != null) {
            orgId = Long.valueOf(this.getPageCache().get(ORG));
        }
        if (this.getModel().getValue(BOOK_TYPE) == null) {
            return;
        }
        Long booktypeId = ((DynamicObject)this.getModel().getValue(BOOK_TYPE)).getLong("id");
        this.setPeriodByOrgAndBooktype(orgId, booktypeId);
        this.getPageCache().put(BOOK_TYPE, booktypeId + "");
        this.setDeafaultAccount();
    }

    private void changeOrg() {
        if (this.getModel().getValue(ORG) == null) {
            return;
        }
        Long orgId = ((DynamicObject)this.getModel().getValue(ORG)).getLong("id");
        Long booktypeId = this.setBookTypeByOrgid(orgId);
        this.setPeriodByOrgAndBooktype(orgId, booktypeId);
        this.getPageCache().put(ORG, orgId + "");
        this.getPageCache().put(BOOK_TYPE, booktypeId + "");
        this.setDeafaultAccount();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        switch (key = op.getOperateKey()) {
            case "autowriteoff": {
                DynamicObject defaultScheme;
                if (!this.notNullCheck()) {
                    return;
                }
                Long orgId = Long.parseLong(((DynamicObject)this.getModel().getValue(ORG)).getString("id") == null ? "0" : ((DynamicObject)this.getModel().getValue(ORG)).getString("id"));
                Long bookType = Long.parseLong(((DynamicObject)this.getModel().getValue(BOOK_TYPE)).getString("id") == null ? "0" : ((DynamicObject)this.getModel().getValue(BOOK_TYPE)).getString("id"));
                AccountBookInfo bookInfo = AccSysUtil.getBookFromAccSys((long)orgId, (long)bookType);
                if (bookInfo == null || !"1".equals(bookInfo.getEnable())) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u5f53\u524d\u6240\u9009\u6761\u4ef6\u4e0b\u6ca1\u6709\u53ef\u7528\u8d26\u7c3f\u3002", (String)"ReciprocalAutoWriteOffPlugin_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    return;
                }
                final String taskId = ((DynamicObject)this.getModel().getValue(ORG)).getString("id") + ((DynamicObject)this.getModel().getValue(BOOK_TYPE)).getString("id");
                this.cache.remove(taskId);
                this.cache.remove(taskId + "isSuccess");
                this.cache.remove(taskId + "isFinish");
                this.cache.remove(taskId + "haswriteoffcount");
                this.cache.remove(taskId + "allcount");
                if (this.cache.get(taskId) != null && this.cache.get(taskId).equals(taskId)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u548c\u8d26\u7c3f\u7ec4\u5408\u5df2\u7ecf\u5728\u6838\u9500\uff0c\u8bf7\u7a0d\u540e\u518d\u6838\u9500\u3002", (String)"ReciprocalAutoWriteOffPlugin_1", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObject[] schemeDys = this.querySchemes();
                if ((schemeDys == null || schemeDys.length < 1) && (defaultScheme = this.queryDefaultScheme()) == null) {
                    StringBuilder buff = new StringBuilder();
                    for (Map.Entry<Long, String> m : this.accountMap.entrySet()) {
                        buff.append(m.getValue()).append(",");
                    }
                    if (buff.length() > 0) {
                        buff.setLength(buff.length() - 1);
                    }
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u79d1\u76ee\uff0c\u5728\u5f53\u524d\u6838\u7b97\u7ec4\u7ec7\u4e0d\u5b58\u5728\u6838\u9500\u65b9\u6848\u3002", (String)"ReciprocalAutoWriteOffPlugin_2", (String)"fi-gl-formplugin", (Object[])new Object[0]), buff.toString()));
                    return;
                }
                final OperateOption option = OperateOption.create();
                option.setVariableValue(ORG, this.getPageCache().get(ORG) != null ? this.getPageCache().get(ORG) : "0");
                option.setVariableValue(BOOK_TYPE, ((DynamicObject)this.getModel().getValue(BOOK_TYPE)).getString("id"));
                option.setVariableValue("startperiod", ((DynamicObject)this.getModel().getValue("startperiod")).getString("id"));
                option.setVariableValue("endperiod", ((DynamicObject)this.getModel().getValue("endperiod")).getString("id"));
                option.setVariableValue("autoByPage", "1");
                DynamicObjectCollection accountDyns = (DynamicObjectCollection)this.getModel().getValue("account");
                ArrayList<Long> accountMasterIdList = new ArrayList<Long>();
                ArrayList<Long> accountIdList = new ArrayList<Long>();
                for (DynamicObject account : accountDyns) {
                    DynamicObject dyAct = account.getDynamicObject("fbasedataid");
                    accountMasterIdList.add(dyAct.getLong("masterid"));
                    accountIdList.add(dyAct.getLong("id"));
                }
                String account = SerializationUtils.serializeToBase64(accountMasterIdList);
                option.setVariableValue("accountmater", account);
                option.setVariableValue("account", SerializationUtils.serializeToBase64(accountIdList));
                String value = DataEntitySerializer.serializerToString((Object)this.getModel().getDataEntity(), (boolean)true, (boolean)true);
                this.getPageCache().put("DataEntity", value);
                final DynamicObject data = this.getDataEntity();
                int allRecordSize = this.queryAllRecord(option);
                if (allRecordSize < 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6240\u9009\u6761\u4ef6\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u6838\u9500\u3002", (String)"ReciprocalAutoWriteOffPlugin_3", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.getView().setEnable(Boolean.valueOf(false), new String[]{WRITEOFF});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"processlable", "leftbrackets", "haswriteoffcount", "percent", "allcount", "rightbrackets"});
                Label label = (Label)this.getControl("allcount");
                label.setText(allRecordSize + "");
                this.getPageCache().put("taskId", taskId);
                this.cache.put(taskId, taskId);
                this.cache.put(taskId + "isFinish", String.valueOf(false));
                this.cache.put(taskId + "haswriteoffcount", "0");
                this.cache.put(taskId + "allcount", String.valueOf(allRecordSize) + "");
                ITimeService timeService = (ITimeService)this.getView().getService(ITimeService.class);
                IUserService userService = (IUserService)this.getView().getService(IUserService.class);
                option.setVariableValue("ITimeService", timeService.getClass().getName());
                option.setVariableValue("IUserService", userService.getClass().getName());
                Task writeOffTask = new Task(new Runnable(){

                    @Override
                    public void run() {
                        OperationResult res = OperationServiceHelper.executeOperate((String)"reciprocal_writeoff", (String)"gl_reci_autowriteoff", (DynamicObject[])new DynamicObject[]{data}, (OperateOption)option);
                        ReciprocalAutoWriteOffPlugin.this.cache.put(taskId + "isFinish", String.valueOf(true));
                        ReciprocalAutoWriteOffPlugin.this.cache.put(taskId + "isSuccess", String.valueOf(res.isSuccess()));
                    }
                });
                GLThreadService.ayncPageLoadingTask((String)((Object)((Object)this)).getClass().getName(), (Runnable)writeOffTask);
                ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
                bar.start();
                break;
            }
        }
    }

    private int queryAllRecord(OperateOption option) {
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        QFilter orgFilter = new QFilter(ORG, "=", (Object)Long.valueOf(option.getVariableValue(ORG)));
        QFilter bookTypeQfFilter = new QFilter(BOOK_TYPE, "=", (Object)Long.valueOf(option.getVariableValue(BOOK_TYPE)));
        QFilter startPeriodFilter = new QFilter("period", ">=", (Object)Long.valueOf(option.getVariableValue("startperiod")));
        QFilter endPeriodFilter = new QFilter("period", "<=", (Object)Long.valueOf(option.getVariableValue("endperiod")));
        String account = option.getVariableValue("accountmater");
        List accountList = (List)SerializationUtils.deSerializeFromBase64((String)account);
        QFilter accountFilter = new QFilter("account", "in", (Object)accountList);
        ArrayList<String> lstStatus = new ArrayList<String>();
        lstStatus.add("0");
        lstStatus.add("1");
        list.add(new QFilter("status", "in", lstStatus));
        list.add(orgFilter);
        list.add(bookTypeQfFilter);
        list.add(accountFilter);
        QFilter periodFilter = startPeriodFilter.and(endPeriodFilter);
        list.add(periodFilter);
        int size = ORM.create().count(((Object)((Object)this)).getClass().getName(), "gl_acccurrent", list.toArray(new QFilter[0]));
        return size;
    }

    private boolean notNullCheck() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        DynamicObject org = (DynamicObject)model.getValue(ORG);
        if (org == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ReciprocalAutoWriteOffPlugin_4", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        DynamicObject bookType = (DynamicObject)model.getValue(BOOK_TYPE);
        if (bookType == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8d26\u7c3f\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (String)"ReciprocalAutoWriteOffPlugin_5", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        DynamicObject startperiod = (DynamicObject)model.getValue("startperiod");
        if (startperiod == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u671f\u95f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ReciprocalAutoWriteOffPlugin_6", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        DynamicObject endperiod = (DynamicObject)model.getValue("endperiod");
        if (endperiod == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u671f\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (String)"ReciprocalAutoWriteOffPlugin_7", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        if ((Long)endperiod.getPkValue() < (Long)startperiod.getPkValue()) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u671f\u95f4\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u671f\u95f4\u3002", (String)"ReciprocalAutoWriteOffPlugin_8", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        DynamicObjectCollection accounts = (DynamicObjectCollection)model.getValue("account");
        if (accounts == null || accounts.isEmpty()) {
            view.showTipNotification(ResManager.loadKDString((String)"\u79d1\u76ee\u4e0d\u80fd\u4e3a\u7a7a", (String)"ReciprocalAutoWriteOffPlugin_9", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        this.putAccountMap(accounts);
        return true;
    }

    private void putAccountMap(DynamicObjectCollection accounts) {
        for (DynamicObject account : accounts) {
            this.accountMap.put(account.getLong("fbasedataid_id"), account.getDynamicObject("fbasedataid").getString("name"));
        }
    }

    private DynamicObject queryDefaultScheme() {
        Long orgid = ((DynamicObject)this.getModel().getValue(ORG)).getLong("id");
        DynamicObject scheme = QueryServiceHelper.queryOne((String)"gl_reciprocal_scheme", (String)select_fileds, (QFilter[])new QFilter[]{BaseDataServiceHelper.getBaseDataFilter((String)"gl_reciprocal_scheme", (Long)orgid), new QFilter("enable", "=", (Object)"1"), new QFilter("accounttable", "=", (Object)Long.valueOf(this.getPageCache().get("accounttableid")))});
        return scheme;
    }

    private DynamicObject[] querySchemes() {
        Long orgid = ((DynamicObject)this.getModel().getValue(ORG)).getLong("id");
        DynamicObjectCollection acountDyns = (DynamicObjectCollection)this.getModel().getValue("account");
        ArrayList<Long> accountMasterIdList = new ArrayList<Long>();
        for (DynamicObject dyn : acountDyns) {
            accountMasterIdList.add(dyn.getLong("fbasedataid.masterid"));
        }
        Long accountTableId = Long.valueOf(this.getPageCache().get("accounttableid"));
        DynamicObject[] schemeDynamicObjects = ReciprocalUtils.querySchemes((long)orgid, (long)accountTableId, accountMasterIdList, null, (String)"2");
        if (schemeDynamicObjects == null || schemeDynamicObjects.length == 0) {
            schemeDynamicObjects = ReciprocalUtils.querySchemes((long)orgid, (long)accountTableId, null, null, (String)"2");
        }
        return schemeDynamicObjects;
    }

    public void onProgress(ProgressEvent progressEvent) {
        boolean isFinish = Boolean.parseBoolean(this.cache.get(this.getPageCache().get("taskId") + "isFinish"));
        String taskId = this.getPageCache().get("taskId");
        Label label1 = (Label)this.getControl("haswriteoffcount");
        Label label2 = (Label)this.getControl("allcount");
        label1.setText(this.cache.get(taskId + "haswriteoffcount"));
        label2.setText(this.cache.get(taskId + "allcount"));
        if (isFinish) {
            boolean isSuccess = Boolean.parseBoolean(this.cache.get(this.getPageCache().get("taskId") + "isSuccess"));
            if (isSuccess) {
                int count = Integer.parseInt(this.cache.get(taskId + "haswriteoffcount"));
                if (count > 0) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6838\u9500\u6210\u529f\u3002", (String)"ReciprocalAutoWriteOffPlugin_10", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6240\u9009\u6761\u4ef6\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u6838\u9500\u6570\u636e\u3002", (String)"ReciprocalAutoWriteOffPlugin_11", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                }
            } else {
                String errMsg = this.cache.get(taskId + "errMsg");
                String errorResult = ResManager.loadKDString((String)"\u6838\u9500\u5931\u8d25\u3002", (String)"ReciprocalAutoWriteOffPlugin_12", (String)"fi-gl-formplugin", (Object[])new Object[0]);
                if (!StringUtils.isEmpty((CharSequence)errMsg)) {
                    errorResult = errorResult + errMsg;
                    this.cache.remove(taskId + "errMsg");
                }
                this.getView().showErrorNotification(errorResult);
            }
            this.stopProgressBar();
        }
    }

    private void stopProgressBar() {
        ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
        bar.stop();
        this.removeCache();
        this.getView().setEnable(Boolean.valueOf(true), new String[]{WRITEOFF});
        Label label1 = (Label)this.getControl("haswriteoffcount");
        Label label2 = (Label)this.getControl("allcount");
        label1.setText("0");
        label2.setText("0");
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"processlable", "leftbrackets", "haswriteoffcount", "percent", "allcount", "rightbrackets"});
    }

    private void removeCache() {
        String taskId = this.getPageCache().get("taskId");
        this.cache.remove(taskId);
        this.cache.remove(taskId + "isFinish");
        this.cache.remove(taskId + "isSuccess");
        this.cache.remove(taskId + "haswriteoffcount");
        this.cache.remove(taskId + "allcount");
        this.getPageCache().remove("taskId");
    }

    private DynamicObject getDataEntity() {
        String value = this.getPageCache().get("DataEntity");
        if (!StringUtils.isBlank((CharSequence)value)) {
            return (DynamicObject)DataEntitySerializer.deSerializerFromString((String)value, (IDataEntityType)this.getModel().getDataEntityType());
        }
        return null;
    }
}

