/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.bd.assign.OpLogHelper;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.enums.ReciprocalDataRepairEnum;
import kd.fi.gl.reciprocal.datarepair.service.IDataCheckAndRepairService;
import kd.fi.gl.reciprocal.datarepair.util.ReciprocalDataRepairUtil;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.GlFormUtil;

public class ReciprocalDataCheckAndRepairPlugin
extends AbstractReportFormPlugin {
    public static final String CHECKTYPE = "checktype";
    public static final String CHECKBTN = "check";
    public static final String REPAIRSELECTEDBTN = "repairselected";
    public static final String REPAIRALLBTN = "repairall";
    private static Log logger = LogFactory.getLog(ReciprocalDataCheckAndRepairPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        HashMap<String, String> paramMap = new HashMap<String, String>(2);
        paramMap.put("pageId", this.getView().getPageId());
        queryParam.setCustomParam(paramMap);
        super.beforeQuery(queryParam);
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        super.processRowData(gridPK, rowData, queryParam);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        switch (evt.getItemKey()) {
            case "repairselected": {
                this.repairSelected();
                break;
            }
            case "repairall": {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(REPAIRALLBTN, (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u4fee\u590d\u67e5\u8be2\u6761\u4ef6\u4e0b\u6240\u6709\u6570\u636e\u5417\uff1f", (String)"ReciprocalDataCheckAndRepairPlugin_0", (String)"fi-gl-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBacks);
                break;
            }
        }
    }

    private void repairSelected() {
        IReportView view = this.getView();
        String checkType = (String)this.getModel().getValue(CHECKTYPE);
        ReportList control = (ReportList)this.getControl("reportlistap");
        int[] rowIdxs = control.getEntryState().getSelectedRows();
        if (rowIdxs == null || rowIdxs.length <= 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u4fee\u590d\u7684\u884c\u3002", (String)"ReciprocalDataCheckAndRepairPlugin_1", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<Long> selectedIds = new ArrayList<Long>(16);
        for (int i = 0; i < rowIdxs.length; ++i) {
            DynamicObject rowData = control.getReportModel().getRowData(rowIdxs[i]);
            selectedIds.add(rowData.getLong("id"));
        }
        IDataCheckAndRepairService checkAndRepairService = ReciprocalDataRepairUtil.getDataCheckAndRepairService((String)checkType);
        ReciprocalDataRepairEnum repairEnum = ReciprocalDataRepairEnum.getDataRepairEnumByCode((String)checkType);
        String desc = repairEnum.getDesc();
        MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u591a\u9009\u4fee\u590d\u3002", "ReciprocalDataCheckAndRepairPlugin_13", "fi-bd-formplugin");
        MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("\u591a\u9009\u4fee\u590d-%1$s", "ReciprocalDataCheckAndRepairPlugin_11", "fi-gl-formplugin");
        String[] descParams = new String[]{desc};
        new OpLogHelper().addOperateLog((IFormView)this.getView(), 0L, "reciprocalSelectedFix", REPAIRSELECTEDBTN, opNameBridge, opDescBridge, descParams);
        String message = checkAndRepairService.repairSelected(checkType, selectedIds);
        if (!kd.bos.util.StringUtils.isEmpty((String)message)) {
            this.getView().showTipNotification(message);
            return;
        }
        this.getView().invokeOperation("refresh");
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if (evt.getCallBackId().equals(REPAIRALLBTN) && MessageBoxResult.Yes.equals((Object)evt.getResult())) {
            IDataModel model = this.getModel();
            String checkType = (String)model.getValue(CHECKTYPE);
            ReciprocalDataRepairEnum repairEnum = ReciprocalDataRepairEnum.getDataRepairEnumByCode((String)checkType);
            String desc = repairEnum.getDesc();
            MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u591a\u9009\u4fee\u590d\u3002", "ReciprocalDataCheckAndRepairPlugin_14", "fi-bd-formplugin");
            MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("\u5168\u90e8\u4fee\u590d-%1$s", "ReciprocalDataCheckAndRepairPlugin_12", "fi-gl-formplugin");
            String[] descParams = new String[]{desc};
            new OpLogHelper().addOperateLog((IFormView)this.getView(), 0L, "reciprocalFixAll", REPAIRALLBTN, opNameBridge, opDescBridge, descParams);
            IDataCheckAndRepairService checkAndRepairService = ReciprocalDataRepairUtil.getDataCheckAndRepairService((String)checkType);
            ReportQueryParam queryParam = this.getView().getQueryParam();
            String message = checkAndRepairService.repairByCondition(queryParam);
            if (!kd.bos.util.StringUtils.isEmpty((String)message)) {
                this.getView().showTipNotification(message);
                return;
            }
            this.getView().invokeOperation("refresh");
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initOrg();
        this.getAllCheckTypeItems();
        ComboEdit currency = (ComboEdit)this.getControl(CHECKTYPE);
        currency.setComboItems(this.getAllCheckTypeItems());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String changeName = e.getProperty().getName();
        Object value = e.getChangeSet()[0].getNewValue();
        switch (changeName) {
            case "org": {
                if (value == null) {
                    this.getModel().setValue("booktype", null);
                    BasedataEdit bookTypeEdit = (BasedataEdit)this.getControl("booktype");
                    GlFormUtil.setF7ClickFilter(bookTypeEdit, new QFilter("id", "in", null));
                    return;
                }
                Long orgId = ((DynamicObject)value).getLong("id");
                this.setEntityBookType(orgId);
                break;
            }
            case "booktype": {
                if (value == null) {
                    this.getModel().setValue("accounttable", null);
                    BasedataEdit accountTableEdit = (BasedataEdit)this.getControl("accounttable");
                    GlFormUtil.setF7ClickFilter(accountTableEdit, new QFilter("id", "in", null));
                    return;
                }
                Long bookTypeId = ((DynamicObject)value).getLong("id");
                this.setBook(bookTypeId);
                break;
            }
        }
    }

    private void initOrg() {
        BasedataEdit orgEdit = this.getOrgEdit();
        List orgList = ReciprocalDataRepairUtil.getAllOrgPkList();
        GlFormUtil.setF7ClickFilter(orgEdit, new QFilter("id", "in", (Object)orgList));
        Long orgId = this.getDefaultOrg(orgList);
        if (orgId == null) {
            return;
        }
        this.getModel().setValue("org", (Object)orgId);
        this.setEntityBookType(orgId);
    }

    private void setEntityBookType(Long orgId) {
        if (orgId == null) {
            return;
        }
        HashSet<Long> childOrg = new HashSet<Long>();
        childOrg.add(orgId);
        this.getPageCache().put("reci_childOrgSet", GLUtil.toSerializedString(childOrg));
        List bookTypes = AccSysUtil.getBookTypeByOrg((long)orgId);
        if (bookTypes.size() <= 0) {
            return;
        }
        Long defaultBookType = (Long)bookTypes.get(0);
        BasedataEdit bookTypeEdit = (BasedataEdit)this.getControl("booktype");
        GlFormUtil.setF7ClickFilter(bookTypeEdit, new QFilter("id", "in", (Object)bookTypes));
        this.getModel().setValue("booktype", (Object)defaultBookType);
        this.setBook(defaultBookType);
    }

    private void setBook(Long bookTypeId) {
        long btId;
        IDataModel model = this.getModel();
        Set childOrgSet = new HashSet();
        String str = this.getPageCache().get("reci_childOrgSet");
        if (str != null) {
            childOrgSet = (Set)GLUtil.fromSerializedString((String)str);
        }
        List bookInfoList = AccSysUtil.getBookFromAccSys(childOrgSet, (long)bookTypeId);
        HashSet<Long> accountTables = new HashSet<Long>(bookInfoList.size());
        Long defaultAccountTable = 0L;
        Long defaultCurPeriod = 0L;
        for (int i = 0; i < bookInfoList.size(); ++i) {
            AccountBookInfo book = (AccountBookInfo)bookInfoList.get(i);
            long accountTableId = book.getAccountTableId();
            accountTables.add(accountTableId);
            if (i != 0) continue;
            defaultAccountTable = accountTableId;
            defaultCurPeriod = book.getCurPeriodId();
        }
        List<Long> orgIds = this.getOrgValue();
        List<Long> tableIds = this.getVerAcctTable(orgIds, btId = ((Long)this.getModel().getValue("booktype_id")).longValue(), defaultCurPeriod);
        if (!tableIds.isEmpty()) {
            BasedataEdit accountTableEdit = (BasedataEdit)this.getControl("accounttable");
            GlFormUtil.setF7ClickFilter(accountTableEdit, new QFilter("id", "in", tableIds));
            if (tableIds.contains(defaultAccountTable)) {
                model.setValue("accounttable", (Object)defaultAccountTable);
            } else {
                model.setValue("accounttable", (Object)tableIds.get(0));
            }
        } else {
            if (model.getValue("org") != null) {
                long orgId = (Long)model.getValue("org_id");
                List<Long> accttableIds = this.getUseAccttables(orgId);
                accountTables.retainAll(accttableIds);
            }
            model.setValue("accounttable", (Object)(defaultAccountTable == 0L ? null : defaultAccountTable));
            BasedataEdit accountTableEdit = (BasedataEdit)this.getControl("accounttable");
            GlFormUtil.setF7ClickFilter(accountTableEdit, new QFilter("id", "in", accountTables));
        }
    }

    private List<Long> getOrgValue() {
        ArrayList<Long> result = new ArrayList<Long>();
        Long value = (Long)this.getModel().getValue("org_id");
        if (value != null && value != 0L) {
            result.add(value);
        }
        return result;
    }

    private List<Long> getVerAcctTable(List<Long> orgIds, long bookTypeId, long endPeriodId) {
        QFilter forg = new QFilter("org", "in", orgIds);
        QFilter fbt = new QFilter("booktype", "=", (Object)bookTypeId);
        String selfield = StringUtils.join((Object[])new String[]{"org", "enableperiod", "oldaccttab", "accounttable"}, (String)",");
        DynamicObjectCollection col = QueryServiceHelper.query((String)"gl_book_version", (String)selfield, (QFilter[])new QFilter[]{forg, fbt}, (String)"org, enableperiod desc");
        ArrayList<Long> orgs = new ArrayList<Long>(orgIds.size());
        ArrayList<Long> acctTableIds = new ArrayList<Long>(orgIds.size());
        if (!col.isEmpty()) {
            if (col.size() == 1) {
                DynamicObject obj = (DynamicObject)col.get(0);
                if (endPeriodId > obj.getLong("enableperiod")) {
                    acctTableIds.add(obj.getLong("accounttable"));
                } else if (endPeriodId == obj.getLong("enableperiod")) {
                    acctTableIds.add(obj.getLong("accounttable"));
                    acctTableIds.add(obj.getLong("oldaccttab"));
                } else {
                    acctTableIds.add(obj.getLong("oldaccttab"));
                }
            } else {
                long org = 0L;
                int size = col.size();
                long acctTableId = 0L;
                int i = 0;
                for (DynamicObject rec : col) {
                    ++i;
                    if (!orgs.contains(org)) {
                        if (endPeriodId >= rec.getLong("enableperiod")) {
                            acctTableIds.add(rec.getLong("accounttable"));
                            orgs.add(rec.getLong("org"));
                        } else if (org != 0L && org != rec.getLong("org")) {
                            acctTableIds.add(acctTableId);
                            orgs.add(rec.getLong("org"));
                        }
                        if (size == i) {
                            acctTableIds.add(rec.getLong("oldaccttab"));
                        }
                    }
                    org = rec.getLong("org");
                    acctTableId = rec.getLong("oldaccttab");
                }
            }
        }
        orgIds.removeAll(orgs);
        if (orgs.size() != 0 && !orgIds.isEmpty()) {
            QFilter forg1 = new QFilter("org", "in", orgIds);
            QFilter fbt1 = new QFilter("bookstype", "=", (Object)bookTypeId);
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"gl_accountbook", (String)"accounttable", (QFilter[])new QFilter[]{forg1, fbt1}, null);){
                for (Row row : ds) {
                    acctTableIds.add(row.getLong("accounttable"));
                }
            }
        }
        return acctTableIds;
    }

    private List<Long> getUseAccttables(long orgId) {
        ArrayList<Long> tables = new ArrayList<Long>(10);
        List orgIds = OrgUnitServiceHelper.getAllSuperiorOrgs((String)"10", (long)orgId);
        orgIds.add(orgId);
        if (!orgIds.isEmpty()) {
            try (DataSet tableSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_accounttable", (String)"id", (QFilter[])new QFilter("org", "in", (Object)orgIds).toArray(), null);){
                while (tableSet.hasNext()) {
                    Row row = tableSet.next();
                    tables.add(row.getLong("id"));
                }
            }
        }
        return tables;
    }

    private Long getOrgParam() {
        String org = (String)this.getView().getFormShowParameter().getCustomParam("org");
        return org == null ? null : Long.valueOf(org);
    }

    private Long getDefaultOrg(List<Long> orgList) {
        Long orgParam = this.getOrgParam();
        return orgParam != null ? orgParam : GlFormUtil.getDefaultAcctOrg(orgList);
    }

    private BasedataEdit getOrgEdit() {
        return (BasedataEdit)this.getControl("org");
    }

    private List<ComboItem> getAllCheckTypeItems() {
        ArrayList<ComboItem> allItems = new ArrayList<ComboItem>(16);
        for (ReciprocalDataRepairEnum repairEnum : ReciprocalDataRepairEnum.values()) {
            ComboItem comboItem = new ComboItem();
            comboItem.setValue(repairEnum.getCode());
            comboItem.setCaption(new LocaleString(ResManager.loadKDString((String)repairEnum.getDesc(), (String)"ReciprocalAcctFormRpt_2", (String)"fi-gl-formplugin", (Object[])new Object[0])));
            allItems.add(comboItem);
        }
        return allItems;
    }
}

