/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.ValueTextItem;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.F7SelectedList;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bd.util.DebugTrace;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.common.TaxAssignInfo;
import kd.fi.gl.exception.GLErrorCode;
import kd.fi.gl.exception.GLException;
import kd.fi.gl.util.PermissonType;
import kd.fi.gl.util.TaxReportFormHelper;

public class TaxAssginPlugin
extends AbstractFormPlugin
implements ListRowClickListener,
SearchEnterListener {
    private static final Log log = LogFactory.getLog(TaxAssginPlugin.class);

    public void initialize() {
        super.initialize();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String entityNumber = (String)formShowParameter.getCustomParam("entityNumber");
        long bookTypeId = (Long)formShowParameter.getCustomParam("bookTypeId");
        Map custom = formShowParameter.getCustomParams();
        HashSet<Long> childOrgSet = new HashSet<Long>();
        if (entityNumber != null) {
            long orgId = Long.parseLong(custom.get("orgId").toString());
            long orgViewId = Long.parseLong(custom.get("orgViewId").toString());
            HashSet<Long> orgParent = new HashSet<Long>();
            orgParent.add(orgId);
            Set childOrgIds = AccSysUtil.getChildOrgId((String)"10", (Long)orgViewId, orgParent, (boolean)true);
            List permOrgList = AccSysUtil.getAcctOrgPkList((String)entityNumber, (boolean)true, (PermissonType)PermissonType.VIEW);
            List<Long> accountOrgs = this.chooseAccoutOrg(bookTypeId, childOrgIds);
            childOrgSet.addAll(accountOrgs);
            childOrgSet.retainAll(permOrgList);
            childOrgSet.remove(orgId);
            if (DebugTrace.enable()) {
                log.info("\u4e0b\u7ea7\u7ec4\u7ec7\uff1a" + childOrgIds.toString());
                log.info("\u6709\u8be5\u8d26\u7c3f\u7c7b\u578b\u7684\u8d26\u7c3f\u7ec4\u7ec7\uff1a" + accountOrgs.toString());
                log.info("\u6709\u6743\u9650\u7ec4\u7ec7\uff1a\uff1a" + permOrgList.toString());
                log.info("\u6709\u6743\u9650\u7ec4\u7ec7\uff1a\uff1a" + ((Object)childOrgSet).toString());
            }
        }
        BillList billList = (BillList)this.getControl("billlistap");
        billList.setFilter(new QFilter("id", "in", childOrgSet));
        if (childOrgSet.isEmpty()) {
            long orgViewId = Long.parseLong(custom.get("orgViewId").toString());
            QFilter fviewId = new QFilter("id", "=", (Object)orgViewId);
            DataSet viewDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_accountingsysviewsch", (String)"name, accountingsys.name sysname", (QFilter[])new QFilter[]{fviewId}, null);
            String viewName = "";
            String sysName = "";
            for (Row row : viewDataSet) {
                viewName = row.getString("name");
                sysName = row.getString("sysname");
            }
            String format = ResManager.loadKDString((String)"\u6838\u7b97\u4f53\u7cfb(%1$s)\u7684\u6838\u7b97\u89c6\u56fe(%2$s)\u6ca1\u6709\u80fd\u5206\u914d\u7684\u4e0b\u7ea7\u7ec4\u7ec7\u3002", (String)"TaxAssginPlugin_0", (String)"fi-gl-formplugin", (Object[])new Object[0]);
            String tip = String.format(format, sysName, viewName);
            this.getView().showTipNotification(tip, Integer.valueOf(10000));
            return;
        }
        billList.addListRowClickListener((ListRowClickListener)this);
        this.addClickListeners(new String[]{"btnok"});
        Search search = (Search)this.getControl("searchap");
        search.addEnterListener((SearchEnterListener)this);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if (control.getKey().equals("btnok")) {
            long bookTypeId;
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection col = billList.getSelectedRows();
            IFormView view = this.getView();
            if (col.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5206\u914d\u7684\u7ec4\u7ec7\u3002", (String)"TaxAssginPlugin_1", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                return;
            }
            HashSet<Long> selUseOrgIds = new HashSet<Long>(col.size());
            for (ListSelectedRow row : col) {
                selUseOrgIds.add((Long)row.getPrimaryKeyValue());
            }
            FormShowParameter showParameter = view.getFormShowParameter();
            String taxType = (String)showParameter.getCustomParam("type");
            if (taxType == null || showParameter.getCustomParam("orgId") == null || showParameter.getCustomParam("accTableId") == null) {
                view.showSuccessNotification(ResManager.loadKDString((String)"\u5206\u914d\u5931\u8d25\u3002", (String)"TaxAssginPlugin_2", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                return;
            }
            long accTableId = Long.parseLong(showParameter.getCustomParam("accTableId").toString());
            if (!this.isExistExp(selUseOrgIds, accTableId, bookTypeId = Long.parseLong(showParameter.getCustomParam("bookTypeId").toString()), taxType)) {
                this.assginExp(selUseOrgIds);
            }
        }
    }

    private void assginExp(Set<Long> selUseOrgIds) {
        IFormView view = this.getView();
        FormShowParameter showParameter = view.getFormShowParameter();
        String taxType = (String)showParameter.getCustomParam("type");
        long orgId = Long.parseLong(showParameter.getCustomParam("orgId").toString());
        long acctTableId = Long.parseLong(showParameter.getCustomParam("accTableId").toString());
        long bookTypeId = Long.parseLong(showParameter.getCustomParam("bookTypeId").toString());
        QFilter faccTableId = new QFilter("accounttable", "=", (Object)acctTableId);
        QFilter fbookTypeId = new QFilter("booktype", "=", (Object)bookTypeId);
        QFilter ftype = new QFilter("type", "=", (Object)taxType);
        ArrayList<DynamicObject> listInfo = new ArrayList<DynamicObject>(selUseOrgIds.size());
        for (Long selUseOrgId : selUseOrgIds) {
            TaxAssignInfo assignInfo = new TaxAssignInfo();
            assignInfo.setCreateOrg(Long.valueOf(orgId));
            assignInfo.setUseOrg(selUseOrgId);
            assignInfo.setAccountTable(Long.valueOf(acctTableId));
            assignInfo.setBookType(Long.valueOf(bookTypeId));
            assignInfo.setType(taxType);
            listInfo.add(assignInfo.toDynamicObject());
        }
        try (TXHandle h = TX.required();){
            try {
                QFilter fdelUseOrg = new QFilter("useorg", "in", selUseOrgIds);
                this.delAssignExp(new QFilter[]{fdelUseOrg, faccTableId, fbookTypeId, ftype});
                this.saveAssignExp(listInfo.toArray(new DynamicObject[0]));
                this.saveTaxExp(selUseOrgIds, orgId, acctTableId, bookTypeId, taxType);
                view.showSuccessNotification(ResManager.loadKDString((String)"\u5206\u914d\u6210\u529f\u3002", (String)"TaxAssginPlugin_3", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            }
            catch (Exception e) {
                h.markRollback();
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5206\u914d\u5931\u8d25\uff1a%s\u3002", (String)"TaxAssginPlugin_4", (String)"fi-gl-formplugin", (Object[])new Object[0]), e.getMessage()));
                if (h != null) {
                    if (var16_13 != null) {
                        try {
                            h.close();
                        }
                        catch (Throwable throwable) {
                            var16_13.addSuppressed(throwable);
                        }
                    } else {
                        h.close();
                    }
                }
                return;
            }
        }
    }

    private void delAssignExp(QFilter[] fQFilters) {
        DeleteServiceHelper.delete((String)"gl_taxassigntable", (QFilter[])fQFilters);
    }

    private void saveAssignExp(DynamicObject[] dynamicObjects) {
        SaveServiceHelper.save((DynamicObject[])dynamicObjects);
    }

    private void saveTaxExp(Set<Long> selUseOrgIds, long orgId, long acctTableId, long bookTypeId, String taxType) {
        QFilter fuseOrgIds = new QFilter("org", "in", selUseOrgIds);
        QFilter forgIds = new QFilter("org", "=", (Object)orgId);
        QFilter facctTable = new QFilter("accounttable", "=", (Object)acctTableId);
        QFilter fbookType = new QFilter("booktype", "=", (Object)bookTypeId);
        QFilter ftaxType = new QFilter("type", "=", (Object)taxType);
        if ("balancesheet".equals(taxType)) {
            this.delBalanceSheet(new QFilter[]{fuseOrgIds, facctTable, fbookType});
            this.saveBalanceSheet(new QFilter[]{forgIds, facctTable, fbookType}, selUseOrgIds);
        } else {
            this.delIncome(new QFilter[]{fuseOrgIds, facctTable, fbookType, ftaxType});
            this.saveIncome(new QFilter[]{forgIds, facctTable, fbookType, ftaxType}, selUseOrgIds);
        }
    }

    private void delBalanceSheet(QFilter[] filters) {
        DeleteServiceHelper.delete((String)"gl_balancesheetedit", (QFilter[])filters);
        DeleteServiceHelper.delete((String)"gl_balancesheetexpression", (QFilter[])filters);
    }

    private void delIncome(QFilter[] filters) {
        DeleteServiceHelper.delete((String)"gl_incomeedit", (QFilter[])filters);
        DeleteServiceHelper.delete((String)"gl_incomeexpression", (QFilter[])filters);
    }

    private void saveBalanceSheet(QFilter[] filters, Set<Long> useOrgIds) {
        this.saveAssignDyn(filters, useOrgIds, "gl_balancesheetedit", "gl_balancesheetexpression");
    }

    private void saveIncome(QFilter[] filters, Set<Long> useOrgIds) {
        this.saveAssignDyn(filters, useOrgIds, "gl_incomeedit", "gl_incomeexpression");
    }

    private void saveAssignDyn(QFilter[] filters, Set<Long> useOrgIds, String entityKey, String expEntityKey) {
        DynamicObject oldEditDyn = BusinessDataServiceHelper.loadSingleFromCache((String)entityKey, (QFilter[])filters);
        if (oldEditDyn == null) {
            throw new GLException(GLErrorCode.common, new Object[]{ResManager.loadKDString((String)"\u8bf7\u5148\u8bbe\u7f6e\u516c\u5f0f\uff0c\u518d\u5206\u914d\u3002", (String)"TaxAssginPlugin_5", (String)"fi-gl-formplugin", (Object[])new Object[0])});
        }
        ArrayList<DynamicObject> editDynList = new ArrayList<DynamicObject>(useOrgIds.size());
        for (Long useOrgId : useOrgIds) {
            DynamicObject newEditDyn = null;
            newEditDyn = "gl_balancesheetedit".equals(entityKey) ? TaxReportFormHelper.copyBalanceSheetEditDyn((DynamicObject)oldEditDyn) : TaxReportFormHelper.copyIncomeDyn((DynamicObject)oldEditDyn);
            newEditDyn.set("org", (Object)useOrgId);
            editDynList.add(newEditDyn);
        }
        Object[] editObjs = SaveServiceHelper.save((DynamicObject[])editDynList.toArray(new DynamicObject[0]));
        if (editObjs == null || editObjs.length == 0) {
            throw new GLException(GLErrorCode.common, new Object[]{ResManager.loadKDString((String)"\u8bf7\u5148\u8bbe\u7f6e\u516c\u5f0f\uff0c\u518d\u5206\u914d\u3002", (String)"TaxAssginPlugin_5", (String)"fi-gl-formplugin", (Object[])new Object[0])});
        }
        Map expDynMap = BusinessDataServiceHelper.loadFromCache((String)expEntityKey, (QFilter[])filters);
        ArrayList<DynamicObject> expDynList = new ArrayList<DynamicObject>();
        for (Map.Entry map : expDynMap.entrySet()) {
            DynamicObject oldExpDyn = (DynamicObject)map.getValue();
            for (Long useOrgId : useOrgIds) {
                DynamicObject newExpDyn = "gl_balancesheetexpression".equals(expEntityKey) ? TaxReportFormHelper.copyBalanceSheetExpDyn((DynamicObject)oldExpDyn) : TaxReportFormHelper.copyIncomeExpDyn((DynamicObject)oldExpDyn);
                newExpDyn.set("org", (Object)useOrgId);
                expDynList.add(newExpDyn);
            }
        }
        SaveServiceHelper.save((DynamicObject[])expDynList.toArray(new DynamicObject[0]));
    }

    private boolean isExistExp(Set<Long> useOrgIds, long accountTableId, long bookTypeId, String type) {
        DynamicObjectCollection collection = null;
        collection = "balancesheet".equals(type) ? TaxReportFormHelper.getBalSheetExps(useOrgIds, (long)accountTableId, (long)bookTypeId) : TaxReportFormHelper.getIncomeExps(useOrgIds, (long)accountTableId, (long)bookTypeId, (String)type);
        if (collection != null && collection.size() > 0) {
            HashSet<Long> existExpOrgIds = new HashSet<Long>();
            for (DynamicObject dynamicObject : collection) {
                long orgId = Long.parseLong(dynamicObject.getString("orgid"));
                existExpOrgIds.add(orgId);
            }
            String selName = "name";
            QFilter forgId = new QFilter("id", "in", existExpOrgIds);
            DataSet orgSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bos_org", (String)selName, (QFilter[])new QFilter[]{forgId}, null);
            StringBuilder sb = new StringBuilder();
            for (Row row : orgSet) {
                String name = row.getString("name");
                sb.append(name).append(",");
            }
            if (sb.length() > 0) {
                sb.setLength(sb.length() - 1);
            }
            String tip = sb.toString();
            this.getPageCache().put("selOverOrgIds", useOrgIds.toString());
            String orgNameTip = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%s\u201d\u5df2\u5b58\u5728\u516c\u5f0f\u3002\u662f\u5426\u8986\u76d6\uff1f", (String)"TaxAssginPlugin_6", (String)"fi-gl-formplugin", (Object[])new Object[0]), tip);
            this.getView().showConfirm(orgNameTip, MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("over", (IFormPlugin)this));
            return true;
        }
        return false;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String orgIdsStr;
        super.confirmCallBack(messageBoxClosedEvent);
        String key = messageBoxClosedEvent.getCallBackId();
        if ("over".equals(key) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult()) && !StringUtils.isEmpty((CharSequence)(orgIdsStr = this.getPageCache().get("selOverOrgIds")))) {
            String subStr = orgIdsStr.substring(1, orgIdsStr.length() - 1);
            String[] orgs = subStr.split(",");
            HashSet<Long> selOrgIds = new HashSet<Long>(orgs.length);
            for (String orgStr : orgs) {
                long orgId = Long.parseLong(orgStr.trim());
                selOrgIds.add(orgId);
            }
            this.assginExp(selOrgIds);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void listRowClick(ListRowClickEvent arg) {
        ListSelectedRowCollection col = arg.getListSelectedRowCollection();
        F7SelectedList f7SelectedList = (F7SelectedList)this.getControl("f7selectedlistap");
        f7SelectedList.removeAllItems();
        ArrayList<ValueTextItem> items = new ArrayList<ValueTextItem>();
        for (ListSelectedRow row : col) {
            ValueTextItem item = new ValueTextItem(String.valueOf(row.getPrimaryKeyValue()), row.getName());
            items.add(item);
        }
        f7SelectedList.addItems(items);
    }

    public void search(SearchEnterEvent arg) {
        BillList billList = (BillList)this.getControl("billlistap");
        List searchFields = arg.getSearchFields();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String entityNumber = (String)formShowParameter.getCustomParam("entityNumber");
        long bookTypeId = (Long)formShowParameter.getCustomParam("bookTypeId");
        Map custom = formShowParameter.getCustomParams();
        HashSet<Long> childOrgSet = new HashSet<Long>();
        long orgId = Long.parseLong(custom.get("orgId").toString());
        long orgViewId = Long.parseLong(custom.get("orgViewId").toString());
        HashSet<Long> orgParent = new HashSet<Long>();
        orgParent.add(orgId);
        Set childOrgIds = AccSysUtil.getChildOrgId((String)"10", (Long)orgViewId, orgParent, (boolean)true);
        List permOrgList = AccSysUtil.getAcctOrgPkList((String)entityNumber, (boolean)true, (PermissonType)PermissonType.VIEW);
        List<Long> accountOrgs = this.chooseAccoutOrg(bookTypeId, childOrgIds);
        childOrgSet.addAll(accountOrgs);
        childOrgSet.retainAll(permOrgList);
        childOrgSet.remove(orgId);
        QFilter idFilter = new QFilter("id", "in", childOrgSet);
        if (searchFields == null) {
            billList.setFilter(idFilter);
        } else {
            List filedList = (List)((Map)searchFields.get(0)).get("fieldName");
            List text = (List)((Map)searchFields.get(0)).get("value");
            QFilter orFilter = new QFilter((String)filedList.get(0), "like", (Object)("%" + (String)text.get(0) + "%"));
            for (int i = 1; i < filedList.size(); ++i) {
                QFilter filter = new QFilter((String)filedList.get(i), "like", (Object)("%" + (String)text.get(0) + "%"));
                orFilter = QFilter.or((QFilter)orFilter, (QFilter)filter);
            }
            billList.setFilter(idFilter.and(orFilter));
        }
        billList.refresh();
    }

    private List<Long> chooseAccoutOrg(long bookTypeId, Set<Long> orgIds) {
        ArrayList<Long> chooseOrgIds = new ArrayList<Long>(orgIds.size());
        for (Long id : orgIds) {
            AccountBookInfo bookFromAccSys = AccSysUtil.getBookFromAccSys((long)id, (long)bookTypeId);
            if (null == bookFromAccSys) continue;
            chooseOrgIds.add(id);
        }
        return chooseOrgIds;
    }
}

