/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin;

import java.util.EventObject;
import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;

public class TaxAssginQueryPlugin
extends AbstractFormPlugin {
    public static final String BD_ORG = "org";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"btnok"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if (control.getKey().equals("btnok")) {
            IDataModel model = this.getModel();
            IFormView view = this.getView();
            EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
            int[] selIndexs = entryGrid.getEntryState().getSelectedRows();
            if (selIndexs.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u53d6\u6d88\u5206\u914d\u7684\u7ec4\u7ec7\u3002", (String)"TaxAssginQueryPlugin_0", (String)"fi-gl-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                return;
            }
            try (TXHandle h = TX.required();){
                try {
                    HashSet<Long> selUseOrgIds = new HashSet<Long>(selIndexs.length);
                    for (int index : selIndexs) {
                        long useOrgId = (Long)model.getValue("useorg_id", index);
                        selUseOrgIds.add(useOrgId);
                    }
                    FormShowParameter showParameter = view.getFormShowParameter();
                    String type = (String)showParameter.getCustomParam("type");
                    long orgId = Long.parseLong(showParameter.getCustomParam("orgId").toString());
                    long accTableId = Long.parseLong(showParameter.getCustomParam("accTableId").toString());
                    QFilter forgId = new QFilter("createorg", "=", (Object)orgId);
                    QFilter fuseOrgIds = new QFilter("useorg", "in", selUseOrgIds);
                    QFilter faccTableId = new QFilter("accounttable", "=", (Object)accTableId);
                    QFilter ftype = new QFilter("type", "=", (Object)type);
                    DeleteServiceHelper.delete((String)"gl_taxassigntable", (QFilter[])new QFilter[]{forgId, fuseOrgIds, faccTableId, ftype});
                    this.deleteTaxTable(selUseOrgIds, orgId, accTableId, type);
                    view.showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u5206\u914d\u6210\u529f", (String)"TaxAssginQueryPlugin_1", (String)"fi-gl-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                    model.deleteEntryData("entryentity");
                    this.batchSetVal();
                }
                catch (Throwable e) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u5206\u914d\u5931\u8d25\uff1a%s", (String)"TaxAssginQueryPlugin_2", (String)"fi-gl-formplugin", (Object[])new Object[]{e.getMessage()}));
                    h.markRollback();
                    throw e;
                }
            }
        }
    }

    private void deleteTaxTable(Set<Long> selUseOrgIds, long orgId, long acctTableId, String taxType) {
        QFilter fuseOrgIds = new QFilter(BD_ORG, "in", selUseOrgIds);
        QFilter facctTable = new QFilter("accounttable", "=", (Object)acctTableId);
        if ("balancesheet".equals(taxType)) {
            this.delBalanceSheet(new QFilter[]{fuseOrgIds, facctTable});
        } else {
            QFilter ftaxType = new QFilter("type", "=", (Object)taxType);
            this.delIncome(new QFilter[]{fuseOrgIds, facctTable, ftaxType});
        }
    }

    private void delBalanceSheet(QFilter[] filters) {
        DeleteServiceHelper.delete((String)"gl_balancesheetedit", (QFilter[])filters);
        DeleteServiceHelper.delete((String)"gl_balancesheetexpression", (QFilter[])filters);
    }

    private void delIncome(QFilter[] filters) {
        DeleteServiceHelper.delete((String)"gl_incomeedit", (QFilter[])filters);
        DeleteServiceHelper.delete((String)"gl_incomeexpression", (QFilter[])filters);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.batchSetVal();
    }

    private void batchSetVal() {
        IFormView view = this.getView();
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        FormShowParameter showParameter = view.getFormShowParameter();
        String type = (String)showParameter.getCustomParam("type");
        if (type == null || showParameter.getCustomParam("orgId") == null || showParameter.getCustomParam("accTableId") == null) {
            return;
        }
        long orgId = Long.parseLong(showParameter.getCustomParam("orgId").toString());
        long accTableId = Long.parseLong(showParameter.getCustomParam("accTableId").toString());
        QFilter forgId = new QFilter("createorg", "=", (Object)orgId);
        QFilter faccTableId = new QFilter("accounttable", "=", (Object)accTableId);
        QFilter ftype = new QFilter("type", "=", (Object)type);
        DataSet querySet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"gl_taxassigntable", (String)"createorg, useorg, accounttable, type", (QFilter[])new QFilter[]{forgId, faccTableId, ftype}, null);
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("createorg", new Object[0]);
        vs.addField("useorg", new Object[0]);
        for (Row row : querySet) {
            long createOrgId = row.getLong("createorg");
            long useOrgId = row.getLong("useorg");
            vs.addRow(new Object[]{createOrgId, useOrgId});
        }
        model.batchCreateNewEntryRow("entryentity", vs);
        model.endInit();
        view.updateView("entryentity");
    }
}

