/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.util.BatchProcessUtil;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.report.GLRptTemplatePlugin;
import kd.fi.gl.util.AnalysisRptUtils;
import kd.fi.gl.util.FormExportUtil;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.GlFormUtil;
import kd.fi.gl.util.PermissonType;
import kd.fi.gl.util.TaxReportFormHelper;

public class TaxShowPlugin
extends AbstractFormPlugin
implements ClickListener {
    private static final String reportEdit = "reportedit";
    private static final String cashFlow = "gl_cashflowstat";
    private static final String taxShow = "gl_taxshow";
    private static final String period = "period";
    private static final String orgView = "orgview";
    private static final String bookType = "booktype";
    private static final String accTable = "accounttable";
    private static final String periodType = "periodtype";
    private static final String entryKey = "entryentity";
    private static final String index = "index";
    private static final String project = "project";
    private static final String balrowId = "balrowid";
    private static final String currentPeriod = "currentperiod";
    private static final String preYearPeriodRate = "preyearperiodrate";
    private static final String prePeriodRate = "preperiodrate";
    private static final String preYearRate = "preyearrate";
    private static final String yearCount = "yearcount";
    private static final String refresh = "refresh";
    private static final String export = "export";

    public void initialize() {
        this.addClickListeners(new String[]{refresh, export, reportEdit});
        this.addItemClickListeners(new String[]{"toolbarap"});
        BasedataEdit unitEdit = (BasedataEdit)this.getControl(period);
        unitEdit.addBeforeF7SelectListener(evt -> ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().getQFilters());
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid control = (EntryGrid)this.getControl(entryKey);
        control.addHyperClickListener(evt -> this.showAccountBalanceRpt(evt));
    }

    private void showAccountBalanceRpt(HyperLinkClickEvent evt) {
        int rowIndex = evt.getRowIndex() + 1;
        int colIndex = 0;
        switch (evt.getFieldName()) {
            case "currentperiod": {
                colIndex = 1;
                break;
            }
            case "yearcount": {
                colIndex = 2;
                break;
            }
        }
        String entityId = this.getView().getEntityId();
        String type = "";
        if (entityId.equals(cashFlow)) {
            type = "cashflow";
        } else if (entityId.equals(taxShow)) {
            type = "taxshow";
        }
        DynamicObject item = (DynamicObject)this.getModel().getValue(project, evt.getRowIndex());
        AnalysisRptUtils.showAccountBalanceRpt((AbstractFormPlugin)this, (DynamicObject)item, (int)rowIndex, (int)colIndex, (String)type);
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        if (reportEdit.equals(key)) {
            this.showIncomeEdit();
        } else if (refresh.equals(key)) {
            String childOrgSetStr = this.getPageCache().get("childOrgSet");
            if (childOrgSetStr == null) {
                return;
            }
            Set childOrgSet = (Set)GLUtil.fromSerializedString((String)childOrgSetStr);
            this.setValue(childOrgSet);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate op = (FormOperate)args.getSource();
        if (op.getOperateKey().equals(export)) {
            this.export(op.getPermissionItemId());
        }
    }

    public void export(String permissionItemId) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        FormExportUtil export = new FormExportUtil();
        List headInfo = AnalysisRptUtils.buildReportHeadInfo((AbstractFormPlugin)this);
        String entityId = view.getEntityId();
        String url = "";
        if (taxShow.equals(entityId)) {
            LinkedHashMap<String, List<String>> fieldMap = new LinkedHashMap<String, List<String>>();
            fieldMap.put(index, null);
            fieldMap.put(project, null);
            ArrayList<String> preList = new ArrayList<String>();
            preList.add(currentPeriod);
            preList.add(preYearPeriodRate);
            preList.add(prePeriodRate);
            fieldMap.put(ResManager.loadKDString((String)"\u672c\u671f\u91d1\u989d", (String)"TaxShowPlugin_0", (String)"fi-gl-formplugin", (Object[])new Object[0]), preList);
            ArrayList<String> yearList = new ArrayList<String>();
            yearList.add(yearCount);
            yearList.add(preYearRate);
            fieldMap.put(ResManager.loadKDString((String)"\u672c\u5e74\u7d2f\u8ba1", (String)"TaxShowPlugin_1", (String)"fi-gl-formplugin", (Object[])new Object[0]), yearList);
            url = export.export((List<String>)headInfo, model.getEntryEntity(entryKey), fieldMap, view, (DynamicObject)model.getValue("basecurrency"), permissionItemId);
        } else {
            ArrayList<String> fieldList = new ArrayList<String>();
            fieldList.add(index);
            fieldList.add(project);
            fieldList.add(currentPeriod);
            url = export.export((List<String>)headInfo, model.getEntryEntity(entryKey), fieldList, view, (DynamicObject)model.getValue("basecurrency"), permissionItemId);
        }
        export.openUrl(url, view);
    }

    private void showIncomeEdit() {
        Long orgId;
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        List<Long> orgIds = this.getOrgValue();
        Long orgViewId = (Long)model.getValue("orgview_id");
        Long bookTypeId = (Long)model.getValue("booktype_id");
        Long accTableId = (Long)model.getValue("accounttable_id");
        String infoTip = "";
        if (orgIds.isEmpty()) {
            infoTip = ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"TaxShowPlugin_2", (String)"fi-gl-formplugin", (Object[])new Object[0]);
        } else if (orgIds.size() > 1) {
            infoTip = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u4e2a\u6838\u7b97\u7ec4\u7ec7\u8fdb\u884c\u7f16\u8f91\u3002", (String)"TaxShowPlugin_3", (String)"fi-gl-formplugin", (Object[])new Object[0]);
        } else if (orgViewId == 0L) {
            infoTip = ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7ec4\u7ec7\u89c6\u56fe\u3002", (String)"TaxShowPlugin_4", (String)"fi-gl-formplugin", (Object[])new Object[0]);
        } else if (bookTypeId == 0L) {
            infoTip = ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8d26\u7c3f\u7c7b\u578b\u3002", (String)"TaxShowPlugin_5", (String)"fi-gl-formplugin", (Object[])new Object[0]);
        } else if (accTableId == 0L) {
            infoTip = ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u79d1\u76ee\u8868\u3002", (String)"TaxShowPlugin_6", (String)"fi-gl-formplugin", (Object[])new Object[0]);
        } else {
            List listId = AccSysUtil.getAcctOrgPkList((String)this.getView().getEntityId(), (boolean)true, (PermissonType)PermissonType.NEW);
            if (!listId.contains(orgId = orgIds.get(0))) {
                infoTip = model.getDataEntity().toString().startsWith("gl_cashflow") ? ResManager.loadKDString((String)"\u65e0\u201c\u73b0\u91d1\u6d41\u91cf\u8868\u201d\u7684\u201c\u65b0\u589e\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TaxShowPlugin_7", (String)"fi-gl-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u65e0\u201c\u4f01\u4e1a\u7eb3\u7a0e\u8868\u201d\u7684\u201c\u65b0\u589e\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TaxShowPlugin_22", (String)"fi-gl-formplugin", (Object[])new Object[0]);
            }
        }
        if (!infoTip.isEmpty()) {
            view.showTipNotification(infoTip);
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.getOpenStyle().setTargetKey("_submaintab_");
        if (model.getDataEntity().toString().startsWith("gl_cashflow")) {
            showParameter.setFormId("gl_cashflowedit");
            showParameter.setCaption(ResManager.loadKDString((String)"\u73b0\u91d1\u6d41\u91cf\u8868\u7f16\u8f91", (String)"TaxShowPlugin_8", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            showParameter.setCustomParam("type", (Object)"cashflow");
            showParameter.setCustomParam("projects", (Object)TaxReportFormHelper.getProjects((String)"cashflow"));
        } else {
            showParameter.setFormId("gl_incomeedit");
            showParameter.setCaption(ResManager.loadKDString((String)"\u4f01\u4e1a\u7eb3\u7a0e\u8868\u7f16\u8f91", (String)"TaxShowPlugin_9", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            showParameter.setCustomParam("type", (Object)"taxshow");
            showParameter.setCustomParam("projects", (Object)TaxReportFormHelper.getProjects((String)"taxshow"));
        }
        orgId = orgIds.get(0);
        showParameter.setCustomParam("orgId", (Object)orgId);
        showParameter.setCustomParam("orgViewId", (Object)orgViewId);
        showParameter.setCustomParam("bookTypeId", (Object)bookTypeId);
        showParameter.setCustomParam("accTableId", (Object)accTableId);
        String isLeafOrg = this.getPageCache().get("isLeafOrg");
        showParameter.setCustomParam("isLeafOrg", (Object)isLeafOrg);
        FormShowParameter parent = this.getView().getFormShowParameter();
        showParameter.setParentPageId(parent.getParentPageId());
        view.showForm(showParameter);
    }

    public void afterCreateNewData(EventObject e) {
        String childOrgSetStr = this.getPageCache().get("childOrgSet");
        if (childOrgSetStr == null) {
            return;
        }
        Set childOrgSet = (Set)GLUtil.fromSerializedString((String)childOrgSetStr);
        this.setValue(childOrgSet);
    }

    private void setValue(Set<Long> childOrgSet) {
        List<Long> orgIds = this.getOrgValue();
        if (orgIds.isEmpty()) {
            return;
        }
        this.getModel().deleteEntryData(entryKey);
        long orgViewId = (Long)this.getModel().getValue("orgview_id");
        long bookTypeId = (Long)this.getModel().getValue("booktype_id");
        long accTableId = (Long)this.getModel().getValue("accounttable_id");
        long periodTypeId = (Long)this.getModel().getValue("periodtype_id");
        long periodId = (Long)this.getModel().getValue("period_id");
        int amtprecision = 2;
        DynamicObject basecurrency = (DynamicObject)this.getModel().getValue("basecurrency");
        if (basecurrency != null) {
            basecurrency.getInt("amtprecision");
        }
        String entityId = this.getView().getEntityId();
        if (orgIds.size() > 1) {
            Set<Long> mulSelectedEntityOrg = this.getEntityOrg(orgIds);
            if (mulSelectedEntityOrg.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u591a\u9009\u7ec4\u7ec7\u5fc5\u987b\u5305\u542b\u4e00\u4e2a\u5b9e\u4f53\u7ec4\u7ec7\u3002", (String)"TaxShowPlugin_10", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                return;
            }
            long parentOrg = GLRptTemplatePlugin.getParentOrgByChildre(orgIds);
            String type = entityId.equals(cashFlow) ? "cashflow" : "taxshow";
            DynamicObjectCollection parentBalSheet = TaxReportFormHelper.getIncomeEdits(Collections.singleton(parentOrg), (long)accTableId, (String)type, (QFilter[])new QFilter(bookType, "=", (Object)bookTypeId).toArray());
            if (parentBalSheet == null || parentBalSheet.isEmpty()) {
                DynamicObject pOrg = BusinessDataServiceHelper.loadSingleFromCache((Object)parentOrg, (String)"bos_org");
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u7684\u5171\u540c\u4e0a\u7ea7%s\u672a\u8bbe\u7f6e\u5bf9\u5e94\u7684\u62a5\u8868\u7f16\u8f91\u516c\u5f0f\uff0c\u8bf7\u5148\u8bbe\u7f6e\u3002", (String)"TaxShowPlugin_11", (String)"fi-gl-formplugin", (Object[])new Object[0]), pOrg != null ? pOrg.getString("name") : ""));
                return;
            }
        }
        if (entityId.equals(cashFlow)) {
            this.batchSetValue(childOrgSet, orgIds, orgViewId, bookTypeId, accTableId, periodTypeId, periodId, "cashflow", amtprecision);
        } else if (entityId.equals(taxShow)) {
            this.batchSetValue(childOrgSet, orgIds, orgViewId, bookTypeId, accTableId, periodTypeId, periodId, "taxshow", amtprecision);
        }
        this.setTotalAmount(childOrgSet);
        this.setProgressBar(childOrgSet, orgIds, orgViewId, bookTypeId, accTableId, periodTypeId, periodId, amtprecision);
        this.getView().updateView(entryKey);
        this.getModel().getValue(currentPeriod, 3);
    }

    private Set<Long> getEntityOrg(List<Long> filterOrg) {
        HashSet<Long> result = new HashSet<Long>();
        try (DataSet dataSet = BatchProcessUtil.batchQueryDataSet(filterOrg, batchData -> QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"gl_accountbook", (String)"org", (QFilter[])new QFilter[]{new QFilter("org", "in", batchData), new QFilter("isbizunit", "=", (Object)true)}, null));){
            for (Row row : dataSet) {
                result.add(row.getLong("org"));
            }
        }
        return result;
    }

    private void batchSetValue(Set<Long> childOrgSet, List<Long> orgIds, long orgViewId, long bookTypeId, long accTableId, long periodTypeId, long periodId, String type, int amtprecision) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField(index, new Object[0]);
        vs.addField(project, new Object[0]);
        vs.addField(balrowId, new Object[0]);
        HashSet<Long> orgSet = new HashSet<Long>();
        orgSet.add(TaxReportFormHelper.getParentOrg(orgIds));
        DynamicObjectCollection collection = TaxReportFormHelper.getIncomeEdit(orgSet, (long)accTableId, (String)type, (QFilter[])new QFilter(bookType, "=", (Object)bookTypeId).toArray());
        if (collection != null && collection.size() > 0) {
            for (int i = 0; i < collection.size(); ++i) {
                DynamicObject dynamicObject = (DynamicObject)collection.get(i);
                vs.addRow(new Object[]{i + 1, dynamicObject.get(project), dynamicObject.get(balrowId)});
            }
        } else {
            List projects = TaxReportFormHelper.getProjects((String)type);
            for (int i = 0; i < projects.size(); ++i) {
                vs.addRow(new Object[]{i + 1, projects.get(i), i + 1});
            }
        }
        List resultList = TaxReportFormHelper.collectBal(orgIds, childOrgSet, (long)orgViewId, (long)bookTypeId, (long)accTableId, (long)periodTypeId, (long)periodId, (String)type, (int)2, (int)amtprecision);
        for (List row : resultList) {
            vs.addField(currentPeriod, new Object[]{row.get(0)});
            vs.addField(yearCount, new Object[]{row.get(1)});
        }
        if ("taxshow".equals(type)) {
            this.setTaxFormRate(childOrgSet, orgIds, orgViewId, bookTypeId, accTableId, periodTypeId, periodId, type, vs, resultList, amtprecision);
        }
        model.batchCreateNewEntryRow(entryKey, vs);
        model.endInit();
    }

    private void setTaxFormRate(Set<Long> childOrgSet, List<Long> orgIds, long orgViewId, long bookTypeId, long accTableId, long periodTypeId, long periodId, String type, TableValueSetter vs, List<List<BigDecimal>> periodTaxValue, int amtprecision) {
        Integer[] paidAmountRowArr;
        DynamicObject preYearPeriodDyn;
        long prePeriodId = 0L;
        if (periodId != 0L) {
            DynamicObject prePeriodDyn = GLUtil.getPreviousPeriod((Object)periodId);
            prePeriodId = prePeriodDyn == null ? 0L : prePeriodDyn.getLong("id");
        }
        long preYearPeriodId = (preYearPeriodDyn = GlFormUtil.getSamePeriodOfYear(periodId, 1)) == null ? 0L : preYearPeriodDyn.getLong("id");
        List prePeriodTaxValue = TaxReportFormHelper.collectBal(orgIds, childOrgSet, (long)orgViewId, (long)bookTypeId, (long)accTableId, (long)periodTypeId, (long)prePeriodId, (String)type, (int)2, (int)amtprecision);
        List preYearTaxValue = TaxReportFormHelper.collectBal(orgIds, childOrgSet, (long)orgViewId, (long)bookTypeId, (long)accTableId, (long)periodTypeId, (long)preYearPeriodId, (String)type, (int)2, (int)amtprecision);
        BigDecimal hundred = new BigDecimal("100");
        for (int i = 0; i < periodTaxValue.size(); ++i) {
            List<BigDecimal> curList = periodTaxValue.get(i);
            List preList = (List)prePeriodTaxValue.get(i);
            List preYearList = (List)preYearTaxValue.get(i);
            vs.set(prePeriodRate, (Object)this.divide(curList.get(0).subtract((BigDecimal)preList.get(0)).multiply(hundred), (BigDecimal)preList.get(0), 2, 4), i);
            vs.set(preYearPeriodRate, (Object)this.divide(curList.get(0).subtract((BigDecimal)preYearList.get(0)).multiply(hundred), (BigDecimal)preYearList.get(0), 2, 4), i);
            vs.set(preYearRate, (Object)this.divide(curList.get(1).subtract((BigDecimal)preYearList.get(1)).multiply(hundred), (BigDecimal)preYearList.get(1), 2, 4), i);
        }
        ArrayList tempVal = new ArrayList(51);
        for (int i = 0; i < 51; ++i) {
            ArrayList<BigDecimal> row = new ArrayList<BigDecimal>();
            row.add(BigDecimal.ZERO);
            row.add(BigDecimal.ZERO);
            tempVal.add(row);
        }
        if (periodTaxValue.size() < 2) {
            periodTaxValue.addAll(tempVal);
        }
        if (prePeriodTaxValue.size() < 2) {
            prePeriodTaxValue.addAll(tempVal);
        }
        if (preYearTaxValue.size() < 2) {
            preYearTaxValue.addAll(tempVal);
        }
        BigDecimal addCurPeriodVal = periodTaxValue.get(1).get(0).subtract(periodTaxValue.get(2).get(0));
        BigDecimal addPrePeriodVal = ((BigDecimal)((List)prePeriodTaxValue.get(1)).get(0)).subtract((BigDecimal)((List)prePeriodTaxValue.get(2)).get(0));
        BigDecimal addPreYearPeriodVal = ((BigDecimal)((List)preYearTaxValue.get(1)).get(0)).subtract((BigDecimal)((List)preYearTaxValue.get(2)).get(0));
        BigDecimal addYearVal = periodTaxValue.get(1).get(1).subtract(periodTaxValue.get(2).get(1));
        BigDecimal addPreYearVal = ((BigDecimal)((List)preYearTaxValue.get(1)).get(1)).subtract((BigDecimal)((List)preYearTaxValue.get(2)).get(1));
        List periodIncomeValue = TaxReportFormHelper.collectBal(orgIds, childOrgSet, (long)orgViewId, (long)bookTypeId, (long)accTableId, (long)periodTypeId, (long)periodId, (String)"income", (int)4, (int)amtprecision);
        List prePeriodIncomeValue = new ArrayList();
        if (prePeriodId != 0L) {
            prePeriodIncomeValue = TaxReportFormHelper.collectBal(orgIds, childOrgSet, (long)orgViewId, (long)bookTypeId, (long)accTableId, (long)periodTypeId, (long)prePeriodId, (String)"income", (int)4, (int)amtprecision);
        }
        List preYearIncomeValue = new ArrayList();
        if (preYearPeriodId != 0L) {
            preYearIncomeValue = TaxReportFormHelper.collectBal(orgIds, childOrgSet, (long)orgViewId, (long)bookTypeId, (long)accTableId, (long)periodTypeId, (long)preYearPeriodId, (String)"income", (int)4, (int)amtprecision);
        }
        BigDecimal periodIncome = new BigDecimal(0);
        BigDecimal yearIncome = new BigDecimal(0);
        if (periodIncomeValue.size() > 1) {
            periodIncome = (BigDecimal)((List)periodIncomeValue.get(0)).get(0);
            yearIncome = (BigDecimal)((List)periodIncomeValue.get(0)).get(1);
        }
        BigDecimal prePeriodIncome = new BigDecimal(0);
        if (prePeriodIncomeValue.size() > 1) {
            prePeriodIncome = (BigDecimal)((List)prePeriodIncomeValue.get(1)).get(0);
        }
        BigDecimal preYearPeriodIncome = new BigDecimal(0);
        BigDecimal preYearIncome = new BigDecimal(0);
        if (preYearIncomeValue.size() > 1) {
            preYearPeriodIncome = (BigDecimal)((List)preYearIncomeValue.get(0)).get(0);
            preYearIncome = (BigDecimal)((List)preYearIncomeValue.get(1)).get(0);
        }
        BigDecimal periodTotal = new BigDecimal("0");
        BigDecimal prePeriodTotal = new BigDecimal("0");
        BigDecimal preYearPeriodTotal = new BigDecimal("0");
        BigDecimal yearTotal = new BigDecimal("0");
        BigDecimal preYearTotal = new BigDecimal("0");
        Integer[] integerArray = paidAmountRowArr = new Integer[]{3, 7, 11, 15, 19, 23, 27, 31, 35, 39, 43, 47};
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int rateIndex = integerArray[i];
            BigDecimal periodVal = periodTaxValue.get(rateIndex).get(0);
            BigDecimal prePeriodVal = (BigDecimal)((List)prePeriodTaxValue.get(rateIndex)).get(0);
            BigDecimal preYearPeriodVal = (BigDecimal)((List)preYearTaxValue.get(rateIndex)).get(0);
            BigDecimal yearVal = periodTaxValue.get(rateIndex).get(1);
            BigDecimal preYearVal = (BigDecimal)((List)preYearTaxValue.get(rateIndex)).get(1);
            BigDecimal curPeriodRateVal = this.divide(periodVal.multiply(hundred), periodIncome);
            BigDecimal prePeriodRateVal = this.divide(prePeriodVal.multiply(hundred), prePeriodIncome);
            BigDecimal preYearPeriodRateVal = this.divide(preYearPeriodVal.multiply(hundred), preYearPeriodIncome);
            BigDecimal yearRateVal = this.divide(yearVal.multiply(hundred), yearIncome);
            BigDecimal preYearRateVal = this.divide(preYearVal.multiply(hundred), preYearIncome);
            vs.set(currentPeriod, (Object)curPeriodRateVal.setScale(2, 4), rateIndex + 1);
            vs.set(prePeriodRate, (Object)this.divide(curPeriodRateVal.subtract(prePeriodRateVal).multiply(hundred), prePeriodRateVal, 2, 4), rateIndex + 1);
            vs.set(preYearPeriodRate, (Object)this.divide(curPeriodRateVal.subtract(preYearPeriodRateVal).multiply(hundred), preYearPeriodRateVal, 2, 4), rateIndex + 1);
            vs.set(yearCount, (Object)yearRateVal.setScale(2, 4), rateIndex + 1);
            vs.set(preYearRate, (Object)this.divide(yearRateVal.subtract(preYearRateVal), preYearRateVal, 2, 4), rateIndex + 1);
            periodTotal = periodTotal.add(periodVal);
            prePeriodTotal = prePeriodTotal.add(prePeriodVal);
            preYearPeriodTotal = preYearPeriodTotal.add(preYearPeriodVal);
            yearTotal = yearTotal.add(yearVal);
            preYearTotal = preYearTotal.add(preYearVal);
        }
        vs.set(currentPeriod, (Object)periodTotal, 49);
        vs.set(prePeriodRate, (Object)this.divide(periodTotal.subtract(prePeriodTotal).multiply(hundred), prePeriodTotal, 2, 4), 49);
        vs.set(preYearPeriodRate, (Object)this.divide(periodTotal.subtract(preYearPeriodTotal).multiply(hundred), preYearPeriodTotal, 2, 4), 49);
        vs.set(yearCount, (Object)yearTotal, 49);
        vs.set(preYearRate, (Object)this.divide(yearTotal.subtract(preYearTotal).multiply(hundred), preYearTotal, 2, 4), 49);
        BigDecimal periodTotalRate = this.divide(periodTotal, periodIncome);
        BigDecimal prePeriodTotalRate = this.divide(prePeriodTotal, prePeriodIncome);
        BigDecimal preYearPeriodTotalRate = this.divide(preYearPeriodTotal, preYearPeriodIncome);
        BigDecimal yearTotalRate = this.divide(yearTotal, yearIncome);
        BigDecimal preYearTotalRate = this.divide(preYearTotal, preYearIncome);
        vs.set(currentPeriod, (Object)periodTotalRate.setScale(2, 4), 50);
        vs.set(prePeriodRate, (Object)this.divide(periodTotalRate.subtract(prePeriodTotalRate).multiply(hundred), prePeriodTotalRate, 2, 4), 50);
        vs.set(preYearPeriodRate, (Object)this.divide(periodTotal.subtract(preYearPeriodTotalRate).multiply(hundred), preYearPeriodTotalRate, 2, 4), 50);
        vs.set(yearCount, (Object)yearTotalRate.setScale(2, 4), 50);
        vs.set(preYearRate, (Object)this.divide(yearTotalRate.subtract(preYearTotalRate).multiply(hundred), preYearTotalRate, 2, 4), 50);
    }

    private String divide(BigDecimal dividend, BigDecimal divisor, int scale, int round) {
        if (dividend.compareTo(BigDecimal.ZERO) == 0) {
            return "";
        }
        if (divisor.compareTo(BigDecimal.ZERO) == 0) {
            if (dividend.compareTo(BigDecimal.ZERO) < 0) {
                return "-100%";
            }
            return "100%";
        }
        return dividend.divide(divisor, scale, round) + "%";
    }

    private BigDecimal divide(BigDecimal dividend, BigDecimal divisor) {
        if (divisor.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        return dividend.divide(divisor, 4, 4);
    }

    private void setProgressBar(Set<Long> childOrgSet, List<Long> orgIds, Long orgViewId, Long bookTypeId, Long accTableId, Long periodTypeId, Long periodId, int amtprecision) {
        FormShowParameter para;
        Map<Object, Object> map = new HashMap();
        IDataModel model = this.getModel();
        DynamicObjectCollection entryColl = model.getEntryEntity(entryKey);
        if (entryColl.isEmpty()) {
            return;
        }
        if (model.getDataEntity().toString().startsWith("gl_cashflow")) {
            BigDecimal num = ((DynamicObject)entryColl.get(10)).getBigDecimal(currentPeriod);
            BigDecimal netAmount = ((DynamicObject)entryColl.get(23)).getBigDecimal(currentPeriod);
            ArrayList<String> list = new ArrayList<String>();
            list.add(ResManager.loadKDString((String)"\u81ea\u7531\u73b0\u91d1\u6d41\u589e\u957f\u7387", (String)"TaxShowPlugin_12", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            list.add(String.valueOf(num.subtract(netAmount)));
            map.put("0", list);
            num = ((DynamicObject)entryColl.get(10)).getBigDecimal(currentPeriod);
            list = new ArrayList();
            list.add(ResManager.loadKDString((String)"\u503a\u52a1\u4fdd\u969c\u6bd4", (String)"TaxShowPlugin_13", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            list.add(String.valueOf(num));
            map.put("1", list);
            num = ((DynamicObject)entryColl.get(10)).getBigDecimal(currentPeriod);
            list = new ArrayList();
            list.add(ResManager.loadKDString((String)"\u5168\u90e8\u8d44\u4ea7\u73b0\u91d1\u56de\u6536\u7387", (String)"TaxShowPlugin_14", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            list.add(String.valueOf(num));
            map.put("2", list);
            num = ((DynamicObject)entryColl.get(5)).getBigDecimal(currentPeriod);
            BigDecimal denom = ((DynamicObject)entryColl.get(1)).getBigDecimal(currentPeriod);
            int value = TaxReportFormHelper.getPercentValue((BigDecimal)num, (BigDecimal)denom);
            list = new ArrayList();
            list.add(ResManager.loadKDString((String)"\u73b0\u91d1\u8d2d\u9500\u6bd4\u7387", (String)"TaxShowPlugin_15", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            list.add(String.valueOf(value));
            map.put("3", list);
            num = ((DynamicObject)entryColl.get(1)).getBigDecimal(currentPeriod);
            list = new ArrayList();
            list.add(ResManager.loadKDString((String)"\u8425\u4e1a\u73b0\u91d1\u56de\u7b3c\u7387", (String)"TaxShowPlugin_16", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            list.add(String.valueOf(num));
            map.put("4", list);
            para = TaxReportFormHelper.FinMainIndexFormShow((String)"cashflow", childOrgSet, orgIds, (Long)orgViewId, (Long)bookTypeId, (Long)accTableId, (Long)periodTypeId, (Long)periodId, map, (int)amtprecision);
        } else {
            map = this.getTaxShowBar();
            para = TaxReportFormHelper.FinMainIndexFormShow((String)"taxshow", childOrgSet, orgIds, (Long)orgViewId, (Long)bookTypeId, (Long)accTableId, (Long)periodTypeId, (Long)periodId, map, (int)amtprecision);
        }
        this.getView().showForm(para);
    }

    private Map<String, List<String>> getTaxShowBar() {
        DynamicObjectCollection entryColl = this.getModel().getEntryEntity(entryKey);
        ArrayList<String> listName = new ArrayList<String>(5);
        listName.add(ResManager.loadKDString((String)"\u589e\u503c\u7a0e\u589e\u957f\u7387", (String)"TaxShowPlugin_17", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        listName.add(ResManager.loadKDString((String)"\u57ce\u5efa\u7a0e\u589e\u957f\u7387", (String)"TaxShowPlugin_18", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        listName.add(ResManager.loadKDString((String)"\u6559\u80b2\u8d39\u9644\u52a0\u589e\u957f\u7387", (String)"TaxShowPlugin_19", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        listName.add(ResManager.loadKDString((String)"\u4e2a\u4eba\u6240\u5f97\u7a0e\u589e\u957f\u7387", (String)"TaxShowPlugin_20", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        listName.add(ResManager.loadKDString((String)"\u4f01\u4e1a\u6240\u5f97\u7a0e\u589e\u957f\u7387", (String)"TaxShowPlugin_21", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        int[] numIndex = new int[]{3, 15, 19, 27, 31};
        int size = listName.size();
        HashMap<String, List<String>> map = new HashMap<String, List<String>>(size);
        for (int i = 0; i < size; ++i) {
            ArrayList list = new ArrayList();
            list.add(listName.get(i));
            BigDecimal num = ((DynamicObject)entryColl.get(numIndex[i])).getBigDecimal(currentPeriod).stripTrailingZeros();
            if (num.compareTo(BigDecimal.ZERO) == 0) {
                list.add(String.valueOf(BigDecimal.ZERO));
            } else {
                list.add(String.valueOf(num));
            }
            map.put(i + "", list);
        }
        return map;
    }

    private void setTotalAmount(Set<Long> childOrgSet) {
        IDataModel model = this.getModel();
        String formName = model.getDataEntity().toString();
        if (formName.startsWith("gl_cashflow")) {
            DynamicObjectCollection entryEntity = model.getEntryEntity(entryKey);
            ArrayList<BigDecimal> list = new ArrayList<BigDecimal>();
            for (DynamicObject dynamicObject : entryEntity) {
                list.add(dynamicObject.getBigDecimal(currentPeriod));
            }
            BigDecimal cashIn1 = this.getSum(list, 2, 4);
            model.setValue(currentPeriod, (Object)cashIn1, 4);
            BigDecimal cashOut1 = this.getSum(list, 6, 9);
            model.setValue(currentPeriod, (Object)cashOut1, 9);
            BigDecimal cashNet1 = cashIn1.subtract(cashOut1);
            model.setValue(currentPeriod, (Object)cashNet1, 10);
            BigDecimal cashIn2 = this.getSum(list, 13, 17);
            model.setValue(currentPeriod, (Object)cashIn2, 17);
            BigDecimal cashOut2 = this.getSum(list, 19, 22);
            model.setValue(currentPeriod, (Object)cashOut2, 22);
            BigDecimal cashNet2 = cashIn2.subtract(cashOut2);
            model.setValue(currentPeriod, (Object)cashNet2, 23);
            BigDecimal cashIn3 = this.getSum(list, 26, 28);
            model.setValue(currentPeriod, (Object)cashIn3, 28);
            BigDecimal cashOut3 = this.getSum(list, 30, 32);
            model.setValue(currentPeriod, (Object)cashOut3, 32);
            BigDecimal cashNet3 = cashIn3.subtract(cashOut3);
            model.setValue(currentPeriod, (Object)cashNet3, 33);
            BigDecimal cashNet = cashNet1.add(cashNet2).add(cashNet3).add((BigDecimal)list.get(34));
            model.setValue(currentPeriod, (Object)cashNet, 35);
            BigDecimal cashBalance = cashNet.add((BigDecimal)list.get(36));
            model.setValue(currentPeriod, (Object)cashBalance, 37);
            BigDecimal suppCashNet = this.getSum(list, 41, 56);
            model.setValue(currentPeriod, (Object)suppCashNet, 56);
            BigDecimal suppCashInc = ((BigDecimal)list.get(62)).subtract((BigDecimal)list.get(63)).add((BigDecimal)list.get(64)).subtract((BigDecimal)list.get(65));
            model.setValue(currentPeriod, (Object)suppCashInc, 66);
        }
    }

    private BigDecimal getSum(List<BigDecimal> list, int begin, int end) {
        BigDecimal result = BigDecimal.ZERO;
        --end;
        for (int i = --begin; i <= end; ++i) {
            result = result.add(list.get(i));
        }
        return result;
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String propertyName = args.getProperty().getName();
        Object newObj = args.getChangeSet()[0].getNewValue();
        if (newObj == null) {
            return;
        }
        switch (propertyName) {
            case "orgs": 
            case "orgview": 
            case "booktype": 
            case "accounttable": 
            case "periodtype": 
            case "period": {
                String childOrgSetStr = this.getPageCache().get("childOrgSet");
                if (childOrgSetStr == null) {
                    return;
                }
                Set childOrgSet = (Set)GLUtil.fromSerializedString((String)childOrgSetStr);
                this.setValue(childOrgSet);
            }
        }
    }

    protected List<Long> getOrgValue() {
        DynamicObjectCollection orgs = (DynamicObjectCollection)this.getModel().getValue("orgs");
        return orgs.stream().map(x -> x.getLong("fbasedataid_id")).collect(Collectors.toList());
    }
}

