/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.constant.Voucher;
import kd.fi.gl.flex.FlexValueJson;
import kd.fi.gl.util.ContextUtil;

public class TemplateVoucherEditValueGetter {
    private final IDataModel templateVoucherEditModel;

    protected TemplateVoucherEditValueGetter(IDataModel voucherEditModel) {
        Objects.requireNonNull(voucherEditModel);
        this.templateVoucherEditModel = voucherEditModel;
    }

    protected long getOrgId() {
        return (Long)this.templateVoucherEditModel.getValue(Voucher.id_((String)"org"));
    }

    protected long getBookTypeId() {
        return (Long)this.templateVoucherEditModel.getValue(Voucher.id_((String)"booktype"));
    }

    protected long getPeriodId() {
        return (Long)this.templateVoucherEditModel.getValue(Voucher.id_((String)"period"));
    }

    protected long getAccountTableId() {
        return AccSysUtil.getCurPeriodAccountTableId((long)this.getOrgId(), (long)this.getBookTypeId(), (long)this.getPeriodId());
    }

    protected DynamicObject getLoaclCurrency() {
        return (DynamicObject)this.templateVoucherEditModel.getValue("localcur");
    }

    protected long getSystemUserId() {
        return ContextUtil.getUserId();
    }

    protected BigDecimal getCashUnused() {
        BigDecimal cashUnused = (BigDecimal)this.templateVoucherEditModel.getValue("cashunused");
        return cashUnused == null ? BigDecimal.ZERO : cashUnused;
    }

    protected BigDecimal getPlUnused() {
        BigDecimal plUnused = (BigDecimal)this.templateVoucherEditModel.getValue("plunused");
        return plUnused == null ? BigDecimal.ZERO : plUnused;
    }

    protected BigDecimal getCashTotal() {
        BigDecimal cashUnused = (BigDecimal)this.templateVoucherEditModel.getValue("cashtotal");
        return cashUnused == null ? BigDecimal.ZERO : cashUnused;
    }

    protected BigDecimal getPlTotal() {
        BigDecimal plUnused = (BigDecimal)this.templateVoucherEditModel.getValue("pltotal");
        return plUnused == null ? BigDecimal.ZERO : plUnused;
    }

    protected long getCurrencyId(int rowIndex) {
        return (Long)this.templateVoucherEditModel.getValue(Voucher.id_((String)"currency"), rowIndex);
    }

    protected DynamicObject getAccount(int rowIndex) {
        return (DynamicObject)this.getEntryValue("account", rowIndex);
    }

    protected long getAccountId(int rowIndex) {
        return (Long)this.getEntryValue(Voucher.id_((String)"account"), rowIndex);
    }

    protected BigDecimal getCreditLocal(int rowIndex) {
        BigDecimal bigDecimal = (BigDecimal)this.getEntryValue("creditlocal", rowIndex);
        return bigDecimal == null ? BigDecimal.ZERO : bigDecimal;
    }

    protected BigDecimal getDebitLocal(int rowIndex) {
        BigDecimal bigDecimal = (BigDecimal)this.getEntryValue("debitlocal", rowIndex);
        return bigDecimal == null ? BigDecimal.ZERO : bigDecimal;
    }

    protected BigDecimal getMainCfAmount(int rowIndex) {
        BigDecimal bigDecimal = (BigDecimal)this.getEntryValue("maincfamount", rowIndex);
        return bigDecimal == null ? BigDecimal.ZERO : bigDecimal;
    }

    protected BigDecimal getSuppCfAmount(int rowIndex) {
        BigDecimal bigDecimal = (BigDecimal)this.getEntryValue("suppcfamount", rowIndex);
        return bigDecimal == null ? BigDecimal.ZERO : bigDecimal;
    }

    protected DynamicObject getMainCfItem(int rowIndex) {
        return (DynamicObject)this.getEntryValue("maincfitem", rowIndex);
    }

    protected DynamicObject getSuppCfItem(int rowIndex) {
        return (DynamicObject)this.getEntryValue("suppcfitem", rowIndex);
    }

    protected Map<String, Object> getAssgrpValue(int rowIndex) {
        DynamicObject assgrpDynValue = (DynamicObject)this.getEntryValue("assgrp", rowIndex);
        if (assgrpDynValue == null) {
            return new HashMap<String, Object>(16);
        }
        FlexValueJson flexValueJson = new FlexValueJson(assgrpDynValue.getString("value"));
        return flexValueJson.getValueMap();
    }

    private Object getEntryValue(String key, int rowIndex) {
        return this.templateVoucherEditModel.getValue(key, rowIndex);
    }
}

