/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.bd.consts.AccountType;
import kd.fi.bd.util.AccountUtils;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.finalprocess.constant.TransPLConstant;
import kd.fi.gl.formplugin.importexport.GLImportHelper;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.PermissonType;
import kd.fi.gl.util.QFBuilder;

public class TransPLProgramsEdit
extends AbstractBillPlugIn
implements ClickListener,
BeforeF7SelectListener {
    private static final String ORG = "org";
    private static final String VOUCHER_TYPE = "vouchertypeid";
    private static final String YEAR_PROFIT_ACCT = "yearprofitacct";
    private static final String BOOK = "book";
    private static final String TRANS_ACCT = "transacct";
    private static final String IS_DES_ACCT = "isdesacct";
    private static final String FieldKey_EDesc = "voucherdesc";
    private static final String KEY_ACCOUNT_TYPE = "accounttype.accounttype";
    private Set<Long> orgIds = new HashSet<Long>();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit org = (BasedataEdit)this.getControl(ORG);
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit voucherType = (BasedataEdit)this.getControl(VOUCHER_TYPE);
        voucherType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit yearprofitacct = (BasedataEdit)this.getControl(YEAR_PROFIT_ACCT);
        yearprofitacct.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit book = (BasedataEdit)this.getControl(BOOK);
        book.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit transacct = (BasedataEdit)this.getControl(TRANS_ACCT);
        transacct.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.setDefaultVouchertype();
        this.setProfitAccount();
        this.getModel().setValue(FieldKey_EDesc, (Object)ResManager.loadKDString((String)"\u7ed3\u8f6c\u635f\u76ca", (String)"TransPLProgramsEdit_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        long orgId = (Long)this.getModel().getValue("org_id");
        List bookTypeIds = AccSysUtil.getAllBookTypeByOrg((long)orgId);
        this.getView().setVisible(Boolean.valueOf(bookTypeIds.size() != 1), new String[]{BOOK});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        switch (propName = e.getProperty().getName()) {
            case "isdesacct": {
                this.getModel().setValue(TRANS_ACCT, null);
                break;
            }
            case "book": {
                IDataModel model = this.getModel();
                model.setValue(VOUCHER_TYPE, null);
                model.setValue(YEAR_PROFIT_ACCT, null);
                model.setValue(TRANS_ACCT, null);
                this.setProfitAccount();
                break;
            }
            case "org": {
                this.setProfitAccount();
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = ((BasedataEdit)e.getSource()).getKey();
        DynamicObject orgDb = (DynamicObject)this.getModel().getValue(ORG);
        DynamicObject bookDb = (DynamicObject)this.getModel().getValue(BOOK);
        if (ORG.equals(key)) {
            List orgIds = AccSysUtil.getAcctOrgPkList((String)this.getView().getEntityId(), (boolean)false, (PermissonType)PermissonType.NEW);
            QFilter qFilter = new QFilter("id", "in", (Object)orgIds);
            this.setListShowFilter(e, qFilter);
        } else if (VOUCHER_TYPE.equals(key)) {
            this.checkOrg(orgDb);
            long orgId = orgDb.getLong("id");
            QFilter qFilter = BaseDataServiceHelper.getBaseDataFilter((String)"gl_vouchertype", (Long)orgId);
            this.setListShowFilter(e, qFilter);
        } else if (YEAR_PROFIT_ACCT.equals(key)) {
            this.checkOrg(orgDb);
            this.checkBook(bookDb);
            long orgId = (Long)this.getModel().getValue("org_Id");
            long bookstype = (Long)this.getModel().getValue("book_Id");
            AccountBookInfo bookInfo = AccSysUtil.getBookFromAccSys((long)orgId, (long)bookstype);
            long accountTableId = AccSysUtil.getCurPeriodAccountTableId((long)orgId, (long)bookstype, (long)bookInfo.getCurPeriodId());
            QFBuilder accountFilter = kd.fi.gl.util.AccountUtils.getAccountFilter((long)orgId, (long)accountTableId, (long)bookInfo.getCurPeriodId(), (boolean)Boolean.TRUE, (QFilter)new QFilter(KEY_ACCOUNT_TYPE, "=", (Object)"2").and("ischangecurrency", "=", (Object)"0"));
            ListShowParameter showParam = (ListShowParameter)e.getFormShowParameter();
            ListFilterParameter filterParam = showParam.getListFilterParameter();
            showParam.getCustomParams().put("acct_filter", Boolean.TRUE);
            filterParam.setQFilters(accountFilter.toList());
        } else if (BOOK.equals(key)) {
            this.checkOrg(orgDb);
            ListShowParameter showParam = (ListShowParameter)e.getFormShowParameter();
            Object orgId = this.getModel().getValue("org_id");
            DynamicObjectCollection books = QueryServiceHelper.query((String)"gl_accountbook", (String)"bookstype", (QFilter[])new QFilter(ORG, "=", orgId).toArray());
            ArrayList<Object> booktypeIds = new ArrayList<Object>();
            for (DynamicObject b : books) {
                booktypeIds.add(b.get("bookstype"));
            }
            showParam.getListFilterParameter().getQFilters().add(new QFilter("id", "in", booktypeIds));
        } else if (TRANS_ACCT.equals(key)) {
            this.checkOrg(orgDb);
            this.checkBook(bookDb);
            long orgId = (Long)this.getModel().getValue("org_Id");
            long bookstype = (Long)this.getModel().getValue("book_Id");
            AccountBookInfo bookInfo = AccSysUtil.getBookFromAccSys((long)orgId, (long)bookstype);
            long accountTableId = AccSysUtil.getCurPeriodAccountTableId((long)orgId, (long)bookstype, (long)bookInfo.getCurPeriodId());
            QFBuilder accountFilter = kd.fi.gl.util.AccountUtils.getAccountFilter((long)orgId, (long)accountTableId, (long)bookInfo.getCurPeriodId(), (boolean)Boolean.FALSE, (QFilter)new QFilter(KEY_ACCOUNT_TYPE, "=", (Object)"4"));
            ListShowParameter showParam = (ListShowParameter)e.getFormShowParameter();
            ListFilterParameter filterParam = showParam.getListFilterParameter();
            filterParam.setQFilters(accountFilter.toList());
            showParam.setCustomParam("acct_filter", (Object)Boolean.TRUE);
        }
    }

    private void checkOrg(DynamicObject orgDb) {
        if (orgDb == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u4e3a\u7a7a\uff0c\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"TransPLProgramsEdit_1", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        }
    }

    private void checkBook(DynamicObject bookDb) {
        if (bookDb == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8d26\u7c3f\u7c7b\u578b\u3002", (String)"TransPLProgramsEdit_4", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        }
    }

    private void setListShowFilter(BeforeF7SelectEvent e, QFilter qFilter) {
        ListShowParameter showParam = (ListShowParameter)e.getFormShowParameter();
        ListFilterParameter filterParam = showParam.getListFilterParameter();
        List qFilters = filterParam.getQFilters();
        qFilters.add(qFilter);
    }

    private void setDefaultVouchertype() {
        long orgId;
        IDataModel model = this.getModel();
        DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
        if (org == null) {
            orgId = AccSysUtil.getAccountingOrg((String)this.getView().getEntityId(), (boolean)false, (PermissonType)PermissonType.NEW);
        } else {
            orgId = org.getLong("id");
            if (!AccSysUtil.isBizUnit((long)orgId) || !GLUtil.hasPermission((String)PermissonType.NEW.getPermId(), (Long)orgId, (String)"gl_transplprogram")) {
                orgId = AccSysUtil.getAccountingOrg((String)this.getView().getEntityId(), (boolean)false, (PermissonType)PermissonType.NEW);
            }
        }
        if (orgId != 0L) {
            model.setValue(ORG, (Object)orgId);
            String exchangeBook = this.getPageCache().get("exchangeBook");
            if (exchangeBook == null) {
                HashMap<String, Object> book = this.getAllBookByOrg(orgId);
                model.setValue(BOOK, book.get("bookid"));
                model.setValue("ismultiplebook", book.get("ismultiplebook"));
                model.setValue(VOUCHER_TYPE, book.get("vouchertype"));
            } else {
                DynamicObject curOrg = (DynamicObject)this.getModel().getContextVariable(ORG);
                model.setValue(ORG, (Object)curOrg);
                model.setValue("ismultiplebook", (Object)"1");
                this.getPageCache().remove("exchangeBook");
            }
        } else {
            model.setValue(ORG, null);
        }
    }

    private HashMap<String, Object> getAllBookByOrg(Long orgId) {
        HashMap<String, Object> bookInfoMap = new HashMap<String, Object>();
        List bookIdList = AccSysUtil.getAllBookFromAccSys((long)orgId);
        if (bookIdList.isEmpty()) {
            bookInfoMap.put("bookid", 0);
            bookInfoMap.put("ismultiplebook", "1");
        } else {
            if (bookIdList.size() > 1) {
                bookInfoMap.put("ismultiplebook", "1");
            } else {
                bookInfoMap.put("ismultiplebook", "0");
            }
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            Object booktypeId = customParams.get(BOOK);
            Map books = BusinessDataServiceHelper.loadFromCache((Object[])bookIdList.toArray(), (String)"gl_accountbook");
            DynamicObject book = null;
            if (booktypeId != null) {
                for (Map.Entry bookEntry : books.entrySet()) {
                    DynamicObject accountbook = (DynamicObject)bookEntry.getValue();
                    long btypeid = accountbook.getLong("bookstype_id");
                    if (btypeid != Long.parseLong(booktypeId.toString())) continue;
                    book = accountbook;
                    break;
                }
            }
            if (book == null && !books.isEmpty()) {
                book = (DynamicObject)books.values().iterator().next();
            }
            if (book != null) {
                bookInfoMap.put("bookid", ((DynamicObject)book.get("bookstype")).getPkValue());
                bookInfoMap.put("vouchertype", book.get("defaultvouchertype"));
            } else {
                bookInfoMap.put("bookid", 0);
            }
        }
        return bookInfoMap;
    }

    private void setProfitAccount() {
        QFilter bookTypeFilter;
        DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
        DynamicObject bookType = (DynamicObject)this.getModel().getValue(BOOK);
        if (org == null || bookType == null) {
            return;
        }
        QFilter orgFilter = new QFilter(ORG, "=", org.getPkValue());
        DynamicObject accountBook = QueryServiceHelper.queryOne((String)"gl_accountbook", (String)YEAR_PROFIT_ACCT, (QFilter[])new QFilter[]{orgFilter, bookTypeFilter = new QFilter("bookstype", "=", bookType.getPkValue())});
        if (accountBook == null) {
            return;
        }
        Long yearProfitAcctId = accountBook.getLong(YEAR_PROFIT_ACCT);
        this.getModel().setValue(YEAR_PROFIT_ACCT, (Object)yearProfitAcctId);
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        Map transAccMap;
        Boolean isDesAcct;
        GLImportHelper importHelper = new GLImportHelper((AbstractFormPlugin)this);
        importHelper.registerBuilder(TransPLConstant.AcctTransFrom, TransPLConstant.AcctTransIn);
        importHelper.build(e);
        Map data = e.getSourceData();
        Long orgId = (Long)((Map)data.get(ORG)).get("id");
        if (orgId == null) {
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", ((Map)data.get(ORG)).get("number"))});
            orgId = dynamicObject.getLong("id");
        }
        if (!this.orgIds.contains(orgId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6743\u9650\u6216\u4e3a\u865a\u4f53\u7ec4\u7ec7\u3002", (String)"TransPLProgramsEdit_2", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        }
        Map bookType = (Map)data.get(BOOK);
        DynamicObject bookTypeDyn = QueryServiceHelper.queryOne((String)"bd_accountbookstype", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", bookType.get("number"))});
        this.checkBook(bookTypeDyn);
        long bookTypeId = bookTypeDyn.getLong("id");
        Map yearPlAcc = (Map)data.get(YEAR_PROFIT_ACCT);
        DynamicObjectCollection yearAccount = this.getAccount(orgId, bookTypeId, (String)yearPlAcc.get("number"));
        this.checkAcc(YEAR_PROFIT_ACCT, (DynamicObject[])yearAccount.toArray((Object[])new DynamicObject[0]));
        Boolean bl = isDesAcct = data.get(IS_DES_ACCT) == null ? Boolean.FALSE : (Boolean)data.get(IS_DES_ACCT);
        if (isDesAcct.booleanValue() && (transAccMap = (Map)data.get(TRANS_ACCT)) != null) {
            DynamicObjectCollection accounts = this.getAccount(orgId, bookTypeId, ((String)transAccMap.get("number")).split(","));
            this.checkAcc(TRANS_ACCT, (DynamicObject[])accounts.toArray((Object[])new DynamicObject[0]));
        }
    }

    public void initImportData(InitImportDataEventArgs e) {
        this.orgIds.addAll(AccSysUtil.getAcctOrgPkList((String)this.getView().getEntityId(), (boolean)false, (PermissonType)PermissonType.VIEW));
    }

    private DynamicObjectCollection getAccount(long orgId, long bookTypeId, String ... accountNumber) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        AccountBookInfo bookInfo = AccSysUtil.getBookFromAccSys((long)orgId, (long)bookTypeId);
        qFilters.add(new QFilter("number", "in", (Object)accountNumber));
        QFilter ctrlFilter = AccountUtils.getAccountDataFilter((long)orgId, (long)bookInfo.getAccountTableId());
        qFilters.add(ctrlFilter);
        DynamicObjectCollection accountView = QueryServiceHelper.query((String)"bd_accountview", (String)String.join((CharSequence)",", "id", "number", "ischangecurrency", KEY_ACCOUNT_TYPE), (QFilter[])qFilters.toArray(new QFilter[0]));
        if (accountView == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u79d1\u76ee%1$s\u4e0d\u53ef\u7528\u3002", (String)"TransPLProgramsEdit_5", (String)"fi-gl-formplugin", (Object[])new Object[0]), Arrays.toString(accountNumber)));
        }
        return accountView;
    }

    private void checkAcc(String fieldKey, DynamicObject ... accDyn) {
        Set list = Arrays.stream(AccountType.BUDGET_ACCOUNT).collect(Collectors.toSet());
        block8: for (DynamicObject dyn : accDyn) {
            if (list.contains(dyn.getString(KEY_ACCOUNT_TYPE))) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ed3\u8f6c\u79d1\u76ee\u4e0d\u80fd\u4e3a\u9884\u7b97\u4f1a\u8ba1\u79d1\u76ee%1$s\u3002", (String)"TransPLProgramsEdit_6", (String)"fi-gl-formplugin", (Object[])new Object[0]), dyn.getString("number")));
            }
            switch (fieldKey) {
                case "yearprofitacct": {
                    if ("2".equals(dyn.getString(KEY_ACCOUNT_TYPE)) && !dyn.getBoolean("ischangecurrency")) continue block8;
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u672c\u5e74\u5229\u6da6\u79d1\u76ee%1$s\u53ea\u80fd\u4e3a\u6743\u76ca\u7c7b\u79d1\u76ee\uff0c\u5e76\u4e14\u672a\u52fe\u9009\u671f\u672b\u8c03\u6c47\u3002", (String)"TransPLProgramsEdit_7", (String)"fi-gl-formplugin", (Object[])new Object[0]), dyn.getString("number")));
                }
                case "transacct": {
                    if ("4".equals(dyn.getString(KEY_ACCOUNT_TYPE))) continue block8;
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ed3\u8f6c\u79d1\u76ee%1$s\u53ea\u80fd\u662f\u635f\u76ca\u7c7b\u79d1\u76ee\u3002", (String)"TransPLProgramsEdit_8", (String)"fi-gl-formplugin", (Object[])new Object[0]), dyn.getString("number")));
                }
            }
        }
    }
}

