/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin;

import com.alibaba.fastjson.JSONArray;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.bd.vo.CommonAssist;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.comassist.model.ComAssistTable;
import kd.fi.gl.comassist.service.ComAssistService;
import kd.fi.gl.comassist.service.ComAssistTableService;
import kd.fi.gl.constant.GLField;
import kd.fi.gl.formplugin.comassist.AbstractComAssistBillPlugin;
import kd.fi.gl.util.CommonAssistUtil;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.PermissonType;

public class VoucherAmortComAssistEdit
extends AbstractComAssistBillPlugin {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void getEntityType(GetEntityTypeEventArgs e) {
        long booktypeId;
        long orgId;
        if (!CommonAssistUtil.isCommonAssistEnabled() || this.getEntityTypeForImport(e)) {
            return;
        }
        BillShowParameter billShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        String formId = billShowParameter.getFormId();
        Object pkId = billShowParameter.getPkId();
        IDataModel model = this.getModel();
        String orgFieldName = this.getOrgKey();
        String booktypeFieldName = this.getBookTypeKey();
        if (model.isDataLoaded()) {
            orgId = (Long)model.getValue(GLField.id_((String)orgFieldName));
            booktypeId = (Long)model.getValue(GLField.id_((String)booktypeFieldName));
        } else if (pkId == null) {
            Map customParams = billShowParameter.getCustomParams();
            boolean needSetDefaultValue = false;
            for (Map.Entry customParamsEntry : customParams.entrySet()) {
                if (!((String)customParamsEntry.getKey()).startsWith("comassist") || !CollectionUtils.isNotEmpty((Collection)((JSONArray)customParamsEntry.getValue()))) continue;
                needSetDefaultValue = true;
                break;
            }
            if (!needSetDefaultValue) return;
            if (StringUtils.isNotBlank(customParams.get(orgFieldName)) && GLUtil.hasPermission((String)PermissonType.NEW.getPermId(), (Long)Long.parseLong(customParams.get(orgFieldName).toString()), (String)formId)) {
                orgId = Long.parseLong(customParams.get(orgFieldName).toString());
            } else {
                orgId = RequestContext.get().getOrgId();
                if (!GLUtil.hasPermission((String)PermissonType.NEW.getPermId(), (Long)orgId, (String)formId)) {
                    orgId = AccSysUtil.getAccountingOrg((String)this.getView().getEntityId(), (boolean)false, (PermissonType)PermissonType.NEW);
                }
            }
            booktypeId = this.getDefBookTypeByOrg(orgId, booktypeFieldName);
        } else {
            DynamicObject billDyn = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)formId, (String)String.join((CharSequence)",", orgFieldName, booktypeFieldName));
            orgId = billDyn.getLong(GLField.id_((String)orgFieldName));
            booktypeId = billDyn.getLong(GLField.id_((String)booktypeFieldName));
        }
        ComAssistTable.get((Long)orgId, (Long)booktypeId).ifPresent(comAssistTable -> e.setNewEntityType((MainEntityType)ComAssistTableService.modifyEntityType((ComAssistTable)comAssistTable, (EntityType)e.getOriginalEntityType())));
        this.getModel().updateCache();
    }

    public void beforeBindData(EventObject e) {
        IDataModel model = this.getModel();
        long orgId = (Long)model.getValue(GLField.id_((String)this.getOrgKey()));
        long bookTypeId = (Long)model.getValue(GLField.id_((String)this.getBookTypeKey()));
        this.modifyCommonAssistFields(this.getView(), orgId, bookTypeId);
    }

    @Override
    public void afterBindData(EventObject e) {
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String orgFieldName = this.getOrgKey();
        String bookTypeFieldName = this.getBookTypeKey();
        long orgId = (Long)this.getModel().getValue(GLField.id_((String)orgFieldName));
        long bookTypeId = (Long)this.getModel().getValue(GLField.id_((String)bookTypeFieldName));
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        String propName = e.getProperty().getName();
        if (propName.equals(orgFieldName) || propName.equals(bookTypeFieldName)) {
            this.modifyCommonAssistFields(this.getView(), orgId, bookTypeId);
            this.cleanComAssistValue();
        } else if (propName.startsWith("comassist") && !propName.endsWith("dest")) {
            if (propName.endsWith("target")) {
                this.getModel().setValue("plantype", (Object)"0", rowIndex);
            } else {
                for (int i = 0; i < this.getModel().getEntryRowCount("targetaccounts"); ++i) {
                    this.getModel().setValue("plantype", (Object)"0", i);
                }
            }
        }
    }

    @Override
    public void registerListener(EventObject e) {
        List allComAssistKeys = this.getModel().getDataEntityType().getAllFields().keySet().stream().filter(field -> field.startsWith("comassist")).collect(Collectors.toList());
        for (String comAssistKey : allComAssistKeys) {
            BasedataEdit comAssistControl = (BasedataEdit)this.getControl(comAssistKey);
            comAssistControl.addBeforeF7SelectListener(ComAssistService.F7Listener);
        }
    }

    private void modifyCommonAssistFields(IFormView view, long orgId, long bookTypeId) {
        List<String> allComAssistKeys = view.getModel().getDataEntityType().getAllFields().keySet().stream().filter(field -> field.startsWith("comassist")).collect(Collectors.toList());
        Optional commonAssistTable = ComAssistTable.get((Long)orgId, (Long)bookTypeId);
        if (commonAssistTable.isPresent()) {
            List<CommonAssist> balanceAssistList = ((ComAssistTable)commonAssistTable.get()).getCommonAssists().stream().filter(assist -> assist.isBalanced).collect(Collectors.toList());
            List<CommonAssist> notBalanceAssistList = ((ComAssistTable)commonAssistTable.get()).getCommonAssists().stream().filter(assist -> !assist.isBalanced).collect(Collectors.toList());
            balanceAssistList.forEach(assist -> {
                BasedataEdit balanceAssist = (BasedataEdit)view.getControl(assist.key);
                ComAssistService.modifyCommonAssistField((CommonAssist)assist, (BasedataEdit)balanceAssist);
                balanceAssist.setMustInput(Boolean.TRUE.booleanValue());
                view.setVisible(Boolean.TRUE, new String[]{assist.key});
                allComAssistKeys.remove(assist.key);
            });
            notBalanceAssistList.forEach(assist -> {
                BasedataEdit targetComAssist = (BasedataEdit)view.getControl(assist.key + "target");
                BasedataEdit destComAssist = (BasedataEdit)view.getControl(assist.key + "dest");
                ComAssistService.modifyCommonAssistField((CommonAssist)assist, (BasedataEdit)targetComAssist);
                ComAssistService.modifyCommonAssistField((CommonAssist)assist, (BasedataEdit)destComAssist);
                targetComAssist.setMustInput(Boolean.FALSE.booleanValue());
                destComAssist.setMustInput(Boolean.FALSE.booleanValue());
                view.setVisible(Boolean.TRUE, new String[]{assist.key + "target", assist.key + "dest"});
                allComAssistKeys.remove(assist.key + "target");
                allComAssistKeys.remove(assist.key + "dest");
            });
        }
        view.setVisible(Boolean.FALSE, allComAssistKeys.toArray(new String[0]));
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        super.beforeImportData(e);
        Map sourceData = e.getSourceData();
        Map org = (Map)sourceData.get(this.getOrgKey());
        DynamicObject orgDyn = QueryServiceHelper.queryOne((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", org.get("number"))});
        long orgId = 0L;
        if (orgDyn != null) {
            orgId = orgDyn.getLong("id");
        }
        Map bookType = (Map)sourceData.get(this.getBookTypeKey());
        String bookTypeNumber = (String)bookType.get("number");
        DynamicObject accountBookType = QueryServiceHelper.queryOne((String)"bd_accountbookstype", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)bookTypeNumber)});
        long bookTypeId = accountBookType.getLong("id");
        ComAssistTable.get((Long)orgId, (Long)bookTypeId).ifPresent(comAssistTable -> {
            for (String balanceCommonAssistKey : comAssistTable.getBalancedCommonAssistKeys()) {
                if (sourceData.get(balanceCommonAssistKey) != null) continue;
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u516c\u5171\u7ef4\u5ea6%s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"VoucherAmortComAssistEdit_0", (String)"fi-gl-formplugin", (Object[])new Object[0]), balanceCommonAssistKey.substring("comassist".length())));
            }
        });
    }
}

