/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.filter.CommonBaseDataFilterColumn;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.bd.util.AccountUtils;
import kd.fi.bd.util.BDUtil;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.PermissonType;

public class VoucherTypeList
extends AbstractListPlugin {
    private static final String DEFORG = "deforg";
    private static final String CONTROLINFORMATION = "controlinformation";
    private static final String GL_CONTROLINFORMATION = "gl_controlinformation";

    public void initialize() {
        super.initialize();
        BillList list = (BillList)this.getControl("billlistap");
        list.setOrderBy("number");
        this.addItemClickListeners(new String[]{CONTROLINFORMATION});
        this.setControlInfView();
    }

    public void filterContainerInit(FilterContainerInitArgs e) {
        super.filterContainerInit(e);
        if (!e.getFilterContainerInitEvent().getCommonFilterColumns().isEmpty()) {
            CommonFilterColumn filterColumn;
            FormShowParameter showParameter = this.getView().getFormShowParameter();
            String imicOrgId = (String)showParameter.getCustomParam("imicdimension_bos_org");
            if (StringUtils.isNotBlank((CharSequence)imicOrgId)) {
                filterColumn = (CommonFilterColumn)e.getFilterColumn("useorg.id");
                filterColumn.setDefaultValue(imicOrgId);
                BDUtil.loadMissId((List)filterColumn.getComboItems(), (String)imicOrgId);
                AccSysUtil.dealCacheOrgCustomFilter((FilterColumn)filterColumn, (IPageCache)this.getPageCache());
            }
            if (!(filterColumn = (FilterColumn)e.getFilterContainerInitEvent().getCommonFilterColumns().get(0)).getDefaultValues().isEmpty()) {
                long orgId = AccSysUtil.getDefaultOrgId((String)((ListView)this.getView()).getBillFormId(), (boolean)true, (PermissonType)PermissonType.VIEW);
                Set allOrgIdList = AccSysUtil.getAllOrgIdByComboItems((Collection)((CommonBaseDataFilterColumn)filterColumn).getComboItems());
                if (allOrgIdList.contains(orgId)) {
                    filterColumn.setDefaultValue(String.valueOf(orgId));
                    this.getPageCache().put("orgid", String.valueOf(orgId));
                    String isInitOrg = this.getPageCache().get("isInitOrg");
                    if (StringUtils.isEmpty((CharSequence)isInitOrg) || isInitOrg.equals("true")) {
                        AccSysUtil.dealCacheOrgCustomFilter((FilterColumn)filterColumn, (IPageCache)this.getPageCache());
                        this.getPageCache().put("isInitOrg", "false");
                    }
                } else {
                    this.getPageCache().put("orgid", (String)filterColumn.getDefaultValues().get(0));
                }
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        if ("assign".equals(operate.getOperateKey())) {
            List<Object> listPK = this.getSelectedRow();
            if (listPK.isEmpty()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8868\u683c\u4e2d\u7684\u4e00\u884c\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"VoucherTypeList_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                return;
            }
        } else if ("deletesingle".equals(operate.getOperateKey())) {
            String useOrgID = this.getPageCache().get("createOrg");
            operate.getOption().setVariableValue("createOrg", useOrgID);
        }
    }

    private List<Object> getSelectedRow() {
        BillList list = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection cols = list.getSelectedRows();
        ArrayList<Object> colList = new ArrayList<Object>();
        int size = cols.size();
        for (int i = 0; i < size; ++i) {
            Object pkValue = cols.get(i).getPrimaryKeyValue();
            if (colList.contains(pkValue)) continue;
            colList.add(pkValue);
        }
        return colList;
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        Map currentCommonFilters = args.getSearchClickEvent().getCurrentCommonFilter();
        if (currentCommonFilters != null && !currentCommonFilters.isEmpty()) {
            String orgId = String.valueOf(((List)currentCommonFilters.get("Value")).get(0));
            this.getPageCache().put("orgid", orgId);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        boolean ifParentControl = false;
        if (key.equals(CONTROLINFORMATION)) {
            List<Object> rowValues = this.getSelectedRow();
            if (rowValues.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u67e5\u770b\u63a7\u5236\u4fe1\u606f\u7684\u6570\u636e\u3002", (String)"VoucherTypeList_3", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            }
            long voucherTypeId = (Long)rowValues.get(0);
            long orgId = GLUtil.getFilterInitDefOrgId((IPageCache)this.getPageCache(), (String)"gl_vouchertype");
            Long userId = Long.parseLong(RequestContext.get().getUserId());
            int checkPermission = PermissionServiceHelper.checkPermission((Long)userId, (Long)orgId, (String)"gl", (String)GL_CONTROLINFORMATION, (String)"47150e89000000ac");
            if (0 == checkPermission) {
                throw new KDBizException(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u63a7\u5236\u4fe1\u606f\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"VoucherTypeList_2", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            }
            BillShowParameter formshowParameter = new BillShowParameter();
            Long voucherTypeMasterId = GLUtil.getMastIdById((Long)voucherTypeId);
            List voucherTypeIds = GLUtil.getIdsByMasterId((Long)voucherTypeMasterId);
            DynamicObject controlInformation = GLUtil.getControlMsg((Long)orgId, (List)voucherTypeIds);
            if (controlInformation == null && (controlInformation = GLUtil.getParentsControl((Long)orgId, (List)voucherTypeIds, (List)GLUtil.getAccounttableIdByOrg((Long)orgId))) != null) {
                ifParentControl = true;
            }
            QFilter id = new QFilter("id", "=", (Object)voucherTypeId);
            DynamicObject vouchertype = QueryServiceHelper.queryOne((String)"gl_vouchertype", (String)"name,number", (QFilter[])new QFilter[]{id});
            if (controlInformation != null && !ifParentControl) {
                Object pkid = controlInformation.get("id");
                formshowParameter.setFormId(GL_CONTROLINFORMATION);
                formshowParameter.setPkId(pkid);
                formshowParameter.getOpenStyle().setShowType(ShowType.Modal);
                formshowParameter.setCaption(String.format(ResManager.loadKDString((String)"\u63a7\u5236\u4fe1\u606f \u2014 %1$s %2$s", (String)"VoucherTypeList_1", (String)"fi-gl-formplugin", (Object[])new Object[0]), vouchertype.get("number"), vouchertype.getString("name")));
                formshowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CONTROLINFORMATION));
                this.getView().showForm((FormShowParameter)formshowParameter);
            } else {
                long orgid = GLUtil.getFilterInitDefOrgId((IPageCache)this.getPageCache(), (String)"gl_vouchertype");
                FormShowParameter param = new FormShowParameter();
                if (ifParentControl) {
                    DynamicObject parentCon = BusinessDataServiceHelper.loadSingle((Object)controlInformation.getLong("id"), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)GL_CONTROLINFORMATION));
                    param.setCustomParam("vouchertype", (Object)voucherTypeId);
                    param.setCustomParam("orgid", (Object)orgid);
                    param.setCustomParam("accounttable", parentCon.get("accounttable.id"));
                    param.setCustomParam("debitmustrecord", this.useAccountFilte(parentCon.getDynamicObjectCollection("debitmustrecord"), orgId, parentCon.getLong("accounttable.id")));
                    param.setCustomParam("creditmustrecord", this.useAccountFilte(parentCon.getDynamicObjectCollection("creditmustrecord"), orgId, parentCon.getLong("accounttable.id")));
                    param.setCustomParam("debitnotrecord", this.useAccountFilte(parentCon.getDynamicObjectCollection("debitnotrecord"), orgId, parentCon.getLong("accounttable.id")));
                    param.setCustomParam("creditnotrecord", this.useAccountFilte(parentCon.getDynamicObjectCollection("creditnotrecord"), orgId, parentCon.getLong("accounttable.id")));
                    param.setCustomParam("debitorcreditmustrecord", this.useAccountFilte(parentCon.getDynamicObjectCollection("debitorcreditmustrecord"), orgId, parentCon.getLong("accounttable.id")));
                    param.setCustomParam("debitandcreditnotrecord", this.useAccountFilte(parentCon.getDynamicObjectCollection("debitandcreditnotrecord"), orgId, parentCon.getLong("accounttable.id")));
                } else {
                    param.setCustomParam("vouchertype", (Object)voucherTypeId);
                    param.setCustomParam("orgid", (Object)orgid);
                    param.setCustomParam("debitmustrecord", (Object)new Object[0]);
                    param.setCustomParam("creditmustrecord", (Object)new Object[0]);
                    param.setCustomParam("debitnotrecord", (Object)new Object[0]);
                    param.setCustomParam("creditnotrecord", (Object)new Object[0]);
                    param.setCustomParam("debitorcreditmustrecord", (Object)new Object[0]);
                    param.setCustomParam("debitandcreditnotrecord", (Object)new Object[0]);
                }
                param.setCaption(String.format(ResManager.loadKDString((String)"\u63a7\u5236\u4fe1\u606f \u2014 %1$s %2$s", (String)"VoucherTypeList_1", (String)"fi-gl-formplugin", (Object[])new Object[0]), vouchertype.get("number"), vouchertype.getString("name")));
                this.showForm(GL_CONTROLINFORMATION, ShowType.Modal, param, new CloseCallBack((IFormPlugin)this, CONTROLINFORMATION));
            }
        }
    }

    private List<Long> useAccountFilte(DynamicObjectCollection accounts, Long orgId, long accountTableId) {
        if (accounts == null || accounts.size() == 0) {
            return new ArrayList<Long>();
        }
        HashMap<Long, Long> accts = new HashMap<Long, Long>();
        DataSet dataSet = AccountUtils.queryAccountDataSet((long)orgId, (long)accountTableId, (String)"id,masterid", null);
        Object object = null;
        try {
            for (Row row : dataSet) {
                accts.put(row.getLong("masterid"), row.getLong("id"));
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (object != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        if (accts.isEmpty()) {
            return new ArrayList<Long>();
        }
        ArrayList<Long> finalAcctIds = new ArrayList<Long>();
        for (DynamicObject dyn : accounts) {
            long id = ((DynamicObject)dyn.get(1)).getLong("masterid");
            if (!accts.containsKey(id)) continue;
            finalAcctIds.add((Long)accts.get(id));
        }
        return finalAcctIds;
    }

    private void showForm(String formKey, ShowType t, FormShowParameter param, CloseCallBack back) {
        param.setFormId(formKey);
        param.getOpenStyle().setShowType(t);
        param.setCloseCallBack(back);
        this.getView().showForm(param);
    }

    public void listRowClick(ListRowClickEvent evt) {
        this.setControlInfView();
    }

    public void setControlInfView() {
        List<Object> rowValues = this.getSelectedRow();
        this.getView().setEnable(Boolean.valueOf(rowValues.size() == 1), new String[]{CONTROLINFORMATION});
    }
}

