/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.accoutdesignation;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.KeyValue;
import kd.bos.entity.datamodel.NumberPrecision;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.flex.FlexValueFormatUtils;
import kd.fi.gl.formplugin.accoutdesignation.MainDesignateListExporter;

public class AccDesignateExportHelper {
    private IFormView view;

    public AccDesignateExportHelper(IFormView view) {
        this.view = view;
    }

    private IFormView getView() {
        return this.view;
    }

    private IDataModel getModel() {
        return this.view.getModel();
    }

    public String getExportEntryFile() {
        IDataModel model = this.getModel();
        int dEntryRowCount = this.getModel().getEntryRowCount("debitentry");
        int cEentryRowCount = this.getModel().getEntryRowCount("creditentry");
        if (dEntryRowCount == 0 && cEentryRowCount == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981\u5bfc\u51fa\u7684\u6570\u636e\u3002", (String)"AccDesignateExportHelper_0", (String)"fi-gl-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return null;
        }
        DynamicObjectCollection dynDColl = model.getEntryEntity("debitentry");
        DynamicObjectCollection dynCColl = model.getEntryEntity("creditentry");
        EntityType entryDType = (EntityType)dynDColl.getDynamicObjectType();
        EntityType entryCType = (EntityType)dynCColl.getDynamicObjectType();
        ArrayList<String> columnNamesD = new ArrayList<String>(2);
        columnNamesD.add("debitaccount");
        columnNamesD.add("debitamount");
        ArrayList<String> columnNamesC = new ArrayList<String>(2);
        columnNamesC.add("creditaccount");
        columnNamesC.add("creditamount");
        List<KeyValue> captionsD = this.prepareCaptions(entryDType, columnNamesD);
        List<KeyValue> captionsC = this.prepareCaptions(entryCType, columnNamesC);
        MainDesignateListExporter exporter = new MainDesignateListExporter("debitentry", "creditentry", captionsD, captionsC);
        int i = 2;
        ArrayList<Object> rowdata = new ArrayList<Object>();
        int rowCount = dEntryRowCount > cEentryRowCount ? dEntryRowCount : cEentryRowCount;
        for (int j = 0; j < rowCount; ++j) {
            if (dEntryRowCount > j) {
                DynamicObject rowd = (DynamicObject)dynDColl.get(j);
                this.createRowData(columnNamesD, model, entryDType, rowdata, rowd);
            } else {
                rowdata.add(null);
                rowdata.add(null);
            }
            if (cEentryRowCount > j) {
                DynamicObject rowc = (DynamicObject)dynCColl.get(j);
                this.createRowData(columnNamesC, model, entryCType, rowdata, rowc);
            } else {
                rowdata.add(null);
                rowdata.add(null);
            }
            exporter.writeLine(rowdata, i++, 0);
            rowdata.clear();
        }
        LocalDate now = LocalDate.now();
        return exporter.flush(ResManager.loadKDString((String)"T\u578b\u8d26\u6237\u6307\u5b9a\u5206\u5f55\u6570\u636e_%1$s%2$s", (String)"AccDesignateExportHelper_1", (String)"fi-gl-formplugin", (Object[])new Object[]{now.getMonthValue(), now.getDayOfMonth()}), 7200);
    }

    public OperationResult exportEntry() {
        String url = this.getExportEntryFile();
        if (url == null) {
            return null;
        }
        this.getView().download(url);
        return null;
    }

    public void exportEntry(String permissionItemId) {
        String url = this.getExportEntryFile();
        if (url == null) {
            return;
        }
        FormShowParameter showParameter = this.view.getFormShowParameter();
        DistributeSessionlessCache distributeCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();
        HashMap<String, String> refEntiryMap = new HashMap<String, String>(2);
        String tempFileId = url.split("id=")[1];
        refEntiryMap.put("entityNum", showParameter.getFormId());
        refEntiryMap.put("appId", showParameter.getServiceAppId());
        refEntiryMap.put("permissionItemId", permissionItemId);
        distributeCache.put("ReportTempFileCheckId:" + tempFileId, (Object)SerializationUtils.toJsonString(refEntiryMap), 7200);
        ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("openUrl", (Object)url);
    }

    private void createRowData(List<String> columnNames, IDataModel model, EntityType entryType, List<Object> rowdata, DynamicObject row) {
        for (IDataEntityProperty prop : entryType.getFields().values()) {
            if (prop instanceof EntryProp || !columnNames.contains(prop.getName())) continue;
            Object val = row.get(prop);
            if (!StringUtils.isBlank((Object)val)) {
                if (prop instanceof FlexProp) {
                    List flexValues = (List)FlexValueFormatUtils.getListDisplayValue((DynamicObject)row, (FlexProp)((FlexProp)prop), (String)((FlexProp)prop).getBasePropertyKey());
                    ArrayList<String> displayValues = new ArrayList<String>();
                    for (Map item : flexValues) {
                        String alias = (String)item.get("alias");
                        if (!StringUtils.isNotBlank((CharSequence)alias)) continue;
                        displayValues.add(alias);
                    }
                    val = String.join((CharSequence)"; ", displayValues);
                } else if (prop instanceof DecimalProp) {
                    if (!((DecimalProp)prop).isZeroShow() && BigDecimal.ZERO.compareTo(new BigDecimal(val.toString().replace(",", ""))) == 0) {
                        val = null;
                    } else if (prop instanceof AmountProp) {
                        if (val.getClass().isArray() && ((Object[])val).length >= 2) {
                            val = ((Object[])val)[0];
                        }
                        DynamicObject currency = (DynamicObject)model.getValue("currency");
                        NumberPrecision number = new NumberPrecision(currency.getInt("amtprecision"), currency.getString("sign"), false, new BigDecimal(val.toString()));
                        val = number;
                    } else {
                        NumberPrecision number = new NumberPrecision(((DecimalProp)prop).getScale(), null, false, new BigDecimal(val.toString()));
                        val = number.toString();
                    }
                }
            }
            rowdata.add(val);
        }
    }

    private List<KeyValue> prepareCaptions(EntityType entryType, List<String> columnNames) {
        ArrayList<KeyValue> captions = new ArrayList<KeyValue>(columnNames.size());
        for (IDataEntityProperty prop : entryType.getFields().values()) {
            if (prop instanceof EntryProp || !columnNames.contains(prop.getName())) continue;
            if (prop instanceof AmountProp) {
                captions.add(new KeyValue(prop.getName(), (Object)prop.getDisplayName().toString(), new Object[]{2, 100, "right"}));
                continue;
            }
            captions.add(new KeyValue(prop.getName(), (Object)new KeyValue(prop.getDisplayName().toString(), new ArrayList())));
        }
        return captions;
    }
}

