/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.accoutdesignation;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.KeyValue;
import kd.bos.entity.datamodel.NumberPrecision;
import kd.bos.mvc.export.ExcelWriter;
import kd.bos.mvc.export.ExportSheetStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class MainDesignateListExporter
extends ExcelWriter {
    private SXSSFSheet sheet;
    private ExportSheetStyle styles;
    private List<KeyValue> fieldCaptionsD;
    private List<KeyValue> fieldCaptionsC;
    private int rowCount = 0;

    public MainDesignateListExporter(String sheetNameD, String sheetNameC, List<KeyValue> fieldCaptionsD, List<KeyValue> fieldCaptionsC) {
        this.sheet = this.wb.createSheet(sheetNameD);
        this.styles = new ExportSheetStyle(this.wb);
        this.fieldCaptionsD = fieldCaptionsD;
        this.fieldCaptionsC = fieldCaptionsC;
        int col = 0;
        this.createTopCellMainDesignate(this.sheet);
        col = this.createCellMainDesignate(this.sheet, fieldCaptionsD, col);
        this.createCellMainDesignate(this.sheet, fieldCaptionsC, col);
    }

    private void createTopCellMainDesignate(SXSSFSheet sheet) {
        String align = "center";
        SXSSFCell cell = MainDesignateListExporter.createCell((SXSSFWorkbook)this.wb, (SXSSFRow)MainDesignateListExporter.getRow((SXSSFSheet)sheet, (int)0), (int)0, (CellStyle)this.styles.getTitleStyle(align));
        cell.setCellValue(ResManager.loadKDString((String)"\u501f\u65b9", (String)"MainDesignateListExporter_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        CellRangeAddress cra1 = new CellRangeAddress(0, 0, 0, 1);
        sheet.addMergedRegion(cra1);
        SXSSFCell cell2 = MainDesignateListExporter.createCell((SXSSFWorkbook)this.wb, (SXSSFRow)MainDesignateListExporter.getRow((SXSSFSheet)sheet, (int)0), (int)2, (CellStyle)this.styles.getTitleStyle(align));
        cell2.setCellValue(ResManager.loadKDString((String)"\u8d37\u65b9", (String)"MainDesignateListExporter_1", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        CellRangeAddress cra2 = new CellRangeAddress(0, 0, 2, 3);
        sheet.addMergedRegion(cra2);
    }

    private int createCellMainDesignate(SXSSFSheet sheet, List<KeyValue> fieldCaptions, int col) {
        for (int i = 0; i < fieldCaptions.size(); ++i) {
            KeyValue colInfo = fieldCaptions.get(i);
            int colWidth = 0;
            String align = "default";
            Object value = colInfo.value;
            if (colInfo.extend != null) {
                colWidth = (Integer)colInfo.extend[1];
                align = (String)colInfo.extend[2];
            } else {
                value = ((KeyValue)value).key;
            }
            SXSSFCell cell = MainDesignateListExporter.createCell((SXSSFWorkbook)this.wb, (SXSSFRow)MainDesignateListExporter.getRow((SXSSFSheet)sheet, (int)1), (int)col, (CellStyle)this.styles.getTitleStyle(align));
            cell.setCellValue((String)value);
            sheet.setColumnWidth(col, Math.min(256 * Math.max(colWidth / 8, Math.max(((String)value).length(), 8)) * 2, 51200));
            ++col;
        }
        return col;
    }

    public void write(List<List<Object>> dataRows) {
        for (List<Object> row : dataRows) {
            this.writeLine(row, ++this.rowCount, 0);
        }
    }

    public void writeLine(List<Object> row, int r, int col) {
        col = this.wtiyrLineTowEntry(this.sheet, this.fieldCaptionsD, row, r, col);
        this.wtiyrLineTowEntry(this.sheet, this.fieldCaptionsC, row, r, col);
    }

    private int wtiyrLineTowEntry(SXSSFSheet sheet, List<KeyValue> fieldCaptions, List<Object> row, int r, int col) {
        for (int i = 0; i < fieldCaptions.size(); ++i) {
            Object value = row.get(col);
            if (StringUtils.isBlank((Object)value)) {
                ++col;
                continue;
            }
            Object[] colExtend = fieldCaptions.get((int)i).extend;
            String align = "default";
            if (colExtend != null) {
                Date datetime;
                align = (String)colExtend[2];
                if (colExtend[0].equals(2)) {
                    BigDecimal decimal;
                    datetime = null;
                    JSONObject dataMap = null;
                    if (!(value instanceof NumberPrecision) && !(value instanceof Map)) {
                        if (!StringUtils.isNotBlank((Object)value)) continue;
                        decimal = new BigDecimal(value.toString());
                    } else {
                        dataMap = (JSONObject)JSONObject.toJSON((Object)value);
                        decimal = new BigDecimal(dataMap.getOrDefault((Object)"result", (Object)0).toString());
                    }
                    if (this.isBigDecimal(decimal.toPlainString())) {
                        MainDesignateListExporter.createCell((SXSSFWorkbook)this.wb, (SXSSFRow)MainDesignateListExporter.getRow((SXSSFSheet)sheet, (int)r), (int)col++, (CellStyle)this.styles.getTextStyle(align)).setCellValue(decimal.toPlainString());
                        continue;
                    }
                    MainDesignateListExporter.createCell((SXSSFWorkbook)this.wb, (SXSSFRow)MainDesignateListExporter.getRow((SXSSFSheet)sheet, (int)r), (int)col++, (CellStyle)this.styles.getDecimalStyle(this.wb, (Map)dataMap, align)).setCellValue(decimal.doubleValue());
                    continue;
                }
                if (colExtend[0].equals(3)) {
                    try {
                        datetime = value instanceof Long ? new Date((Long)value) : new SimpleDateFormat("yyyy-MM-dd H:m:s").parse(value.toString());
                        MainDesignateListExporter.createCell((SXSSFWorkbook)this.wb, (SXSSFRow)MainDesignateListExporter.getRow((SXSSFSheet)sheet, (int)r), (int)col++, (CellStyle)this.styles.getDatetimeStyle(align)).setCellValue(datetime);
                    }
                    catch (ParseException var10) {
                        MainDesignateListExporter.createCell((SXSSFWorkbook)this.wb, (SXSSFRow)MainDesignateListExporter.getRow((SXSSFSheet)sheet, (int)r), (int)col++, (CellStyle)this.styles.getDateStyle(align)).setCellValue(value.toString());
                    }
                    continue;
                }
            }
            MainDesignateListExporter.createCell((SXSSFWorkbook)this.wb, (SXSSFRow)MainDesignateListExporter.getRow((SXSSFSheet)sheet, (int)r), (int)col++, (CellStyle)this.styles.getTextStyle(align)).setCellValue(value instanceof BigDecimal ? ((BigDecimal)value).toPlainString() : (value == null ? "" : value.toString()));
        }
        return col;
    }

    private boolean isBigDecimal(String decimalStr) {
        StringBuilder sb = new StringBuilder(decimalStr);
        int i = sb.indexOf(".");
        if (i >= 0) {
            for (int j = sb.length() - 1; j > i; --j) {
                if (sb.charAt(j) == '0') {
                    continue;
                }
                sb.setLength(j + 1);
                break;
            }
            decimalStr = sb.substring(0, i);
        }
        return decimalStr.length() >= 15;
    }
}

