/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.acctformula;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.form.FormDataModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.bd.util.AccountUtils;
import kd.fi.gl.common.DynamicObjectCollectionUtil;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.QFBuilder;

public class AccountAndAssgrpPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
RowClickEventListener {
    private static final String ACCOUNT = "account";
    private static final String ENDACCOUNT = "endaccount";
    private static final String ISMULTIACCOUNT = "ismultiaccount";
    private static final String ASSTMEMBER = "asstmember";
    private static final String SASSTMEMBER = "sasstmember";
    private static final String EASSTMEMBER = "easstmember";
    private static String ENTRY = "assgrpentity";
    private static String MULTIACCOUNT = "multiaccount";
    private static final String TYPE_CONSIST = "1";
    private static final String TYPE_MULT = "2";
    private static final String DISPLAY_PROPERTY = "displayproperty";
    private static final String DIS_PROPERTY = "disproperty";
    private static final String PROPERTIES = "properties";
    private static final String IS_FILTER = "isfilter";
    private static final String ASSTACT_TYPE = "asstacttype";
    private static final String VALUE_TYPE = "valuetype";
    private static final String VALUE_SOURCE = "valuesource";
    private static final String NUMBER = "number";
    private static final String DIS_PROPERTY_NUMBER = "dispropertynumber";
    private static final String ASSIST_FIELD_DATA = "bos_assistantdata_detail";
    private static final String TYPE = "type";
    private static final String DOUCMENT_FIELD = "documentfield";
    private static final Table<String, String, Map<String, String>> assistValueSourceFieldTable = HashBasedTable.create();

    public void initialize() {
        super.initialize();
        this.addItemClickListeners(new String[]{"toolbarap", ACCOUNT, "org", "accounttable"});
        this.addClickListeners(new String[]{"cancel", "confirm"});
        BasedataEdit account = (BasedataEdit)this.getControl(ACCOUNT);
        BasedataEdit endaccount = (BasedataEdit)this.getControl(ENDACCOUNT);
        BasedataEdit multiaccountEdit = (BasedataEdit)this.getControl("multiaccount");
        account.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        endaccount.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        multiaccountEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{DIS_PROPERTY_NUMBER});
    }

    private void setAccountF7Filter(BeforeF7SelectEvent e) {
        ListShowParameter param = (ListShowParameter)e.getFormShowParameter();
        param.getListFilterParameter().getQFilters().clear();
        if (this.getModel().getValue("org") != null) {
            QFilter qc = AccountUtils.getAccountDataFilter((long)((DynamicObject)this.getModel().getValue("org")).getLong("id"), (long)((DynamicObject)this.getModel().getValue("accounttable")).getLong("id"));
            param.getListFilterParameter().setFilter(qc);
        }
        param.getListFilterParameter().setFilter(new QFilter("accounttable.id", "=", (Object)((DynamicObject)this.getModel().getValue("accounttable")).getLong("id")));
        param.getListFilterParameter().setFilter(new QFilter("enddate", "=", (Object)GLUtil.getEndDate()));
    }

    private String getAccountBookMetadataNumber() {
        String str = "select fid from t_meta_formdesign where fnumber = ? ";
        DataSet result = DB.queryDataSet((String)"IntergrationUtil", (DBRoute)DBRoute.meta, (String)str, (Object[])new Object[]{"bd_accountbooks"});
        if (result.hasNext()) {
            return "bd_accountbooks";
        }
        return "gl_accountbook";
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{ASSTMEMBER, SASSTMEMBER, EASSTMEMBER, DISPLAY_PROPERTY, DIS_PROPERTY, PROPERTIES, IS_FILTER, DISPLAY_PROPERTY});
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY);
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (evt.getSource() instanceof TextEdit) {
            if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)PROPERTIES)) {
                this.dealAcctProperty(key);
            } else {
                QFilter orgFilter;
                EntryGrid entryGrid = (EntryGrid)this.getControl("assgrpentity");
                int[] selectRows = entryGrid.getSelectRows();
                if (selectRows.length == 0) {
                    return;
                }
                if (this.getModel().getEntryEntity("assgrpentity").isEmpty()) {
                    return;
                }
                DynamicObject asstacttype = ((DynamicObject)this.getModel().getEntryEntity("assgrpentity").get(selectRows[0])).getDynamicObject(ASSTACT_TYPE);
                if (asstacttype == null) {
                    return;
                }
                String valuetype = asstacttype.getString(VALUE_TYPE);
                if ("3".equals(valuetype)) {
                    return;
                }
                if (TYPE_MULT.equals(valuetype)) {
                    Object orgId;
                    ListShowParameter lsp = ShowFormHelper.createShowListForm((String)ASSIST_FIELD_DATA, (boolean)false);
                    long groupId = BusinessDataServiceHelper.loadSingle((Object)asstacttype.get("id"), (String)"bd_asstacttype").getDynamicObject("assistanttype").getLong("id");
                    lsp.getListFilterParameter().setFilter(new QFilter("group", "=", (Object)groupId));
                    CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, key);
                    lsp.setCloseCallBack(closeCallBack);
                    if (ASSTMEMBER.equals(key)) {
                        lsp.setMultiSelect(true);
                    }
                    if (Objects.nonNull(orgId = this.getModel().getValue("org_id")) && Long.parseLong(orgId.toString()) != 0L) {
                        this.getView().getFormShowParameter().setCustomParam("orgId", orgId);
                    } else {
                        this.getView().getFormShowParameter().getCustomParams().remove("orgId");
                    }
                    this.getView().cacheFormShowParameter();
                    this.getView().showForm((FormShowParameter)lsp);
                    return;
                }
                DynamicObject valuesource = asstacttype.getDynamicObject(VALUE_SOURCE);
                String entityName = valuesource.getString("id");
                ListShowParameter lsp = ShowFormHelper.createShowListForm((String)entityName, (boolean)false);
                ListFilterParameter filterParam = lsp.getListFilterParameter();
                List qFilters = filterParam.getQFilters();
                MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityName);
                DynamicProperty statusProp = entityType.getProperty("status");
                if (statusProp != null) {
                    qFilters.add(new QFilter("status", "=", (Object)"C"));
                }
                if ((orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)entityName, (Long)Long.valueOf(String.valueOf(this.getModel().getValue("org_id"))))) != null) {
                    qFilters.add(orgFilter);
                }
                lsp.setUseOrgId(((Long)this.getModel().getValue("org_id")).longValue());
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, key);
                lsp.setCloseCallBack(closeCallBack);
                if (ASSTMEMBER.equals(key)) {
                    lsp.setMultiSelect(true);
                }
                this.getView().showForm((FormShowParameter)lsp);
            }
        } else {
            HashMap map = Maps.newHashMap();
            if ("cancel".equals(key)) {
                this.getView().close();
            } else {
                DynamicObjectCollection assgrpentity;
                String result;
                StringBuilder returnData = new StringBuilder();
                IDataModel model = this.getModel();
                String ismultiaccount = (String)model.getValue(ISMULTIACCOUNT);
                if (TYPE_MULT.equals(ismultiaccount)) {
                    DynamicObjectCollection accts = (DynamicObjectCollection)model.getValue("multiaccount");
                    if (accts.isEmpty()) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f1a\u8ba1\u79d1\u76ee\u4e3a\u7a7a", (String)"AccountAndAssgrpPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    for (DynamicObject acct : accts) {
                        if (returnData.length() != 0) {
                            returnData.append(',');
                        }
                        returnData.append(acct.getDynamicObject("fbasedataid").getString(NUMBER));
                    }
                } else {
                    DynamicObject account = (DynamicObject)model.getValue(ACCOUNT);
                    DynamicObject endaccount = (DynamicObject)model.getValue(ENDACCOUNT);
                    if (account == null || endaccount == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d77\u59cb\u6216\u7ed3\u675f\u79d1\u76ee\u4e3a\u7a7a\u3002", (String)"AccountAndAssgrpPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    if (account.getString(NUMBER).equals(endaccount.getString(NUMBER))) {
                        returnData.append(account.getString(NUMBER));
                    } else {
                        returnData.append('[');
                        returnData.append(account.getString(NUMBER)).append(',');
                        returnData.append(endaccount.getString(NUMBER));
                        returnData.append(']');
                    }
                    if (account.getLong("level") != endaccount.getLong("level")) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8fde\u7eed\u79d1\u76ee\u53d6\u6570\u65f6\uff0c\u8d77\u59cb\u548c\u7ed3\u675f\u79d1\u76ee\u7684\u7ea7\u6b21\u5e94\u4fdd\u6301\u4e00\u81f4\u3002", (String)"AccountAndAssgrpPlugin_2", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                        return;
                    }
                }
                if (!StringUtils.isEmpty((CharSequence)(result = this.appendAssgrps(assgrpentity = model.getEntryEntity(ENTRY), returnData)))) {
                    this.getView().showTipNotification(result);
                    return;
                }
                map.put("returnData", returnData.toString());
                DynamicObject endaccount = (DynamicObject)this.getModel().getValue(ENDACCOUNT);
                map.put(ENDACCOUNT, endaccount == null ? "" : endaccount.getString(NUMBER));
                map.put("level", endaccount == null ? "" : endaccount.getString("level"));
                DynamicObject table = (DynamicObject)this.getModel().getValue("accounttable");
                map.put("accounttable", table == null ? "0" : table.getString("id"));
                this.getView().returnDataToParent((Object)map);
                this.getView().close();
            }
        }
    }

    private void dealAcctProperty(String key) {
        QFilter orgFilter;
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY);
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length == 0) {
            return;
        }
        DynamicObject disProperty = (DynamicObject)this.getModel().getEntryEntity("assgrpentity").get(selectRows[0]);
        if (null == disProperty) {
            return;
        }
        DynamicObject asstacttype = disProperty.getDynamicObject(ASSTACT_TYPE);
        if (asstacttype == null) {
            return;
        }
        String disPropertyNumber = disProperty.getString(DIS_PROPERTY_NUMBER);
        if (StringUtils.isBlank((CharSequence)disPropertyNumber)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u663e\u793a\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AccountAndAssgrpPlugin_7", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        String valuetype = asstacttype.getString(VALUE_TYPE);
        if (TYPE_MULT.equals(valuetype)) {
            Object orgId;
            ListShowParameter lsp = ShowFormHelper.createShowListForm((String)disPropertyNumber, (boolean)false);
            if (ASSIST_FIELD_DATA.equalsIgnoreCase(disPropertyNumber)) {
                long groupId = BusinessDataServiceHelper.loadSingle((Object)asstacttype.get("id"), (String)"bd_asstacttype").getDynamicObject("assistanttype").getLong("id");
                lsp.getListFilterParameter().setFilter(new QFilter("group", "=", (Object)groupId));
            }
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, key);
            lsp.setCloseCallBack(closeCallBack);
            if (PROPERTIES.equals(key)) {
                lsp.setMultiSelect(true);
            }
            if (Objects.nonNull(orgId = this.getModel().getValue("org_id")) && Long.parseLong(orgId.toString()) != 0L) {
                this.getView().getFormShowParameter().setCustomParam("orgId", orgId);
            } else {
                this.getView().getFormShowParameter().getCustomParams().remove("orgId");
            }
            this.getView().cacheFormShowParameter();
            this.getView().showForm((FormShowParameter)lsp);
            return;
        }
        ListShowParameter lsp = ShowFormHelper.createShowListForm((String)disPropertyNumber, (boolean)false);
        ListFilterParameter filterParam = lsp.getListFilterParameter();
        List qFilters = filterParam.getQFilters();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)disPropertyNumber);
        DynamicProperty statusProp = entityType.getProperty("status");
        if (statusProp != null) {
            qFilters.add(new QFilter("status", "=", (Object)"C"));
        }
        if ((orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)disPropertyNumber, (Long)Long.valueOf(String.valueOf(this.getModel().getValue("org_id"))))) != null) {
            qFilters.add(orgFilter);
        }
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, key);
        lsp.setCloseCallBack(closeCallBack);
        if (PROPERTIES.equals(key)) {
            lsp.setMultiSelect(true);
        }
        this.getView().showForm((FormShowParameter)lsp);
    }

    private String appendAssgrps(DynamicObjectCollection assgrpentity, StringBuilder returnData) {
        StringBuilder result = new StringBuilder();
        for (DynamicObject row : assgrpentity) {
            boolean isExistMember;
            boolean isfilter = row.getBoolean(IS_FILTER);
            if (!isfilter) continue;
            DynamicObject asstacttype = row.getDynamicObject(ASSTACT_TYPE);
            String type = row.getString(TYPE);
            String sasstmember = row.getString(SASSTMEMBER);
            String easstmember = row.getString(EASSTMEMBER);
            String asstmember = row.getString(ASSTMEMBER);
            returnData.append('|');
            String asstacttypeNum = asstacttype.getString(NUMBER);
            returnData.append(asstacttypeNum).append('|');
            boolean bl = isExistMember = org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)sasstmember) && org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)easstmember) && org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)asstmember);
            if (!isExistMember) {
                if (TYPE_CONSIST.equals(type)) {
                    returnData.append('[');
                    returnData.append(sasstmember).append(',');
                    returnData.append(easstmember);
                    returnData.append(']');
                    if (StringUtils.isEmpty((CharSequence)sasstmember) || StringUtils.isEmpty((CharSequence)easstmember)) {
                        result.append(ResManager.loadKDString((String)"\u5f00\u59cb\u6216\u7ed3\u675f\u6210\u5458\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AccountAndAssgrpPlugin_3", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    }
                } else {
                    returnData.append(asstmember);
                }
            }
            String documentField = row.getString(DOUCMENT_FIELD);
            String properties = row.getString(PROPERTIES);
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)documentField) || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)properties)) continue;
            returnData.append(documentField).append(":").append(properties);
        }
        return result.toString();
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        e.getSource();
        if (e.getSource() instanceof BasedataEdit) {
            BasedataEdit t = (BasedataEdit)e.getSource();
            if (ACCOUNT.equals(t.getKey()) || "multiaccount".equals(t.getKey())) {
                if (this.getModel().getValue("accounttable") != null) {
                    this.setAccountF7Filter(e);
                }
            } else if (!"accounttable".equals(t.getKey()) && ENDACCOUNT.equals(t.getKey())) {
                if (this.getModel().getValue(ACCOUNT) == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8d77\u59cb\u79d1\u76ee\u3002", (String)"AccountAndAssgrpPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                if (this.getModel().getValue("accounttable") != null) {
                    this.setAccountF7Filter(e);
                    DynamicObject dy = (DynamicObject)this.getModel().getValue(ACCOUNT);
                    ListShowParameter param = (ListShowParameter)e.getFormShowParameter();
                    param.getListFilterParameter().getQFilters().add(new QFilter("level", "=", (Object)dy.getInt("level")));
                }
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter param = this.getView().getFormShowParameter();
        String accountBookType = (String)param.getCustomParam("accountbookstype");
        String orgid = (String)param.getCustomParam("org");
        Object isShow = this.getModel().getValue(DISPLAY_PROPERTY);
        boolean isDisplayProperty = Objects.nonNull(isShow) && Boolean.parseBoolean(isShow.toString());
        String accountParam = (String)param.getCustomParam(ACCOUNT);
        if (StringUtils.isNotBlank((CharSequence)accountParam) && accountParam.contains(":")) {
            this.getModel().setValue(DISPLAY_PROPERTY, (Object)true);
        } else if (!isDisplayProperty) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{DIS_PROPERTY});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{PROPERTIES});
        }
        if (StringUtils.isNotEmpty((CharSequence)orgid)) {
            long orgId = Long.parseLong(orgid);
            this.getModel().setValue("org", (Object)orgId);
            this.modifyByOrgChange(orgId, accountBookType);
        } else {
            long oid = 0L;
            IFormView view = this.getAutoTransParentView(this.getView());
            if (view != null) {
                oid = (Long)view.getModel().getValue("org_id");
                accountBookType = view.getModel().getValue("bookstype_id").toString();
            } else {
                oid = RequestContext.get().getOrgId();
            }
            this.getModel().setValue("org", (Object)oid);
            this.modifyByOrgChange(oid, accountBookType);
        }
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject accounttableDyo = (DynamicObject)this.getModel().getValue("accounttable");
        this.resetAccountAndAssgrp(org == null ? 0L : org.getLong("id"), accounttableDyo == null ? 0L : accounttableDyo.getLong("id"), (String)param.getCustomParam(ACCOUNT));
    }

    private IFormView getAutoTransParentView(IFormView curView) {
        String curPageId = curView.getPageId();
        IFormView originalView = curView;
        while (!StringUtils.isEmpty((CharSequence)curPageId) && !Objects.isNull(curView)) {
            if ("gl_autotrans".equals(curView.getEntityId())) {
                return curView;
            }
            curPageId = curView.getFormShowParameter().getParentPageId();
            curView = originalView.getViewNoPlugin(curPageId);
        }
        return null;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] changeSet;
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        if (ACCOUNT.equals(propName) || "org".equals(propName) || "accounttable".equals(propName) || ENDACCOUNT.equals(propName)) {
            ChangeData[] changeSet2 = e.getChangeSet();
            DynamicObject newOne = (DynamicObject)changeSet2[0].getNewValue();
            DynamicObject oldOne = (DynamicObject)changeSet2[0].getOldValue();
            switch (propName) {
                case "account": {
                    if (newOne == null) {
                        this.getModel().deleteEntryData(ENTRY);
                        break;
                    }
                    this.getModel().beginInit();
                    this.getModel().setValue(ENDACCOUNT, (Object)newOne);
                    this.getModel().endInit();
                    this.getView().updateView(ENDACCOUNT);
                    if (oldOne != null && newOne.getLong("id") == oldOne.getLong("id")) break;
                    this.initAsstEntry(newOne, newOne, new ArrayList<String>(5), new HashMap<String, AssgrpEntryRowInfo>(5));
                    break;
                }
                case "endaccount": {
                    if (newOne == null) {
                        this.getModel().deleteEntryData(ENTRY);
                        break;
                    }
                    DynamicObject startaccount = (DynamicObject)this.getModel().getValue(ACCOUNT);
                    if (startaccount == null) break;
                    this.initAsstEntry(startaccount, newOne, new ArrayList<String>(5), new HashMap<String, AssgrpEntryRowInfo>(5));
                    break;
                }
                case "org": {
                    Long orgid = newOne == null ? null : Long.valueOf(newOne.getLong("id"));
                    this.modifyByOrgChange(orgid, null);
                    break;
                }
                case "accounttable": {
                    this.getModel().setValue(ENDACCOUNT, null);
                    this.getModel().setValue("multiaccount", null);
                    this.getModel().setValue(ACCOUNT, null);
                }
            }
        } else if ("multiaccount".equals(propName)) {
            ChangeData[] changeSet3 = e.getChangeSet();
            DynamicObjectCollection newOne = (DynamicObjectCollection)changeSet3[0].getNewValue();
            if (newOne == null || newOne.isEmpty()) {
                this.getModel().deleteEntryData(ENTRY);
            }
            if (newOne != null && !newOne.isEmpty()) {
                List acts = DynamicObjectCollectionUtil.getMultiDynamicObjects((DynamicObjectCollection)newOne);
                this.initMultiAsstEntry(acts, new ArrayList<String>(5), new HashMap<String, AssgrpEntryRowInfo>(5));
            }
        } else if (ISMULTIACCOUNT.equals(propName)) {
            String ismultiaccount = (String)this.getModel().getValue(ISMULTIACCOUNT);
            if (TYPE_MULT.equals(ismultiaccount)) {
                this.getModel().setValue(ENDACCOUNT, null);
                this.getModel().setValue(ACCOUNT, null);
            } else {
                this.getModel().setValue("multiaccount", null);
            }
        } else if (TYPE.equals(propName)) {
            IDataModel model = this.getModel();
            int index = model.getEntryCurrentRowIndex("assgrpentity");
            String type = (String)model.getValue(propName);
            boolean isConsist = TYPE_CONSIST.equals(type);
            if (isConsist) {
                model.setValue(ASSTMEMBER, null, index);
            } else {
                model.setValue(SASSTMEMBER, null, index);
                model.setValue(EASSTMEMBER, null, index);
            }
            this.getView().setEnable(Boolean.valueOf(!isConsist), index, new String[]{ASSTMEMBER});
            this.getView().setEnable(Boolean.valueOf(isConsist), index, new String[]{SASSTMEMBER, EASSTMEMBER});
        } else if (propName.equalsIgnoreCase(DISPLAY_PROPERTY)) {
            boolean isDisplayProperty;
            IDataModel model = this.getModel();
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY);
            if (null == entryEntity || entryEntity.isEmpty()) {
                return;
            }
            Object isDisPlay = this.getModel().getValue(propName);
            boolean bl = isDisplayProperty = Objects.nonNull(isDisPlay) && Boolean.parseBoolean(isDisPlay.toString());
            if (isDisplayProperty) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{DIS_PROPERTY, PROPERTIES});
                entryEntity.forEach(row -> {
                    int index = row.getInt("seq") - 1;
                    boolean filter = row.getBoolean(IS_FILTER);
                    if (filter) {
                        this.getView().setEnable(Boolean.valueOf(true), index, new String[]{PROPERTIES});
                        boolean properties = StringUtils.isNotBlank((CharSequence)row.getString(DIS_PROPERTY_NUMBER));
                        this.getView().setEnable(Boolean.valueOf(properties), index, new String[]{PROPERTIES});
                    }
                    model.setValue(ASSTMEMBER, null, index);
                    model.setValue(EASSTMEMBER, null, index);
                    model.setValue(SASSTMEMBER, null, index);
                    this.initAssgrpDocumentField(row.getDynamicObject(ASSTACT_TYPE));
                });
                this.getView().showMessage(ResManager.loadKDString((String)"\u6309\u7167\u5c5e\u6027\u6c47\u603b\u53d6\u6570\uff0c\u67e5\u8be2\u901f\u5ea6\u53ef\u80fd\u8f83\u6162\u3002", (String)"AccountAndAssgrpPlugin_6", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{DIS_PROPERTY, PROPERTIES});
                entryEntity.forEach(row -> {
                    int index = row.getInt("seq") - 1;
                    model.setValue(DIS_PROPERTY, null, index);
                    model.setValue(PROPERTIES, null, index);
                });
            }
            this.setEntryEnable(entryEntity);
        } else if (propName.equalsIgnoreCase(IS_FILTER)) {
            IDataModel model = this.getModel();
            int index = model.getEntryCurrentRowIndex("assgrpentity");
            Object isFilter = this.getModel().getValue(IS_FILTER);
            if (null != isFilter && Boolean.parseBoolean(isFilter.toString())) {
                this.getView().setEnable(Boolean.valueOf(true), index, new String[]{DIS_PROPERTY});
                this.getView().setEnable(Boolean.valueOf(false), index, new String[]{PROPERTIES});
            } else {
                this.getView().setEnable(Boolean.valueOf(false), index, new String[]{DIS_PROPERTY, PROPERTIES});
                this.getModel().setValue(DIS_PROPERTY, null, index);
                this.getModel().setValue(PROPERTIES, null, index);
            }
        } else if (propName.equalsIgnoreCase(DIS_PROPERTY)) {
            ChangeData[] changeSet4 = e.getChangeSet();
            IDataModel model = this.getModel();
            int index = model.getEntryCurrentRowIndex("assgrpentity");
            if (null != changeSet4[0].getNewValue() && StringUtils.isNotBlank((Object)changeSet4[0].getNewValue())) {
                String newValue = e.getChangeSet()[0].getNewValue().toString();
                String entiry = org.apache.commons.lang3.StringUtils.substringBefore((String)newValue, (String)"&");
                String documentFiled = org.apache.commons.lang3.StringUtils.substringAfterLast((String)newValue, (String)"#");
                this.getModel().setValue(DIS_PROPERTY_NUMBER, (Object)entiry);
                this.getModel().setValue(DOUCMENT_FIELD, (Object)documentFiled);
                this.getModel().setValue(PROPERTIES, null);
                this.getView().setEnable(Boolean.valueOf(true), index, new String[]{PROPERTIES});
            } else {
                this.getModel().setValue(PROPERTIES, null);
                this.getModel().setValue(DIS_PROPERTY_NUMBER, null);
                this.getModel().setValue(DOUCMENT_FIELD, null);
                this.getView().setEnable(Boolean.valueOf(false), index, new String[]{PROPERTIES});
            }
        } else if (propName.equalsIgnoreCase(PROPERTIES) && null != (changeSet = e.getChangeSet())[0].getNewValue()) {
            String newValue = e.getChangeSet()[0].getNewValue().toString();
            this.getModel().setValue(PROPERTIES, (Object)newValue);
        }
    }

    private void resetAccountAndAssgrp(long orgId, long accounttableId, String accountStr) {
        IDataModel model = this.getModel();
        if (orgId == 0L || accounttableId == 0L || StringUtils.isEmpty((CharSequence)accountStr)) {
            return;
        }
        String[] memberStrs = accountStr.split("\\|");
        String accountAndAssStr = accountStr;
        accountStr = memberStrs[0];
        int oldLen = accountStr.length();
        accountStr = accountStr.replace("[", "").replace("]", "");
        int newLen = accountStr.length();
        String[] accts = accountStr.split(",");
        HashMap<String, Long> numIdsMap = new HashMap<String, Long>();
        ArrayList<QFilter> otherFilters = new ArrayList<QFilter>();
        otherFilters.add(new QFilter(NUMBER, "in", (Object)accts));
        try (DataSet dt = AccountUtils.queryAccountDataSet((long)orgId, (long)accounttableId, (String)"id,number", otherFilters);){
            while (dt.hasNext()) {
                Row row = dt.next();
                String number = row.getString(NUMBER);
                long id = row.getLong("id");
                numIdsMap.put(number, id);
            }
        }
        ArrayList<String> asstNums = new ArrayList<String>(memberStrs.length - 1);
        HashMap<String, AssgrpEntryRowInfo> asstNumAndInfoMap = new HashMap<String, AssgrpEntryRowInfo>(memberStrs.length - 1);
        for (int i = 1; i < memberStrs.length; i += 2) {
            String member = memberStrs[i];
            asstNums.add(member);
            if (i + 1 >= memberStrs.length) continue;
            AssgrpEntryRowInfo info = null;
            if (accountAndAssStr.contains(":")) {
                this.getModel().setValue(DISPLAY_PROPERTY, (Object)true);
                String propertyAndValues = memberStrs[i + 1];
                String disproperty = StringUtils.substringBefore((String)propertyAndValues, (String)":");
                String properties = StringUtils.substringAfterLast((String)propertyAndValues, (String)":");
                info = new AssgrpEntryRowInfo(null, null, null, null, disproperty, properties, disproperty);
            } else {
                int newAssgrpValueLen;
                String assgrpValueStr = memberStrs[i + 1];
                int oldAssgrpValueLen = assgrpValueStr.length();
                if (oldAssgrpValueLen != (newAssgrpValueLen = (assgrpValueStr = assgrpValueStr.replace("[", "").replace("]", "")).length())) {
                    String[] assgrpValues = assgrpValueStr.split(",");
                    if (assgrpValues.length > 0) {
                        info = new AssgrpEntryRowInfo(TYPE_CONSIST, null, assgrpValues[0], assgrpValues[assgrpValues.length - 1], null, null, null);
                    }
                } else {
                    info = new AssgrpEntryRowInfo(TYPE_MULT, assgrpValueStr, null, null, null, null, null);
                }
            }
            if (info == null) continue;
            asstNumAndInfoMap.put(member, info);
        }
        if (oldLen != newLen) {
            model.setValue(ISMULTIACCOUNT, (Object)TYPE_CONSIST);
            model.setValue(ACCOUNT, numIdsMap.get(accts[0]));
            model.setValue(ENDACCOUNT, numIdsMap.get(accts[accts.length - 1]));
            if (numIdsMap.get(accts[0]) == null || numIdsMap.get(accts[accts.length - 1]) == null) {
                return;
            }
            this.initAsstEntry((DynamicObject)model.getValue(ACCOUNT), (DynamicObject)model.getValue(ENDACCOUNT), asstNums, asstNumAndInfoMap);
        } else {
            model.setValue(ISMULTIACCOUNT, (Object)TYPE_MULT);
            Object[] ids = numIdsMap.values().toArray();
            if (numIdsMap.values().isEmpty()) {
                return;
            }
            model.setValue(MULTIACCOUNT, (Object)ids);
            this.initMultiAsstEntry(DynamicObjectCollectionUtil.getMultiDynamicObjects((DynamicObjectCollection)((DynamicObjectCollection)model.getValue(MULTIACCOUNT))), asstNums, asstNumAndInfoMap);
        }
    }

    private void modifyByOrgChange(Long orgId, String booktypeId) {
        this.getModel().beginInit();
        this.getModel().setValue("accounttable", null);
        this.getModel().setValue(ENDACCOUNT, null);
        this.getModel().setValue("multiaccount", null);
        this.getModel().setValue(ACCOUNT, null);
        this.getModel().deleteEntryData(ENTRY);
        this.getModel().endInit();
        if (orgId == null || (double)orgId.longValue() == 0.0) {
            return;
        }
        QFBuilder bookBuilder = new QFBuilder();
        bookBuilder.add("org.id", "=", (Object)orgId);
        if (StringUtils.isNotEmpty((CharSequence)booktypeId)) {
            bookBuilder.add("bookstype.id", "=", (Object)Long.parseLong(booktypeId));
        } else {
            bookBuilder.add("bookstype.accounttype", "=", (Object)TYPE_CONSIST);
        }
        DynamicObject[] dcs = BusinessDataServiceHelper.load((String)this.getAccountBookMetadataNumber(), (String)"accounttable,accounttable.name,accounttable.number", (QFilter[])bookBuilder.toArray());
        if (dcs != null && dcs.length > 0) {
            this.getModel().setValue("accounttable", (Object)dcs[0].getDynamicObject("accounttable"));
        }
        this.getView().updateView();
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection coll;
        super.closedCallBack(closedCallBackEvent);
        Object returnData = closedCallBackEvent.getReturnData();
        String actionId = closedCallBackEvent.getActionId();
        if (returnData != null && (actionId.endsWith(ASSTMEMBER) || actionId.endsWith(PROPERTIES)) && (coll = (ListSelectedRowCollection)returnData).size() > 0) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("assgrpentity");
            int[] selectRows = entryGrid.getSelectRows();
            StringBuilder sb = new StringBuilder();
            for (ListSelectedRow row : coll) {
                if (StringUtils.isEmpty((CharSequence)row.getNumber())) continue;
                if (sb.length() != 0) {
                    sb.append(',');
                }
                sb.append(row.getNumber());
            }
            this.getModel().setValue(actionId, (Object)sb.toString(), selectRows[0]);
        }
    }

    private void initAsstEntry(DynamicObject startAcct, DynamicObject endAcct, List<String> asstNums, Map<String, AssgrpEntryRowInfo> asstNumAndInfoMap) {
        DynamicObject table;
        this.getModel().beginInit();
        String selector = AccountAndAssgrpPlugin.genUniqueKey("id", "checkitementry", "checkitementry.asstactitem", "checkitementry.asstactitem.number", "checkitementry.asstactitem.name", "checkitementry.asstactitem.flexfield", "checkitementry.asstactitem.valuesource, checkitementry.asstactitem.valuetype");
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        ArrayList<QFilter> qfs = new ArrayList<QFilter>(3);
        if (org != null) {
            QFilter qids = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)org.getLong("id"));
            qfs.add(qids);
        }
        if ((table = (DynamicObject)this.getModel().getValue("accounttable")) != null) {
            qfs.add(new QFilter("accounttable", "=", (Object)table.getLong("id")));
        }
        QFilter idFilter = new QFilter(NUMBER, ">=", (Object)startAcct.getString(NUMBER)).and(new QFilter(NUMBER, "<=", (Object)endAcct.getString(NUMBER)));
        qfs.add(idFilter);
        qfs.add(new QFilter("enddate", "=", (Object)GLUtil.getEndDate()));
        DynamicObject[] accounts = BusinessDataServiceHelper.load((String)"bd_accountview", (String)selector, (QFilter[])qfs.toArray(new QFilter[0]));
        DynamicObjectCollection checkitemEntry = this.getRetainCollection(accounts);
        if (CollectionUtils.isNotEmpty((Collection)checkitemEntry)) {
            this.getModel().deleteEntryData(ENTRY);
            this.getModel().batchCreateNewEntryRow(ENTRY, checkitemEntry.size());
            int i = 0;
            boolean isDisplayProperty = (Boolean)this.getModel().getValue(DISPLAY_PROPERTY);
            for (DynamicObject checkitem : checkitemEntry) {
                DynamicObject asst = checkitem.getDynamicObject("asstactitem");
                if (asst == null) continue;
                String asstNumber = asst.getString(NUMBER);
                DynamicObject rowObj = this.getModel().getEntryRowEntity(ENTRY, i);
                int index = asstNums.indexOf(asstNumber);
                if (index >= 0) {
                    rowObj.set(IS_FILTER, (Object)true);
                    AssgrpEntryRowInfo info = asstNumAndInfoMap.get(asstNumber);
                    if (info != null) {
                        rowObj.set(TYPE, (Object)info.type);
                        if (TYPE_CONSIST.equals(info.type)) {
                            rowObj.set(SASSTMEMBER, (Object)info.sasstmember);
                            rowObj.set(EASSTMEMBER, (Object)info.easstmember);
                        } else {
                            rowObj.set(ASSTMEMBER, (Object)info.asstmember);
                        }
                    }
                }
                rowObj.set(ASSTACT_TYPE, (Object)asst);
                rowObj.set("asstnum", (Object)asstNumber);
                this.setDisplayProperty(isDisplayProperty, asstNumAndInfoMap, asst, asstNumber, rowObj);
                ++i;
            }
        } else {
            this.getModel().deleteEntryData(ENTRY);
        }
        this.getModel().endInit();
        this.getView().updateView();
        this.setEntryEnable(this.getModel().getEntryEntity(ENTRY));
    }

    private void setDisplayProperty(boolean isDisplayProperty, Map<String, AssgrpEntryRowInfo> asstNumAndInfoMap, DynamicObject asst, String asstNumber, DynamicObject rowObj) {
        if (isDisplayProperty) {
            Map dispropertyMap;
            AssgrpEntryRowInfo info = asstNumAndInfoMap.get(asstNumber);
            this.initAssgrpDocumentField(asst);
            if (info != null && !(dispropertyMap = (Map)assistValueSourceFieldTable.get((Object)asstNumber, (Object)info.disproperty)).isEmpty()) {
                rowObj.set(DIS_PROPERTY, dispropertyMap.values());
                rowObj.set(PROPERTIES, (Object)info.properties);
                Set entitySet = dispropertyMap.keySet();
                rowObj.set(DIS_PROPERTY_NUMBER, new ArrayList(entitySet).get(0));
                if (StringUtils.isNotBlank((CharSequence)info.documentField)) {
                    rowObj.set(DOUCMENT_FIELD, (Object)info.documentField);
                }
            }
        }
    }

    private void initAssgrpDocumentField(DynamicObject asstacttype) {
        if (null != asstacttype) {
            DynamicObject valueSource = (DynamicObject)asstacttype.get(VALUE_SOURCE);
            if (valueSource == null) {
                return;
            }
            MainEntityType valueSourceMeta = null;
            valueSourceMeta = EntityMetadataCache.getDataEntityType((String)valueSource.getString(NUMBER));
            for (IDataEntityProperty property : valueSourceMeta.getProperties()) {
                if (StringUtils.isNotBlank((CharSequence)property.getAlias()) && property instanceof BasedataProp) {
                    this.getBaseDataProperty(asstacttype, property);
                }
                if (!(property instanceof EntryProp)) continue;
                DynamicObjectType dynamicCollectionProperty = ((EntryProp)property)._collectionItemPropertyType;
                DataEntityPropertyCollection properties = dynamicCollectionProperty.getProperties();
                for (IDataEntityProperty iDataEntityProperty : properties) {
                    if (!StringUtils.isNotBlank((CharSequence)iDataEntityProperty.getAlias())) continue;
                    this.getBaseDataProperty(asstacttype, iDataEntityProperty);
                }
            }
        }
    }

    private void getBaseDataProperty(DynamicObject asstacttype, IDataEntityProperty property) {
        if (property instanceof BasedataProp) {
            HashMap<String, String> proNameToDisplayName = new HashMap<String, String>(8);
            proNameToDisplayName.put(((BasedataProp)property).getBaseEntityId(), property.getDisplayName().getLocaleValue());
            assistValueSourceFieldTable.put((Object)asstacttype.getString(NUMBER), (Object)property.getName(), proNameToDisplayName);
        }
    }

    private void initMultiAsstEntry(List<DynamicObject> newDys, List<String> asstNums, Map<String, AssgrpEntryRowInfo> asstNumAndInfoMap) {
        this.getModel().beginInit();
        String selector = AccountAndAssgrpPlugin.genUniqueKey("id", "checkitementry", "checkitementry.asstactitem", "checkitementry.asstactitem.number", "checkitementry.asstactitem.name", "checkitementry.asstactitem.flexfield", "checkitementry.asstactitem.valuesource, checkitementry.asstactitem.valuetype");
        ArrayList<Long> ids = new ArrayList<Long>(10);
        for (DynamicObject newDy : newDys) {
            ids.add(newDy.getLong("id"));
        }
        QFilter idFilter = new QFilter("id", "in", ids);
        QFilter[] filters = new QFilter[]{idFilter};
        DynamicObject[] accounts = BusinessDataServiceHelper.load((String)"bd_accountview", (String)selector, (QFilter[])filters);
        DynamicObjectCollection checkitemEntry = this.getRetainCollection(accounts);
        if (CollectionUtils.isNotEmpty((Collection)checkitemEntry)) {
            this.getModel().deleteEntryData(ENTRY);
            this.getModel().batchCreateNewEntryRow(ENTRY, checkitemEntry.size());
            boolean isDisplayProperty = (Boolean)this.getModel().getValue(DISPLAY_PROPERTY);
            int i = 0;
            for (DynamicObject checkitem : checkitemEntry) {
                DynamicObject asst = checkitem.getDynamicObject("asstactitem");
                if (asst == null) continue;
                String asstNumber = asst.getString(NUMBER);
                DynamicObject rowObj = this.getModel().getEntryRowEntity(ENTRY, i);
                int index = asstNums.indexOf(asstNumber);
                if (index >= 0) {
                    rowObj.set(IS_FILTER, (Object)true);
                    AssgrpEntryRowInfo info = asstNumAndInfoMap.get(asstNumber);
                    if (info != null) {
                        rowObj.set(TYPE, (Object)info.type);
                        if (TYPE_CONSIST.equals(info.type)) {
                            rowObj.set(SASSTMEMBER, (Object)info.sasstmember);
                            rowObj.set(EASSTMEMBER, (Object)info.easstmember);
                        } else {
                            rowObj.set(ASSTMEMBER, (Object)info.asstmember);
                        }
                    }
                }
                rowObj.set(ASSTACT_TYPE, (Object)asst);
                rowObj.set("asstnum", (Object)asstNumber);
                this.setDisplayProperty(isDisplayProperty, asstNumAndInfoMap, asst, asstNumber, rowObj);
                ++i;
            }
        } else {
            this.getModel().deleteEntryData(ENTRY);
        }
        this.getModel().endInit();
        this.getView().updateView();
        this.setEntryEnable(this.getModel().getEntryEntity(ENTRY));
    }

    private void setEntryEnable(DynamicObjectCollection entry) {
        IFormView view = this.getView();
        boolean isDisplayProperty = (Boolean)this.getModel().getValue(DISPLAY_PROPERTY);
        for (int i = 0; i < entry.size(); ++i) {
            if (isDisplayProperty) {
                this.isEnable(view, i);
                this.getView().setEnable(Boolean.FALSE, i, new String[]{ASSTMEMBER, TYPE});
                continue;
            }
            String typeVal = ((DynamicObject)entry.get(i)).getString(TYPE);
            view.setEnable(Boolean.TRUE, i, new String[]{TYPE});
            if (TYPE_MULT.equalsIgnoreCase(typeVal)) {
                view.setEnable(Boolean.TRUE, i, new String[]{ASSTMEMBER});
                view.setEnable(Boolean.FALSE, i, new String[]{SASSTMEMBER, EASSTMEMBER});
                continue;
            }
            view.setEnable(Boolean.FALSE, i, new String[]{ASSTMEMBER});
            view.setEnable(Boolean.TRUE, i, new String[]{SASSTMEMBER, EASSTMEMBER});
        }
    }

    private void isEnable(IFormView view, int i) {
        if (Boolean.parseBoolean(this.getModel().getValue(IS_FILTER, i).toString())) {
            view.setEnable(Boolean.TRUE, i, new String[]{DIS_PROPERTY});
            view.setEnable(Boolean.FALSE, i, new String[]{SASSTMEMBER, EASSTMEMBER});
        } else {
            view.setEnable(Boolean.FALSE, i, new String[]{TYPE, ASSTMEMBER, EASSTMEMBER, SASSTMEMBER, DIS_PROPERTY, PROPERTIES});
        }
    }

    private DynamicObjectCollection getRetainCollection(DynamicObject[] accounts) {
        HashSet idSets = Sets.newHashSet();
        HashMap idMaps = Maps.newHashMap();
        if (accounts != null) {
            for (int i = 0; i < accounts.length; ++i) {
                HashSet curSets = Sets.newHashSet();
                DynamicObject account = accounts[i];
                for (DynamicObject dynamicObject : account.getDynamicObjectCollection("checkitementry")) {
                    idMaps.put(dynamicObject.getLong("asstactitem_id"), dynamicObject);
                    curSets.add(dynamicObject.getLong("asstactitem_id"));
                }
                if (i == 0) {
                    idSets = curSets;
                    continue;
                }
                idSets.retainAll(curSets);
            }
        }
        DynamicObjectCollection checkitemEntry = new DynamicObjectCollection();
        for (Long id : idSets) {
            DynamicObject dyo = (DynamicObject)idMaps.get(id);
            if (dyo == null) continue;
            checkitemEntry.add((Object)dyo);
        }
        return checkitemEntry;
    }

    public static String genUniqueKey(String ... strings) {
        StringBuilder key = new StringBuilder();
        key.append(strings[0]);
        for (int i = 1; i < strings.length; ++i) {
            key.append(',');
            key.append(strings[i]);
        }
        return key.toString();
    }

    public void entryRowClick(RowClickEvent evt) {
        IDataModel model = this.getModel();
        Control source = (Control)evt.getSource();
        String key = ((Control)evt.getSource()).getKey();
        if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)ENTRY, (CharSequence)source.getKey())) {
            DynamicObject entity = ((FormDataModel)model).getEntryEntity(ENTRY, evt.getRow());
            DynamicObject asstacttype = entity.getDynamicObject(ASSTACT_TYPE);
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(8);
            ComboEdit comboedit = (ComboEdit)this.getControl(DIS_PROPERTY);
            if (null != asstacttype) {
                String valueSourceNumber = asstacttype.getString(NUMBER);
                if (assistValueSourceFieldTable.containsRow((Object)valueSourceNumber)) {
                    Map assgrpEntityMap = assistValueSourceFieldTable.rowMap();
                    Map documentFieldMap = (Map)assgrpEntityMap.get(valueSourceNumber);
                    for (Map.Entry documentField : documentFieldMap.entrySet()) {
                        Map nameToDisplayName = (Map)documentField.getValue();
                        for (Map.Entry documentFiledName : nameToDisplayName.entrySet()) {
                            StringBuilder disproperty = new StringBuilder();
                            disproperty.append((String)documentFiledName.getKey()).append("&").append((String)documentFiledName.getValue()).append("#").append((String)documentField.getKey());
                            comboItems.add(new ComboItem(new LocaleString((String)documentFiledName.getValue()), disproperty.toString()));
                        }
                    }
                }
                comboedit.setComboItems(comboItems);
                entity.set(DIS_PROPERTY, comboItems);
            }
        }
    }

    static class AssgrpEntryRowInfo {
        private String type;
        private String asstmember;
        private String sasstmember;
        private String easstmember;
        private String disproperty;
        private String properties;
        private String documentField;

        AssgrpEntryRowInfo(String type, String asstmember, String sasstmember, String easstmember, String disproperty, String properties, String documentField) {
            this.type = type;
            this.asstmember = asstmember;
            this.sasstmember = sasstmember;
            this.easstmember = easstmember;
            this.disproperty = disproperty;
            this.properties = properties;
            this.documentField = documentField;
        }
    }
}

