/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.acctformula;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class AcctAssgrpBasePlugin
extends AbstractFormPlugin {
    protected static String ENTRY = "assgrpentity";
    public static final String ACCOUNT = "account";
    public static final String CASHFLOWITEM = "cashflowitem";
    private static final String ASSTACT_TYPE = "asstacttype";
    private static final String ASSTMEMBER = "asstmember";
    private static final String SASSTMEMBER = "sasstmember";
    private static final String EASSTMEMBER = "easstmember";
    private static final String TYPE_CONSIST = "1";
    private static final String TYPE_MULT = "2";
    private static final String SELECTORS = AcctAssgrpBasePlugin.genUniqueKey("id", "assistentry", "assistentry.asstypeid", "assistentry.asstypeid.number", "assistentry.asstypeid.name", "assistentry.asstypeid.flexfield", "assistentry.asstypeid.valuesource", "assistentry.asstypeid.valuetype");
    private static final String GROUP = "group";
    private static final String GROUPSTANDARD = "groupstandard";
    private static final String GROUPSTANDARD_NUMBER = "groupstandardnumber";
    private static final List<String> grpEntity = new ArrayList<String>(3);

    public void initialize() {
        super.initialize();
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String orgid = (String)this.getView().getFormShowParameter().getCustomParam("org");
        if (StringUtils.isNotEmpty((CharSequence)orgid) && !"0".equals(orgid)) {
            this.getPageCache().put("orgid", orgid);
            this.getModel().setValue("org", (Object)Long.valueOf(orgid));
        }
    }

    protected void resetEntityAndAssgrp(long orgId, long accounttableId, String accountStr, String entityKey) {
        QFilter qnum;
        QFilter qbase;
        List ids;
        IDataModel model = this.getModel();
        if (orgId == 0L || accounttableId == 0L && "bd_accountview".equals(entityKey) || StringUtils.isEmpty((CharSequence)accountStr)) {
            return;
        }
        String[] memberStrs = accountStr.split("\\|");
        if (memberStrs.length > 0 && !(ids = QueryServiceHelper.queryPrimaryKeys((String)entityKey, (QFilter[])new QFilter[]{qbase = BaseDataServiceHelper.getBaseDataFilter((String)entityKey, (Long)orgId), qnum = new QFilter("number", "=", (Object)memberStrs[0])}, null, (int)-1)).isEmpty()) {
            model.setValue(CASHFLOWITEM, ids.get(0));
        }
        ArrayList<String> asstNums = new ArrayList<String>(memberStrs.length - 1);
        HashMap<String, AssgrpEntryRowInfo> asstNumAndInfoMap = new HashMap<String, AssgrpEntryRowInfo>(memberStrs.length - 1);
        for (int i = 1; i < memberStrs.length; i += 2) {
            String member = memberStrs[i];
            asstNums.add(member);
            String type = null;
            String asstmember = null;
            String sasstmember = null;
            String easstmember = null;
            String groupStandard = null;
            String group = null;
            if (i + 1 < memberStrs.length) {
                boolean isNoCategory = AcctAssgrpBasePlugin.isCollectionNumber(memberStrs[i + 1]);
                if (isNoCategory) {
                    String[] values = memberStrs[i + 1].split("#");
                    groupStandard = values[0];
                    group = values[1];
                } else {
                    int newAssgrpValueLen;
                    String assgrpValueStr = memberStrs[i + 1];
                    int oldAssgrpValueLen = assgrpValueStr.length();
                    if (oldAssgrpValueLen != (newAssgrpValueLen = (assgrpValueStr = assgrpValueStr.replace("[", "").replace("]", "")).length())) {
                        String[] assgrpValues = assgrpValueStr.split(",");
                        if (assgrpValues.length > 0) {
                            type = TYPE_CONSIST;
                            sasstmember = assgrpValues[0];
                            easstmember = assgrpValues[assgrpValues.length - 1];
                        }
                    } else {
                        type = TYPE_MULT;
                        asstmember = assgrpValueStr;
                    }
                }
            }
            AssgrpEntryRowInfo info = new AssgrpEntryRowInfo(type, asstmember, sasstmember, easstmember, groupStandard, group);
            asstNumAndInfoMap.put(member, info);
        }
        DynamicObject dyo = (DynamicObject)model.getValue("bd_accountview".equals(entityKey) ? ACCOUNT : CASHFLOWITEM);
        if (dyo != null) {
            this.initAsstEntry(dyo.getLong("id"), entityKey, SELECTORS, "assistentry", "asstypeid", asstNums, asstNumAndInfoMap);
        }
    }

    public static boolean isCollectionNumber(String acctAssistListStr) {
        return !StringUtils.isBlank((CharSequence)acctAssistListStr) && acctAssistListStr.endsWith("#") && acctAssistListStr.split("#").length == 2;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{ASSTMEMBER, SASSTMEMBER, EASSTMEMBER});
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (evt.getSource() instanceof TextEdit) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("assgrpentity");
            int[] selectRows = entryGrid.getSelectRows();
            DynamicObject asstacttype = ((DynamicObject)this.getModel().getEntryEntity("assgrpentity").get(selectRows[0])).getDynamicObject(ASSTACT_TYPE);
            String valuetype = asstacttype.getString("valuetype");
            DynamicObject valuesource = asstacttype.getDynamicObject("valuesource");
            String entityName = valuesource.getString("id");
            ListShowParameter lsp = null;
            switch (key) {
                case "asstmember": {
                    QFilter orgFilter;
                    if ("3".equals(valuetype)) {
                        return;
                    }
                    if (TYPE_MULT.equals(valuetype)) {
                        Object orgId;
                        lsp = ShowFormHelper.createShowListForm((String)"bos_assistantdata_detail", (boolean)false);
                        long groupId = BusinessDataServiceHelper.loadSingle((Object)asstacttype.get("id"), (String)"bd_asstacttype").getDynamicObject("assistanttype").getLong("id");
                        lsp.getListFilterParameter().setFilter(new QFilter(GROUP, "=", (Object)groupId));
                        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, key);
                        lsp.setCloseCallBack(closeCallBack);
                        if (ASSTMEMBER.equals(key)) {
                            lsp.setMultiSelect(true);
                        }
                        if (Objects.nonNull(orgId = this.getModel().getValue("org_id")) && Long.parseLong(orgId.toString()) != 0L) {
                            this.getView().getFormShowParameter().setCustomParam("orgId", orgId);
                        } else {
                            this.getView().getFormShowParameter().getCustomParams().remove("orgId");
                        }
                        this.getView().cacheFormShowParameter();
                        this.getView().showForm((FormShowParameter)lsp);
                        return;
                    }
                    lsp = ShowFormHelper.createShowListForm((String)entityName, (boolean)true);
                    ListFilterParameter filterParam = lsp.getListFilterParameter();
                    List qFilters = filterParam.getQFilters();
                    MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityName);
                    DynamicProperty statusProp = entityType.getProperty("status");
                    if (statusProp != null) {
                        qFilters.add(new QFilter("status", "=", (Object)"C"));
                    }
                    if ((orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)entityName, (Long)Long.valueOf(String.valueOf(this.getModel().getValue("org_id"))))) != null) {
                        qFilters.add(orgFilter);
                    }
                    lsp.setUseOrgId(((Long)this.getModel().getValue("org_id")).longValue());
                    break;
                }
                case "group": {
                    entityName = entityName.concat(GROUP);
                    lsp = ShowFormHelper.createShowListForm((String)entityName, (boolean)true);
                    ListFilterParameter filterParam = lsp.getListFilterParameter();
                    List qFilters = filterParam.getQFilters();
                    DynamicObject groupStandard = ((DynamicObject)this.getModel().getEntryEntity("assgrpentity").get(selectRows[0])).getDynamicObject(GROUPSTANDARD);
                    if (groupStandard == null) break;
                    qFilters.add(new QFilter("standard", "=", groupStandard.get("id")));
                    break;
                }
            }
            if (lsp == null) {
                return;
            }
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, key);
            lsp.setCloseCallBack(closeCallBack);
            this.getView().showForm((FormShowParameter)lsp);
        }
    }

    protected void appendAssgrps(DynamicObjectCollection assgrpentity, StringBuilder returnData) {
        for (DynamicObject row : assgrpentity) {
            boolean isfilter = row.getBoolean("isfilter");
            if (!isfilter) continue;
            DynamicObject asstacttype = row.getDynamicObject(ASSTACT_TYPE);
            String type = row.getString("type");
            String sasstmember = row.getString(SASSTMEMBER);
            String easstmember = row.getString(EASSTMEMBER);
            String asstmember = row.getString(ASSTMEMBER);
            returnData.append('|');
            String asstacttypeNum = asstacttype.getString("number");
            returnData.append(asstacttypeNum).append('|');
            if (StringUtils.isEmpty((CharSequence)sasstmember) && StringUtils.isEmpty((CharSequence)easstmember) && StringUtils.isEmpty((CharSequence)asstmember)) {
                String groupStandardNum = row.getString(GROUPSTANDARD_NUMBER);
                String groupNum = row.getString(GROUP);
                if (StringUtils.isNotEmpty((CharSequence)groupStandardNum)) {
                    returnData.append(groupStandardNum);
                }
                if (!StringUtils.isNotEmpty((CharSequence)groupNum)) continue;
                returnData.append("#").append(groupNum).append("#");
                continue;
            }
            if (TYPE_CONSIST.equals(type)) {
                returnData.append('[');
                returnData.append(sasstmember).append(',');
                returnData.append(easstmember);
                returnData.append(']');
                continue;
            }
            returnData.append(asstmember);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection coll;
        super.closedCallBack(closedCallBackEvent);
        Object returnData = closedCallBackEvent.getReturnData();
        String actionId = closedCallBackEvent.getActionId();
        if (returnData != null && (actionId.endsWith(ASSTMEMBER) || actionId.endsWith(GROUP)) && (coll = (ListSelectedRowCollection)returnData).size() > 0) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("assgrpentity");
            int[] selectRows = entryGrid.getSelectRows();
            StringBuilder sb = new StringBuilder();
            for (ListSelectedRow row : coll) {
                if (sb.length() != 0) {
                    sb.append(',');
                }
                sb.append(row.getNumber());
            }
            this.getModel().setValue(actionId, (Object)sb.toString(), selectRows[0]);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("cancel".equals(key)) {
            this.getView().close();
        }
    }

    public static String genUniqueKey(String ... strings) {
        StringBuilder key = new StringBuilder();
        key.append(strings[0]);
        for (int i = 1; i < strings.length; ++i) {
            key.append(',');
            key.append(strings[i]);
        }
        return key.toString();
    }

    public void initAsstEntry(Long newOneId, String entity, String selector, String entryid, String asstacttype, List<String> asstNums, Map<String, AssgrpEntryRowInfo> asstNumAndInfoMap) {
        this.getModel().deleteEntryData(ENTRY);
        DynamicObject dy = BusinessDataServiceHelper.loadSingle((Object)newOneId, (String)entity, (String)selector);
        DynamicObjectCollection entry = dy.getDynamicObjectCollection(entryid);
        if (entry != null && entry.size() > 0) {
            this.getModel().batchCreateNewEntryRow(ENTRY, entry.size());
            int i = 0;
            for (DynamicObject item : entry) {
                DynamicObject asst = item.getDynamicObject(asstacttype);
                DynamicObject valueSource = asst.getDynamicObject("valuesource");
                if (null == valueSource) continue;
                String entityName = valueSource.getString("id");
                String asstNumber = asst.getString("number");
                DynamicObject rowObj = this.getModel().getEntryRowEntity(ENTRY, i);
                int index = asstNums.indexOf(asstNumber);
                if (index >= 0) {
                    rowObj.set("isfilter", (Object)Boolean.TRUE);
                    AssgrpEntryRowInfo info = asstNumAndInfoMap.get(asstNumber);
                    if (info != null) {
                        rowObj.set("type", (Object)info.type);
                        if (TYPE_CONSIST.equals(info.type)) {
                            rowObj.set(SASSTMEMBER, (Object)info.sasstmember);
                            rowObj.set(EASSTMEMBER, (Object)info.easstmember);
                        } else {
                            rowObj.set(ASSTMEMBER, (Object)info.asstmember);
                        }
                        if (grpEntity.contains(entityName)) {
                            DynamicObject groupStandard = BusinessDataServiceHelper.loadSingleFromCache((String)(entityName + GROUPSTANDARD), (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)info.groupStandard)});
                            rowObj.set(GROUPSTANDARD, (Object)groupStandard);
                            rowObj.set(GROUPSTANDARD_NUMBER, (Object)info.groupStandard);
                            rowObj.set(GROUP, (Object)info.group);
                        }
                    }
                }
                rowObj.set(ASSTACT_TYPE, (Object)asst);
                if (StringUtils.isNotEmpty((CharSequence)rowObj.getString(GROUPSTANDARD))) {
                    this.getView().setEnable(Boolean.valueOf(false), i, new String[]{ASSTMEMBER});
                }
                if (!grpEntity.contains(entityName) || StringUtils.isNotEmpty((CharSequence)rowObj.getString(ASSTMEMBER))) {
                    this.getView().setEnable(Boolean.valueOf(false), i, new String[]{GROUPSTANDARD});
                }
                if (StringUtils.isEmpty((CharSequence)rowObj.getString(GROUPSTANDARD))) {
                    this.getView().setEnable(Boolean.valueOf(false), i, new String[]{GROUP});
                }
                ++i;
            }
        }
        this.getView().updateView();
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        DynamicObject valuesource;
        String entityNumber;
        super.getEntityType(e);
        MainEntityType type = this.getModel().getDataEntityType();
        EntryProp entry = (EntryProp)type.getProperty(ENTRY);
        IDataModel model = this.getModel();
        int rowIndex = model.getEntryCurrentRowIndex(ENTRY);
        DynamicObject fieldNameDyn = (DynamicObject)model.getValue(ASSTACT_TYPE, rowIndex);
        if (fieldNameDyn == null) {
            return;
        }
        String valuetype = fieldNameDyn.getString("valuetype");
        if (TYPE_CONSIST.equals(valuetype) && grpEntity.contains(entityNumber = (valuesource = fieldNameDyn.getDynamicObject("valuesource")).getString("id"))) {
            String formId = entityNumber + GROUPSTANDARD;
            BasedataProp prop = (BasedataProp)entry.getDynamicCollectionItemPropertyType().getProperty(GROUPSTANDARD);
            prop.setBaseEntityId(formId);
            prop.setComplexType((IDataEntityType)EntityMetadataCache.getDataEntityType((String)formId));
        }
    }

    static {
        grpEntity.add("bd_customer");
        grpEntity.add("bd_supplier");
        grpEntity.add("bd_material");
    }

    static class AssgrpEntryRowInfo {
        private String type;
        private String asstmember;
        private String sasstmember;
        private String easstmember;
        private String groupStandard;
        private String group;

        AssgrpEntryRowInfo(String type, String asstmember, String sasstmember, String easstmember, String groupStandard, String group) {
            this.type = type;
            this.asstmember = asstmember;
            this.sasstmember = sasstmember;
            this.easstmember = easstmember;
            this.groupStandard = groupStandard;
            this.group = group;
        }
    }
}

