/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.cashflow;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.dataset.TreeNode;
import kd.fi.gl.formplugin.CashFlowDesignate;

public class CashFlowAccountLevelStrategy {
    private int level;
    private long orgId;
    private long bookType;
    private Map<String, CashFlowDesignate> map;

    public CashFlowAccountLevelStrategy(int level, long orgId, long bookType, Map<String, CashFlowDesignate> map) {
        if (orgId == 0L || bookType == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u76f8\u5e94\u7684\u8d26\u7c3f\u3002", (String)"CashFlowAccountLevelStrategy_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        }
        this.level = level;
        this.orgId = orgId;
        this.bookType = bookType;
        this.map = map;
    }

    public Map<String, CashFlowDesignate> excute() {
        Map<Object, TreeNode> accIdMap = this.getAccountMap();
        LinkedHashMap<String, CashFlowDesignate> newMap = new LinkedHashMap<String, CashFlowDesignate>();
        for (Map.Entry<String, CashFlowDesignate> entry : this.map.entrySet()) {
            Long id = Long.valueOf(entry.getKey());
            TreeNode node = accIdMap.get(id);
            if ((node = this.getNodeByLevel(node, this.level)) == null) continue;
            CashFlowDesignate value = entry.getValue();
            String name = node.getPropValue("number") + "_" + node.getPropValue("name");
            value.setName(name);
            value.setLevel(this.level + 1 + "");
            String idKey = String.valueOf(node.getId());
            newMap.compute(idKey, (k, v) -> {
                if (v == null) {
                    return value;
                }
                Set<Long> entryIds = v.getVchIds();
                entryIds.addAll(value.getVchIds());
                v.setAmt(v.getAmt().add(value.getAmt()));
                return v;
            });
        }
        return newMap;
    }

    private TreeNode getNodeByLevel(TreeNode node, int level) {
        int nodeLevel = (Integer)node.getPropValue("level");
        if (nodeLevel == level) {
            return node;
        }
        if (nodeLevel > level) {
            return this.getNodeByLevel(node.getParent(), level);
        }
        return null;
    }

    private Map<Object, TreeNode> getAccountMap() {
        HashMap<Object, TreeNode> accIdMap = new HashMap<Object, TreeNode>();
        AccountBookInfo book = AccSysUtil.getBookFromAccSys((long)this.orgId, (long)this.bookType);
        long accountTableId = book.getAccountTableId();
        QFilter atFilter = new QFilter("accounttable", "=", (Object)accountTableId);
        String sel = "id,parent,name,number,level,isleaf";
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + ".account"), (String)"bd_accountview", (String)sel, (QFilter[])new QFilter[]{atFilter}, null);){
            for (Row row : ds) {
                Long id = row.getLong("id");
                TreeNode node2 = new TreeNode(id.longValue());
                node2.setParentId(row.getLong("parent").longValue());
                node2.setPropValue("name", (Object)row.getString("name"));
                node2.setPropValue("number", (Object)row.getString("number"));
                node2.setPropValue("level", (Object)row.getInteger("level"));
                node2.setPropValue("isleaf", (Object)row.getBoolean("isleaf"));
                accIdMap.put(id, node2);
            }
        }
        accIdMap.values().forEach(node -> node.setParent((TreeNode)accIdMap.get(node.getParentId())));
        return accIdMap;
    }
}

