/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.cashflow;

import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.fi.gl.formplugin.cashflow.RecalCFSumThread;
import kd.fi.gl.service.GLThreadService;
import kd.fi.gl.util.AppLogHelper;

public class CashFlowSumRecalFormPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final String PROGRESS = "progress";
    private static final int INIT_PROGRESS = 5;
    private static final String PROGRESSBARAP = "progressbarap";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"recal", "recalall"});
        BasedataEdit startperiod = (BasedataEdit)this.getControl("period");
        startperiod.addBeforeF7SelectListener(evt -> {
            ListShowParameter show = (ListShowParameter)evt.getFormShowParameter();
            long periodType = (Long)this.getModel().getValue("periodtype_id");
            QFilter ftypeId = new QFilter("periodtype", "=", (Object)periodType);
            show.getListFilterParameter().getQFilters().add(ftypeId);
        });
        ProgressBar bar = (ProgressBar)this.getControl(PROGRESSBARAP);
        bar.addProgressListener((ProgresssListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey();
        long orgId = (Long)this.getModel().getValue("org_id");
        long bookTypeId = (Long)this.getModel().getValue("booktype_id");
        long periodId = (Long)this.getModel().getValue("period_id");
        this.getPageCache().put("operation_key", key);
        if (key.equals("recal")) {
            this.writeOperationLog(key + "_start", orgId, bookTypeId, periodId);
            GLThreadService.ayncCallBalance((String)"CashFlowSumRecalculate", (Runnable)new RecalCFSumThread(orgId, bookTypeId, periodId, 0L, 0L, this.getView(), false));
            ProgressBar bar = (ProgressBar)this.getControl(PROGRESSBARAP);
            bar.setPercent(5);
            bar.start();
            this.setLabel(5);
        } else if (key.equals("recalall")) {
            long periodType = (Long)this.getModel().getValue("periodtype_id");
            long curperiodId = (Long)this.getModel().getValue("curperiod_id");
            this.writeOperationLog(key + "_start", orgId, bookTypeId, periodId, curperiodId);
            GLThreadService.ayncCallBalance((String)"CashFlowSumRecalculate", (Runnable)new RecalCFSumThread(orgId, bookTypeId, periodId, periodType, curperiodId, this.getView(), true));
            ProgressBar bar = (ProgressBar)this.getControl(PROGRESSBARAP);
            bar.setPercent(5);
            bar.start();
            this.setLabel(5);
        }
    }

    private void setLabel(int percent) {
        Label label = (Label)this.getControl("labelap");
        label.setText(String.format("calculating... %s ", percent) + "%");
    }

    public void onProgress(ProgressEvent progressEvent) {
        int percent = this.getPageCache().get(PROGRESS) == null ? 5 : Integer.parseInt(this.getPageCache().get(PROGRESS));
        progressEvent.setProgress(percent);
        this.setLabel(percent);
        if (percent >= 100) {
            this.writeOperationLog(this.getPageCache().get("operation_key") + "_end", new long[0]);
            Label label = (Label)this.getControl("labelap");
            label.setText("calculate complete");
            ProgressBar bar = (ProgressBar)this.getControl(PROGRESSBARAP);
            bar.setPercent(percent);
            bar.stop();
        }
    }

    private void writeOperationLog(String opKey, long ... filters) {
        String[] descParams;
        MultiLangEnumBridge opDescBridge;
        IDataModel model = this.getModel();
        List collected = Arrays.stream(filters).mapToObj(String::valueOf).collect(Collectors.toList());
        String opKeyWord = String.join((CharSequence)" | ", collected);
        if (filters == null || filters.length == 0) {
            filters = new long[4];
            filters[0] = (Long)model.getValue("org_id");
            filters[1] = (Long)model.getValue("booktype_id");
            filters[2] = (Long)model.getValue("period_id");
            if (opKey.startsWith("recalall")) {
                filters[3] = (Long)model.getValue("curperiod_id");
            }
            opDescBridge = new MultiLangEnumBridge("\u7ec4\u7ec7\u3010%1$s\u3011\u73b0\u91d1\u6d41\u91cf\u53d1\u751f\u91cd\u7b97\u6210\u529f\u3002\u91cd\u7b97\u6761\u4ef6\uff1a\u3010%2$s\u3011\u3002", "CashFlowSumRecalFormPlugin_0", "fi-gl-formplugin");
            descParams = new String[]{((DynamicObject)model.getValue("org")).getString("name"), opKeyWord};
        } else {
            opDescBridge = new MultiLangEnumBridge("\u73b0\u91d1\u6d41\u91cf\u53d1\u751f\u91cd\u7b97\u6210\u529f\u3002\u91cd\u7b97\u6761\u4ef6\uff1a\u3010%1$s\u3011\u3002", "CashFlowSumRecalFormPlugin_1", "fi-gl-formplugin");
            descParams = new String[]{opKeyWord};
        }
        Long orgId = filters[0];
        MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge();
        if (opKey.equals("recal_start")) {
            opKey = "recal_start";
            opNameBridge = new MultiLangEnumBridge("\u91cd\u7b97\u5f00\u59cb\u3002", "BalanceRecalculateFormPlugin_1", "fi-gl-formplugin");
        } else if (opKey.equals("recalall_start")) {
            opKey = "recal_start";
            opNameBridge = new MultiLangEnumBridge("\u91cd\u7b97\u671f\u95f4\u53ca\u540e\u671f\u5f00\u59cb\u3002", "BalanceRecalculateFormPlugin_2", "fi-gl-formplugin");
        } else if (opKey.equals("recal_end")) {
            opKey = "recal_end";
            opNameBridge = new MultiLangEnumBridge("\u91cd\u7b97\u7ed3\u675f\u3002", "BalanceRecalculateFormPlugin_3", "fi-gl-formplugin");
        } else if (opKey.equals("recalall_end")) {
            opKey = "recalall_end";
            opNameBridge = new MultiLangEnumBridge("\u91cd\u7b97\u671f\u95f4\u53ca\u540e\u671f\u7ed3\u675f\u3002", "BalanceRecalculateFormPlugin_4", "fi-gl-formplugin");
        }
        AppLogHelper.addBatchLog((long)orgId, (String)"gl_accountbook", (String)opKeyWord, (String)opKey, (MultiLangEnumBridge)opNameBridge, (MultiLangEnumBridge)opDescBridge, (String[])descParams);
    }
}

