/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.cashflow;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.gl.common.Tuple;
import kd.fi.gl.formplugin.cashflow.UpCFSumThread;
import org.apache.commons.collections.CollectionUtils;

public class CashFlowSumUpFormPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(CashFlowSumUpFormPlugin.class);
    private static final String lock_key = "cfsumup";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey();
        if (key.equals("btnok")) {
            boolean islock;
            block33: {
                Date startdate = (Date)this.getModel().getValue("startdate");
                if (startdate == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5f00\u59cb\u65e5\u671f\u3002", (String)"CashFlowSumUpFormPlugin_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    return;
                }
                islock = false;
                try (DLock lock = DLock.create((String)"fi/gl/cfsumup").fastMode();){
                    if (!lock.tryLock()) break block33;
                    Long latestUpRecordId = this.queryLatestUpRecord();
                    try (TXHandle txh = TX.requiresNew();){
                        try {
                            if (latestUpRecordId != 0L) {
                                islock = this.dbLock(latestUpRecordId);
                            } else {
                                latestUpRecordId = this.saveUpRecord(startdate);
                                islock = true;
                            }
                        }
                        catch (Exception ex) {
                            txh.markRollback();
                            throw ex;
                        }
                    }
                    if (islock) {
                        Long recordId = latestUpRecordId;
                        ThreadService.execute(() -> this.doUpgrade(recordId, startdate), (TaskType)TaskType.GL_COMMON_ASYNC_TASK);
                    }
                }
            }
            if (islock) {
                Label label = (Label)this.getControl("labelap");
                label.setText(ResManager.loadKDString((String)"\u73b0\u91d1\u6d41\u91cf\u6570\u636e\u5347\u7ea7\u7a0b\u5e8f\u5df2\u8f6c\u5165\u540e\u53f0\u6267\u884c\uff0c\u6267\u884c\u65f6\u95f4\u8f83\u957f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u786e\u8ba4\u7ed3\u679c\u3002", (String)"CashFlowSumUpFormPlugin_2", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"btnok"});
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u73b0\u91d1\u6d41\u91cf\u6570\u636e\u5347\u7ea7\u7a0b\u5e8f\u5df2\u5728\u540e\u53f0\u6267\u884c\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"CashFlowSumUpFormPlugin_1", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void doUpgrade(Long latestUpRecordId, Date startdate) {
        Map<Long, Long> succInfos = this.querySuccUpInfo(latestUpRecordId);
        Map<Long, Long> startPeriods = this.queryStartPeriods(startdate);
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fid,forgid,fbookstypeid,fperiodtypeid,fcashinitperiodid from t_bd_accountbooks where ", new Object[0]);
        sqlBuilder.append(" fisbizunit =?", new Object[]{"1"});
        DataSet ds = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)DBRoute.of((String)"gl"), (SqlBuilder)sqlBuilder);
        ArrayList<Future> resultList = new ArrayList<Future>();
        for (Row row : ds) {
            Long succPeriodId;
            boolean succUp;
            long id = row.getLong("fid");
            long orgId = row.getLong("forgid");
            long booktypeId = row.getLong("fbookstypeid");
            long periodTypeId = row.getLong("fperiodtypeid");
            long cashInitPeriodId = row.getLong("fcashinitperiodid");
            if (cashInitPeriodId == 0L) continue;
            Long startPeriodId = startPeriods.get(periodTypeId);
            if (startPeriodId == null || cashInitPeriodId > startPeriodId) {
                startPeriodId = cashInitPeriodId;
            }
            if ((succUp = this.isSuccUp(succPeriodId = succInfos.get(id))) && succPeriodId != null && startPeriodId >= succPeriodId) continue;
            Future future = ThreadService.submit((Callable)new UpCFSumThread(id, orgId, booktypeId, startPeriodId, periodTypeId, succPeriodId, succUp), (TaskType)TaskType.GL_PARELLEL_COMPUTE);
            resultList.add(future);
        }
        Boolean isUpgradeSuccess = true;
        ArrayList<Object[]> details = new ArrayList<Object[]>(10);
        for (Future task : resultList) {
            try {
                Tuple result = (Tuple)task.get();
                details.add(new Object[]{result.item1, result.item2});
                if (((Boolean)result.item1).booleanValue()) continue;
                isUpgradeSuccess = false;
            }
            catch (Exception e) {
                logger.error("CashFlowSum_upgrade_failed on " + e.getMessage(), (Throwable)e);
                isUpgradeSuccess = false;
            }
        }
        try (TXHandle txh = TX.requiresNew();){
            try {
                this.updateUpRecord(latestUpRecordId, startdate, isUpgradeSuccess, details);
            }
            catch (Exception ex) {
                txh.markRollback();
                throw ex;
            }
        }
    }

    private void updateUpRecord(Long latestUpRecordId, Date startdate, Boolean isUpgradeSuccess, List<Object[]> details) {
        String sql = "update t_gl_cashflowsum_uprd set fstartdate=?,fexecutionstatus=?,fislock=?  WHERE fid=?;";
        DB.execute((DBRoute)DBRoute.of((String)"gl"), (String)sql, (Object[])new Object[]{startdate, isUpgradeSuccess != false ? "1" : "2", "0", latestUpRecordId});
        if (details.size() > 0) {
            long[] pkIds = DB.genLongIds((String)"t_gl_cashflowsum_uprde", (int)details.size());
            ArrayList<Object[]> insertParams = new ArrayList<Object[]>(details.size());
            ArrayList<Long> delAcctBookIds = new ArrayList<Long>(details.size());
            int pkIdx = 0;
            for (Object[] detail : details) {
                Boolean isSucc = (Boolean)detail[0];
                String infoStr = detail[1].toString();
                String[] infos = infoStr.split("-");
                long accountbookid = Long.parseLong(infos[0]);
                long orgid = Long.parseLong(infos[1]);
                long booktypeid = Long.parseLong(infos[2]);
                long startperiodid = Long.parseLong(infos[3]);
                delAcctBookIds.add(accountbookid);
                Object[] insertParam = new Object[]{latestUpRecordId, pkIds[pkIdx], orgid, booktypeid, accountbookid, startperiodid, isSucc != false ? "1" : "2"};
                insertParams.add(insertParam);
                ++pkIdx;
            }
            List batchList = Lists.partition(delAcctBookIds, (int)1000);
            for (List part : batchList) {
                String delSql = this.getDelSql(part.size());
                DB.execute((DBRoute)DBRoute.of((String)"gl"), (String)delSql, (Object[])part.toArray());
            }
            sql = "insert into t_gl_cashflowsum_uprde(fid,fentryid,forgid,fbooktypeid,faccountbookid,fstartperiodid,fexecresult) values(?,?,?,?,?,?,?);";
            DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)sql, insertParams);
        }
    }

    private Long saveUpRecord(Date startdate) {
        DynamicObject record = BusinessDataServiceHelper.newDynamicObject((String)"gl_cashflowsum_uprd");
        long pkId = DB.genLongId((String)"t_gl_cashflowsum_uprd");
        record.set("id", (Object)pkId);
        record.set("billno", (Object)DB.genGlobalLongId());
        record.set("startdate", (Object)startdate);
        record.set("executionstatus", (Object)"0");
        record.set("islock", (Object)"1");
        record.set("creator", (Object)RequestContext.get().getCurrUserId());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{record});
        return pkId;
    }

    private boolean isSuccUp(Long succPeriodId) {
        return succPeriodId != null && succPeriodId != 0L;
    }

    private Long queryLatestUpRecord() {
        QFilter isLatestF = new QFilter("islatest", "=", (Object)"1");
        DynamicObject upRecord = QueryServiceHelper.queryOne((String)"gl_cashflowsum_uprd", (String)"id", (QFilter[])new QFilter[]{isLatestF});
        if (upRecord != null) {
            return upRecord.getLong("id");
        }
        return 0L;
    }

    private Map<Long, Long> querySuccUpInfo(Long recordId) {
        HashMap<Long, Long> succInfos = new HashMap<Long, Long>(16);
        if (recordId == null || recordId == 0L) {
            return succInfos;
        }
        QFilter idF = new QFilter("id", "=", (Object)recordId);
        QFilter succF = new QFilter("entryentity.execresult", "=", (Object)"1");
        DynamicObjectCollection upRecords = QueryServiceHelper.query((String)"gl_cashflowsum_uprd", (String)"entryentity.accountbook,entryentity.startperiod", (QFilter[])new QFilter[]{idF, succF});
        if (CollectionUtils.isNotEmpty((Collection)upRecords)) {
            for (DynamicObject r : upRecords) {
                succInfos.put(r.getLong("entryentity.accountbook"), r.getLong("entryentity.startperiod"));
            }
        }
        return succInfos;
    }

    private Map<Long, Long> queryStartPeriods(Date startdate) {
        HashMap<Long, Long> startPeriods = new HashMap<Long, Long>(16);
        QFilter date1 = new QFilter("begindate", "<=", (Object)startdate);
        QFilter date2 = new QFilter("enddate", ">=", (Object)startdate);
        DynamicObjectCollection periods = QueryServiceHelper.query((String)"bd_period", (String)"id,periodtype", (QFilter[])new QFilter[]{date1, date2});
        for (DynamicObject p : periods) {
            startPeriods.put(p.getLong("periodtype"), p.getLong("id"));
        }
        return startPeriods;
    }

    private String getDelSql(int size) {
        StringBuilder sb = new StringBuilder();
        sb.append("delete from t_gl_cashflowsum_uprde where faccountbookid in (?");
        for (int i = 1; i < size; ++i) {
            sb.append(",?");
        }
        sb.append(")");
        return sb.toString();
    }

    private boolean dbLock(Long latestUpRecordId) {
        String sql = "update t_gl_cashflowsum_uprd set fislock=? WHERE fid=? and fislock=?;";
        int count = DB.update((DBRoute)DBRoute.of((String)"gl"), (String)sql, (Object[])new Object[]{"1", latestUpRecordId, "0"});
        return count > 0;
    }
}

