/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.cashflow;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.gl.balance.CalculatorFactory;
import kd.fi.gl.balance.ICalculator;
import kd.fi.gl.balcal.CashflowSumCalculator;
import kd.fi.gl.common.Tuple;
import kd.fi.gl.lock.Lock;
import kd.fi.gl.lock.LockKey;
import kd.fi.gl.util.BalanceCheckHelper;

class UpCFSumThread
implements Callable<Tuple<Boolean, String>> {
    boolean recal = false;
    Long accountBookId = 0L;
    Long orgId = 0L;
    Long bookTypeId = 0L;
    Long periodId = 0L;
    Long succperiodId = 0L;
    Long periodTypeId = 0L;
    Log log = LogFactory.getLog((String)"UpCFSumThread");

    UpCFSumThread(Long id, Long orgId, Long bookTypeId, Long periodId, Long periodTypeId, Long succperiodId, boolean recal) {
        this.accountBookId = id;
        this.orgId = orgId;
        this.bookTypeId = bookTypeId;
        this.periodId = periodId;
        this.periodTypeId = periodTypeId;
        this.succperiodId = succperiodId;
        this.recal = recal;
    }

    @Override
    public Tuple<Boolean, String> call() {
        try {
            Long endperiodid = this.succperiodId;
            if (!this.recal && (endperiodid = BalanceCheckHelper.getMaxCFPeriodId((long)this.orgId, (long)this.bookTypeId, (long)0L)) == 0L) {
                return new Tuple((Object)true, (Object)(this.accountBookId + "-" + this.orgId + "-" + this.bookTypeId + "-" + this.periodId));
            }
            QFilter ftypeId = new QFilter("periodtype", "=", (Object)this.periodTypeId);
            QFilter fid1 = new QFilter("id", ">=", (Object)this.periodId);
            QFilter fid2 = new QFilter("id", "<=", (Object)endperiodid);
            DynamicObjectCollection col = QueryServiceHelper.query((String)"bd_period", (String)"id", (QFilter[])new QFilter[]{fid1, fid2, ftypeId}, (String)"id");
            boolean result = true;
            if (!col.isEmpty()) {
                List<Long> ids = col.stream().map(x -> x.getLong("id")).collect(Collectors.toList());
                result = this.calculate(this.orgId, this.bookTypeId, ids);
            }
            return new Tuple((Object)result, (Object)(this.accountBookId + "-" + this.orgId + "-" + this.bookTypeId + "-" + this.periodId));
        }
        catch (Exception ex) {
            this.log.error((Throwable)ex);
            return new Tuple((Object)false, (Object)(this.accountBookId + "-" + this.orgId + "-" + this.bookTypeId + "-" + this.periodId));
        }
    }

    private boolean calculate(Long orgId, Long bookTypeId, List<Long> periodIds) {
        LockKey lockKey = LockKey.CashflowCal;
        return Lock.tryLock((long)orgId, (long)bookTypeId, (LockKey)lockKey, () -> {
            Throwable throwable;
            TXHandle txh;
            int count = 0;
            ICalculator calculator = CalculatorFactory.createCashflowCalculator();
            do {
                txh = TX.requiresNew();
                throwable = null;
                try {
                    count = calculator.calculate(orgId.longValue(), bookTypeId.longValue());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (txh != null) {
                        if (throwable != null) {
                            try {
                                txh.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            txh.close();
                        }
                    }
                }
            } while (count > 0);
            txh = TX.requiresNew();
            throwable = null;
            try {
                try {
                    if (!periodIds.isEmpty()) {
                        Iterator iterator = periodIds.iterator();
                        while (iterator.hasNext()) {
                            long id = (Long)iterator.next();
                            new CashflowSumCalculator().reCalculate(orgId.longValue(), bookTypeId.longValue(), id);
                        }
                    }
                }
                catch (Exception ex) {
                    txh.markRollback();
                    throw ex;
                }
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (txh != null) {
                    if (throwable != null) {
                        try {
                            txh.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        txh.close();
                    }
                }
            }
        });
    }
}

