/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.cfitem.bdctl.unassign;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.util.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.vo.AssignOrgTreeNode;
import kd.fi.gl.formplugin.cfitem.bdctl.CashFlowItemNumTreeNode;
import kd.fi.gl.formplugin.cfitem.bdctl.unassign.OrgCashFlowItemInfo;

public class UnAssignCtx
implements Serializable {
    private Map<Long, Map<Long, String>> unAssignCheckResMap;
    private Map<Long, Map<String, OrgCashFlowItemInfo>> orgAndDatas;
    private Set<Long> orgIds;
    private Set<Long> dataIds;
    private String ctrlstrategy;
    private Map<Long, String> dataIdNumbers;
    private Map<String, CashFlowItemNumTreeNode> cashFlowItemNumTreeNodeMap;
    private Map<Long, AssignOrgTreeNode> assignOrgTreeNodeMap;

    public UnAssignCtx(Map<Long, Set<Long>> cancelDataMap) {
        this.dataIds = cancelDataMap.keySet();
        this.orgIds = cancelDataMap.entrySet().stream().filter(x -> x.getValue() != null).map(x -> (Set)x.getValue()).flatMap(x -> x.stream()).collect(Collectors.toSet());
        this.dataIdNumbers = new HashMap<Long, String>(this.dataIds.size());
        this.orgAndDatas = new HashMap<Long, Map<String, OrgCashFlowItemInfo>>(16);
        this.unAssignCheckResMap = new HashMap<Long, Map<Long, String>>(16);
        this.init();
    }

    protected void init() {
        this.assignOrgTreeNodeMap = new HashMap<Long, AssignOrgTreeNode>(this.orgIds.size());
        this.cashFlowItemNumTreeNodeMap = new HashMap<String, CashFlowItemNumTreeNode>(this.dataIds.size());
        this.initCtrlstrategy(this.dataIds.iterator().next());
        this.buildOrgNodes();
        this.buildCashFlowItemNumNodes();
        this.buildOrgAndDatas();
    }

    private void initCtrlstrategy(Long dataId) {
        DynamicObject cashFlowItem = BusinessDataServiceHelper.loadSingle((Object)dataId, (String)"gl_cashflowitem");
        this.ctrlstrategy = cashFlowItem.getString("ctrlstrategy");
    }

    private void buildOrgAndDatas() {
        for (Map.Entry<Long, String> dataIdNumbersEntry : this.dataIdNumbers.entrySet()) {
            Long cashFlowItemId = dataIdNumbersEntry.getKey();
            String cashFlowItemNumber = dataIdNumbersEntry.getValue();
            for (Long orgId : this.orgIds) {
                OrgCashFlowItemInfo orgCashFlowItemInfo = new OrgCashFlowItemInfo(orgId, cashFlowItemNumber);
                orgCashFlowItemInfo.getCashFlowItemIds().add(cashFlowItemId);
                this.orgAndDatas.computeIfAbsent(orgId, k -> new HashMap()).put(cashFlowItemNumber, orgCashFlowItemInfo);
            }
        }
    }

    private void buildOrgNodes() {
        block19: {
            block18: {
                if (null == this.orgIds || this.orgIds.size() == 0) {
                    throw new KDBizException(new ErrorCode("common", "%s"), new Object[]{ResManager.loadKDString((String)"\u5206\u914d\u7ec4\u7ec7\u4e3a\u7a7a", (String)"AssignCtx_0", (String)"fi-bd-common", (Object[])new Object[0])});
                }
                if (!"1".equals(this.ctrlstrategy) && !"3".equals(this.ctrlstrategy)) break block18;
                QFilter f2 = new QFilter("view", "=", (Object)10);
                QFilter f3 = new QFilter("org", "in", this.orgIds);
                DataSet dt = QueryServiceHelper.queryDataSet((String)"getUseregParams", (String)"bos_org_structure", (String)"org,parent", (QFilter[])new QFilter[]{f2, f3}, null);
                Iterator<Long> iterator = null;
                try {
                    for (Row row : dt) {
                        Long orgId = row.getLong("org");
                        AssignOrgTreeNode curorgNode = this.assignOrgTreeNodeMap.get(orgId);
                        if (null != curorgNode) continue;
                        curorgNode = new AssignOrgTreeNode(orgId);
                        curorgNode.setParentId(row.getLong("parent"));
                        this.assignOrgTreeNodeMap.put(orgId, curorgNode);
                    }
                }
                catch (Throwable throwable) {
                    iterator = throwable;
                    throw throwable;
                }
                finally {
                    if (dt != null) {
                        if (iterator != null) {
                            try {
                                dt.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)((Object)iterator)).addSuppressed(throwable);
                            }
                        } else {
                            dt.close();
                        }
                    }
                }
                Set<Long> assignOrgIds = this.assignOrgTreeNodeMap.keySet();
                assignOrgIds = new HashSet<Long>(assignOrgIds);
                for (Long assignOrgId : assignOrgIds) {
                    AssignOrgTreeNode curOrgNode = this.assignOrgTreeNodeMap.get(assignOrgId);
                    Long parentOrgId = curOrgNode.getParentId();
                    AssignOrgTreeNode parentOrgNode = this.assignOrgTreeNodeMap.computeIfAbsent(parentOrgId, k -> new AssignOrgTreeNode(k));
                    parentOrgNode.getChildIds().add(assignOrgId);
                }
                for (Long orgId : this.orgIds) {
                    AssignOrgTreeNode curorgNode = this.assignOrgTreeNodeMap.get(orgId);
                    if (null != curorgNode) continue;
                    curorgNode = new AssignOrgTreeNode(orgId);
                    this.assignOrgTreeNodeMap.put(orgId, curorgNode);
                }
                break block19;
            }
            if (!this.ctrlstrategy.equals("2")) break block19;
            for (Long orgId : this.orgIds) {
                AssignOrgTreeNode curorgNode = this.assignOrgTreeNodeMap.get(orgId);
                if (null != curorgNode) continue;
                curorgNode = new AssignOrgTreeNode(orgId);
                this.assignOrgTreeNodeMap.put(orgId, curorgNode);
            }
        }
    }

    private void buildCashFlowItemNumNodes() {
        CashFlowItemNumTreeNode pnode;
        String pnumber;
        CashFlowItemNumTreeNode node;
        String number;
        DynamicObject[] cashFlowItems;
        HashSet<Long> pidSet = new HashSet<Long>(this.dataIds.size());
        for (DynamicObject cashFlowItem : cashFlowItems = BusinessDataServiceHelper.load((Object[])this.dataIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"gl_cashflowitem"))) {
            number = cashFlowItem.getString("number");
            node = this.cashFlowItemNumTreeNodeMap.computeIfAbsent(number, k -> new CashFlowItemNumTreeNode((String)k));
            pnumber = cashFlowItem.getString("parent.number");
            if (StringUtils.isNotEmpty((String)pnumber)) {
                node.setPnumber(pnumber);
                pnode = this.cashFlowItemNumTreeNodeMap.computeIfAbsent(pnumber, k -> new CashFlowItemNumTreeNode((String)k));
                pnode.getChildNumbers().add(number);
            }
            if (cashFlowItem.getLong("parent.id") != 0L) {
                pidSet.add(cashFlowItem.getLong("parent.id"));
            }
            this.dataIdNumbers.put(cashFlowItem.getLong("id"), number);
        }
        if (pidSet.size() > 0) {
            do {
                cashFlowItems = BusinessDataServiceHelper.load((Object[])pidSet.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"gl_cashflowitem"));
                pidSet.clear();
                for (DynamicObject cashFlowItem : cashFlowItems) {
                    number = cashFlowItem.getString("number");
                    if (this.cashFlowItemNumTreeNodeMap.containsKey(number)) continue;
                    this.dataIds.add((Long)cashFlowItem.getPkValue());
                    if (cashFlowItem.getLong("parent.id") != 0L) {
                        pidSet.add(cashFlowItem.getLong("parent.id"));
                    }
                    node = new CashFlowItemNumTreeNode(number);
                    pnumber = cashFlowItem.getString("parent.number");
                    if (StringUtils.isNotEmpty((String)pnumber)) {
                        node.setPnumber(pnumber);
                        pnode = this.cashFlowItemNumTreeNodeMap.computeIfAbsent(pnumber, k -> new CashFlowItemNumTreeNode((String)k));
                        pnode.getChildNumbers().add(pnumber);
                    }
                    this.cashFlowItemNumTreeNodeMap.put(number, node);
                }
            } while (pidSet.size() > 0);
        }
        Set<Map.Entry<String, CashFlowItemNumTreeNode>> entries = this.cashFlowItemNumTreeNodeMap.entrySet();
        for (Map.Entry<String, CashFlowItemNumTreeNode> treeNodeEntry : entries) {
            CashFlowItemNumTreeNode node2 = treeNodeEntry.getValue();
            String pnumber2 = node2.getPnumber();
            if (!StringUtils.isNotEmpty((String)pnumber2)) continue;
            CashFlowItemNumTreeNode parentOrgNode = this.cashFlowItemNumTreeNodeMap.computeIfAbsent(pnumber2, k -> new CashFlowItemNumTreeNode((String)k));
            parentOrgNode.getChildNumbers().add(treeNodeEntry.getKey());
        }
    }

    public Map<Long, Map<String, OrgCashFlowItemInfo>> getOrgAndDatas() {
        return this.orgAndDatas;
    }

    public void setOrgAndDatas(Map<Long, Map<String, OrgCashFlowItemInfo>> orgAndDatas) {
        this.orgAndDatas = orgAndDatas;
    }

    public Set<Long> getOrgIds() {
        return this.orgIds;
    }

    public void setOrgIds(Set<Long> orgIds) {
        this.orgIds = orgIds;
    }

    public Set<Long> getDataIds() {
        return this.dataIds;
    }

    public void setDataIds(Set<Long> dataIds) {
        this.dataIds = dataIds;
    }

    public Map<Long, AssignOrgTreeNode> getAssignOrgTreeNodeMap() {
        return this.assignOrgTreeNodeMap;
    }

    public void setAssignOrgTreeNodeMap(Map<Long, AssignOrgTreeNode> assignOrgTreeNodeMap) {
        this.assignOrgTreeNodeMap = assignOrgTreeNodeMap;
    }

    public Map<String, CashFlowItemNumTreeNode> getAssignAcctountNumTreeNodeMap() {
        return this.cashFlowItemNumTreeNodeMap;
    }

    public void setAssignAcctountNumTreeNodeMap(Map<String, CashFlowItemNumTreeNode> cashFlowItemNumTreeNodeMap) {
        this.cashFlowItemNumTreeNodeMap = cashFlowItemNumTreeNodeMap;
    }

    public String getCtrlstrategy() {
        return this.ctrlstrategy;
    }

    public void setCtrlstrategy(String ctrlstrategy) {
        this.ctrlstrategy = ctrlstrategy;
    }

    public Map<Long, Map<Long, String>> getUnAssignCheckResMap() {
        return this.unAssignCheckResMap;
    }

    public void setUnAssignCheckResMap(Map<Long, Map<Long, String>> unAssignCheckResMap) {
        this.unAssignCheckResMap = unAssignCheckResMap;
    }

    public Map<Long, String> getDataIdNumbers() {
        return this.dataIdNumbers;
    }

    public void setDataIdNumbers(Map<Long, String> dataIdNumbers) {
        this.dataIdNumbers = dataIdNumbers;
    }
}

