/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.comassist;

import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.ControlFilter;
import kd.bos.entity.filter.FilterKeyValueCollections;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.exception.KDBizException;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.filter.FilterGridView;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterQueryOfExportEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.util.ReflectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.bd.util.DebugTrace;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.comassist.model.ComAssistTable;
import kd.fi.gl.comassist.service.ComAssistTableService;
import kd.fi.gl.constant.FieldConfig;
import kd.fi.gl.enums.ControlVisible;
import kd.fi.gl.formplugin.comassist.ComAssistListDataProvider;
import kd.fi.gl.formplugin.comassist.cache.ICommonAssistListCache;
import kd.fi.gl.formplugin.comassist.cache.impl.CommonAssistListPageCache;
import kd.fi.gl.util.CommonAssistUtil;
import kd.fi.gl.util.GlFormUtil;
import kd.fi.gl.util.PermissonType;

public class CommonAssistListPlugin
extends AbstractListPlugin {
    private static final Log logger = LogFactory.getLog(CommonAssistListPlugin.class);
    private static final String FIRST_COMING = "firstComing";
    private ICommonAssistListCache listCache;

    private MainEntityType getNewBillEntityType(FilterValueMode mode) {
        return (MainEntityType)ThreadCache.get((Object)(((Object)((Object)this)).getClass().getName() + ".getNewBillEntityType" + (Object)((Object)mode)), () -> {
            MainEntityType newBillEntityType = MetadataServiceHelper.getDataEntityType((String)this.getBillEntity());
            Optional<ComAssistTable> commonAssistTable = this.getCommonAssistTable(mode);
            if (commonAssistTable.isPresent()) {
                newBillEntityType = (MainEntityType)ComAssistTableService.modifyEntityType((ComAssistTable)commonAssistTable.get(), (EntityType)newBillEntityType);
            }
            return newBillEntityType;
        });
    }

    protected ICommonAssistListCache getListCache() {
        if (this.listCache == null) {
            this.listCache = new CommonAssistListPageCache(this.getPageCache());
        }
        return this.listCache;
    }

    private boolean isCommonSearch(FilterContainer filterContainer) {
        Field isCommonSearchField = ReflectionUtils.findField(FilterContainer.class, (String)"isCommonSearch");
        ReflectionUtils.makeAccessible((Field)isCommonSearchField);
        return (Boolean)ReflectionUtils.getField((Field)isCommonSearchField, (Object)filterContainer);
    }

    public void initialize() {
        super.initialize();
        FilterContainer filterContainer = (FilterContainer)this.getView().getControl("filtercontainerap");
        filterContainer.addFilterContainerInitListener(evt -> {
            FilterValueMode mode;
            FilterKeyValueCollections otherFilterValues = filterContainer.getCachedFilterValues().getOtherFilterValues();
            boolean schemeFilter = otherFilterValues != null && "schemefilter".equals(otherFilterValues.getFilterKey());
            Map controlFiltersMap = filterContainer.getContext().getControlFiltersMap();
            List commonFilterColumns = evt.getCommonFilterColumns();
            if (!(schemeFilter || commonFilterColumns.isEmpty() || controlFiltersMap.isEmpty())) {
                for (FilterColumn commonFilterColumn : commonFilterColumns) {
                    String filterFieldName = commonFilterColumn.getFilterFieldName();
                    if (filterFieldName.startsWith(this.getOrgKey()) && controlFiltersMap.containsKey(filterFieldName)) {
                        this.getListCache().setCommonSearchOrgIds(CommonAssistUtil.getIdsInControlFilter((IFormView)this.getView(), (String)this.getOrgKey(), (String)"bos_org", (ControlFilter)((ControlFilter)controlFiltersMap.get(filterFieldName))));
                    }
                    if (!filterFieldName.startsWith(this.getBookTypeKey()) || !controlFiltersMap.containsKey(filterFieldName)) continue;
                    this.getListCache().setCommonSearchBookTypeIds(CommonAssistUtil.getIdsInControlFilter((IFormView)this.getView(), (String)this.getBookTypeKey(), (String)"bd_accountbookstype", (ControlFilter)((ControlFilter)controlFiltersMap.get(filterFieldName))));
                }
            }
            if ((mode = schemeFilter ? (this.isCommonSearch(filterContainer) ? FilterValueMode.COMMON_SEARCH_CACHE : FilterValueMode.DEFAULT) : FilterValueMode.COMMON_SEARCH_CACHE) == FilterValueMode.COMMON_SEARCH_CACHE) {
                filterContainer.setEntityType(this.getNewBillEntityType(mode));
                this.getCommonAssistTable(mode).ifPresent(commonAssistTable -> evt.getCommonFilterColumns().addAll(ComAssistTableService.getCommonFilterColumns((ComAssistTable)commonAssistTable, (ListView)((ListView)this.getView()))));
            }
        });
        filterContainer.addSwitchModeListener(evt -> {
            filterContainer.setEntityType(this.getNewBillEntityType(FilterValueMode.DEFAULT));
            this.getCommonAssistTable(FilterValueMode.DEFAULT).ifPresent(commonAssistTable -> filterContainer.getItems().stream().filter(FilterGridView.class::isInstance).map(FilterGridView.class::cast).forEach(filterGrid -> {
                List filterColumns = filterGrid.getFilterColumns();
                filterColumns.removeIf(filterColumn -> filterColumn.getFieldName().contains("comassist"));
                filterColumns.addAll(ComAssistTableService.getCommonFilterColumns((ComAssistTable)commonAssistTable, (ListView)((ListView)this.getView())));
            }));
        });
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Optional<ComAssistTable> commonAssistTable = this.getCommonAssistTable();
        if (e.getSource() instanceof BillList) {
            ((BillList)e.getSource()).getShowListColumns().forEach(column -> {
                String columnKey = column.getListFieldKey();
                if (columnKey.contains("comassist")) {
                    int visible = commonAssistTable.isPresent() && ((ComAssistTable)commonAssistTable.get()).getCommonAssist(columnKey.split("\\.")[0]).isPresent() ? ControlVisible.show.value : ControlVisible.hide.value;
                    Optional<Map> userConfigColumnSettings = Optional.ofNullable(column.getUserConfigColumnSettings());
                    if (visible == ControlVisible.show.value) {
                        userConfigColumnSettings.ifPresent(config -> config.putIfAbsent("visible", ControlVisible.show.value));
                    } else {
                        userConfigColumnSettings.ifPresent(config -> config.put("visible", ControlVisible.hide.value));
                    }
                }
            });
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        if (args.getListDataProvider() == null) {
            args.setListDataProvider((IListDataProvider)new ComAssistListDataProvider(this.getView()));
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        if (DebugTrace.enable()) {
            logger.info("CommonAssistListPlugin beforeCreateListColumns args : " + args.getListColumns().toString());
        }
        ComAssistTableService.modifyListColumn((ComAssistTable)this.getCommonAssistTable().orElse(null), (List)args.getListColumns());
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        this.getPageCache().put(FIRST_COMING, "false");
    }

    public void filterContainerAfterSearchClick(FilterContainerSearchClickArgs args) {
        List<Long> bookTypeIds;
        List<Long> orgIds = this.getOrgID();
        if (!CommonAssistUtil.isSameCommonAssist(new HashSet<Long>(orgIds), new HashSet<Long>(bookTypeIds = this.getBookTypeID(orgIds)))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u7ec4\u7ec7\u53ca\u8d26\u7c3f\u5bf9\u5e94\u79d1\u76ee\u8868\u7684\u516c\u5171\u7ef4\u5ea6\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u7b5b\u9009\u3002", (String)"TransPLProgramsList_2", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        }
    }

    protected Optional<ComAssistTable> getCommonAssistTable(FilterValueMode mode) {
        return (Optional)ThreadCache.get((Object)(((Object)((Object)this)).getClass().getName() + ".getCommonAssistTable_" + (Object)((Object)mode)), () -> {
            List<Long> orgIdList = this.getOrgID(mode);
            List<Long> bookTypeIdList = this.getBookTypeID(orgIdList, mode);
            return ComAssistTable.tryGetMaxComAssist(new HashSet<Long>(orgIdList), new HashSet<Long>(bookTypeIdList));
        }, (boolean)true);
    }

    protected Optional<ComAssistTable> getCommonAssistTable() {
        return this.getCommonAssistTable(FilterValueMode.DEFAULT);
    }

    protected String getBillEntity() {
        return ((ListView)this.getView()).getListModel().getEntityId();
    }

    public String getOrgKey() {
        return (String)FieldConfig.getOrgAndBookTypeFieldKey((String)this.getBillEntity()).item1;
    }

    public String getBookTypeKey() {
        return (String)FieldConfig.getOrgAndBookTypeFieldKey((String)this.getBillEntity()).item2;
    }

    protected Long getDefaultOrgID() {
        long defaultOrg = Long.parseLong(Optional.ofNullable(this.getPageCache().get("initorg")).orElse("0"));
        if (defaultOrg == 0L) {
            List orgList = AccSysUtil.getAcctOrgPkList((String)this.getBillEntity(), (boolean)false, (PermissonType)PermissonType.VIEW);
            defaultOrg = Optional.ofNullable(GlFormUtil.getDefaultAcctOrg(orgList)).orElse(0L);
            this.getPageCache().put("initorg", String.valueOf(defaultOrg));
        }
        return defaultOrg;
    }

    protected Long getDefaultBookTypeID() {
        long defaultOrg = Long.parseLong(Optional.ofNullable(this.getPageCache().get("initbt")).orElse("0"));
        if (this.getPageCache().get(FIRST_COMING) == null && defaultOrg == 0L) {
            defaultOrg = AccSysUtil.getBookTypeComboByOrg((long)this.getDefaultOrgID()).stream().mapToLong(item -> Long.parseLong(item.getValue())).findFirst().orElse(0L);
            this.getPageCache().put("initbt", String.valueOf(defaultOrg));
        }
        return defaultOrg;
    }

    protected List<Long> getOrgID() {
        List filterValues = CommonAssistUtil.getOrgCommonFilterColumnValues((IFormView)this.getView(), (String)this.getOrgKey());
        if (CollectionUtils.isEmpty((Collection)filterValues) && "false".equals(this.getPageCache().get(FIRST_COMING))) {
            filterValues = AccSysUtil.getAcctOrgPkList((String)this.getBillEntity(), (boolean)Boolean.FALSE, (PermissonType)PermissonType.VIEW);
        }
        List orgIds = CollectionUtils.isEmpty((Collection)filterValues) ? Collections.singletonList(this.getDefaultOrgID()) : filterValues;
        this.getView().getPageCache().put("alluseorg", JSONObject.toJSONString(orgIds));
        return orgIds;
    }

    protected List<Long> getOrgID(FilterValueMode mode) {
        List<Long> orgIds;
        if (mode == FilterValueMode.COMMON_SEARCH_CACHE) {
            orgIds = this.getListCache().getCommonSearchOrgIds();
            if (orgIds != null) {
                this.getView().getPageCache().put("alluseorg", JSONObject.toJSONString(orgIds));
            } else {
                orgIds = this.getOrgID();
                this.getListCache().setCommonSearchOrgIds(orgIds);
            }
        } else {
            orgIds = this.getOrgID();
        }
        return orgIds;
    }

    protected List<Long> getBookTypeID(List<Long> orgIdList) {
        if ("gl_voucher_ref".equals(this.getBillEntity())) {
            return Collections.singletonList(AccSysUtil.getMainBookTypeId());
        }
        List filterValues = CommonAssistUtil.getBookTypeCommonFilterColumnValues((IFormView)this.getView(), (String)this.getBookTypeKey());
        if (CollectionUtils.isEmpty((Collection)filterValues) && "false".equals(this.getPageCache().get(FIRST_COMING))) {
            filterValues = AccSysUtil.getBookTypeDataPermission(orgIdList);
        }
        return CollectionUtils.isEmpty((Collection)filterValues) ? Collections.singletonList(this.getDefaultBookTypeID()) : filterValues;
    }

    protected List<Long> getBookTypeID(List<Long> orgIdList, FilterValueMode mode) {
        List<Long> bookTypeIds;
        if (mode == FilterValueMode.COMMON_SEARCH_CACHE) {
            bookTypeIds = this.getListCache().getCommonSearchBookTypeIds();
            if (bookTypeIds == null) {
                bookTypeIds = this.getBookTypeID(orgIdList);
                this.getListCache().setCommonSearchBookTypeIds(bookTypeIds);
            }
        } else {
            bookTypeIds = this.getBookTypeID(orgIdList);
        }
        return bookTypeIds;
    }

    public void afterQueryOfExport(AfterQueryOfExportEvent e) {
        if (CommonAssistUtil.isCommonAssistEnabled()) {
            CommonAssistUtil.loadReference(Arrays.asList(e.getQueryValues()));
        }
    }

    private static enum FilterValueMode {
        COMMON_SEARCH_CACHE,
        DEFAULT;

    }
}

