/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.finalprocess;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.util.QFBuilder;

public class AutoTransEditHelper {
    public static Set<String> analyzeAccountAssgrp(DynamicObjectCollection coll) {
        HashSet<Long> outAcctIds = new HashSet<Long>();
        HashSet<Long> inAcctIds = new HashSet<Long>();
        for (DynamicObject row : coll) {
            long accountId = row.getLong("accountid_id");
            int rowDataType = row.getInt("datasourcetype");
            if (5 == rowDataType || 4 == rowDataType || 3 == rowDataType || 2 == rowDataType) {
                outAcctIds.add(accountId);
                continue;
            }
            inAcctIds.add(accountId);
        }
        HashSet<String> transInFlexField = new HashSet<String>();
        HashSet<String> transOutFlexField = new HashSet<String>();
        HashSet<Long> tempAccIds = new HashSet<Long>(outAcctIds);
        tempAccIds.addAll(inAcctIds);
        QFilter fid = new QFilter("id", "in", tempAccIds);
        DataSet acctSet = QueryServiceHelper.queryDataSet((String)"getAccountAssist", (String)"bd_accountview", (String)"checkitementry.asstactitem.flexfield flexfield, id", (QFilter[])new QFilter[]{fid}, null);
        Object object = null;
        try {
            for (Row row : acctSet) {
                String flexField = row.getString("flexfield");
                if (flexField == null) continue;
                long acctId = row.getLong("id");
                if (outAcctIds.contains(acctId)) {
                    transOutFlexField.add(flexField);
                    continue;
                }
                transInFlexField.add(flexField);
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (acctSet != null) {
                if (object != null) {
                    try {
                        acctSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    acctSet.close();
                }
            }
        }
        HashSet<String> notIncludeFlexField = new HashSet<String>();
        for (String flexField : transInFlexField) {
            if (transOutFlexField.contains(flexField)) continue;
            notIncludeFlexField.add(flexField);
        }
        return notIncludeFlexField;
    }

    public static boolean canSetAssgrp(DynamicObject accountDyn, String assgrpType, String dsType, Set<String> notIncludeFlexField) {
        boolean isAssist;
        boolean bl = isAssist = accountDyn != null && accountDyn.getBoolean("isassist");
        if (isAssist) {
            if ("2".equals(assgrpType)) {
                return true;
            }
            int dataTypeInt = Integer.parseInt(dsType);
            return 6 == dataTypeInt && !notIncludeFlexField.isEmpty() || 1 == dataTypeInt;
        }
        return false;
    }

    public static QFBuilder getCurFilterByAcc(DynamicObject accountDyn, AccountBookInfo bookInfo) {
        QFBuilder qfBuilder = new QFBuilder();
        if (accountDyn != null && bookInfo != null) {
            ArrayList<Long> ids = new ArrayList<Long>();
            switch (accountDyn.getString("acctcurrency")) {
                case "nocurrency": {
                    qfBuilder.add(new QFilter("id", "=", (Object)bookInfo.getBaseCurrencyId()));
                    break;
                }
                case "descurrency": {
                    DynamicObjectCollection coll = (DynamicObjectCollection)accountDyn.get("currencyentry");
                    for (DynamicObject dyn : coll) {
                        Long acctCur = dyn.getLong("currency_id");
                        ids.add(acctCur);
                    }
                    ids.add(bookInfo.getBaseCurrencyId());
                    qfBuilder.add(new QFilter("id", "in", ids));
                    break;
                }
            }
        }
        return qfBuilder;
    }
}

