/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.finalprocess.breakpoint;

import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.schedule.api.TaskInfo;

public class TaskResult {
    protected static final String KEY_OPTION = "option";
    protected static final String KEY_RESULT = "result";
    protected static final String KEY_CUSTOM = "custom";
    private final OperationResult operationResult;
    private final OperateOption operateOption;
    private final Map<String, Object> customParam;

    public static TaskResult fromClosedCallBackEvent(ClosedCallBackEvent event) {
        Object returnData = event.getReturnData();
        Map customData = Optional.ofNullable(returnData).map(data -> (Map)data).map(data -> (TaskInfo)SerializationUtils.fromJsonString((String)((String)data.get("taskinfo")), TaskInfo.class)).map(info -> (Map)SerializationUtils.fromJsonString((String)info.getData(), Map.class)).orElseThrow(() -> new KDBizException("parse customData error:" + returnData));
        OperationResult operationResult = Optional.of(customData).map(data -> SerializationUtils.toJsonString(data.get(KEY_RESULT))).map(resultStr -> (OperationResult)SerializationUtils.fromJsonString((String)resultStr, OperationResult.class)).orElseThrow(() -> new KDBizException("parse operationResult error:" + customData));
        Map variablesMap = Optional.of(customData).map(data -> SerializationUtils.toJsonString(data.get(KEY_OPTION))).map(optionStr -> (Map)SerializationUtils.fromJsonString((String)optionStr, Map.class)).map(optionMap -> (Map)optionMap.get("variables")).orElseThrow(() -> new KDBizException("parse variablesMap error:" + customData));
        Map customMap = Optional.of(customData).map(data -> SerializationUtils.toJsonString(data.get(KEY_CUSTOM))).map(optionStr -> (Map)SerializationUtils.fromJsonString((String)optionStr, Map.class)).orElseThrow(() -> new KDBizException("parse variablesMap error:" + customData));
        OperateOption operateOption = OperateOption.create();
        variablesMap.forEach((arg_0, arg_1) -> ((OperateOption)operateOption).setVariableValue(arg_0, arg_1));
        return new TaskResult(operationResult, operateOption, customMap);
    }

    private TaskResult(OperationResult operationResult, OperateOption operateOption, Map<String, Object> customParam) {
        this.operationResult = operationResult;
        this.operateOption = operateOption;
        this.customParam = customParam;
    }

    public OperationResult getOperationResult() {
        return this.operationResult;
    }

    public OperateOption getOperateOption() {
        return this.operateOption;
    }

    public Map<String, Object> getCustomParam() {
        return this.customParam;
    }
}

