/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.multilingual;

import com.google.common.base.Joiner;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.gl.cache.CacheHelper;
import kd.fi.gl.exception.BOSException;
import kd.fi.gl.formplugin.multilingual.MultilingualResultBean;
import kd.fi.gl.formplugin.multilingual.MultilingualTypeEnum;
import kd.fi.gl.util.FormExportUtil;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class MultilingualRepairPlugin
extends AbstractFormPlugin
implements UploadListener {
    private static Log log = LogFactory.getLog(MultilingualRepairPlugin.class);
    private static final String Key_FileName = "filename";
    private static final String Key_FilePanel = "filepanel";
    private static final String IMPORTDATA = "importdata";
    private static final String OUTPUTDATA = "outputdata";
    private static final String BACHUPDATA = "backupdata";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        AttachmentPanel filePanel = (AttachmentPanel)this.getControl(Key_FilePanel);
        filePanel.addUploadListener((UploadListener)this);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        String type = (String)this.getModel().getValue("type");
        if (kd.bos.util.StringUtils.isEmpty((String)type)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u591a\u8bed\u8a00\u7c7b\u578b\u3002", (String)"AccMultilingualPlugin_6", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        }
        String fileName = MultilingualTypeEnum.getFileNameByType(type);
        MultilingualRepairPlugin clazz = (MultilingualRepairPlugin)((Object)MultilingualTypeEnum.getMultilingualTypeClassByType(type));
        if (OUTPUTDATA.equals(key)) {
            DynamicObjectCollection orgCol = (DynamicObjectCollection)this.getModel().getValue("org");
            long accoutTable = (Long)this.getModel().getValue("accounttable_id");
            ArrayList<Long> orgs = new ArrayList<Long>(orgCol.size());
            for (DynamicObject org : orgCol) {
                orgs.add(org.getDynamicObject("fbasedataid").getLong("id"));
            }
            String filter = "";
            if (!orgs.isEmpty() && accoutTable != 0L) {
                filter = "forg in (" + Joiner.on((String)",").join(orgs) + ") and faccounttable = " + accoutTable;
            }
            MultilingualResultBean resultBean = clazz.getOutputData(filter);
            String url = this.outputData(fileName, resultBean.getHeadNameList(), resultBean.getDataMap(), resultBean.getLocaleList());
            FormExportUtil util = new FormExportUtil();
            util.openUrl(url, this.getView());
        } else if (BACHUPDATA.equals(key)) {
            String table = MultilingualTypeEnum.getTableByType(type);
            String copyTable = table + "_copy";
            List columns = DB.getColumnNames((DBRoute)DBRoute.of((String)"gl"), (String)table);
            String copeDataSql = String.format("insert into %s select %s from %s", copyTable, Joiner.on((String)",").join((Iterable)columns), table);
            DB.execute((DBRoute)DBRoute.of((String)"gl"), (String)String.format("truncate table %s", copyTable));
            DB.execute((DBRoute)DBRoute.of((String)"gl"), (String)copeDataSql);
        }
    }

    public void afterUpload(UploadEvent evt) {
        List<String> uploadFileUrls = this.getUploadFileUrls(evt);
        String fieldValue = (String)this.getModel().getValue(Key_FileName);
        String[] fieldValues = new String[]{};
        if (StringUtils.isNotBlank((CharSequence)fieldValue)) {
            fieldValues = StringUtils.split((String)fieldValue, (String)";");
        }
        HashSet<String> fileUrls = new HashSet<String>(uploadFileUrls.size() + fieldValues.length);
        for (String fileUrl : uploadFileUrls) {
            fileUrls.add(fileUrl);
        }
        for (String fileUrl : fieldValues) {
            fileUrls.add(fileUrl);
        }
        fieldValue = StringUtils.join((Object[])fileUrls.toArray(), (String)";");
        this.getModel().setValue(Key_FileName, (Object)fieldValue);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operateInfo = (FormOperate)args.getSource();
        String key = operateInfo.getOperateKey();
        if (IMPORTDATA.equals(key)) {
            String type = (String)this.getModel().getValue("type");
            if (kd.bos.util.StringUtils.isEmpty((String)type)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u591a\u8bed\u8a00\u7c7b\u578b\u3002", (String)"AccMultilingualPlugin_6", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            }
            MultilingualRepairPlugin clazz = (MultilingualRepairPlugin)((Object)MultilingualTypeEnum.getMultilingualTypeClassByType(type));
            String fileNames = (String)this.getModel().getValue(Key_FileName);
            clazz.doImport(fileNames);
        }
    }

    private List<String> getUploadFileUrls(UploadEvent evt) {
        ArrayList<String> fileUrls = new ArrayList<String>(evt.getUrls().length);
        for (Object url : evt.getUrls()) {
            fileUrls.add((String)((Map)url).get("url"));
        }
        return fileUrls;
    }

    protected MultilingualResultBean getOutputData(String filter) {
        return null;
    }

    protected void doImport(String fileNames) {
    }

    private String outputData(String fileName, List<String> headNameList, Map<List<String>, Map<String, List<String>>> dataMap, List<String> localeList) {
        ArrayList<String> headList = new ArrayList<String>(headNameList.size());
        for (String name : headNameList) {
            headList.add(name);
        }
        ArrayList<List<String>> rowDatas = new ArrayList<List<String>>(dataMap.size());
        for (Map.Entry<List<String>, Map<String, List<String>>> entry : dataMap.entrySet()) {
            ArrayList<String> dataList = new ArrayList<String>(headNameList.size());
            dataList.addAll(entry.getKey());
            Map<String, List<String>> value = entry.getValue();
            for (String localId : localeList) {
                if (value.containsKey(localId)) {
                    dataList.addAll(value.get(localId));
                    continue;
                }
                dataList.add("");
                dataList.add("");
            }
            rowDatas.add(dataList);
        }
        return this.export(headList, rowDatas, fileName);
    }

    private String export(List<String> header, List<List<String>> rowDatas, String fileName) {
        XSSFWorkbook wb = new XSSFWorkbook();
        XSSFSheet sheet = wb.createSheet();
        XSSFCellStyle style = wb.createCellStyle();
        style.setAlignment(HorizontalAlignment.CENTER);
        int index = 0;
        index = this.setHeader(header, sheet, index, style);
        index = this.setRowData(rowDatas, sheet, index, style);
        try {
            return this.writeFile(wb, fileName, ".xlsx");
        }
        catch (IOException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private int setHeader(List<String> header, XSSFSheet sheet, int index, XSSFCellStyle style) {
        XSSFRow headerRow = sheet.createRow(index);
        for (int i = 0; i < header.size(); ++i) {
            XSSFCell cell = headerRow.createCell(i);
            cell.setCellValue(header.get(i));
            cell.setCellStyle((CellStyle)style);
        }
        return ++index;
    }

    private int setRowData(List<List<String>> rowDatas, XSSFSheet sheet, int index, XSSFCellStyle style) {
        for (List<String> rowData : rowDatas) {
            XSSFRow row = sheet.createRow(index);
            for (int i = 0; i < rowData.size(); ++i) {
                XSSFCell cell = row.createCell(i);
                cell.setCellValue(rowData.get(i));
                cell.setCellStyle((CellStyle)style);
            }
            ++index;
        }
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String writeFile(XSSFWorkbook wb, String formName, String fileType) throws IOException {
        ByteArrayOutputStream outStream = null;
        ByteArrayInputStream inStream = null;
        try {
            outStream = new ByteArrayOutputStream();
            wb.write((OutputStream)outStream);
            outStream.flush();
            inStream = new ByteArrayInputStream(outStream.toByteArray());
            String string = CacheHelper.getTempFileCache().saveAsUrl(this.getTempFilename(formName, fileType), (InputStream)inStream, 10000);
            return string;
        }
        finally {
            if (outStream != null) {
                outStream.close();
            }
            if (inStream != null) {
                inStream.close();
            }
        }
    }

    private String getTempFilename(String formName, String fileType) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("MMdd");
        String currDateTime = dateFormat.format(new Date());
        return formName + "_" + currDateTime + fileType;
    }

    public static class Local {
        private String localId;
        private int nameIndex;
        private int fullNameIndex;

        public String getLocalId() {
            return this.localId;
        }

        public void setLocalId(String localId) {
            this.localId = localId;
        }

        public int getNameIndex() {
            return this.nameIndex;
        }

        public void setNameIndex(int nameIndex) {
            this.nameIndex = nameIndex;
        }

        public int getFullNameIndex() {
            return this.fullNameIndex;
        }

        public void setFullNameIndex(int fullNameIndex) {
            this.fullNameIndex = fullNameIndex;
        }
    }
}

