/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.voucher;

import com.google.common.collect.ImmutableMap;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.report.FilterInfo;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.ext.fi.util.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.mutex.DataMutex;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.form.FormView;
import kd.bos.mvc.report.ReportView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.bd.service.balance.AppHelper;
import kd.fi.bd.util.FlexUtils;
import kd.fi.gl.balancecarryover.BalanceCarryOverContext;
import kd.fi.gl.common.VoucherInfo;
import kd.fi.gl.constant.EntityName;
import kd.fi.gl.constant.GLField;
import kd.fi.gl.enums.basedata.AssistValueType;
import kd.fi.gl.exception.GLErrorCode;
import kd.fi.gl.exception.GLException;
import kd.fi.gl.util.BaseDataUtil;
import kd.fi.gl.util.MetaUtils;
import kd.fi.gl.util.OrgFilterUtils;
import kd.fi.gl.util.QFBuilder;
import kd.fi.gl.voucher.carryover.genentry.EntryGeneratorFactory;
import kd.fi.gl.voucher.carryover.genentry.EntryGeneratorType;
import kd.fi.gl.voucher.carryover.utils.BalanceCarryOverUtils;
import kd.fi.gl.voucher.carryover.utils.CarryOverCacheManager;

public class BalanceCarryOverFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(BalanceCarryOverFormPlugin.class);
    private static final String OK = "ok";
    private static final String ASSIST_PANEL = "assistpanel";
    private static final String PARAM_KEY = "contexts";
    private static final String FLEX_KEY = "flexs";
    private static final String DESCRIPTION = "description";
    private static final String VOUCHERY_TYPE = "vouchertype";
    private static final String DUPLICATE_CALLBACK = "duplicate";

    public void registerListener(EventObject e) {
        String[] split;
        for (String s : split = this.getPageCache().get(FLEX_KEY).split(",")) {
            if (!(this.getControl(s) instanceof BasedataEdit)) continue;
            BasedataEdit control = (BasedataEdit)this.getControl(s);
            control.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        this.calInfoToCache((EventObject)e);
        this.setFormSizeByFlexCount(e);
        FlexPanelAp dynamicPanel = this.createPanel((EventObject)e);
        HashMap<String, String> mapHead = new HashMap<String, String>(4);
        mapHead.put("id", ASSIST_PANEL);
        mapHead.put("items", (String)dynamicPanel.createControl().get("items"));
        e.getItems().add(mapHead);
    }

    private void setFormSizeByFlexCount(LoadCustomControlMetasArgs e) {
        int column;
        int row;
        String flexs = this.getPageCache((EventObject)e).get(FLEX_KEY);
        int count = 2 + (StringUtils.isEmpty((String)flexs) ? 0 : flexs.split(",").length);
        if (count >= 15) {
            row = 5;
            column = 3;
        } else {
            column = (int)Math.ceil((float)count / 5.0f);
            row = (int)Math.ceil((float)count / (float)column);
        }
        LocaleString caption = ((FormShowParameter)e.getSource()).getFormConfig().getCaption();
        if (caption != null && StringUtils.isNotEmpty((String)caption.getLocaleValue())) {
            column = Math.max(column, (int)Math.ceil((float)caption.getLocaleValue().getBytes(StandardCharsets.UTF_8).length / 25.0f));
        }
        e.setFormWidth(String.valueOf(column * 280));
        e.setFormHeight(String.valueOf(50 + 82 * row));
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FlexPanelAp dynamicPanel = this.createPanel(e);
        Container myPanel = (Container)this.getView().getControl(ASSIST_PANEL);
        myPanel.getItems().addAll(((Container)dynamicPanel.buildRuntimeControl()).getItems());
        this.getView().createControlIndex(myPanel.getItems());
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType newMainType;
        super.getEntityType(e);
        MainEntityType oldMainType = e.getOriginalEntityType();
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            throw new KDException((Throwable)ex, BosErrorCode.systemError, new Object[0]);
        }
        this.registerDynamicProps(newMainType);
        e.setNewEntityType(newMainType);
    }

    public void onGetControl(OnGetControlArgs e) {
        String key;
        switch (key = e.getKey()) {
            case "vouchertype": {
                e.setControl(MetaUtils.createControl(BasedataEdit.class, (String)key, (IFormView)this.getView()));
                break;
            }
            case "description": {
                e.setControl(MetaUtils.createControl(TextEdit.class, (String)key, (IFormView)this.getView()));
                break;
            }
            default: {
                if (StringUtils.isEmpty((String)this.getPageCache((EventObject)e).get(key))) break;
                int length = this.getPageCache((EventObject)e).get(key).split(",").length;
                if (length >= 3) {
                    e.setControl(MetaUtils.createControl(BasedataEdit.class, (String)key, (IFormView)this.getView()));
                    break;
                }
                if (length != 1) break;
                e.setControl(MetaUtils.createControl(TextEdit.class, (String)key, (IFormView)this.getView()));
            }
        }
    }

    private void registerDynamicProps(MainEntityType newMainType) {
        this.registerFixedProps(newMainType);
        String flexs = this.getPageCache().get(FLEX_KEY);
        if (StringUtils.isEmpty((String)flexs)) {
            return;
        }
        Stream.of(flexs.split(",")).forEach(flex -> {
            String[] flexInfos = this.getPageCache().get(flex).split(",");
            if (flexInfos.length >= 3) {
                MetaUtils.registerBaseDataProp((MainEntityType)newMainType, (String)flex, (String)flexInfos[1], (String)"org");
            } else {
                MetaUtils.registerTextProp((MainEntityType)newMainType, (String)flex);
            }
        });
    }

    private void registerFixedProps(MainEntityType newMainType) {
        MetaUtils.registerBaseDataProp((MainEntityType)newMainType, (String)VOUCHERY_TYPE, (String)"gl_vouchertype", (String)"org");
        MetaUtils.registerTextProp((MainEntityType)newMainType, (String)DESCRIPTION);
    }

    private void calInfoToCache(EventObject e) {
        List contexts = (List)this.getFowmShowParameter(e).getCustomParam(PARAM_KEY);
        String flexs = contexts.stream().map(BalanceCarryOverContext::getAssistDifferentMsg).flatMap(diff -> Stream.of(diff.getAddMustInputAssists(), diff.getTreeBaseAddLeaf())).flatMap(Collection::stream).distinct().collect(Collectors.joining(","));
        this.getPageCache(e).put(FLEX_KEY, flexs);
        if (StringUtils.isEmpty((String)flexs)) {
            return;
        }
        ArrayList<String> checkDetailFlexs = new ArrayList<String>(contexts.size() * 2);
        Map flex2Property = FlexUtils.batchGetFlexProperty((String[])flexs.split(","));
        flex2Property.forEach((flexField, flexProperty) -> {
            switch (AssistValueType.getTypeEnum((String)flexProperty.getValueType())) {
                case baseData: {
                    String valueSource = flexProperty.getValueSource();
                    if (EntityName.isDetailEntity((String)valueSource)) {
                        checkDetailFlexs.add((String)flexField);
                    }
                    this.getPageCache(e).put(flexField, String.join((CharSequence)",", flexProperty.getName().toString(), valueSource, "false"));
                    break;
                }
                case assistData: {
                    checkDetailFlexs.add((String)flexField);
                    this.getPageCache(e).put(flexField, String.join((CharSequence)",", flexProperty.getName().toString(), "bos_assistantdata_detail", "false", flexProperty.getAssistantType()));
                    break;
                }
                default: {
                    this.getPageCache(e).put(flexField, flexProperty.getName().toString());
                }
            }
        });
        this.rePutAssistCache(contexts, checkDetailFlexs, e);
    }

    private void rePutAssistCache(List<BalanceCarryOverContext> contexts, List<String> checkDetailFlexs, EventObject e) {
        contexts.forEach(context -> {
            Set mustAssists = context.getAssistDifferentMsg().getAddMustInputAssists();
            Set treeAssists = context.getAssistDifferentMsg().getTreeBaseAddLeaf();
            List checkFlexs = Stream.of(mustAssists, treeAssists).flatMap(Collection::stream).filter(checkDetailFlexs::contains).collect(Collectors.toList());
            if (checkFlexs.isEmpty()) {
                return;
            }
            DynamicObject curAccountDyn = BalanceCarryOverUtils.getReplaceAccount((Long)context.getOrgId(), (Long)context.getAccountMasterId(), (Long)context.getSearchPeriodId());
            curAccountDyn.getDynamicObjectCollection("checkitementry").stream().filter(row -> checkDetailFlexs.contains(row.getString("asstactitem.flexfield")) && row.getBoolean("isdetail")).forEach(row -> {
                String flex = row.getString("asstactitem.flexfield");
                this.getPageCache(e).put(flex, this.getPageCache(e).get(flex).replace(",false", ",true"));
            });
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterDoOperation(AfterDoOperationEventArgs e) {
        if (OK.equals(e.getOperateKey())) {
            DataMutex dataMutex = DataMutex.create();
            boolean require = dataMutex.require(this.getModel().getValue(GLField.id_((String)"org")).toString(), "genvch", "gl_genvch_carryover", "genvch", true);
            if (!require) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u540c\u4e00\u65f6\u523b\u5176\u4ed6\u7528\u6237\u4e5f\u5728\u751f\u6210\u8be5\u7ec4\u7ec7\u7684\u7ed3\u8f6c\u51ed\u8bc1\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"BalanceCarryOverFormPlugin_3", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                return;
            }
            try {
                this.executeGenVoucher();
            }
            catch (GLException ex) {
                this.getView().showMessage(ex.getMessage());
            }
            finally {
                dataMutex.release(this.getModel().getValue(GLField.id_((String)"org")).toString(), "gl_genvch_carryover", "genvch");
            }
        }
    }

    private void executeGenVoucher() {
        List contexts = SerializationUtils.fromJsonStringToList((String)this.getView().getFormShowParameter().getCustomParam(PARAM_KEY).toString(), BalanceCarryOverContext.class);
        BalanceCarryOverUtils.logContextsIfEnable((Collection)contexts);
        BalanceCarryOverUtils.existLog((Collection)contexts).ifPresent(msg -> {
            throw new GLException(GLErrorCode.common, new Object[]{msg});
        });
        this.initThreadCaches(contexts);
        VoucherInfo voucherInfo = new VoucherInfo();
        this.constructVoucherHead(voucherInfo, (BalanceCarryOverContext)contexts.get(0));
        contexts.forEach(context -> EntryGeneratorFactory.get((EntryGeneratorType)EntryGeneratorType.CarryOver).build((Map)ImmutableMap.of((Object)"carryOverContext", (Object)context)).generateEntry(voucherInfo));
        voucherInfo.loadRefence();
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("carry_info", SerializationUtils.toJsonString((Object)contexts));
        OperationResult result = OperationServiceHelper.executeOperate((String)"submit", (String)"gl_voucher", (DynamicObject[])new DynamicObject[]{voucherInfo.toDynamicObject()}, (OperateOption)operateOption);
        if (result.isSuccess()) {
            Object pkId = result.getSuccessPkIds().get(0);
            this.getView().returnDataToParent(pkId);
            this.getView().close();
        } else {
            logger.error("submit fail, voucher info:" + voucherInfo);
            this.getView().showTipNotification(result.getAllErrorOrValidateInfo().stream().map(IOperateInfo::getMessage).collect(Collectors.joining("\n")));
        }
    }

    private void initThreadCaches(Collection<BalanceCarryOverContext> contexts) {
        Set masterIds = contexts.stream().map(BalanceCarryOverContext::getAccountMasterId).collect(Collectors.toSet());
        Set assgrpIds = contexts.stream().map(BalanceCarryOverContext::getAssgrpId).collect(Collectors.toSet());
        List balances = contexts.stream().map(BalanceCarryOverContext::getBalanceId).collect(Collectors.toList());
        CarryOverCacheManager.initDefaultVal(this.collectDefaultVal());
        CarryOverCacheManager.initAccountMatchCollection((Long)((Long)this.getModel().getValue("org_id")), masterIds);
        CarryOverCacheManager.initHgId2Assvals(assgrpIds);
        CarryOverCacheManager.initBalanceId2AmountInfo(balances);
    }

    private void constructVoucherHead(VoucherInfo voucherInfo, BalanceCarryOverContext context) {
        voucherInfo.setDesc((String)this.getModel().getValue(DESCRIPTION));
        voucherInfo.setCreator(Long.valueOf(RequestContext.get().getCurrUserId()));
        voucherInfo.setSourceSys(AppHelper.getAppIdByFormId((String)"gl_voucher"));
        voucherInfo.setStatus("A");
        voucherInfo.setBookType(Long.valueOf(context.getBookTypeId()));
        voucherInfo.setVoucherType(Long.valueOf(((DynamicObject)this.getModel().getValue(VOUCHERY_TYPE)).getLong("id")));
        voucherInfo.setSourceType("c");
        voucherInfo.setOrg(Long.valueOf(context.getOrgId()));
        Date date = BusinessDataServiceHelper.loadSingleFromCache((Object)context.getSearchPeriodId(), (String)"bd_period").getDate("enddate");
        voucherInfo.setBizDate(date);
        voucherInfo.setBookedDate(date);
        voucherInfo.setPeriod(Long.valueOf(context.getSearchPeriodId()));
    }

    IPageCache getPageCache(EventObject e) {
        return SessionManager.getCurrent().getPageCache(this.getFowmShowParameter(e).getPageId());
    }

    FormShowParameter getFowmShowParameter(EventObject e) {
        if (e.getSource() instanceof FormShowParameter) {
            return (FormShowParameter)e.getSource();
        }
        return ((FormView)e.getSource()).getFormShowParameter();
    }

    private FlexPanelAp createPanel(EventObject e) {
        FlexPanelAp flexPanel = new FlexPanelAp();
        this.addFixedField(flexPanel);
        flexPanel.setKey("ignore");
        String flexs = this.getPageCache(e).get(FLEX_KEY);
        if (StringUtils.isEmpty((String)flexs)) {
            return flexPanel;
        }
        Stream.of(flexs.split(",")).forEach(flex -> {
            String[] flexInfo = this.getPageCache(e).get(flex).split(",");
            if (flexInfo.length >= 3) {
                FieldAp baseDateFieldAp = MetaUtils.buildBaseDateFieldAp((String)flex, (LocaleString)new LocaleString(flexInfo[0]), (String)flexInfo[1], (String)"org", (boolean)false, (boolean)true);
                flexPanel.getItems().add(baseDateFieldAp);
            } else {
                FieldAp textFieldAp = MetaUtils.buildTextFieldAp((String)flex, (LocaleString)new LocaleString(flexInfo[0]), (boolean)false, (boolean)true);
                flexPanel.getItems().add(textFieldAp);
            }
        });
        return flexPanel;
    }

    private void addFixedField(FlexPanelAp flexPanel) {
        FieldAp desFieldAp = MetaUtils.buildTextFieldAp((String)DESCRIPTION, (LocaleString)ResManager.getLocaleString((String)"\u6458\u8981", (String)"BalanceCarryOverFormPlugin_4", (String)"fi-gl-formplugin"), (boolean)false, (boolean)true);
        flexPanel.getItems().add(desFieldAp);
        FieldAp voucherTypeField = MetaUtils.buildBaseDateFieldAp((String)VOUCHERY_TYPE, (LocaleString)ResManager.getLocaleString((String)"\u51ed\u8bc1\u7c7b\u578b", (String)"BalanceCarryOverFormPlugin_5", (String)"fi-gl-formplugin"), (String)"gl_vouchertype", (String)"org", (boolean)false, (boolean)true);
        flexPanel.getItems().add(voucherTypeField);
    }

    public void afterCreateNewData(EventObject e) {
        FilterInfo filter = ((ReportView)this.getView().getParentView()).getQueryParam().getFilter();
        this.getModel().setValue("org", (Object)filter.getLong("org"));
        this.getModel().setValue(VOUCHERY_TYPE, (Object)BusinessDataServiceHelper.loadSingleFromCache((String)"gl_accountbook", (String)"defaultvouchertype", (QFilter[])new QFBuilder("org", "=", (Object)filter.getLong("org")).add("bookstype", "=", (Object)filter.getLong("booktype")).toArray()).getLong(GLField.id_((String)"defaultvouchertype")));
        this.getModel().setValue(DESCRIPTION, (Object)ResManager.loadKDString((String)"\u4f59\u989d\u7ed3\u8f6c", (String)"BalanceCarryOverFormPlugin_1", (String)"fi-gl-formplugin", (Object[])new Object[0]));
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String flex = ((BasedataEdit)evt.getSource()).getKey();
        String[] flexInfo = this.getPageCache().get(flex).split(",");
        if (flexInfo.length == 4) {
            evt.addCustomQFilter(new QFilter("group.id", "=", (Object)Long.parseLong(flexInfo[3])));
        }
        boolean isDetail = Boolean.parseBoolean(flexInfo[2]);
        switch (flexInfo[1]) {
            case "bos_org": {
                String orgViewType = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_asstacttype", (QFilter[])new QFBuilder("flexfield", "=", (Object)flex).toArray()).getString("orgfunc.fnumber");
                orgViewType = StringUtils.isEmpty((String)orgViewType) ? "15" : orgViewType;
                OrgFilterUtils.addOrgFilterToF7ByViewType((BeforeF7SelectEvent)evt, (String)orgViewType, (boolean)isDetail);
                break;
            }
            case "bos_adminorg": {
                OrgFilterUtils.addOrgFilterToF7ByEntityId((BeforeF7SelectEvent)evt, (String)"bos_adminorg", (boolean)isDetail);
                break;
            }
            default: {
                if (!EntityName.isDetailEntity((String)flexInfo[1]) || !isDetail) break;
                evt.addCustomQFilter(new QFilter("isleaf", "=", (Object)"1"));
            }
        }
    }

    private Map<String, Object> collectDefaultVal() {
        String flexs = this.getPageCache().get(FLEX_KEY);
        if (null == this.getModel().getValue(VOUCHERY_TYPE)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u51ed\u8bc1\u7c7b\u578b\u3002", (String)"BalanceCarryOverFormPlugin_6", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((String)flexs)) {
            return Collections.emptyMap();
        }
        return Stream.of(flexs.split(",")).collect(Collectors.toMap(key -> key, key -> {
            Control controlBuf = this.getControl((String)key);
            if (controlBuf instanceof BasedataEdit) {
                boolean hasMasterId;
                return Optional.ofNullable((DynamicObject)this.getModel().getValue(key)).orElseThrow(() -> new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6240\u6709\u7ef4\u5ea6\u9ed8\u8ba4\u503c\u3002", (String)"BalanceCarryOverFormPlugin_0", (String)"fi-gl-formplugin", (Object[])new Object[0]))).getLong((hasMasterId = BaseDataUtil.containsProp((Control)controlBuf, (String)"masterid")) ? "masterid" : "id");
            }
            return this.getModel().getValue(key);
        }));
    }
}

