/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.voucher;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.fi.bd.business.service.AssgrpService;
import kd.fi.gl.util.GLApp;
import kd.fi.gl.util.GLUtil;

public class CashFlowAnalyzer {
    private static final Log logger = LogFactory.getLog(CashFlowAnalyzer.class);
    private static final String PROCESS_ID_STR = "1981857302625396736";

    protected static void analyzeVoucherForm(IFormView voucherFormView) {
        IDataModel model = voucherFormView.getModel();
        if (model.getEntryRowCount("entries") > 20) {
            voucherFormView.showTipNotification(ResManager.loadKDString((String)"\u5206\u5f55\u884c\u591a\u4e8e20\u884c\u65f6\u6682\u4e0d\u652f\u6301\u4f7f\u7528\u8be5\u529f\u80fd\u3002", (String)"CashFlowAnalyzer_0", (String)GLApp.instance.formpluginModule(), (Object[])new Object[0]));
            return;
        }
        JSONObject entryInfo = CashFlowAnalyzer.formatEntryInfo(model);
        if (entryInfo.isEmpty()) {
            voucherFormView.showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u6709\u6548\u5206\u5f55\u884c\u3002", (String)"CashFlowAnalyzer_1", (String)GLApp.instance.formpluginModule(), (Object[])new Object[0]));
            return;
        }
        CashFlowAnalyzer.invokeSideBar(entryInfo, voucherFormView.getMainView().getPageId());
    }

    private static void invokeSideBar(JSONObject entryInfo, String rootPageId) {
        ImmutableMap startParams = ImmutableMap.of((Object)"voucher_info", (Object)entryInfo);
        JSONObject gaiInitConfig = new JSONObject();
        gaiInitConfig.put("switchSide", (Object)true);
        gaiInitConfig.put("lockSide", (Object)true);
        gaiInitConfig.put("selectedProcessId", (Object)PROCESS_ID_STR);
        gaiInitConfig.put("startProcessId", (Object)PROCESS_ID_STR);
        gaiInitConfig.put("startParams", (Object)startParams);
        DispatchServiceHelper.invokeBizService((String)"ai", (String)"gai", (String)"GaiService", (String)"sideBarInit", (Object[])new Object[]{rootPageId, gaiInitConfig.toString()});
    }

    private static JSONObject formatEntryInfo(IDataModel model) {
        long tick = System.currentTimeMillis();
        JSONObject result = new JSONObject();
        result.put("fields", (Object)new JSONArray(Arrays.asList(ResManager.loadKDString((String)"\u6458\u8981", (String)"CashFlowAnalyzer_2", (String)GLApp.instance.formpluginModule(), (Object[])new Object[0]), ResManager.loadKDString((String)"\u79d1\u76ee", (String)"CashFlowAnalyzer_3", (String)GLApp.instance.formpluginModule(), (Object[])new Object[0]), ResManager.loadKDString((String)"\u6838\u7b97\u7ef4\u5ea6", (String)"CashFlowAnalyzer_4", (String)GLApp.instance.formpluginModule(), (Object[])new Object[0]), ResManager.loadKDString((String)"\u5206\u5f55\u65b9\u5411", (String)"CashFlowAnalyzer_5", (String)GLApp.instance.formpluginModule(), (Object[])new Object[0]), ResManager.loadKDString((String)"\u91d1\u989d", (String)"CashFlowAnalyzer_6", (String)GLApp.instance.formpluginModule(), (Object[])new Object[0]))));
        JSONArray records = new JSONArray();
        for (DynamicObject entryDyn : model.getEntryEntity("entries")) {
            DynamicObject accountDyn = entryDyn.getDynamicObject("account");
            if (accountDyn == null) continue;
            records.add(Arrays.asList(entryDyn.getString("edescription"), String.join((CharSequence)",", accountDyn.getString("number"), accountDyn.getString("fullname")), GLUtil.dealAssgrp((JSONObject)new JSONObject(AssgrpService.fromJsonStr((String)entryDyn.getString("assgrp.value"))), (String)";"), "1".equals(model.getValue("entrydc", entryDyn.getInt("seq") - 1)) ? ResManager.loadKDString((String)"\u501f", (String)"CashFlowAnalyzer_7", (String)GLApp.instance.formpluginModule(), (Object[])new Object[0]) : ResManager.loadKDString((String)"\u8d37", (String)"CashFlowAnalyzer_8", (String)GLApp.instance.formpluginModule(), (Object[])new Object[0]), entryDyn.getBigDecimal("debitlocal").add(entryDyn.getBigDecimal("creditlocal"))));
        }
        result.put("records", (Object)records);
        logger.info("parse entry info end\uff1a{}\uff0ccost{}ms", (Object)result, (Object)(System.currentTimeMillis() - tick));
        return result;
    }
}

