/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.voucher;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.fi.gl.formplugin.voucher.MulBaseData;
import kd.fi.gl.formplugin.voucher.MulBaseDataQueryInfo;

class MulBaseDataQuery {
    private MulBaseDataQuery() {
    }

    static List<MulBaseData> getMulBaseData(final MulBaseDataQueryInfo mulBaseDataQueryInfo) {
        int size = mulBaseDataQueryInfo.getPkList().size();
        ArrayList<String> questionMarkList = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            questionMarkList.add("?");
        }
        if (questionMarkList.isEmpty()) {
            return new ArrayList<MulBaseData>();
        }
        String sql = "SELECT FPKID, " + mulBaseDataQueryInfo.getFieldName() + " , FBASEDATAID FROM " + mulBaseDataQueryInfo.getTableName() + "  where " + mulBaseDataQueryInfo.getFieldName() + " IN(" + String.join((CharSequence)",", questionMarkList) + ") ";
        try {
            return (List)DB.query((DBRoute)new DBRoute(mulBaseDataQueryInfo.getDbRouteKey()), (String)sql, (Object[])mulBaseDataQueryInfo.getPkList().toArray(new Object[0]), (ResultSetHandler)new ResultSetHandler<List<MulBaseData>>(){

                public List<MulBaseData> handle(ResultSet rs) throws Exception {
                    ArrayList<MulBaseData> mulBaseDatas = new ArrayList<MulBaseData>();
                    MulBaseData mulBaseData = null;
                    try {
                        while (rs.next()) {
                            Object fBaseDataId;
                            Object fid;
                            Object pkId;
                            if (mulBaseDataQueryInfo.isPkLongType()) {
                                pkId = rs.getBigDecimal(1).longValue();
                                fid = rs.getBigDecimal(2).longValue();
                                fBaseDataId = rs.getBigDecimal(3).longValue();
                            } else {
                                pkId = rs.getString(1);
                                fid = rs.getString(2);
                                fBaseDataId = rs.getString(3);
                            }
                            mulBaseData = new MulBaseData(pkId, fid, fBaseDataId);
                            mulBaseDatas.add(mulBaseData);
                        }
                    }
                    catch (SQLException e) {
                        throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("Error:%s", e.getMessage())});
                    }
                    return mulBaseDatas;
                }
            });
        }
        catch (Exception e) {
            String msg = String.format("error:%s;  sql:%s", e.getMessage(), sql);
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{msg});
        }
    }
}

