/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.voucher;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.openapi.api.plugin.ApiSerializerPlugin;
import kd.bos.openapi.api.plugin.SerializerResult;
import kd.bos.openapi.api.result.ApiQueryResult;
import kd.bos.openapi.common.result.OpenApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.vo.CommonAssist;
import kd.fi.gl.comassist.model.ComAssistTable;

public class VoucherAPIQueryPlugin
implements ApiSerializerPlugin {
    private static final String ORG_NUMBER = "org_number";
    private static final String BOOKTYPE_NUMBER = "booktype_number";
    private static final String ENTRY_ID = "id";

    public SerializerResult serialize(Object response, String accept, String contentType) {
        try {
            boolean dealComassist;
            ApiQueryResult data;
            List rows;
            OpenApiResult result = (OpenApiResult)response;
            if (result.isStatus() && (rows = (data = (ApiQueryResult)result.getData()).getRows()).size() > 0 && (dealComassist = this.dispose((Map)rows.get(0)))) {
                Map<String, List<Map>> group = rows.stream().collect(Collectors.groupingBy(x -> x.get(ORG_NUMBER) + "|" + x.get(BOOKTYPE_NUMBER)));
                for (Map.Entry<String, List<Map>> groupEntry : group.entrySet()) {
                    String key = groupEntry.getKey();
                    String[] split = key.split("\\|");
                    Optional<ComAssistTable> table = this.getComassistTable(split[0], split[1]);
                    if (!table.isPresent() || table.get().getCommonAssists().size() <= 0) continue;
                    List commonAssists = table.get().getCommonAssists();
                    int size = commonAssists.size();
                    List<Map<String, Object>> value = groupEntry.getValue();
                    HashMap<Integer, List<Long>> comassist = new HashMap<Integer, List<Long>>(size);
                    Map<Long, List<Long>> entryId2Comassist = this.parseEntryId(value, comassist, size);
                    Map<Integer, Map<Long, String>> numberMap = this.queryComassistNumber(commonAssists, comassist);
                    this.parseData(value, numberMap, entryId2Comassist);
                }
            }
            String responseStr = new ObjectMapper().writeValueAsString(response);
            if (contentType == null) {
                return new SerializerResult("application/json", responseStr);
            }
            return new SerializerResult(contentType, responseStr);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    protected Map<Long, List<Long>> parseEntryId(List<Map<String, Object>> value, Map<Integer, List<Long>> comassist, int size) {
        ArrayList entryIds = new ArrayList();
        for (Map<String, Object> map : value) {
            List entryId = ((List)map.get("entries")).stream().map(x -> x.get(ENTRY_ID)).collect(Collectors.toList());
            entryIds.addAll(entryId);
        }
        HashMap<Long, List<Long>> entryId2Comassist = new HashMap<Long, List<Long>>();
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fentryid,", new Object[0]).append(this.getSelField(size), new Object[0]).append(" from t_gl_voucherentry where ", new Object[0]);
        sqlBuilder.appendIn(" fentryid ", entryIds);
        try (DataSet dataSet = DB.queryDataSet((String)"VoucherAPIQueryPlugin", (DBRoute)DBRoute.of((String)"gl"), (SqlBuilder)sqlBuilder);){
            for (Row row : dataSet) {
                ArrayList<Long> comIds = new ArrayList<Long>(size);
                for (int i = 1; i <= size; ++i) {
                    long comId = row.getLong("fcomassist" + i + ENTRY_ID);
                    comIds.add(comId);
                    List<Long> list = comassist.get(i);
                    if (list == null) {
                        list = new ArrayList<Long>();
                        list.add(comId);
                        comassist.put(i, list);
                        continue;
                    }
                    list.add(comId);
                }
                entryId2Comassist.put(row.getLong("fentryid"), comIds);
            }
        }
        return entryId2Comassist;
    }

    protected Map<Integer, Map<Long, String>> queryComassistNumber(List<CommonAssist> commonAssists, Map<Integer, List<Long>> comassist) {
        HashMap<Integer, Map<Long, String>> numberMap = new HashMap<Integer, Map<Long, String>>(comassist.size());
        for (CommonAssist assist : commonAssists) {
            HashMap<Long, String> number = new HashMap<Long, String>();
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"VoucherAPIQueryPlugin#queryComassistNumber", (String)assist.valueSource, (String)"id,number", (QFilter[])new QFilter[]{new QFilter(ENTRY_ID, "in", comassist.get(assist.getSeq()))}, null);){
                for (Row row : dataSet) {
                    number.put(row.getLong(ENTRY_ID), row.getString("number"));
                }
            }
            numberMap.put(assist.getSeq(), number);
        }
        return numberMap;
    }

    protected void parseData(List<Map<String, Object>> value, Map<Integer, Map<Long, String>> numberMap, Map<Long, List<Long>> entryId2Comassist) {
        for (Map<String, Object> map : value) {
            List entries = (List)map.get("entries");
            for (Map entry : entries) {
                Object entryId = entry.get(ENTRY_ID);
                List<Long> comIds = entryId2Comassist.get(entryId);
                for (int i = 1; i <= numberMap.size(); ++i) {
                    entry.put("comassist" + i + "_number", numberMap.get(i).get(comIds.get(i - 1)));
                }
            }
        }
    }

    protected String getSelField(int size) {
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i <= size; ++i) {
            sb.append("fcomassist").append(i).append("id,");
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    protected Optional<ComAssistTable> getComassistTable(String orgNumber, String booktypeNumber) {
        DynamicObject org = QueryServiceHelper.queryOne((String)"bos_org", (String)ENTRY_ID, (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)orgNumber)});
        DynamicObject booktype = QueryServiceHelper.queryOne((String)"bd_accountbookstype", (String)ENTRY_ID, (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)booktypeNumber)});
        if (org == null || booktype == null) {
            return Optional.empty();
        }
        Optional comAssistTable = ComAssistTable.get((Long)org.getLong(ENTRY_ID), (Long)booktype.getLong(ENTRY_ID));
        return comAssistTable;
    }

    protected boolean dispose(Map<String, Object> data) {
        HashSet<String> field = new HashSet<String>();
        HashSet entryField = new HashSet();
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            String key = entry.getKey();
            if (key.equals("entries")) {
                List entries = (List)entry.getValue();
                entryField.addAll(((Map)entries.get(0)).keySet());
                continue;
            }
            field.add(key);
        }
        return field.contains(BOOKTYPE_NUMBER) && field.contains(ORG_NUMBER) && entryField.contains(ENTRY_ID) && entryField.contains("comassist1_number");
    }
}

