/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.voucher;

import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IPageCache;

public class VoucherEditCacheManager {
    private static final String VOUCHER_EDIT_CACHEKEYS = "voucher_edit_cachekeys";
    private final IPageCache cache;

    protected VoucherEditCacheManager(IPageCache cache) {
        this.cache = cache;
    }

    private Set<String> getCacheKeys() {
        HashSet<String> cacheKeys;
        String cacheValue = this.cache.get(VOUCHER_EDIT_CACHEKEYS);
        if (StringUtils.isBlank((CharSequence)cacheValue)) {
            cacheKeys = new HashSet();
            this.cache.put(VOUCHER_EDIT_CACHEKEYS, SerializationUtils.toJsonString(cacheKeys));
        } else {
            cacheKeys = (Set)SerializationUtils.fromJsonString((String)cacheValue, Set.class);
        }
        return cacheKeys;
    }

    private void addCacheKey(String cacheKey) {
        Set<String> cacheKeys = this.getCacheKeys();
        cacheKeys.add(cacheKey);
        this.cache.put(VOUCHER_EDIT_CACHEKEYS, SerializationUtils.toJsonString(cacheKeys));
    }

    private void removeCacheKey(String cacheKey) {
        Set<String> cacheKeys = this.getCacheKeys();
        cacheKeys.remove(cacheKey);
        this.cache.put(VOUCHER_EDIT_CACHEKEYS, SerializationUtils.toJsonString(cacheKeys));
    }

    protected void releaseCache() {
        this.removeCache();
        Set<String> cacheKeys = this.getCacheKeys();
        for (String cacheKey : cacheKeys) {
            this.cache.remove(cacheKey);
        }
        this.cache.remove(VOUCHER_EDIT_CACHEKEYS);
    }

    private void removeCache() {
        this.cache.remove("cashAcctCount");
        this.cache.remove("plAcctCount");
        this.cache.remove("adjustment");
        this.cache.remove("changefield");
        this.cache.remove("autosave");
        this.cache.remove("autosaveargs");
        this.cache.remove("local-bal-key");
        this.cache.remove("rateBizdate");
        this.cache.remove("updateRate");
        this.cache.remove("isReciprocal_cache");
        this.cache.remove("entry-field-key");
        this.cache.remove("presetmap");
        this.cache.remove("voucherControlState");
    }

    public void removeCache(String cacheKey) {
        this.cache.remove(cacheKey);
        this.removeCacheKey(cacheKey);
    }

    public String get(String cacheKey) {
        return this.cache.get(cacheKey);
    }

    public void set(String cacheKey, String cacheValue) {
        this.cache.put(cacheKey, cacheValue);
        this.addCacheKey(cacheKey);
    }
}

