/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.voucher;

import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.fi.gl.common.AccountType;
import kd.fi.gl.constant.GLField;
import kd.fi.gl.formplugin.voucher.VoucherEditCashFlowCounter;
import kd.fi.gl.formplugin.voucher.VoucherEditView;
import kd.fi.gl.util.GLUtil;

public class VoucherEditCashFlowStatusManager {
    private final VoucherEditView voucherEditView;
    private static final String IS_ADJUSTMENT = "adjustment";

    protected VoucherEditCashFlowStatusManager(VoucherEditView voucherEditView) {
        this.voucherEditView = voucherEditView;
    }

    public boolean isLocalSet() {
        if (this.voucherEditView.isFromTemplateVoucher()) {
            return false;
        }
        return this.isLocalSet(this.voucherEditView.getValueGetter().getBookDate());
    }

    protected boolean isLocalSet(Date date) {
        DynamicObject bookDyn = this.voucherEditView.getValueGetter().getBook();
        return bookDyn != null && bookDyn.getBoolean("localset") && bookDyn.getDate("localsetdate").compareTo(date) <= 0;
    }

    protected boolean isAdjustment() {
        return Boolean.parseBoolean(this.voucherEditView.getCacheManager().get(IS_ADJUSTMENT));
    }

    protected void setAdjustment(boolean adjustment) {
        this.voucherEditView.getCacheManager().set(IS_ADJUSTMENT, String.valueOf(adjustment));
    }

    protected RowDesignateStatus calcRowDesignateStatus(int index) {
        boolean localSet = this.voucherEditView.getService(VoucherEditCashFlowStatusManager.class).isLocalSet();
        IDataModel model = this.voucherEditView.getVoucherEditModel();
        DynamicObject acct = (DynamicObject)model.getValue("account", index);
        if (acct == null || !this.voucherEditView.isFromTemplateVoucher() && "1".equals(this.voucherEditView.getValueGetter().getSourceType())) {
            return new RowDesignateStatus(false, false);
        }
        if (AccountType.isBudgetType((long)acct.getLong(GLField.id_((String)"accounttype")))) {
            return new RowDesignateStatus(false, false);
        }
        VoucherEditCashFlowCounter cashFlowCounter = this.voucherEditView.getService(VoucherEditCashFlowCounter.class);
        int cashAcctCount = cashFlowCounter.getCashCount();
        int nnAcctCount = cashFlowCounter.getNonCashNonPLCount();
        int plAcctCount = cashFlowCounter.getPLCount();
        if (cashAcctCount <= 0) {
            if (plAcctCount <= 0) {
                if (this.voucherEditView.getPageCache().get(IS_ADJUSTMENT) != null) {
                    return new RowDesignateStatus(false, true);
                }
                return new RowDesignateStatus(false, false);
            }
            if (GLUtil.isPLAcct((DynamicObject)acct) && !localSet || localSet && (!GLUtil.isPLAcct((DynamicObject)acct) || nnAcctCount <= 0)) {
                return new RowDesignateStatus(false, false);
            }
            return new RowDesignateStatus(false, true);
        }
        if (!localSet && GLUtil.isCashAcct((DynamicObject)acct) || localSet && !GLUtil.isCashAcct((DynamicObject)acct) && !GLUtil.isPLAcct((DynamicObject)acct)) {
            return new RowDesignateStatus(false, false);
        }
        if (!localSet) {
            if (GLUtil.isPLAcct((DynamicObject)acct)) {
                DynamicObject mainCF = (DynamicObject)model.getValue("maincfitem", index);
                if (mainCF != null && mainCF.getBoolean("isdealactivity")) {
                    return new RowDesignateStatus(true, false);
                }
                return new RowDesignateStatus(true, true);
            }
            DynamicObject mainCF = (DynamicObject)model.getValue("maincfitem", index);
            if (mainCF != null && !mainCF.getBoolean("isdealactivity")) {
                return new RowDesignateStatus(true, false);
            }
            return new RowDesignateStatus(true, true);
        }
        if (GLUtil.isPLAcct((DynamicObject)acct)) {
            return new RowDesignateStatus(false, true);
        }
        if (plAcctCount <= 0 && nnAcctCount <= 0) {
            return new RowDesignateStatus(false, false);
        }
        DynamicObject mainCF = (DynamicObject)model.getValue("maincfitem", index);
        if (mainCF != null && !mainCF.getBoolean("isdealactivity")) {
            return new RowDesignateStatus(true, false);
        }
        return new RowDesignateStatus(true, true);
    }

    protected static class RowDesignateStatus {
        private final boolean mainCfItemEnable;
        private final boolean suppCfItemEnable;

        public boolean isMainCfItemEnable() {
            return this.mainCfItemEnable;
        }

        public boolean isSuppCfItemEnable() {
            return this.suppCfItemEnable;
        }

        public RowDesignateStatus(boolean mainCfItemEnable, boolean suppCfItemEnable) {
            this.mainCfItemEnable = mainCfItemEnable;
            this.suppCfItemEnable = suppCfItemEnable;
        }
    }
}

