/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.voucher;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.ext.fi.ai.v2.fah.dto.BillToVchRelationDto;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.gl.business.GLServiceFactory;
import kd.fi.gl.common.NoticeData;
import kd.fi.gl.formplugin.voucher.VoucherEditCacheManager;
import kd.fi.gl.interfaces.service.dap.IDAPService;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.QFBuilder;

public class VoucherEditNoticeUtils {
    private static final String CASH_NOTICE = "cash_notice";
    private static final String CHECKED_NOTICE = "checked_notice";
    private static final String GENERATED_NOTICE = "generated_notice";
    private static final String ACPANEL = "acpanel";
    private static final String CFPANEL = "cfpanel";
    private static final String ACP = "acp";
    private static final String CFP = "cfp";

    private static IDAPService getDAPService() {
        return (IDAPService)GLServiceFactory.getService(IDAPService.class);
    }

    private VoucherEditNoticeUtils() {
    }

    protected static void handleNoticeOnVoucherEditView(RowClickEvent evt, IFormView voucherEditView, Long orgId, String voucherStatus) {
        if (voucherEditView == null) {
            return;
        }
        if ("A".equals(voucherStatus) || null == evt || !(evt.getSource() instanceof EntryGrid) || evt.getRow() < 0) {
            VoucherEditNoticeUtils.setNoticePanelVisiable(0, ACP, voucherEditView);
            VoucherEditNoticeUtils.setNoticePanelVisiable(0, CFP, voucherEditView);
            return;
        }
        EntryGrid voucherEntryGrid = (EntryGrid)evt.getSource();
        String entryKey = voucherEntryGrid.getKey();
        if ("entries".equals(entryKey)) {
            int row = evt.getRow();
            DynamicObject entryRowEntity = voucherEditView.getModel().getEntryRowEntity("entries", row);
            if (entryRowEntity == null) {
                VoucherEditNoticeUtils.setNoticePanelVisiable(0, ACP, voucherEditView);
                VoucherEditNoticeUtils.setNoticePanelVisiable(0, CFP, voucherEditView);
                return;
            }
            long voucherEntryId = entryRowEntity.getLong("id");
            int acNoticeCounts = VoucherEditNoticeUtils.showACNoticeOnVoucherEdit(voucherEditView, orgId, voucherEntryId);
            VoucherEditNoticeUtils.setNoticePanelVisiable(acNoticeCounts, ACP, voucherEditView);
            int cfNoticeCounts = VoucherEditNoticeUtils.showCFNoticeOnVoucherEdit(voucherEditView, orgId, voucherEntryId);
            VoucherEditNoticeUtils.setNoticePanelVisiable(cfNoticeCounts, CFP, voucherEditView);
            if (cfNoticeCounts > 1 && !"c".equals(voucherEditView.getModel().getValue("ischeck"))) {
                voucherEditView.setEnable(Boolean.valueOf(false), new String[]{"maincf", "maincfamt", "mcfassgrp"});
            }
        }
    }

    protected static void lockEntryByNoticeCheckStatus(IFormView voucherEditView, String voucherStatus, VoucherEditCacheManager cacheManager) {
        Object row3;
        if (!"B".equals(voucherStatus) || null == voucherEditView) {
            return;
        }
        IDataModel voucherModel = voucherEditView.getModel();
        long voucherId = voucherModel.getDataEntity().getLong("id");
        QFilter voucherIdFilter = new QFilter(NoticeData.VOUCHER_ID_FIELD, "=", (Object)voucherId);
        QFilter opVoucherIdFilter = new QFilter(NoticeData.OP_VOUCHER_ID_FIELD, "=", (Object)voucherId);
        HashSet<Long> checkedEntries = new HashSet<Long>(10);
        try (DataSet logAcEntrySet = QueryServiceHelper.queryDataSet((String)VoucherEditNoticeUtils.class.getName(), (String)"gl_acnotice_relation", (String)NoticeData.ENTRY_ID_FIELD, (QFilter[])voucherIdFilter.toArray(), null);){
            for (Object row2 : logAcEntrySet) {
                checkedEntries.add(row2.getLong(NoticeData.ENTRY_ID_FIELD));
            }
        }
        var10_9 = null;
        try (DataSet logAcOpEntrySet = QueryServiceHelper.queryDataSet((String)VoucherEditNoticeUtils.class.getName(), (String)"gl_acnotice_relation", (String)NoticeData.OP_ENTRY_ID_FIELD, (QFilter[])opVoucherIdFilter.toArray(), null);){
            for (Object row2 : logAcOpEntrySet) {
                checkedEntries.add(row2.getLong(NoticeData.OP_ENTRY_ID_FIELD));
            }
        }
        catch (Throwable throwable) {
            var10_9 = throwable;
            throw throwable;
        }
        HashSet<Long> checkedCfEntryIds = new HashSet<Long>(10);
        DataSet logCfEntrySet = QueryServiceHelper.queryDataSet((String)VoucherEditNoticeUtils.class.getName(), (String)"gl_cfnotice_relation", (String)NoticeData.ENTRY_ID_FIELD, (QFilter[])voucherIdFilter.toArray(), null);
        Object object = null;
        try {
            for (Object row3 : logCfEntrySet) {
                checkedCfEntryIds.add(row3.getLong(NoticeData.ENTRY_ID_FIELD));
            }
        }
        catch (Throwable row4) {
            object = row4;
            throw row4;
        }
        finally {
            if (logCfEntrySet != null) {
                if (object != null) {
                    try {
                        logCfEntrySet.close();
                    }
                    catch (Throwable row4) {
                        ((Throwable)object).addSuppressed(row4);
                    }
                } else {
                    logCfEntrySet.close();
                }
            }
        }
        DataSet logCfOpEntrySet = QueryServiceHelper.queryDataSet((String)VoucherEditNoticeUtils.class.getName(), (String)"gl_cfnotice_relation", (String)NoticeData.OP_ENTRY_ID_FIELD, (QFilter[])opVoucherIdFilter.toArray(), null);
        object = null;
        try {
            for (Object row3 : logCfOpEntrySet) {
                checkedCfEntryIds.add(row3.getLong(NoticeData.OP_ENTRY_ID_FIELD));
            }
        }
        catch (Throwable row4) {
            object = row4;
            throw row4;
        }
        finally {
            if (logCfOpEntrySet != null) {
                if (object != null) {
                    try {
                        logCfOpEntrySet.close();
                    }
                    catch (Throwable row4) {
                        ((Throwable)object).addSuppressed(row4);
                    }
                } else {
                    logCfOpEntrySet.close();
                }
            }
        }
        HashSet<Long> generatedEntryIds = new HashSet<Long>(10);
        HashMap<Long, Long> sourceIdToVchEntryIdMap = new HashMap<Long, Long>(8);
        DataSet dataSet = DB.queryDataSet((String)VoucherEditNoticeUtils.class.getName(), (DBRoute)DBRoute.of((String)"fi"), (String)"select fid ,fvoucherentryid from t_gl_acnotice where fvoucherid = ?", (Object[])new Object[]{voucherId});
        row3 = null;
        try {
            for (Row row5 : dataSet) {
                sourceIdToVchEntryIdMap.put(row5.getLong("fid"), row5.getLong("fvoucherentryid"));
            }
        }
        catch (Throwable throwable) {
            row3 = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (row3 != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)row3).addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        if (!sourceIdToVchEntryIdMap.isEmpty()) {
            Set sourceIds = sourceIdToVchEntryIdMap.keySet();
            BillToVchRelationDto voucherRelations = VoucherEditNoticeUtils.getDAPService().getBillToVchReDtoByBillTypeAndIds("gl_acnotice", sourceIds);
            for (BillToVchRelationDto.BillToVoucherRelation relation : voucherRelations) {
                Long billId = relation.getBillId();
                Long vchEntryId = (Long)sourceIdToVchEntryIdMap.get(billId);
                generatedEntryIds.add(vchEntryId);
            }
        }
        boolean hasCheckedCF = false;
        if (!checkedCfEntryIds.isEmpty()) {
            hasCheckedCF = true;
            checkedEntries.addAll(checkedCfEntryIds);
        }
        if (checkedEntries.isEmpty() && generatedEntryIds.isEmpty()) {
            return;
        }
        DynamicObjectCollection entries = voucherModel.getEntryEntity("entries");
        HashSet<Long> checkedNoticeEntries = new HashSet<Long>(entries.size());
        HashSet<Long> checkedNoticeCashEntries = new HashSet<Long>(entries.size());
        EntryGrid grid = (EntryGrid)voucherEditView.getControl("entries");
        int size = VoucherEditNoticeUtils.getSplitSize(entries, grid);
        int i = 0;
        for (DynamicObject entry : entries) {
            long pkValue = entry.getLong("id");
            if (checkedEntries.contains(pkValue)) {
                if (i <= size) {
                    VoucherEditNoticeUtils.lockEntry(entry.getInt("seq") - 1, voucherEditView);
                }
                checkedNoticeEntries.add(pkValue);
            } else if (hasCheckedCF) {
                DynamicObject acct = entry.getDynamicObject("account");
                if (GLUtil.isCashAcct((DynamicObject)acct)) {
                    if (i <= size) {
                        VoucherEditNoticeUtils.lockEntry(entry.getInt("seq") - 1, voucherEditView);
                    }
                    checkedNoticeCashEntries.add(pkValue);
                }
            } else if (generatedEntryIds.contains(pkValue) && i <= size) {
                VoucherEditNoticeUtils.lockEntry(entry.getInt("seq") - 1, voucherEditView);
            }
            ++i;
        }
        cacheManager.set(CHECKED_NOTICE, SerializationUtils.toJsonString(checkedNoticeEntries));
        cacheManager.set(CASH_NOTICE, SerializationUtils.toJsonString(checkedNoticeCashEntries));
        cacheManager.set(GENERATED_NOTICE, SerializationUtils.toJsonString(generatedEntryIds));
    }

    private static int getSplitSize(DynamicObjectCollection col, EntryGrid grid) {
        int size;
        String split = System.getProperty("billmodel.splitpage");
        if (grid.isSplitPage() || split != null && Boolean.parseBoolean(split)) {
            size = grid.getPageRow();
            if (size > col.size()) {
                size = col.size();
            }
        } else {
            size = col.size();
        }
        return size;
    }

    protected static void afterEntryGridBindData(IFormView voucherEditView, String voucherStatus, List<RowDataEntity> rowDatas, VoucherEditCacheManager cacheManager) {
        Set generatedNoticeEntries;
        if (!"B".equals(voucherStatus) || null == voucherEditView) {
            return;
        }
        String lockNotices = cacheManager.get(CHECKED_NOTICE);
        String cashNotices = cacheManager.get(CASH_NOTICE);
        String generatedNotices = cacheManager.get(GENERATED_NOTICE);
        Set checkedNoticeEntries = StringUtils.isNotBlank((CharSequence)lockNotices) ? (Set)SerializationUtils.fromJsonString((String)lockNotices, Set.class) : Collections.emptySet();
        Set checkedNoticeCashEntries = StringUtils.isNotBlank((CharSequence)cashNotices) ? (Set)SerializationUtils.fromJsonString((String)cashNotices, Set.class) : Collections.emptySet();
        Set set = generatedNoticeEntries = StringUtils.isNotBlank((CharSequence)generatedNotices) ? (Set)SerializationUtils.fromJsonString((String)generatedNotices, Set.class) : Collections.emptySet();
        if (checkedNoticeEntries.isEmpty() && checkedNoticeCashEntries.isEmpty() && generatedNoticeEntries.isEmpty()) {
            return;
        }
        for (RowDataEntity rowData : rowDatas) {
            long entryId = rowData.getDataEntity().getLong("id");
            if (!checkedNoticeEntries.contains(entryId) && !checkedNoticeCashEntries.contains(entryId) && !generatedNoticeEntries.contains(entryId)) continue;
            VoucherEditNoticeUtils.lockEntry(rowData.getRowIndex(), voucherEditView);
        }
    }

    protected static boolean deletable(IFormView voucherEditView, BeforeDeleteRowEventArgs e, int row, VoucherEditCacheManager cacheManager) {
        Set generatedNoticeCashEntries;
        Set checkedNoticeCashEntries;
        Set checkedNoticeEntries;
        if (null == voucherEditView || null == e || row < 0) {
            return true;
        }
        IDataModel voucherEditModel = voucherEditView.getModel();
        Object status = voucherEditModel.getValue("billstatus");
        if (!"B".equals(status)) {
            return true;
        }
        DynamicObject entryRowEntity = voucherEditModel.getEntryRowEntity("entries", row);
        if (null == entryRowEntity || null == entryRowEntity.getPkValue()) {
            return true;
        }
        String lockNotices = cacheManager.get(CHECKED_NOTICE);
        if (StringUtils.isNotBlank((CharSequence)lockNotices) && (checkedNoticeEntries = (Set)SerializationUtils.fromJsonString((String)lockNotices, Set.class)).contains(entryRowEntity.getLong("id"))) {
            voucherEditView.showErrorNotification(ResManager.loadKDString((String)"\u6b64\u5206\u5f55\u7684\u901a\u77e5\u5355\u5df2\u52fe\u7a3d\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"VoucherEditNoticeUtils_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return false;
        }
        String cashNotices = cacheManager.get(CASH_NOTICE);
        if (StringUtils.isNotBlank((CharSequence)cashNotices) && (checkedNoticeCashEntries = (Set)SerializationUtils.fromJsonString((String)cashNotices, Set.class)).contains(entryRowEntity.getLong("id"))) {
            voucherEditView.showErrorNotification(ResManager.loadKDString((String)"\u6b64\u51ed\u8bc1\u5305\u542b\u5df2\u52fe\u7a3d\u7684\u73b0\u91d1\u6d41\u91cf\u901a\u77e5\u5355\uff0c\u65e0\u6cd5\u5220\u9664\u5305\u542b\u73b0\u91d1\u79d1\u76ee\u7684\u5206\u5f55\u3002", (String)"VoucherEditNoticeUtils_1", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return false;
        }
        String generatedNotices = cacheManager.get(GENERATED_NOTICE);
        if (StringUtils.isNotBlank((CharSequence)generatedNotices) && (generatedNoticeCashEntries = (Set)SerializationUtils.fromJsonString((String)generatedNotices, Set.class)).contains(entryRowEntity.getLong("id"))) {
            voucherEditView.showErrorNotification(ResManager.loadKDString((String)"\u8be5\u5206\u5f55\u7684\u901a\u77e5\u5355\u5df2\u88ab\u5bf9\u65b9\u7ec4\u7ec7\u751f\u6210\u51ed\u8bc1\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"VoucherEditNoticeUtils_2", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return false;
        }
        return true;
    }

    private static void lockEntry(int row, IFormView voucherEditView) {
        voucherEditView.setEnable(Boolean.valueOf(false), row, new String[]{"account", "oriamount", "assgrp", "currency", "price", "quantity", "creditlocal", "debitlocal"});
    }

    private static void setNoticePanelVisiable(int noticeCounts, String panelKey, IFormView voucherEditView) {
        voucherEditView.setVisible(Boolean.valueOf(noticeCounts > 0), new String[]{panelKey});
    }

    private static int showCFNoticeOnVoucherEdit(IFormView voucherEditView, Long orgId, Long voucherEntryId) {
        return VoucherEditNoticeUtils.showNoticeOnVoucherEdit(voucherEditView, orgId, voucherEntryId, CFPANEL, "gl_cfnotice", "gl_cfnotice_relation");
    }

    private static int showACNoticeOnVoucherEdit(IFormView voucherEditView, Long orgId, Long voucherEntryId) {
        return VoucherEditNoticeUtils.showNoticeOnVoucherEdit(voucherEditView, orgId, voucherEntryId, ACPANEL, "gl_acnotice", "gl_acnotice_relation");
    }

    private static int showNoticeOnVoucherEdit(IFormView voucherEditView, Long orgId, Long voucherEntryId, String flexKey, String noticeEntity, String noticeCheckLogEntity) {
        if (null == voucherEditView) {
            return 0;
        }
        if (null == voucherEditView.getControl(flexKey)) {
            return 0;
        }
        if (null == orgId || orgId <= 0L) {
            return 0;
        }
        if (null == voucherEntryId || voucherEntryId <= 0L) {
            return 0;
        }
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("org", "=", (Object)orgId);
        qfBuilder.add("voucherentry", "=", (Object)voucherEntryId);
        DynamicObject ownNotice = QueryServiceHelper.queryOne((String)noticeEntity, (String)String.join((CharSequence)",", "id", "checkstatus"), (QFilter[])qfBuilder.toArray());
        if (null == ownNotice) {
            return 0;
        }
        List noticeIds = Collections.singletonList(ownNotice.get("id"));
        if ("1".equals(ownNotice.getString("checkstatus"))) {
            qfBuilder.clear();
            qfBuilder.add(NoticeData.ENTRY_ID_FIELD, "=", (Object)voucherEntryId);
            List checkLogPkValues = QueryServiceHelper.queryPrimaryKeys((String)noticeCheckLogEntity, (QFilter[])qfBuilder.toArray(), null, (int)1);
            if (checkLogPkValues.isEmpty()) {
                qfBuilder.clear();
                qfBuilder.add(NoticeData.OP_ENTRY_ID_FIELD, "=", (Object)voucherEntryId);
                checkLogPkValues = QueryServiceHelper.queryPrimaryKeys((String)noticeCheckLogEntity, (QFilter[])qfBuilder.toArray(), null, (int)1);
            }
            if (!checkLogPkValues.isEmpty()) {
                qfBuilder.clear();
                qfBuilder.add("id", "=", checkLogPkValues.get(0));
                HashSet<Long> checkedEntryIds = new HashSet<Long>(10);
                try (DataSet checkLogSet = QueryServiceHelper.queryDataSet((String)VoucherEditNoticeUtils.class.getName(), (String)noticeCheckLogEntity, (String)String.join((CharSequence)",", NoticeData.ENTRY_ID_FIELD, NoticeData.OP_ENTRY_ID_FIELD), (QFilter[])qfBuilder.toArray(), null);){
                    for (Row row : checkLogSet) {
                        checkedEntryIds.add(row.getLong(NoticeData.ENTRY_ID_FIELD));
                        checkedEntryIds.add(row.getLong(NoticeData.OP_ENTRY_ID_FIELD));
                    }
                }
                qfBuilder.clear();
                qfBuilder.add("org", "=", (Object)orgId);
                qfBuilder.add("voucherentry", "in", checkedEntryIds);
                noticeIds = QueryServiceHelper.queryPrimaryKeys((String)noticeEntity, (QFilter[])qfBuilder.toArray(), null, (int)-1);
            }
        }
        if (noticeIds.size() > 0) {
            voucherEditView.setVisible(Boolean.TRUE, new String[]{flexKey});
            FormShowParameter form = new FormShowParameter();
            form.setFormId("gl_voucher_notice");
            form.getOpenStyle().setShowType(ShowType.InContainer);
            form.getOpenStyle().setTargetKey(flexKey);
            form.setCustomParam("noticeids", noticeIds);
            form.setCustomParam("notice_entity", (Object)noticeEntity);
            voucherEditView.showForm(form);
        }
        return noticeIds.size();
    }
}

