/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.voucher;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.ThreadCache;
import kd.bos.context.OperationContext;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.EntryInfo;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.FlexEdit;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bd.consts.VoucherStatus;
import kd.fi.bd.service.balance.AppHelper;
import kd.fi.bd.util.BDUtil;
import kd.fi.gl.business.service.BatchReplacerFactory;
import kd.fi.gl.business.service.voucher.option.helper.VoucherArgConfigServiceHelper;
import kd.fi.gl.business.service.voucher.option.helper.VoucherCarryConfigServiceHelper;
import kd.fi.gl.business.service.voucher.option.key.ArgKey;
import kd.fi.gl.business.vo.voucher.IVoucherEntry;
import kd.fi.gl.business.vo.voucher.wrap.DynamicEntryWrap;
import kd.fi.gl.flex.FlexValue;
import kd.fi.gl.flex.FlexValueEntry;
import kd.fi.gl.format.UserFormatter;
import kd.fi.gl.formplugin.voucher.EpmMserviceInvoker;
import kd.fi.gl.formplugin.voucher.TemplateVoucherEditValueGetter;
import kd.fi.gl.formplugin.voucher.VoucherEditCacheManager;
import kd.fi.gl.formplugin.voucher.VoucherEditControlStateRecoder;
import kd.fi.gl.formplugin.voucher.VoucherEditLabelManager;
import kd.fi.gl.formplugin.voucher.VoucherEditServiceLoader;
import kd.fi.gl.formplugin.voucher.VoucherEditSummry;
import kd.fi.gl.formplugin.voucher.VoucherEditValueGetter;
import kd.fi.gl.util.AssgrpDefValUtil;
import kd.fi.gl.util.ContextUtil;
import kd.fi.gl.util.FlexUtils;
import kd.fi.gl.util.replace.CashFlowItemBatchReplacer;
import kd.fi.gl.wrap.DynWrapper;

public class VoucherEditView {
    private final IFormView vchFormView;
    private final IDataModel voucherEditModel;
    private final IPageCache pageCache;
    private final VoucherEditValueGetter valueGetter;
    private final VoucherEditCacheManager cacheManager;
    private final VoucherEditLabelManager labelManager;
    private final VoucherEditServiceLoader serviceLoader;
    private final VoucherEditControlStateRecoder controlStateRecoder;
    private UserFormatter userFormatter;
    private VoucherEditSummry voucherEditSummry;
    private static final String MODEL_INIT_LOADSPLITPAGE = "MODEL_INIT_LOADSPLITPAGE";
    private static final Predicate<FlexValueEntry> REMOVE_BANK = x -> {
        String valueSource = x.getFlexItem().getFlexProperty().getValueSource();
        return "bd_accountbanks".equals(valueSource) || "am_accountbank".equals(valueSource);
    };

    public VoucherEditView(IFormView vchFormView, IDataModel voucherEditModel, IPageCache pageCache) {
        this.vchFormView = vchFormView;
        this.voucherEditModel = voucherEditModel;
        this.pageCache = pageCache;
        this.valueGetter = this.createValueGetter(vchFormView.getEntityId(), voucherEditModel);
        this.cacheManager = new VoucherEditCacheManager(pageCache);
        this.labelManager = new VoucherEditLabelManager(vchFormView);
        this.controlStateRecoder = new VoucherEditControlStateRecoder(pageCache);
        this.serviceLoader = VoucherEditServiceLoader.create(this);
    }

    public IFormView getVchFormView() {
        return this.vchFormView;
    }

    public String getEntityId() {
        return this.vchFormView.getEntityId();
    }

    public boolean isFromTemplateVoucher() {
        return this.getEntityId().equals("gl_templatevoucher");
    }

    public IDataModel getVoucherEditModel() {
        return this.voucherEditModel;
    }

    protected IPageCache getPageCache() {
        return this.pageCache;
    }

    public VoucherEditValueGetter getValueGetter() {
        return this.valueGetter;
    }

    public VoucherEditCacheManager getCacheManager() {
        return this.cacheManager;
    }

    protected VoucherEditLabelManager getLabelManager() {
        return this.labelManager;
    }

    public <T> T getService(Class<? extends T> clazz) {
        return this.serviceLoader.getService(clazz);
    }

    private VoucherEditValueGetter createValueGetter(String formId, IDataModel model) {
        if ("gl_templatevoucher".equals(formId)) {
            return new TemplateVoucherEditValueGetter(model);
        }
        return new VoucherEditValueGetter(model);
    }

    protected UserFormatter getUserFormatter() {
        if (this.userFormatter == null) {
            this.userFormatter = new UserFormatter();
        }
        return this.userFormatter;
    }

    protected VoucherEditControlStateRecoder getControlStateRecoder() {
        return this.controlStateRecoder;
    }

    protected VoucherEditSummry getVoucherEditSummry() {
        if (this.voucherEditSummry == null) {
            this.voucherEditSummry = new VoucherEditSummry(this);
        }
        return this.voucherEditSummry;
    }

    protected EntryGrid getVoucherEntryGrid() {
        return (EntryGrid)this.vchFormView.getControl("entries");
    }

    protected boolean isEntryNeedPaged() {
        return this.getVoucherEntryGrid().isNeedPaged();
    }

    protected void setAccountChanged(Boolean value) {
        if (value == null) {
            this.getCacheManager().removeCache("acct-change");
        } else {
            this.getCacheManager().set("acct-change", value.toString());
        }
    }

    protected boolean isAccountChanged() {
        return Boolean.TRUE.toString().equals(this.getCacheManager().get("acct-change"));
    }

    protected SafeAutoCloseable setCopyingLine() {
        ThreadCache.put((Object)"VoucherEdit_Copying_Line", (Object)Boolean.TRUE);
        return () -> ThreadCache.remove((Object)"VoucherEdit_Copying_Line");
    }

    protected boolean isCopyingLine() {
        return ThreadCache.exists((Object)"VoucherEdit_Copying_Line");
    }

    protected SafeAutoCloseable setUpdatingVersion() {
        ThreadCache.put((Object)"VoucherEdit_updating_version", (Object)Boolean.TRUE);
        return () -> ThreadCache.remove((Object)"VoucherEdit_updating_version");
    }

    protected boolean isUpdatingVersion() {
        return ThreadCache.exists((Object)"VoucherEdit_updating_version");
    }

    protected boolean isFlippingPage() {
        return OperationContext.get() != null && "setPageIndex".equals(OperationContext.get().getOpMethod());
    }

    protected void setEpmShowBalanceBtnVisiable() {
        boolean isShowBalance = EpmMserviceInvoker.INSTANCE.isShowBalance("gl_voucher", this.getValueGetter().getOrgId());
        this.getVchFormView().setVisible(Boolean.valueOf(isShowBalance), new String[]{"btn_showepmbalance"});
    }

    public void setBudgetVisiable() {
        boolean enableBudget = this.valueGetter.isBudget();
        boolean canModify = VoucherStatus.canModify((DynamicObject)this.voucherEditModel.getDataEntity());
        boolean canEdit = this.vchFormView.getFormShowParameter().getStatus() != OperationStatus.VIEW;
        boolean enableSum = this.voucherEditModel.getEntryRowCount("entries") <= this.voucherEditModel.getEntryPageSize();
        this.vchFormView.setVisible(Boolean.valueOf(enableBudget), new String[]{"accountingtype"});
        this.vchFormView.setVisible(Boolean.valueOf(enableBudget && canModify && canEdit), new String[]{"generatebudget"});
        this.vchFormView.setVisible(Boolean.valueOf(enableBudget && enableSum), new String[]{"accountingtypesumpanel"});
    }

    protected int getEntryCurrentPageSize() {
        String splitPageProperty = AppHelper.getSystemProperty((String)"billmodel.splitpage", (String)Boolean.FALSE.toString());
        Object billSplitVariable = this.getVoucherEditModel().getContextVariable(MODEL_INIT_LOADSPLITPAGE);
        boolean billSplit = billSplitVariable != null && (Boolean)billSplitVariable != false;
        DynamicObjectCollection entryColl = this.getVoucherEditModel().getDataEntity(true).getDynamicObjectCollection("entries");
        EntryGrid entryGrid = (EntryGrid)this.getVchFormView().getControl("entries");
        if (entryGrid.isSplitPage() || Boolean.parseBoolean(splitPageProperty) || billSplit) {
            return Math.min(entryGrid.getPageRow(), entryColl.size());
        }
        return entryColl.size();
    }

    protected EntryInfo getEntryPageInfo() {
        return this.getVoucherEditModel().getEntryPageInfo("entries");
    }

    protected int getHeadRowIndex() {
        return this.getVoucherEditModel().getDataEntity().getDataEntityState().getEntryStartRowIndex("entries");
    }

    protected void triggerPropertyChanged(boolean isTrigger) {
        ThreadCache.put((Object)"voucher_edit_ignorePropertyChanged", (Object)isTrigger);
    }

    protected boolean isTriggerPropertyChanged() {
        return (Boolean)ThreadCache.get((Object)"voucher_edit_ignorePropertyChanged", () -> Boolean.TRUE);
    }

    protected void autoSetAssistValue(int rowIndex) {
        Map<String, Object> lastAssgrpValueMap;
        Map oldValueMap = this.valueGetter.getAssgrpValue(rowIndex);
        long currencyId = this.valueGetter.getCurrencyId(rowIndex);
        FlexValue flexValueBuf = new FlexValue(oldValueMap);
        flexValueBuf.remove(flexValueEntry -> AssgrpDefValUtil.removeIllegalFlexEntry((Long)this.valueGetter.getOrgId(), (Long)this.valueGetter.getBookTypeId(), (Long)currencyId, (FlexValueEntry)flexValueEntry));
        boolean isAutoFillAssgrep = this.isCarry("assgrp");
        if (isAutoFillAssgrep && rowIndex != 0 && !(lastAssgrpValueMap = this.valueGetter.getAssgrpValue(rowIndex - 1)).isEmpty()) {
            lastAssgrpValueMap.forEach((arg_0, arg_1) -> ((FlexValue)flexValueBuf).addIfAbsent(arg_0, arg_1));
            long lastCurrencyId = this.valueGetter.getCurrencyId(rowIndex - 1);
            if (currencyId != lastCurrencyId) {
                flexValueBuf.remove(REMOVE_BANK);
            }
        }
        oldValueMap = flexValueBuf.getFlexToValues();
        Object pk = AssgrpDefValUtil.getAssgrpDefVal((Long)this.valueGetter.getOrgId(), (Long)this.valueGetter.getBookTypeId(), (Long)this.valueGetter.getAccountTableId(), (Long)this.valueGetter.getSystemUserId(), (Long)this.valueGetter.getAccountId(rowIndex), (Long)currencyId, (Map)oldValueMap);
        if (pk != null) {
            this.voucherEditModel.setValue("assgrp", pk, rowIndex);
            FlexEdit flexEdit = (FlexEdit)this.getVchFormView().getControl("assgrp");
            flexEdit.setFlexModelValue(pk, rowIndex);
        } else {
            oldValueMap = this.valueGetter.getAssgrpValue(rowIndex);
            if (!oldValueMap.isEmpty()) {
                FlexValue flexValue = new FlexValue(oldValueMap);
                flexValue.remove(REMOVE_BANK);
                oldValueMap = flexValue.getFlexToValues();
                long newId = FlexUtils.saveFlexData((Map)oldValueMap);
                this.voucherEditModel.setValue("assgrp", (Object)newId, rowIndex);
                FlexEdit flexEdit = (FlexEdit)this.getVchFormView().getControl("assgrp");
                flexEdit.setFlexModelValue((Object)newId, rowIndex);
            }
        }
    }

    protected boolean unmodifiable() {
        String status = this.getValueGetter().getStatus();
        return this.getVchFormView().getFormShowParameter().getStatus() == OperationStatus.VIEW || "C".equals(status) || "D".equals(status) || "c".equals(this.getValueGetter().getCheckStatus()) || this.getValueGetter().isPost();
    }

    protected void setEntryAddAndDeleteIconVisible() {
        HashMap<String, Boolean> operateIconMap = new HashMap<String, Boolean>(1);
        boolean unmodifiable = this.unmodifiable();
        operateIconMap.put("hasOperateIcon", !unmodifiable);
        this.getVchFormView().updateControlMetadata("entries", operateIconMap);
        if (unmodifiable) {
            this.getVchFormView().setEnable(Boolean.valueOf(false), new String[]{"entries"});
        }
    }

    protected boolean isCarry(String entryField) {
        return VoucherCarryConfigServiceHelper.isCarry((long)this.getValueGetter().getOrgId(), (long)RequestContext.get().getCurrUserId(), (String)entryField);
    }

    protected <T> T getArgValue(ArgKey key) {
        return (T)VoucherArgConfigServiceHelper.getArgValue((long)this.getValueGetter().getOrgId(), (long)ContextUtil.getUserId(), (ArgKey)key);
    }

    protected void addRowIfEndOfEntry(int currentRowIndex) {
        if (currentRowIndex + 1 >= this.getValueGetter().getEntryCount()) {
            this.getVoucherEditModel().createNewEntryRow("entries");
        }
    }

    protected boolean doVersionReplacementForCashFlowItem() {
        CashFlowItemBatchReplacer cashFlowItemBatchReplacer = BatchReplacerFactory.createCombinedBatchReplacer((long)this.valueGetter.getOrgId(), (long)this.valueGetter.getPeriodId(), (boolean)false, (String)"maincfassgrp", (Long)this.valueGetter.getOrgId(), (Long)this.valueGetter.getBookTypeId());
        for (DynamicObject rowDyn : this.valueGetter.getVoucherEntries()) {
            cashFlowItemBatchReplacer.addReplace((IVoucherEntry)new DynamicEntryWrap(rowDyn));
        }
        Set changedRows = cashFlowItemBatchReplacer.finish();
        List changedRowDyns = BDUtil.extractToList((Collection)changedRows, DynWrapper::getDyn);
        if (!changedRowDyns.isEmpty()) {
            BusinessDataServiceHelper.loadRefence((Object[])changedRowDyns.toArray(new DynamicObject[0]), (IDataEntityType)((DynamicObject)changedRowDyns.get(0)).getDataEntityType());
            return true;
        }
        return false;
    }

    protected void updateEntriesViewAndRestoreIndex() {
        this.updateEntriesViewAndRestoreIndex(this.getValueGetter().getEntriesCurrentRowIndex());
    }

    protected void updateEntriesViewAndRestoreIndex(int index) {
        this.vchFormView.updateView("entries");
        this.getVoucherEntryGrid().selectRows(index);
    }

    public static interface SafeAutoCloseable
    extends AutoCloseable {
        @Override
        public void close();
    }
}

