/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.voucher;

import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.ImmutableMap;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.OperationContext;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.ControlFilter;
import kd.bos.entity.filter.ControlFilters;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.events.CloseQueryByOrEvent;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.ListColumnCompareTypesSetEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.Copy;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.bd.logger.ExtLogFactory;
import kd.fi.bd.service.balance.VoucherQueryUtils;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.common.CustomCompare;
import kd.fi.gl.common.VoucherAgainst;
import kd.fi.gl.formplugin.voucher.ViewInvoiceExecutor;
import kd.fi.gl.formplugin.voucher.VoucherListDataProvider;
import kd.fi.gl.listfilter.FilterContainerValues;
import kd.fi.gl.listfilter.FilterValues;
import kd.fi.gl.util.CommonAssistUtil;
import kd.fi.gl.util.ContextUtil;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.PermissonType;
import kd.fi.gl.util.QFBuilder;
import kd.fi.gl.util.SystemParamHelper;
import kd.fi.gl.util.TraceBizVoucherUtil;
import kd.fi.gl.util.VoucherNumCheckUtil;
import kd.fi.gl.util.VoucherUtil;
import kd.fi.gl.voucher.carryover.utils.BalanceCarryOverUtils;
import kd.fi.gl.voucher.operate.VoucherElecreceiptView;

public class VoucherList
extends AbstractListPlugin {
    private static final Log LOG = ExtLogFactory.getLog(VoucherList.class, (String)"VOUCHER_LIST");
    private static final Map<String, Object> ENABLE_FLIP_META = ImmutableMap.of((Object)"enabledChangePage", (Object)true);
    boolean hasBookstype = false;
    boolean hasPeriod = false;
    boolean hasOrg = false;
    private static final String IS_FIRST = "isFirst";
    private static final String CHECK_PERMISSION = "addattachtovoucher";
    private static final String ITEMKEY_VIEWINVOICE = "viewinvoice";
    private static final String OPKEY_IMAGEREVIEW = "imagereview";
    private static final String ITEMKEY_SHOWELECRECEIPT = "showelecreceipt";
    private static final String OPKEY_TRACEIMAGEVIEW = "traceimageview";
    private static final String OPKEY_VIEWBILLRELATION = "viewbillrelation";

    public void initialize() {
        super.initialize();
        if (!PermissionServiceHelper.checkPermission((long)ContextUtil.getUserId(), (String)"10", (String)"gl", (String)"gl_voucher", (String)"47150e89000000ac")) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"manageattach"});
        }
    }

    public void closeQueryByOr(CloseQueryByOrEvent e) {
        super.closeQueryByOr(e);
        e.setQueryByOr(false);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BillList billList = (BillList)this.getControl("billlistap");
        billList.addListRowFilterListeners(listRowFilterEvent -> this.getPageCache().put("isSetFilter", "false"));
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        LOG.info("VoucherList_ListDataProvider source_form parameter:" + formShowParameter.toString());
        args.setListDataProvider((IListDataProvider)new VoucherListDataProvider(this.getView()));
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        IListView view;
        ControlFilters cfs;
        Map map;
        super.filterContainerBeforeF7Select(args);
        String field = args.getFieldName();
        if (field.startsWith("org.")) {
            String entityId = ((ListView)this.getView()).getListModel().getEntityId();
            args.addCustomQFilter(AccSysUtil.getAccountingOrgFilter((String)entityId, (boolean)false, (PermissonType)PermissonType.VIEW));
        }
        if ((map = (cfs = (view = (IListView)this.getView()).getControlFilters()).getFilters()).containsKey("org.name")) {
            if (field.startsWith("account.") || field.startsWith("period.")) {
                ControlFilter cf = (ControlFilter)map.get("org.name");
                String type = cf.getCompareType();
                List vals = cf.getValue();
                if (vals.size() == 1 && !"".equals(vals.get(0).toString().trim())) {
                    QFilter filter = null;
                    if ("110".equals(type) || "111".equals(type)) {
                        filter = new QFilter("name", "=", vals.get(0));
                    } else if ("59".equals(type)) {
                        filter = new QFilter("name", "like", vals.get(0));
                    }
                    DynamicObject org = QueryServiceHelper.queryOne((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{filter});
                    if (null != org) {
                        QFilter orgId;
                        List val;
                        QFilter bf;
                        DynamicObject acctbook;
                        ControlFilter booktype;
                        if (field.startsWith("account.")) {
                            QFilter orgId2;
                            List val2;
                            QFilter bf2;
                            DynamicObject acctbook2;
                            QFilter acctFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)org.getLong("id"));
                            args.addCustomQFilter(acctFilter);
                            ControlFilter booktype2 = (ControlFilter)map.get("booktype.name");
                            if (null != booktype2 && null != (acctbook2 = QueryServiceHelper.queryOne((String)"gl_accountbook", (String)"accounttable", (QFilter[])new QFilter[]{bf2 = new QFilter("bookstype.name", "=", (val2 = booktype2.getValue()).get(0)), orgId2 = new QFilter("org", "=", (Object)org.getLong("id"))}))) {
                                QFilter faccttable = new QFilter("accounttable", "=", (Object)acctbook2.getLong("accounttable"));
                                args.addCustomQFilter(faccttable);
                            }
                        } else if (field.startsWith("period.") && null != (booktype = (ControlFilter)map.get("booktype.name")) && null != (acctbook = QueryServiceHelper.queryOne((String)"gl_accountbook", (String)"periodtype", (QFilter[])new QFilter[]{bf = new QFilter("bookstype.name", "=", (val = booktype.getValue()).get(0)), orgId = new QFilter("org", "=", (Object)org.getLong("id"))}))) {
                            QFilter fperiodtype = new QFilter("periodtype", "=", (Object)acctbook.getLong("periodtype"));
                            args.addCustomQFilter(fperiodtype);
                        }
                    }
                }
            }
        } else if (field.startsWith("booktype")) {
            List orgIds = GLUtil.getCustomFilterIds((IFormView)this.getView(), (String)"org.id");
            List bookTypeIdList = AccSysUtil.getBookTypeIdList((List)orgIds);
            args.addCustomQFilter(new QFilter("id", "in", (Object)bookTypeIdList));
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        IPageCache pageCache = this.getPageCache();
        pageCache.put("isSetFilter", "false");
        FilterContainerValues filterContainerValues = new FilterContainerValues(args.getFilterValues());
        List<FilterValues> customFilterValuesList = filterContainerValues.getCustomFilterValuesList();
        for (FilterValues filterValues : customFilterValuesList) {
            if (!filterValues.getFieldName().equalsIgnoreCase("booktype.id") || filterValues.unlimitedValue()) continue;
            List orgIds = GLUtil.getCustomFilterIds((IFormView)this.getView(), (String)"org.id");
            if (orgIds == null || orgIds.isEmpty()) break;
            List bookTypeComboList = AccSysUtil.getBookTypeCombo((List)orgIds);
            if (bookTypeComboList.isEmpty()) {
                filterValues.getValues().clear();
                filterValues.getValues().add("");
                break;
            }
            Set bookTypeSet = bookTypeComboList.stream().map(ComboItem::getValue).collect(Collectors.toSet());
            filterValues.getValues().removeIf(x -> !bookTypeSet.contains(x.toString()));
            if (!filterValues.getValues().isEmpty()) break;
            filterValues.getValues().add(((ComboItem)bookTypeComboList.get(0)).getValue());
            break;
        }
        List<FilterValues> schemeFilterValuesList = filterContainerValues.getSchemeFilterValuesList();
        for (FilterValues filterValues : schemeFilterValuesList) {
            if (!filterValues.getFieldName().startsWith("account")) continue;
            filterValues.removeId();
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    public void filterContainerAfterSearchClick(FilterContainerSearchClickArgs args) {
        QFilter orgFilter;
        Map curMap = args.getCurrentCommonFilter();
        if (null == curMap && null != (orgFilter = args.getQFilter("org.name")) && orgFilter.getCP().equals("=")) {
            this.getPageCache().put("orgQFilter", "true");
        }
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        if ("org.name".equals(args.getFieldName())) {
            FilterColumn column = (FilterColumn)args.getSource();
            String entityId = column.getEntityType().getName();
            QFilter filter = AccSysUtil.getAccountingOrgFilter((String)entityId, (boolean)false, (PermissonType)PermissonType.VIEW);
            args.getQFilters().add(filter);
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        boolean customAndInital = this.isCustomAndInital();
        List orgIds = GLUtil.getCustomFilterIds((IFormView)this.getView(), (String)"org.id");
        List listFilterColumns = args.getFilterContainerInitEvent().getCommonFilterColumns();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map paramMap = formShowParameter.getCustomParams();
        Iterator filterColumns = listFilterColumns.iterator();
        block12: while (filterColumns.hasNext()) {
            String fieldName;
            CommonFilterColumn commFilter = (CommonFilterColumn)filterColumns.next();
            switch (fieldName = commFilter.getFieldName()) {
                case "org.name": {
                    String defaultOrg = null;
                    if (paramMap.get("org") instanceof Collection) {
                        if (!StringUtils.isBlank((CharSequence)this.getPageCache().get(IS_FIRST)) && orgIds != null) break;
                        Collection orgIdList = (Collection)paramMap.get("org");
                        if (!CollectionUtils.isNotEmpty((Collection)orgIdList)) continue block12;
                        commFilter.setDefaultValues((Object[])orgIdList.toArray(new String[0]));
                        orgIds = orgIdList.stream().mapToLong(v -> Long.parseLong(v.toString())).boxed().collect(Collectors.toList());
                        break;
                    }
                    String orgFilterObjId = (String)paramMap.get("org");
                    if (orgFilterObjId != null) {
                        if (!"".equals(orgFilterObjId) && !"0".equals(orgFilterObjId)) {
                            defaultOrg = orgFilterObjId;
                        }
                        commFilter.setDefaultValue(defaultOrg);
                    } else {
                        long defaultOrgId = AccSysUtil.getDefaultOrgId((String)"gl_voucher", (boolean)false, (PermissonType)PermissonType.VIEW);
                        if (AccSysUtil.getAllOrgIdByComboItems((Collection)commFilter.getComboItems()).contains(defaultOrgId)) {
                            defaultOrg = String.valueOf(defaultOrgId);
                            commFilter.setDefaultValue(defaultOrg);
                        } else {
                            defaultOrg = this.getPageCache().get("defaultOrg");
                            if (defaultOrg != null) {
                                commFilter.setDefaultValue(defaultOrg);
                            }
                        }
                    }
                    this.getPageCache().put("defaultOrg", defaultOrg);
                    if (customAndInital) {
                        commFilter.setDefaultValue(defaultOrg);
                    }
                    if (!StringUtils.isBlank((CharSequence)this.getPageCache().get(IS_FIRST)) && orgIds != null) continue block12;
                    List defaultValue = commFilter.getDefaultValues();
                    orgIds = defaultValue.stream().mapToLong(v -> Long.parseLong(v.toString())).boxed().collect(Collectors.toList());
                    break;
                }
                case "booktype.name": {
                    List comboItems = AccSysUtil.getBookTypeCombo((List)orgIds);
                    commFilter.setComboItems(comboItems);
                    if (paramMap.get("booktype") instanceof Collection) {
                        if (!StringUtils.isBlank((CharSequence)this.getPageCache().get(IS_FIRST)) && orgIds != null) break;
                        Collection bookTypeList = (Collection)paramMap.get("booktype");
                        if (!CollectionUtils.isNotEmpty((Collection)bookTypeList)) continue block12;
                        commFilter.setDefaultValues((Object[])bookTypeList.toArray(new String[0]));
                        break;
                    }
                    String cusBookType = (String)paramMap.get("booktype");
                    String defBookType = comboItems.isEmpty() ? null : ((ComboItem)comboItems.get(0)).getValue();
                    List values = comboItems.stream().map(ComboItem::getValue).collect(Collectors.toList());
                    if (cusBookType != null && (values.contains(cusBookType) || "".equals(cusBookType))) {
                        defBookType = cusBookType;
                    }
                    commFilter.setDefaultValue(defBookType);
                    int bookTypeCount = AccSysUtil.getAllBookTypeCount();
                    if (bookTypeCount > 1) continue block12;
                    if (bookTypeCount == 1 && StringUtils.isNotBlank((CharSequence)defBookType)) {
                        this.getPageCache().put("bookstype", defBookType);
                    }
                    filterColumns.remove();
                    break;
                }
                case "billstatus": {
                    if (!customAndInital) break;
                    ArrayList<String> mulStatus = new ArrayList<String>();
                    Object statusObj = paramMap.get("status");
                    if (statusObj instanceof JSONArray) {
                        JSONArray j = (JSONArray)statusObj;
                        Object[] array = j.toArray();
                        Collections.addAll(mulStatus, array);
                    } else {
                        String status = (String)statusObj;
                        if (kd.bos.util.StringUtils.isNotEmpty((String)status)) {
                            mulStatus.add(status);
                        }
                    }
                    if (mulStatus.isEmpty()) continue block12;
                    commFilter.setDefaultValues(mulStatus);
                    break;
                }
                case "bookeddate": {
                    if (this.getPageCache().get(IS_FIRST) != null) break;
                    Object bookeddate = paramMap.get("bookeddate");
                    if (bookeddate instanceof JSONArray) {
                        JSONArray j = (JSONArray)bookeddate;
                        Object[] array = j.toArray();
                        ArrayList l = new ArrayList(array.length);
                        Collections.addAll(l, array);
                        commFilter.setDefaultValues(l);
                        break;
                    }
                    String defaultBookDate = "";
                    if (!customAndInital && !"gl_periodclosedetails".equals(formShowParameter.getParentFormId())) continue block12;
                    commFilter.setDefaultValue(defaultBookDate);
                    break;
                }
            }
        }
        if (this.getPageCache().get(IS_FIRST) == null) {
            this.getPageCache().put(IS_FIRST, "false");
        }
    }

    private boolean isMatchCondition() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map paramMap = formShowParameter.getCustomParams();
        boolean flag = false;
        String key = (String)paramMap.get("source");
        if (key != null) {
            LOG.info("VoucherList_source=" + key);
            switch (key) {
                case "GLIndexMulOrgPlugin": 
                case "CashFlowDesignate": 
                case "RecordedCenterPlugin": 
                case "AdjustExchangeRateList": 
                case "TransPLProgramsList": 
                case "PeriodCloseDetail": 
                case "VoucherAmortScheme": 
                case "AutoTransCreateVoucher": 
                case "GLUtil": 
                case "VoucherSummaryFormRpt": {
                    flag = true;
                    break;
                }
            }
        }
        return flag;
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        Object id;
        DynamicObject voucher;
        Long orgId;
        boolean isView;
        super.beforeShowBill(e);
        BillShowParameter param = e.getParameter();
        if (OperationStatus.ADDNEW == param.getStatus()) {
            List bookTypeList = GLUtil.getCustomFilterIds((IFormView)this.getView(), (String)"booktype.id");
            Long bookType = bookTypeList == null || bookTypeList.isEmpty() ? null : (Long)bookTypeList.get(0);
            param.setCustomParam("booktype", (Object)bookType);
            Object pkId = param.getPkId();
            if (null == pkId) {
                boolean isSelectSingleBookType;
                List orgIdList = GLUtil.getCustomFilterIds((IFormView)this.getView(), (String)"org.id");
                boolean isSelectSingleOrg = orgIdList != null && orgIdList.size() == 1 && (Long)orgIdList.get(0) != 0L;
                boolean bl = isSelectSingleBookType = bookTypeList != null && bookTypeList.size() == 1 && (Long)bookTypeList.get(0) != 0L;
                if (isSelectSingleOrg && isSelectSingleBookType) {
                    Long orgId2 = (Long)orgIdList.get(0);
                    Long bookTypeId = (Long)bookTypeList.get(0);
                    QFBuilder qfBuilder = new QFBuilder();
                    qfBuilder.add("org", "=", (Object)orgId2);
                    qfBuilder.add("bookstype", "=", (Object)bookTypeId);
                    DynamicObject accountBookDynObj = BusinessDataServiceHelper.loadSingleFromCache((String)"gl_accountbook", (String)"enable", (QFilter[])qfBuilder.toArray());
                    if (accountBookDynObj != null && !accountBookDynObj.getBoolean("enable")) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u62e9\u7684\u7ec4\u7ec7\u548c\u8d26\u7c3f\u7c7b\u578b\u7684\u8d26\u7c3f\u5df2\u7ecf\u7981\u7528\uff0c\u4e0d\u80fd\u65b0\u589e\u51ed\u8bc1\u3002", (String)"VoucherList_6", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                        e.setCancel(Boolean.TRUE.booleanValue());
                    }
                }
            } else {
                String bookEnableField = String.join((CharSequence)".", "book", "enable");
                DynamicObject voucherDynObj = BusinessDataServiceHelper.loadSingleFromCache((Object)pkId, (String)"gl_voucher", (String)String.join((CharSequence)",", bookEnableField, "sourcetype"));
                if (voucherDynObj != null && !voucherDynObj.getBoolean(bookEnableField)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u62e9\u51ed\u8bc1\u7684\u8d26\u7c3f\u5df2\u7ecf\u7981\u7528\uff0c\u4e0d\u80fd\u590d\u5236\u3002", (String)"VoucherList_7", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    e.setCancel(Boolean.TRUE.booleanValue());
                } else if (BalanceCarryOverUtils.isCarryOverVoucher((DynamicObject)voucherDynObj)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u590d\u5236\u5931\u8d25\uff0c\u4f59\u989d\u7ed3\u8f6c\u7684\u51ed\u8bc1\u4e0d\u80fd\u8fdb\u884c\u590d\u5236\u64cd\u4f5c\u3002", (String)"VoucherList_8", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    e.setCancel(Boolean.TRUE.booleanValue());
                }
            }
        } else if (OperationStatus.EDIT == param.getStatus() && (isView = GLUtil.getEnableBizVoucherBySysParam((Long)(orgId = Long.valueOf((voucher = BusinessDataServiceHelper.loadSingle((Object)(id = param.getPkId()), (String)"gl_voucher", (String)"org.id,sourcetype")).getLong("org.id"))))) && "4".equals(voucher.getString("sourcetype"))) {
            param.setStatus(OperationStatus.VIEW);
        }
    }

    private boolean isCustomAndInital() {
        if (!this.isMatchCondition()) {
            return false;
        }
        return !StringUtils.isNotBlank((CharSequence)this.getPageCache().get(IS_FIRST));
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("tblreverse".equals(itemKey)) {
            this.voucherReverse();
        } else if ("printsetting".equals(itemKey)) {
            VoucherUtil.showPrintSetting(this.getView());
        } else if ("tracebizvoucher".equals(itemKey)) {
            this.showBizVoucherPage();
        }
        if ("brokennumbercheck".equals(itemKey) && new VoucherNumCheckUtil((AbstractFormPlugin)this).beforeCheckBreakPoint()) {
            this.showVoucherBpForm();
        }
        if (ITEMKEY_VIEWINVOICE.equals(itemKey)) {
            if (this.checkSelected(itemKey)) {
                ViewInvoiceExecutor.getINSTANCE().execute(this.getView());
            }
        } else if (ITEMKEY_SHOWELECRECEIPT.equals(itemKey) && this.checkSelected(itemKey)) {
            BillList voucerList = (BillList)this.getView().getControl("billlistap");
            ListSelectedRowCollection selectedRows = voucerList.getSelectedRows();
            Long vchId = (Long)selectedRows.get(0).getPrimaryKeyValue();
            new VoucherElecreceiptView(this.getView()).showElecReceipt(vchId);
        }
    }

    private void showVoucherBpForm() {
        ListShowParameter parame = new ListShowParameter();
        parame.setBillFormId("gl_vouchernoadjust_layout");
        parame.setFormId("gl_vouchernolist");
        parame.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "adjustBreakPoint"));
        parame.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("check_broken_origin_form", "origin_form_vch_list");
        map.put("orgBookTypePeriodList", this.getPageCache().get("orgBookTypePeriodList"));
        map.put("orgAndBooksForPointList", this.getPageCache().get("orgAndBooksForPointList"));
        parame.setCustomParams(map);
        this.getView().showForm((FormShowParameter)parame);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IPageCache pageCache = this.getPageCache();
        String pageId = pageCache.getPageId();
        if (!pageId.equals(pageCache.get("afterCreateNewData_flag" + pageId))) {
            pageCache.put("afterCreateNewData_flag" + pageId, pageId);
        }
    }

    private boolean checkQueryPermission() {
        int permission = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (Long)Long.parseLong("0"), (String)"gl", (String)"gl_voucherbreakpoint", (String)PermissonType.VIEW.getPermId());
        if (permission == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u51ed\u8bc1\u65ad\u53f7\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PeriodcloseHomePlugin_13", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void showBizVoucherPage() {
        BillList billList = (BillList)this.getControl("BillListAp");
        ListSelectedRowCollection listCol = billList.getSelectedRows();
        if (listCol.size() == 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u8054\u67e5\u7684\u6570\u636e\u3002", (String)"VoucherList_14", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        HashSet glVoucherIds = new HashSet(100);
        HashMap<Long, Set> map = new HashMap<Long, Set>();
        ArrayList orgList = new ArrayList();
        for (ListSelectedRow row : listCol) {
            Long orgId = row.getMainOrgId();
            Long id = (Long)row.getPrimaryKeyValue();
            Set voucherIds = map.computeIfAbsent(orgId, k -> new HashSet());
            voucherIds.add(id);
        }
        for (Map.Entry entry : map.entrySet()) {
            if (GLUtil.getEnableBizVoucherBySysParam((Long)((Long)entry.getKey()))) {
                glVoucherIds.addAll((Collection)entry.getValue());
                continue;
            }
            orgList.add(entry.getKey());
        }
        if (!orgList.isEmpty()) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u6253\u5f00\u4e8b\u4ef6\u5e93\u7684\u7ec4\u7ec7\uff0c\u65e0\u6cd5\u8054\u67e5\u3002", (String)"VoucherList_15", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        TraceBizVoucherUtil.showBizVoucherPage((IFormView)this.getView(), glVoucherIds);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate source = (AbstractOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if (OPKEY_IMAGEREVIEW.equals(operateKey) || OPKEY_TRACEIMAGEVIEW.equals(operateKey) || OPKEY_VIEWBILLRELATION.equals(operateKey)) {
            if (!this.checkSelected(operateKey)) {
                args.setCancel(true);
            }
        } else if ("manageattach".equalsIgnoreCase(operateKey)) {
            BillList voucerList = (BillList)this.getView().getControl("billlistap");
            ListSelectedRowCollection selectedRows = voucerList.getSelectedRows();
            if (selectedRows.isEmpty()) {
                args.setCancel(true);
                return;
            }
            Set voucerIds = selectedRows.stream().map(x -> x.getPrimaryKeyValue()).collect(Collectors.toSet());
            if (0 == PermissionServiceHelper.checkPermission((Long)ContextUtil.getUserId(), (Long)selectedRows.get(0).getMainOrgId(), (String)"10", (String)"gl", (String)"gl_voucher", (String)"1MG7VC679AW5")) {
                args.setCancel(true);
                return;
            }
            if (voucerIds.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5355\u5f20\u51ed\u8bc1\u9644\u4ef6\u7ba1\u7406\u3002", (String)"VoucherList_9", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            String checkRes = this.checkCurrVoucher(selectedRows);
            if (StringUtils.isNotBlank((CharSequence)checkRes)) {
                this.getView().showTipNotification(checkRes);
                args.setCancel(true);
            }
        }
        if (args.getSource() instanceof Copy) {
            VoucherUtil.copyLimit(this.getView(), args);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String name = afterDoOperationEventArgs.getOperateKey();
        if (("voucheragainst".equals(name) || "bluewriteoff".equals(name)) && !((IListView)this.getView()).getSelectedRows().isEmpty()) {
            ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
            OperationResult result = afterDoOperationEventArgs.getOperationResult();
            if (result.isSuccess()) {
                List successPkIds = result.getSuccessPkIds();
                VoucherAgainst.openVoucher((IFormView)this.getView(), (Collection)successPkIds);
            }
        } else if ("manageattach".equalsIgnoreCase(name) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            BillList voucerList = (BillList)this.getView().getControl("billlistap");
            ListSelectedRowCollection selectedRows = voucerList.getSelectedRows();
            if (selectedRows.isEmpty()) {
                return;
            }
            FormShowParameter manageAttachForm = new FormShowParameter();
            HashMap<String, Object> manageAttachParam = new HashMap<String, Object>(8);
            manageAttachParam.put("formId", "gl_voucher");
            manageAttachParam.put("voucherId", selectedRows.get(0).getPrimaryKeyValue());
            manageAttachParam.put("attachKey", "attachmentpanel");
            manageAttachParam.put("billStatus", selectedRows.get(0).getBillStatus());
            manageAttachParam.put("org", selectedRows.get(0).getMainOrgId());
            manageAttachParam.put("billNumber", selectedRows.get(0).getBillNo());
            manageAttachForm.setFormId("gl_manageattach");
            manageAttachForm.getOpenStyle().setShowType(ShowType.Modal);
            manageAttachForm.setCustomParam("params", (Object)SerializationUtils.toJsonString(manageAttachParam));
            this.getView().showForm(manageAttachForm);
        }
    }

    private void voucherReverse() {
        BillList billList = (BillList)this.getControl("BillListAp");
        ListSelectedRowCollection listCol = billList.getSelectedRows();
        if (listCol.isEmpty()) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u9700\u9009\u62e9\u4e00\u884c!", (String)"VoucherList_2", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        Long selectID = (Long)listCol.get(0).getPrimaryKeyValue();
        QFilter f1 = new QFilter("id", "=", (Object)selectID);
        QFilter f2 = new QFilter("billstatus", "=", (Object)"C");
        DynamicObject o = ORM.create().queryOne("gl_voucher", "id,period,book", new QFilter[]{f1, f2});
        if (o == null) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bb0\u8d26\u51ed\u8bc1\u624d\u5141\u8bb8\u51b2\u9500\u3002", (String)"VoucherList_3", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        BillShowParameter sp = new BillShowParameter();
        sp.setBillStatusValue(Integer.valueOf(0));
        sp.setCaption(ResManager.loadKDString((String)"\u51ed\u8bc1-\u51b2\u9500", (String)"VoucherList_4", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        sp.getCustomParams().put("id", selectID);
        sp.getCustomParams().put("isreverse", true);
        this.showForm((FormShowParameter)sp);
    }

    private void showForm(FormShowParameter param) {
        param.setFormId("gl_voucher");
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(param);
    }

    private void handlFilter(List<QFilter> dateFilters, List<QFilter.QFilterNest> nests) {
        if (nests == null) {
            return;
        }
        for (QFilter.QFilterNest nest : nests) {
            List nests2;
            QFilter f = nest.getFilter();
            String property = f.getProperty();
            if (property != null) {
                if (property.startsWith("booktype")) {
                    this.hasBookstype = true;
                } else if (property.startsWith("period")) {
                    this.hasPeriod = true;
                } else if (property.startsWith("org")) {
                    this.hasOrg = true;
                } else if ("bookeddate".equals(f.getProperty())) {
                    dateFilters.add(new QFilter("bookeddate", f.getCP(), f.getValue()));
                }
            }
            if ((nests2 = f.getNests(false)) == null || nests2.isEmpty()) continue;
            this.handlFilter(dateFilters, nests2);
        }
    }

    public void setFilter(SetFilterEvent e) {
        String filterStr;
        super.setFilter(e);
        List qFilters = e.getQFilters();
        List orgIds = new ArrayList(1);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map paramMap = formShowParameter.getCustomParams();
        ArrayList<QFilter> dateFilters = new ArrayList();
        String sysProperty = System.getProperty("orm.crossdb.enable");
        if (!"true".equals(sysProperty)) {
            List distinctFilterList = VoucherQueryUtils.distinctToFilterList((QFilter[])qFilters.toArray(new QFilter[0]));
            dateFilters = VoucherQueryUtils.getFilterMatchAndNestsAllMatchFilterList((List)distinctFilterList, x -> "bookeddate".equals(x.getProperty()));
            for (QFilter f : distinctFilterList) {
                String property = f.getProperty();
                if (property == null) continue;
                if (property.startsWith("booktype")) {
                    this.hasBookstype = true;
                    continue;
                }
                if (property.startsWith("period")) {
                    this.hasPeriod = true;
                    continue;
                }
                if (!property.startsWith("org")) continue;
                this.hasOrg = true;
            }
        } else if (qFilters != null && !qFilters.isEmpty()) {
            QFilter f = (QFilter)qFilters.get(0);
            String property = f.getProperty();
            if (property != null) {
                if (property.startsWith("booktype")) {
                    this.hasBookstype = true;
                } else if (property.startsWith("period")) {
                    this.hasPeriod = true;
                } else if (property.startsWith("org")) {
                    this.hasOrg = true;
                } else if ("bookeddate".equals(f.getProperty())) {
                    dateFilters.add(new QFilter("bookeddate", f.getCP(), f.getValue()));
                }
            }
            List nests = f.getNests(false);
            this.handlFilter(dateFilters, nests);
        }
        if (!this.hasPeriod && !dateFilters.isEmpty()) {
            qFilters.add(new QFilter("period", "in", this.getPeriodIdSet(dateFilters)));
        }
        if (!this.hasOrg && e.getMainOrgQFilter() == null) {
            String entityId = ((BillList)e.getSource()).getEntityType().getName();
            orgIds = AccSysUtil.getAcctOrgPkList((String)entityId, (boolean)false, (PermissonType)PermissonType.VIEW);
            qFilters.add(new QFilter("org", "in", orgIds));
        }
        if (!this.hasBookstype) {
            if (this.getPageCache().get("bookstype") != null) {
                qFilters.add(new QFilter("booktype", "=", (Object)Long.valueOf(this.getPageCache().get("bookstype"))));
            } else {
                if (orgIds.isEmpty()) {
                    orgIds = GLUtil.getCustomFilterIds((IFormView)this.getView(), (String)"org.id");
                }
                List bookTypeIds = AccSysUtil.getBookTypeDataPermission(orgIds);
                qFilters.add(new QFilter("booktype", "in", (Object)bookTypeIds));
            }
        }
        LOG.info("VoucherList_preset filter = {}", (Object)qFilters);
        if (this.isMatchCondition() && this.getPageCache().get("isSetFilter") == null && StringUtils.isNotBlank((CharSequence)(filterStr = (String)paramMap.get("filter")))) {
            QFilter filter = QFilter.fromSerializedString((String)filterStr);
            qFilters.clear();
            LOG.info("VoucherList_reset filter on forward page={}", (Object)filter);
            qFilters.add(filter);
        }
    }

    private Set<Long> getPeriodIdSet(List<QFilter> dateFilters) {
        List periodDateFilterList = VoucherQueryUtils.transFilterList(dateFilters, x -> new QFilter(x.getCP().startsWith(">") ? "enddate" : "begindate", x.getCP(), x.getValue()));
        return QueryServiceHelper.queryPrimaryKeys((String)"bd_period", (QFilter[])periodDateFilterList.toArray(new QFilter[0]), null, (int)-1).stream().map(x -> Long.valueOf(x.toString())).collect(Collectors.toSet());
    }

    private long[] processId(HyperLinkClickArgs args) {
        long id = 0L;
        long entryId = 0L;
        HyperLinkClickEvent hyperEvt = args.getHyperLinkClickEvent();
        BillList list = (BillList)hyperEvt.getSource();
        int rowIndex = args.getRowIndex();
        ListSelectedRowCollection col = list.getSelectedRows();
        for (ListSelectedRow r : col) {
            if (r.getRowKey() != rowIndex) continue;
            id = (Long)r.getPrimaryKeyValue();
            entryId = (Long)r.getEntryPrimaryKeyValue();
            break;
        }
        return new long[]{id, entryId};
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldName;
        HyperLinkClickEvent hyperEvt = args.getHyperLinkClickEvent();
        switch (fieldName = hyperEvt.getFieldName()) {
            case "account_number": {
                long[] ids = this.processId(args);
                if (ids[0] == 0L || ids[1] == 0L) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8054\u67e5\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"VoucherList_5", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    return;
                }
                args.setCancel(true);
                DynamicObject voucher = BusinessDataServiceHelper.loadSingle((Object)ids[0], (String)"gl_voucher");
                DynamicObjectCollection entries = voucher.getDynamicObjectCollection("entries");
                long acctId = 0L;
                long curId = 0L;
                long accountTableId = 0L;
                for (DynamicObject obj : entries) {
                    if (obj.getLong("id") != ids[1]) continue;
                    acctId = obj.getLong("account_id");
                    curId = obj.getLong("currency_id");
                    DynamicObject account = obj.getDynamicObject("account");
                    accountTableId = account.getLong("accounttable_id");
                    break;
                }
                VoucherUtil.hyperSublidger(voucher, acctId, curId, this.getView(), accountTableId);
                break;
            }
            case "assgrp": {
                long[] ids = this.processId(args);
                if (ids[0] == 0L || ids[1] == 0L) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8054\u67e5\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"VoucherList_5", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    return;
                }
                args.setCancel(true);
                DynamicObject voucher = BusinessDataServiceHelper.loadSingle((Object)ids[0], (String)"gl_voucher");
                DynamicObjectCollection entries = voucher.getDynamicObjectCollection("entries");
                DynamicObject assgrp = null;
                BigDecimal qty = null;
                long acctId = 0L;
                long curId = 0L;
                long accountTableId = 0L;
                for (DynamicObject obj : entries) {
                    if (obj.getLong("id") != ids[1]) continue;
                    acctId = obj.getLong("account_id");
                    curId = obj.getLong("currency_id");
                    assgrp = obj.getDynamicObject("assgrp");
                    qty = obj.getBigDecimal("quantity");
                    DynamicObject account = obj.getDynamicObject("account");
                    accountTableId = account.getLong("accounttable_id");
                    break;
                }
                VoucherUtil.hyperSubsidiaryledger(voucher, acctId, curId, assgrp, qty, this.getView(), accountTableId);
                break;
            }
        }
    }

    private String checkCurrVoucher(ListSelectedRowCollection selectedRows) {
        if (!"C".equalsIgnoreCase(selectedRows.get(0).getBillStatus())) {
            return ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5ba1\u6838\u540e\u7684\u51ed\u8bc1\u8fdb\u884c\u9644\u4ef6\u4e0a\u4f20\u3002", (String)"VoucherList_11", (String)"fi-gl-formplugin", (Object[])new Object[0]);
        }
        if (SystemParamHelper.getBooleanParam((String)CHECK_PERMISSION, (long)selectedRows.get(0).getMainOrgId(), (boolean)false)) {
            String voucherId = String.valueOf(selectedRows.get(0).getPrimaryKeyValue());
            if (this.checkFiling(Long.parseLong(voucherId))) {
                return ResManager.loadKDString((String)"\u5f53\u524d\u51ed\u8bc1\u5df2\u5f52\u6863\uff0c\u4e0d\u5141\u8bb8\u53d8\u66f4\u9644\u4ef6\u4fe1\u606f\u3002", (String)"VoucherList_12", (String)"fi-gl-formplugin", (Object[])new Object[0]);
            }
        } else {
            return ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u672a\u52fe\u9009\u2018\u5df2\u5ba1\u6838\u51ed\u8bc1\u5141\u8bb8\u8865\u5145\u9644\u4ef6\u2019\u53c2\u6570\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\u914d\u7f6e\u3002", (String)"VoucherList_13", (String)"fi-gl-formplugin", (Object[])new Object[0]);
        }
        return "";
    }

    private boolean checkFiling(long id) {
        QFilter fvchId = new QFilter("billid", "=", (Object)id);
        QFilter fstatus = new QFilter("type ", "=", (Object)"1");
        return QueryServiceHelper.exists((String)"aef_acelre", (QFilter[])new QFilter[]{fvchId, fstatus});
    }

    public void afterBindData(EventObject e) {
        this.getView().updateControlMetadata("billlistap", ENABLE_FLIP_META);
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        List bookTypeIds;
        IListColumn accountingTypeColumn = args.getListColumn("accountingtype");
        if (Objects.isNull(accountingTypeColumn) || Objects.isNull(OperationContext.get())) {
            return;
        }
        List orgIds = CommonAssistUtil.getOrgCommonFilterColumnValues((IFormView)this.getView(), (String)"org");
        if (!AccSysUtil.existsBudgetBook((Collection)orgIds, (Collection)(bookTypeIds = CommonAssistUtil.getBookTypeCommonFilterColumnValues((IFormView)this.getView(), (String)"booktype")))) {
            accountingTypeColumn.setVisible(0);
            args.getListColumns().remove(accountingTypeColumn);
            return;
        }
        if (!"listFieldsControl".equals(OperationContext.get().getOpMethod())) {
            accountingTypeColumn.setCaption(new LocaleString(""));
        }
    }

    public void listColumnCompareTypesSet(ListColumnCompareTypesSetEvent args) {
        super.listColumnCompareTypesSet(args);
        if ("bookeddate".equals(args.getListFieldKey())) {
            args.getListColumnCompareTypes().removeIf(type -> CustomCompare.isCustomCompare(type.getId()));
        }
    }

    private boolean checkSelected(String key) {
        String billStatus;
        BillList voucerList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = voucerList.getSelectedRows();
        Set voucerIds = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toSet());
        String viewInvoiceMsg = ResManager.loadKDString((String)"\u53d1\u7968", (String)"VoucherList_19", (String)"fi-gl-formplugin", (Object[])new Object[0]);
        String imageReviewMsg = ResManager.loadKDString((String)"\u5f71\u50cf", (String)"VoucherList_20", (String)"fi-gl-formplugin", (Object[])new Object[0]);
        String showElecReceiptMsg = ResManager.loadKDString((String)"\u56de\u5355", (String)"VoucherList_21", (String)"fi-gl-formplugin", (Object[])new Object[0]);
        if (voucerIds.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"VoucherList_18", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (voucerIds.size() != 1) {
            String msg = "";
            if (ITEMKEY_VIEWINVOICE.equals(key)) {
                msg = viewInvoiceMsg;
            } else if (OPKEY_IMAGEREVIEW.equals(key)) {
                msg = imageReviewMsg;
            } else if (ITEMKEY_SHOWELECRECEIPT.equals(key)) {
                msg = showElecReceiptMsg;
            } else if (OPKEY_TRACEIMAGEVIEW.equals(key)) {
                msg = ResManager.loadKDString((String)"\u5f52\u6863\u5f71\u50cf", (String)"VoucherList_22", (String)"fi-gl-formplugin", (Object[])new Object[0]);
            } else if (OPKEY_VIEWBILLRELATION.equals(key)) {
                msg = ResManager.loadKDString((String)"\u5355\u636e\u5173\u7cfb\u56fe", (String)"VoucherList_25", (String)"fi-gl-formplugin", (Object[])new Object[0]);
            }
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5355\u5f20\u51ed\u8bc1\u67e5\u770b%1$s\u3002", (String)"VoucherList_17", (String)"fi-gl-formplugin", (Object[])new Object[0]), msg));
            return false;
        }
        if (OPKEY_TRACEIMAGEVIEW.equals(key)) {
            Long vouchId = (Long)selectedRows.get(0).getPrimaryKeyValue();
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(3);
            qFilters.add(new QFilter("billid", "=", (Object)vouchId));
            qFilters.add(new QFilter("billtype.number", "=", (Object)"gl_voucher"));
            qFilters.add(new QFilter("type", "=", (Object)"1"));
            boolean exsitImage = QueryServiceHelper.exists((String)"aef_acelre", (QFilter[])qFilters.toArray(new QFilter[0]));
            if (!exsitImage) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u51ed\u8bc1\u6682\u672a\u5f52\u6863\uff0c\u65e0\u6cd5\u67e5\u770b\u5f52\u6863\u5f71\u50cf\u3002", (String)"VoucherList_23", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                return false;
            }
        } else if ((ITEMKEY_VIEWINVOICE.equals(key) || OPKEY_IMAGEREVIEW.equals(key) || ITEMKEY_SHOWELECRECEIPT.equals(key)) && "A".equals(billStatus = selectedRows.get(0).getBillStatus())) {
            String msg = "";
            msg = ITEMKEY_VIEWINVOICE.equals(key) ? viewInvoiceMsg : (OPKEY_IMAGEREVIEW.equals(key) ? imageReviewMsg : showElecReceiptMsg);
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6682\u5b58\u51ed\u8bc1\u4e0d\u652f\u6301\u67e5\u770b%1$s\u3002", (String)"VoucherList_24", (String)"fi-gl-formplugin", (Object[])new Object[0]), msg));
            return false;
        }
        return true;
    }
}

