/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.voucher;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoContext;
import kd.bos.context.OperationContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.list.IQuery;
import kd.bos.entity.list.QueryBuilder;
import kd.bos.entity.list.QueryResult;
import kd.bos.entity.list.SummaryResult;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.fi.bd.logger.ExtLogFactory;
import kd.fi.bd.util.BillParamUtil;
import kd.fi.bd.util.PerformanceWatch;
import kd.fi.bd.vo.CommonAssist;
import kd.fi.gl.comassist.model.ComAssistTable;
import kd.fi.gl.comassist.service.ComAssistService;
import kd.fi.gl.formplugin.comassist.ComAssistListDataProvider;
import kd.fi.gl.formplugin.voucher.VoucherIdQuery;
import kd.fi.gl.formplugin.voucher.list.VoucherListSummaryHelper;
import kd.fi.gl.formplugin.voucher.list.ctx.VoucherListContext;
import kd.fi.gl.formplugin.voucher.list.enhancer.VoucherListContextEnhancer;
import kd.fi.gl.formplugin.voucher.list.enums.QueryType;
import kd.fi.gl.formplugin.voucher.list.query.VoucherQueryFactory;
import kd.fi.gl.formplugin.voucher.list.utils.PageUtil;
import kd.fi.gl.util.BudgetPropExtender;
import kd.fi.gl.voucher.count.VoucherCountHelper;

public class VoucherListDataProvider
extends ComAssistListDataProvider {
    private static final Log LOG = ExtLogFactory.getLog(VoucherListDataProvider.class, (String)"VOUCHER_LIST_QUERY_");
    private final IFormView view;
    private IQuery iQuery = new VoucherIdQuery();
    private final Set<QueryBuilder> processedQueryBuilderSet = new HashSet<QueryBuilder>(4);
    private VoucherListContext ctx;
    private static final String ENTRIES_PREFIX = "entries.";

    public VoucherListDataProvider(IFormView view) {
        super(view);
        this.view = view;
    }

    protected boolean isOnlyPK4SelectedAllRows() {
        return BillParamUtil.getBooleanValue((String)"83bfebc8000017ac", (String)"fi.gl.voucher.query.isOnlyPK4SelectedAllRows", (boolean)true);
    }

    public QueryBuilder getQueryBuilder() {
        List orgIds;
        QueryBuilder queryBuilder = super.getQueryBuilder();
        if (this.processedQueryBuilderSet.add(queryBuilder) && this.view != null && !CollectionUtils.isEmpty((Collection)(orgIds = JSON.parseArray((String)this.view.getPageCache().get("alluseorg"), Long.class)))) {
            ComAssistTable.get((Long)((Long)orgIds.get(0)), (Long)this.getBookTypeID(this.getEntityType().getName())).ifPresent(comAssistTable -> comAssistTable.getCommonAssists().forEach(commonAssist -> {
                ArrayList<QFilter> filters = new ArrayList<QFilter>(Arrays.asList(queryBuilder.getFilters()));
                ComAssistService.getDataPermIds((CommonAssist)commonAssist, (List)orgIds, (String)"id").ifPresent(ids -> filters.add(new QFilter(ENTRIES_PREFIX + commonAssist.key, "in", ids)));
                queryBuilder.setFilters(filters.toArray(new QFilter[0]));
            }));
        }
        return queryBuilder;
    }

    protected boolean isRegisterProperty() {
        return true;
    }

    protected VoucherListContext getCtx() {
        return this.ctx;
    }

    protected VoucherListContext initCtx() {
        this.ctx = new VoucherListContext();
        this.ctx.setQueryBuilder(this.getQueryBuilder());
        this.ctx.setEntityType(this.getEntityType());
        this.ctx.setDataEntityTypes(this.getDataEntityTypes());
        this.ctx.setForceSqlQuery(this.isForceSqlQuery());
        this.ctx.setSelectEntry(this.existsEntrySelect(this.getVisibleSelectFieldList()));
        this.ctx.setPageNumber(PageUtil.getPageNumber(this.ctx.getQueryBuilder().getStart(), this.ctx.getQueryBuilder().getLimit()));
        return this.ctx;
    }

    private QueryType getQueryTypeOnGetData() {
        boolean isExportList;
        boolean bl = isExportList = OperationContext.get() != null && "kd.bos.mvc.export.ExportListTask".equals(OperationContext.get().getFormName());
        if (isExportList) {
            return QueryType.EXPORT;
        }
        boolean selectedAllRows = this.getQueryBuilder().isSelectedAllRows();
        if (selectedAllRows) {
            return QueryType.SELECT_ALL;
        }
        return QueryType.SEARCH;
    }

    public DynamicObjectCollection getData(int start, int limit) {
        PerformanceWatch watch = new PerformanceWatch(((Object)((Object)this)).getClass(), "VoucherListDataProvider#getData", true);
        watch.start("VoucherListDataProvider#getData");
        VoucherListContext ctx = this.initCtx();
        ctx.setQueryType(this.getQueryTypeOnGetData());
        LOG.info("ctx init {}", (Object)ctx);
        VoucherListContextEnhancer.enhance(ctx.getQueryType(), ctx);
        this.iQuery = VoucherQueryFactory.getVoucherQuery(ctx);
        LOG.info("used query {}", (Object)this.iQuery.getClass().getSimpleName());
        LOG.info("ctx final {}", (Object)ctx);
        try (AlgoContext ignored = Algo.newContext();){
            DynamicObjectCollection result = this.iQuery.getData(ctx.getQueryBuilder());
            this.packageResults(result);
            watch.stop();
            DynamicObjectCollection dynamicObjectCollection = result;
            return dynamicObjectCollection;
        }
    }

    protected void packageResults(DynamicObjectCollection result) {
        new BudgetPropExtender(result, (MainEntityType)this.getCtx().getQueryBuilder().getEntityType()).extend();
    }

    private boolean existsEntrySelect(List<ListField> visibleSelectField) {
        return visibleSelectField.stream().anyMatch(x -> x.getFieldName() != null && x.getFieldName().startsWith(ENTRIES_PREFIX));
    }

    public QueryResult getQueryResult() {
        return this.iQuery.getQueryResult();
    }

    public int getRealCount() {
        VoucherListContext ctx = this.initCtx();
        ctx.setQueryType(QueryType.GET_REAL_COUNT);
        VoucherListContextEnhancer.enhance(ctx.getQueryType(), ctx);
        if (VoucherCountHelper.checkFilterOptEnable((QFilter[])ctx.getQueryBuilder().getFilters())) {
            List qFilters = VoucherCountHelper.optimizeVoucherFilters((QFilter[])ctx.getQueryBuilder().getFilters());
            if (ctx.isSelectEntry()) {
                return VoucherCountHelper.queryEntryCount((List)qFilters);
            }
            return VoucherCountHelper.queryVoucherCount((List)qFilters);
        }
        return super.getRealCount();
    }

    public int getBillDataCount() {
        VoucherListContext ctx = this.initCtx();
        ctx.setQueryType(QueryType.GET_BILL_DATA_COUNT);
        VoucherListContextEnhancer.enhance(ctx.getQueryType(), ctx);
        if (VoucherCountHelper.checkFilterOptEnable((QFilter[])ctx.getQueryBuilder().getFilters())) {
            List qFilters = VoucherCountHelper.optimizeVoucherFilters((QFilter[])ctx.getQueryBuilder().getFilters());
            return VoucherCountHelper.queryVoucherCount((List)qFilters);
        }
        return super.getBillDataCount();
    }

    public List<SummaryResult> getSummaryResults() {
        VoucherListContext ctx = this.initCtx();
        ctx.setQueryType(QueryType.GET_SUMMARY_RESULTS);
        VoucherListContextEnhancer.enhance(ctx.getQueryType(), ctx);
        String entity = ctx.getEntityType().getName();
        Optional<List<SummaryResult>> summaryResult = VoucherListSummaryHelper.getSummaryResult(ctx.getQueryBuilder(), ComAssistTable.get((Long)this.getOrgID(entity), (Long)this.getBookTypeID(entity)).orElse(null));
        return summaryResult.orElseGet(() -> super.getSummaryResults());
    }
}

