/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.voucher;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.plugin.AbstractPrintServicePlugin;
import kd.bos.entity.plugin.args.CustomPrintDataEntitiesArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserConfigServiceHelper;
import kd.fi.gl.exception.BOSException;
import kd.fi.gl.util.GLUtil;

public class VoucherPrint
extends AbstractPrintServicePlugin {
    private static final String CONFIG_CUSTOM = "gl_voucher_customprintsetting";
    private static final Log log = LogFactory.getLog((String)"kd.fi.gl.formplugin.voucher.VoucherPrint");
    private static final String ACCTNAME = "accountname";
    private static final String ITEMS = "items";
    private static final String SUMBYACCT = "1";
    private static final String SUMBYACCTWITHASSGRP = "2";
    private static final String SUMBYACCTWTIHCF = "3";
    private static final String FORMID_2_NAME_AND_NUMBER_PROP_CACHEKEY = "formId2nameAndNumberPropCacheKey";
    private static final String VALUEID_2_DYN_CACHEKEY = "valueId2DynCacheKey";
    private static final String ASSGRP_ID_SQL = "select fassgrpid from t_gl_voucherentry where fassgrpid <> 0 and fid in (?";
    private static final String ASSGRP_VALUE_SQL = "select fvalue from t_gl_assist where fid in (?";

    public void customPrintDataEntities(CustomPrintDataEntitiesArgs e) {
        if (!ThreadCache.exists((Object)"glVoucher")) {
            Set customerField;
            String dataSource = e.getDataSourceName();
            if ("entries".equals(dataSource) && (customerField = e.getCustomFields()) != null && (customerField.contains(ACCTNAME) || customerField.contains(ITEMS))) {
                String sumfilter;
                DynamicObjectType customDT;
                List<Object> dyn = e.getDataEntities();
                ArrayList<DynamicObject> newdyn = new ArrayList<DynamicObject>();
                if (dyn == null || dyn.isEmpty()) {
                    return;
                }
                try {
                    customDT = (DynamicObjectType)((DynamicObject)dyn.get(0)).getDynamicObjectType().clone();
                    DynamicSimpleProperty acctP = new DynamicSimpleProperty(ACCTNAME, String.class, (Object)"");
                    customDT.registerSimpleProperty(acctP);
                    DynamicSimpleProperty itemP = new DynamicSimpleProperty(ITEMS, String.class, (Object)"");
                    customDT.registerSimpleProperty(itemP);
                }
                catch (Exception e1) {
                    log.error((Throwable)e1);
                    throw new BOSException((Throwable)e1);
                }
                long voucherId = Long.parseLong(e.getFilter().getValue().toString());
                if (voucherId == 0L) {
                    return;
                }
                DynamicObject vou = BusinessDataServiceHelper.loadSingleFromCache((Object)voucherId, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"gl_voucher"));
                DynamicObjectCollection col = vou.getDynamicObjectCollection("entries");
                dyn = new ArrayList(col);
                String settingData = UserConfigServiceHelper.getSetting((long)RequestContext.get().getCurrUserId(), (String)CONFIG_CUSTOM);
                String excludezero = null;
                try {
                    Map cusdata = (Map)SerializationUtils.fromJsonString((String)settingData, Map.class);
                    sumfilter = (String)cusdata.get("sumfilter");
                    excludezero = (String)cusdata.get("excludezero");
                }
                catch (Exception ex) {
                    sumfilter = settingData;
                }
                if (StringUtils.isNotBlank((CharSequence)sumfilter)) {
                    switch (sumfilter) {
                        case "1": {
                            dyn = this.sumData((Collection<DynamicObject>)col, SUMBYACCT);
                            break;
                        }
                        case "2": {
                            dyn = this.sumData((Collection<DynamicObject>)col, SUMBYACCTWITHASSGRP);
                            break;
                        }
                        case "3": {
                            dyn = this.sumData((Collection<DynamicObject>)col, SUMBYACCTWTIHCF);
                            break;
                        }
                    }
                }
                int amtprecision = vou.getDynamicObject("localcur").getInt("amtprecision");
                int seq = 1;
                Object[] accountIdArray = dyn.stream().filter(v -> null != v.get("account")).map(v -> v.getDynamicObject("account").getLong("id")).toArray();
                Map accountMap = BusinessDataServiceHelper.loadFromCache((Object[])accountIdArray, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_accountview"));
                Map<Object, Object> valueId2Dyn = new HashMap(1);
                if (customerField.contains(ITEMS)) {
                    valueId2Dyn = this.cacheAssist(e.getPkIds());
                }
                Map<String, String[]> formId2nameAndNumberProp = this.getCachedFormDisplayPropMap();
                for (DynamicObject dynamicObject : dyn) {
                    DynamicObject account;
                    DynamicObject newObj = (DynamicObject)new CloneUtils(false, false).clone((IDataEntityType)customDT, (Object)dynamicObject);
                    BusinessDataServiceHelper.loadRefence((Object[])new Object[]{newObj}, (IDataEntityType)((IDataEntityType)MetadataServiceHelper.getDataEntityType((String)"gl_voucher").getAllEntities().get("entries")));
                    int precision = newObj.getDynamicObject("currency").getInt("amtprecision");
                    BigDecimal crLoc = newObj.getBigDecimal("creditlocal");
                    BigDecimal drLoc = newObj.getBigDecimal("debitlocal");
                    BigDecimal crOri = newObj.getBigDecimal("creditori");
                    BigDecimal drOri = newObj.getBigDecimal("debitori");
                    if (SUMBYACCT.equals(excludezero) && crLoc.compareTo(BigDecimal.ZERO) == 0 && drLoc.compareTo(BigDecimal.ZERO) == 0) continue;
                    newObj.set("creditlocal", null);
                    newObj.set("creditlocal", (Object)crLoc.setScale(amtprecision, 4));
                    newObj.set("debitlocal", null);
                    newObj.set("debitlocal", (Object)drLoc.setScale(amtprecision, 4));
                    newObj.set("creditori", null);
                    newObj.set("creditori", (Object)crOri.setScale(precision, 4));
                    newObj.set("debitori", null);
                    newObj.set("debitori", (Object)drOri.setScale(precision, 4));
                    if (customerField.contains(ACCTNAME) && (account = dynamicObject.getDynamicObject("account")) != null) {
                        newObj.set(ACCTNAME, (Object)(account.getString("number") + " " + account.getString("fullname")));
                    }
                    if (customerField.contains(ITEMS)) {
                        DynamicObject assgrp = dynamicObject.getDynamicObject("assgrp");
                        if (assgrp == null) {
                            newObj.set("seq", (Object)seq++);
                            newdyn.add(newObj);
                            continue;
                        }
                        JSONObject valueJson = JSONObject.parseObject((String)assgrp.getString("value"));
                        JSONObject sortItems = this.sortItems(valueJson, (DynamicObject)accountMap.get(dynamicObject.getDynamicObject("account").getPkValue()));
                        String itemStr = GLUtil.dealAssgrp((JSONObject)sortItems, (String)"\n", valueId2Dyn, formId2nameAndNumberProp);
                        newObj.set(ITEMS, (Object)itemStr);
                    }
                    newObj.set("seq", (Object)seq++);
                    newdyn.add(newObj);
                }
                e.setDataEntities(newdyn);
            }
        } else {
            List idList = e.getPkIds();
            Map voucherMap = (Map)ThreadCache.get((Object)"glVoucher");
            for (Object id : idList) {
                DynamicObjectType customDT;
                Set customerField;
                String key = String.valueOf(id);
                List dynFromArhieve = (List)voucherMap.get(key);
                List dyn = e.getDataEntities();
                HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>(dynFromArhieve.size());
                for (DynamicObject d : dynFromArhieve) {
                    map.put(d.getString("entries.id"), d);
                }
                String dataSource = e.getDataSourceName();
                if (!"entries".equals(dataSource) || (customerField = e.getCustomFields()) == null || !customerField.contains(ACCTNAME) && !customerField.contains(ITEMS)) continue;
                ArrayList<DynamicObject> newdyn = new ArrayList<DynamicObject>();
                if (dyn == null || dyn.isEmpty()) {
                    return;
                }
                try {
                    customDT = (DynamicObjectType)((DynamicObject)dyn.get(0)).getDynamicObjectType().clone();
                    DynamicSimpleProperty acctP = new DynamicSimpleProperty(ACCTNAME, String.class, (Object)"");
                    customDT.registerSimpleProperty(acctP);
                    DynamicSimpleProperty itemP = new DynamicSimpleProperty(ITEMS, String.class, (Object)"");
                    customDT.registerSimpleProperty(itemP);
                }
                catch (Exception e1) {
                    throw new BOSException((Throwable)e1);
                }
                Object[] accIds = map.values().stream().map(x -> x.getLong("entries.account")).toArray();
                Map accountMap = BusinessDataServiceHelper.loadFromCache((Object[])accIds, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_accountview"));
                Map<Object, Object> valueId2Dyn = new HashMap(1);
                if (customerField.contains(ITEMS)) {
                    valueId2Dyn = this.cacheAssist(e.getPkIds());
                }
                Map<String, String[]> formId2nameAndNumberProp = this.getCachedFormDisplayPropMap();
                for (DynamicObject d : dyn) {
                    String entryid = String.valueOf(d.get("id"));
                    DynamicObject dynamicObject = (DynamicObject)new CloneUtils(false, false).clone((IDataEntityType)customDT, (Object)d);
                    this.setComplexPropertyValue(dynamicObject, d);
                    if (customerField.contains(ACCTNAME)) {
                        dynamicObject.set(ACCTNAME, (Object)(((DynamicObject)map.get(entryid)).getString("entries.account.number") + " " + ((DynamicObject)map.get(entryid)).getString("entries.account.fullname")));
                    }
                    long accountId = ((DynamicObject)map.get(entryid)).getLong("entries.account");
                    if (customerField.contains(ITEMS)) {
                        String assgrp = ((DynamicObject)map.get(entryid)).getString("entries.assgrp.value");
                        if (assgrp == null) {
                            newdyn.add(dynamicObject);
                            continue;
                        }
                        JSONObject valueJson = JSONObject.parseObject((String)assgrp);
                        if (accountId > 0L) {
                            JSONObject sortItems = this.sortItems(valueJson, (DynamicObject)accountMap.get(accountId));
                            String itemStr = GLUtil.dealAssgrp((JSONObject)sortItems, (String)"\n", valueId2Dyn, formId2nameAndNumberProp);
                            dynamicObject.set(ITEMS, (Object)itemStr);
                        }
                    }
                    newdyn.add(dynamicObject);
                }
                e.setDataEntities(newdyn);
            }
        }
    }

    private JSONObject sortItems(JSONObject valueJson, DynamicObject account) {
        DynamicObjectCollection dynamicObjectCollection = account.getDynamicObjectCollection("checkitementry");
        dynamicObjectCollection.sort(Comparator.comparingInt(arg0 -> arg0.getInt("seq")));
        JSONObject js = new JSONObject(true);
        for (DynamicObject entry : dynamicObjectCollection) {
            String flexfield = entry.getDynamicObject("asstactitem").getString("flexfield");
            Object objId = valueJson.get((Object)flexfield);
            if (null == objId) continue;
            js.put(flexfield, objId);
        }
        return js;
    }

    private void setComplexPropertyValue(DynamicObject newObj, DynamicObject oldObj) {
        newObj.set("currency", (Object)oldObj.getDynamicObject("currency"));
        newObj.set("measureunit", (Object)oldObj.getDynamicObject("measureunit"));
        newObj.set("assgrp", (Object)oldObj.getDynamicObject("assgrp"));
        newObj.set("account", (Object)oldObj.getDynamicObject("account"));
        newObj.set("maincfitem", (Object)oldObj.getDynamicObject("maincfitem"));
        newObj.set("suppcfitem", (Object)oldObj.getDynamicObject("suppcfitem"));
        newObj.set("maincfassgrp", (Object)oldObj.getDynamicObject("maincfassgrp"));
    }

    private List<DynamicObject> sumData(Collection<DynamicObject> values, String sumType) {
        String key = "";
        LinkedHashMap<String, DynamicObject> map = new LinkedHashMap<String, DynamicObject>();
        for (DynamicObject obj : values) {
            switch (sumType) {
                case "1": {
                    key = obj.getString("account.id") + "-" + obj.getString("currency.id") + "-" + obj.getString("measureunit.id") + "-" + obj.getString("entrydc");
                    break;
                }
                case "2": {
                    key = obj.getString("account.id") + "-" + obj.getString("assgrp.id") + "-" + obj.getString("currency.id") + "-" + obj.getString("measureunit.id") + "-" + obj.getString("entrydc");
                    break;
                }
                case "3": {
                    key = obj.getString("account.id") + "-" + obj.getString("maincfitem.id") + "-" + obj.getString("currency.id") + "-" + obj.getString("measureunit.id") + "-" + obj.getString("entrydc");
                    break;
                }
            }
            if (map.containsKey(key)) {
                DynamicObject o = (DynamicObject)map.get(key);
                o.set("creditori", (Object)obj.getBigDecimal("creditori").add(o.getBigDecimal("creditori")));
                o.set("debitori", (Object)obj.getBigDecimal("debitori").add(o.getBigDecimal("debitori")));
                o.set("creditlocal", (Object)obj.getBigDecimal("creditlocal").add(o.getBigDecimal("creditlocal")));
                o.set("debitlocal", (Object)obj.getBigDecimal("debitlocal").add(o.getBigDecimal("debitlocal")));
                o.set("quantity", (Object)this.sumQty(o, obj));
                continue;
            }
            DynamicObject newObj = (DynamicObject)new CloneUtils(false, false).clone(obj.getDataEntityType(), (Object)obj);
            if (sumType.equals(SUMBYACCT)) {
                newObj.set("assgrp", null);
                newObj.set("maincfitem", null);
            } else if (sumType.equals(SUMBYACCTWTIHCF)) {
                newObj.set("assgrp", null);
            }
            map.put(key, newObj);
        }
        return new ArrayList<DynamicObject>(map.values());
    }

    private BigDecimal sumQty(DynamicObject e1, DynamicObject e2) {
        BigDecimal qty1 = e1.getBigDecimal("quantity");
        BigDecimal qty2 = e2.getBigDecimal("quantity");
        if (qty1 == null) {
            return qty2;
        }
        if (qty2 == null) {
            return qty1;
        }
        return qty1.add(qty2);
    }

    private List<Object> getCachedPkIds() {
        return (List)ThreadCache.get((Object)"voucher_print_pkids", () -> new ArrayList(10));
    }

    private Map<String, Map<Object, DynamicObject>> getCachedValueIdDynMap() {
        return (Map)ThreadCache.get((Object)VALUEID_2_DYN_CACHEKEY, () -> new HashMap(16));
    }

    private Map<String, String> getCachedFlexFieldFormIdMap() {
        return (Map)ThreadCache.get((Object)"flexField2FormId", () -> new HashMap(16));
    }

    private Map<String, String[]> getCachedFormDisplayPropMap() {
        return (Map)ThreadCache.get((Object)FORMID_2_NAME_AND_NUMBER_PROP_CACHEKEY, () -> new HashMap(16));
    }

    private Map<String, Set<Object>> getCachedFormIdValuesMap() {
        return (Map)ThreadCache.get((Object)"formId2valueIds", () -> new HashMap(16));
    }

    private Map<String, Map<Object, DynamicObject>> cacheAssist(List<Object> pkIds) {
        List<Object> cachedPkIds = this.getCachedPkIds();
        ArrayList<Object> batchPkIds = new ArrayList<Object>(pkIds);
        batchPkIds.removeAll(cachedPkIds);
        cachedPkIds.addAll(batchPkIds);
        Map<String, Map<Object, DynamicObject>> cachedValueIdDynMap = this.getCachedValueIdDynMap();
        if (batchPkIds.isEmpty()) {
            return cachedValueIdDynMap;
        }
        String sql = this.getSql(batchPkIds.size(), ASSGRP_ID_SQL, "fassgrpid");
        Object[] params = batchPkIds.toArray();
        HashSet<Long> assgrpIds = new HashSet<Long>(1);
        try (DataSet rows = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)DBRoute.of((String)"fi"), (String)sql, (Object[])params);){
            for (Row row : rows) {
                assgrpIds.add(row.getLong("fassgrpid"));
            }
        }
        if (assgrpIds.isEmpty()) {
            return cachedValueIdDynMap;
        }
        HashSet<String> assgrpValues = new HashSet<String>(assgrpIds.size());
        DataSet rows = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"gl_assist", (String)"assvals", (QFilter[])new QFilter[]{new QFilter("id", "in", assgrpIds)}, null);
        Object object = null;
        try {
            for (Row row : rows) {
                assgrpValues.add(row.getString("assvals"));
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (rows != null) {
                if (object != null) {
                    try {
                        rows.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    rows.close();
                }
            }
        }
        Map<String, Set<Object>> cachedFormIdValuesMap = this.getCachedFormIdValuesMap();
        Map<String, String[]> cachedFormDisplayPropMap = this.getCachedFormDisplayPropMap();
        GLUtil.batchDealAssgrp(assgrpValues, this.getCachedFlexFieldFormIdMap(), cachedFormDisplayPropMap, cachedFormIdValuesMap);
        for (Map.Entry<String, Set<Object>> assistValueEntry : cachedFormIdValuesMap.entrySet()) {
            String key = assistValueEntry.getKey();
            String[] fields = cachedFormDisplayPropMap.get(key);
            String select = StringUtils.equals((CharSequence)fields[0], (CharSequence)fields[1]) ? "id," + fields[0] : "id," + fields[0] + "," + fields[1];
            DynamicObjectCollection assists = QueryServiceHelper.query((String)key, (String)select, (QFilter[])new QFilter[]{new QFilter("id", "in", assistValueEntry.getValue())});
            Map idDynMap = cachedValueIdDynMap.computeIfAbsent(key, k -> new HashMap(assists.size()));
            for (DynamicObject assist : assists) {
                idDynMap.put(assist.get("id"), assist);
            }
        }
        return cachedValueIdDynMap;
    }

    private String getSql(int size, String sql, String groupBy) {
        StringBuilder sb = new StringBuilder(sql);
        for (int i = 0; i < size - 1; ++i) {
            sb.append(",?");
        }
        sb.append(")");
        if (groupBy != null) {
            sb.append(" group by ");
            sb.append(groupBy);
        }
        return sb.toString();
    }
}

