/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.voucher;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.print.core.data.DataRowSet;
import kd.bos.print.core.data.datasource.MainDataSource;
import kd.bos.print.core.data.datasource.PrtDataSource;
import kd.bos.print.core.data.field.CollectionField;
import kd.bos.print.core.data.field.DecimalField;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.IntegerField;
import kd.bos.print.core.data.field.LongField;
import kd.bos.print.core.data.field.TextField;
import kd.bos.print.core.plugin.AbstractPrintSeniorPlugin;
import kd.bos.print.core.plugin.event.AfterLoadDataEvent;
import kd.bos.print.core.plugin.event.BeforeLoadDataEvent;
import kd.bos.print.core.plugin.event.DataVisitorEvent;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserConfigServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.bd.util.BillParamUtil;
import kd.fi.gl.business.service.voucher.mc.MulLocalConfig;
import kd.fi.gl.constant.GLField;
import kd.fi.gl.enums.GLBillParamEnum;
import kd.fi.gl.util.FlexFormatUtil;
import kd.fi.gl.util.PrintUtil;
import kd.fi.gl.util.replace.CommonAssistValueReplacer;

public class VoucherPrintNew
extends AbstractPrintSeniorPlugin {
    private static final String CONFIG_CUSTOM = "gl_voucher_customprintsetting";
    private static final String SUMBYACCT = "1";
    private static final String SUMBYACCTWITHASSGRP = "2";
    private static final String SUMBYACCTWTIHCF = "3";
    private static final Log log = LogFactory.getLog(VoucherPrintNew.class);
    private static final String[] VOUCHER_FIELD = new String[]{"localcur.amtprecision", "localcur.number", "localcur.sign"};
    private static final String ASSGRP_ASSGRP = "assgrp.assgrp";
    private static final String[] ENTRY_FIELD = new String[]{"maincfitem.number", "measureunit.number", "entrydc", "creditori", "debitori", "currency.amtprecision", "currency.number", "currency.sign", "assgrp.assgrp"};
    private static final Supplier<Integer> EXT_MAX_ENTRY_SIZE = () -> BillParamUtil.getIntegerValue((String)"83bfebc8000017ac", (String)"kd.fi.gl.formplugin.voucher.VoucherPrint.EXT_MAX_ENTRY_SIZE", (int)100000);

    public void beforeLoadData(BeforeLoadDataEvent evt) {
        super.beforeLoadData(evt);
        this.addCustomField(evt);
    }

    private void addCustomField(BeforeLoadDataEvent evt) {
        if (evt.getDataSource() instanceof MainDataSource && "gl_voucher".equalsIgnoreCase(evt.getDataSource().getDsName())) {
            MainDataSource dataSource = (MainDataSource)evt.getDataSource();
            for (String vchField : VOUCHER_FIELD) {
                dataSource.addField(vchField);
            }
            String ekDs = String.join((CharSequence)".", "gl_voucher", "entries");
            List collectEntry = dataSource.getChildrenDs().stream().filter(ds -> ekDs.equalsIgnoreCase(ds.getDsName())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(collectEntry)) {
                PrtDataSource prtDataSource = (PrtDataSource)collectEntry.get(0);
                List collect = prtDataSource.getQueryField().stream().filter(key -> key.startsWith("assgrp")).collect(Collectors.toList());
                boolean hasNotAssgrp = CollectionUtils.isEmpty(collect);
                for (String enField : ENTRY_FIELD) {
                    if (hasNotAssgrp && enField.startsWith("assgrp")) continue;
                    prtDataSource.addField(enField);
                }
            }
        }
    }

    public void afterLoadData(AfterLoadDataEvent evt) {
        super.afterLoadData(evt);
        if (!"gl_voucher".equalsIgnoreCase(evt.getDataSource().getDsName())) {
            return;
        }
        List voucherdataRowSets = evt.getDataRowSets();
        if (voucherdataRowSets == null || voucherdataRowSets.isEmpty()) {
            return;
        }
        PrintConfig printConfig = this.getPrintConfig();
        List<String> entryFields = this.getEntryFields(evt.getDataSource());
        boolean containAssgrp = this.checkContainAssgrp(entryFields);
        CommonAssistValueReplacer<DataRowSet> commonAssistValueReplacer = null;
        if (this.containsCommonAssist(entryFields)) {
            commonAssistValueReplacer = this.createCommonAssistValueReplacer((Long)((DataRowSet)voucherdataRowSets.get(0)).getField("id").getValue());
        }
        MulLocalConfig[] configs = MulLocalConfig.enabledConfigs();
        for (DataRowSet voucherData : voucherdataRowSets) {
            Field id = voucherData.getField("id");
            long voucherId = (Long)id.getValue();
            if (voucherId == 0L) {
                return;
            }
            int amtprecision = ((IntegerField)voucherData.getField("localcur.amtprecision")).getValue();
            String localCurrencyNumber = (String)((TextField)voucherData.getField("localcur.number")).getValue();
            String localCurrencySign = (String)((TextField)voucherData.getField("localcur.sign")).getValue();
            CollectionField entries = voucherData.getCollectionField("entries");
            List valueList = entries.getValue();
            List<DataRowSet> summed = this.sumDataByConfig(valueList, printConfig.getSumfilter(), configs);
            int seq = 1;
            Iterator<DataRowSet> iterator = summed.iterator();
            while (iterator.hasNext()) {
                DataRowSet next = iterator.next();
                int precision = ((IntegerField)next.getField("currency.amtprecision")).getValue();
                String currencyNumber = (String)((TextField)next.getField("currency.number")).getValue();
                String currencySign = (String)((TextField)next.getField("currency.sign")).getValue();
                BigDecimal crLoc = ((DecimalField)next.getField("creditlocal")).getValue();
                BigDecimal drLoc = ((DecimalField)next.getField("debitlocal")).getValue();
                BigDecimal crOri = ((DecimalField)next.getField("creditori")).getValue();
                BigDecimal drOri = ((DecimalField)next.getField("debitori")).getValue();
                if (SUMBYACCT.equals(printConfig.getExcludezero()) && crLoc.compareTo(BigDecimal.ZERO) == 0 && drLoc.compareTo(BigDecimal.ZERO) == 0 && !this.isExistsLocalAmountNonZero(next, configs)) {
                    iterator.remove();
                    continue;
                }
                DecimalField crLocField = new DecimalField(crLoc.setScale(amtprecision, 4));
                crLocField.setSymbol(localCurrencySign);
                crLocField.setCode(localCurrencyNumber);
                DecimalField drLocField = new DecimalField(drLoc.setScale(amtprecision, 4));
                drLocField.setSymbol(localCurrencySign);
                drLocField.setCode(localCurrencyNumber);
                DecimalField crOriField = new DecimalField(crOri.setScale(precision, 4));
                crOriField.setSymbol(currencySign);
                crOriField.setCode(currencyNumber);
                DecimalField drOriField = new DecimalField(drOri.setScale(precision, 4));
                drOriField.setSymbol(currencySign);
                drOriField.setCode(currencyNumber);
                next.put("creditlocal", (Field)crLocField);
                next.put("debitlocal", (Field)drLocField);
                next.put("creditori", (Field)crOriField);
                next.put("debitori", (Field)drOriField);
                DecimalField oriAmountField = crOri.compareTo(BigDecimal.ZERO) == 0 ? drOriField : crOriField;
                next.put("oriamount", (Field)oriAmountField);
                next.put("seq", (Field)new IntegerField(Integer.valueOf(seq++)));
                if (containAssgrp) {
                    this.putAssgrpIfExists(next);
                }
                if (commonAssistValueReplacer == null) continue;
                commonAssistValueReplacer.addReplace((Object)next, ((Long)next.getField("id").getValue()).longValue(), voucherId);
            }
            voucherData.put("entries", (Field)new CollectionField(summed));
        }
        if (commonAssistValueReplacer != null) {
            commonAssistValueReplacer.finish();
        }
    }

    private boolean isExistsLocalAmountNonZero(DataRowSet row, MulLocalConfig[] configs) {
        if (configs.length == 0) {
            return false;
        }
        return Arrays.stream(configs).anyMatch(x -> row.containerKey(x.getDebitField()) && ((DecimalField)row.getField(x.getDebitField())).getValue().signum() != 0 || row.containerKey(x.getCreditField()) && ((DecimalField)row.getField(x.getCreditField())).getValue().signum() != 0);
    }

    public void beforeInitDataVisitor(DataVisitorEvent event) {
        super.beforeInitDataVisitor(event);
        if (EXT_MAX_ENTRY_SIZE.get() > 1) {
            event.setMaxEntrySize(EXT_MAX_ENTRY_SIZE.get().intValue());
        }
    }

    private List<String> getEntryFields(PrtDataSource dataSource) {
        MainDataSource mainDataSource = (MainDataSource)dataSource;
        List childrenDs = mainDataSource.getChildrenDs();
        ArrayList<String> entryFields = CollectionUtils.isNotEmpty((Collection)childrenDs) ? new ArrayList(new HashSet(((PrtDataSource)mainDataSource.getChildrenDs().get(0)).getQueryField())) : new ArrayList<String>(0);
        log.info("entryFields: {}", entryFields);
        return entryFields;
    }

    private void putAssgrpIfExists(DataRowSet newEntryDataRowSet) {
        TextField assGrpAssGrpField = (TextField)newEntryDataRowSet.getField(ASSGRP_ASSGRP);
        if (assGrpAssGrpField.getValue() == null) {
            return;
        }
        if (GLBillParamEnum.VOUCHER_FLEX_PRINTLN.getBooleanValue()) {
            assGrpAssGrpField.setValue(FlexFormatUtil.replaceDisplayValueSeparator((String)((String)assGrpAssGrpField.getValue()), (String)"\n"));
        }
        newEntryDataRowSet.put("assgrp", (Field)assGrpAssGrpField);
    }

    private List<DataRowSet> sumDataByConfig(List<DataRowSet> entries, String sumFilter, MulLocalConfig[] configs) {
        if (StringUtils.isNotEmpty((CharSequence)sumFilter)) {
            return this.sumData(entries, sumFilter, configs);
        }
        return entries;
    }

    private PrintConfig getPrintConfig() {
        PrintConfig printConfig = new PrintConfig();
        String settingData = UserConfigServiceHelper.getSetting((long)RequestContext.get().getCurrUserId(), (String)CONFIG_CUSTOM);
        try {
            Map cusdata = (Map)SerializationUtils.fromJsonString((String)settingData, Map.class);
            printConfig.setSumfilter((String)cusdata.get("sumfilter"));
            printConfig.setExcludezero((String)cusdata.get("excludezero"));
        }
        catch (Exception ex) {
            printConfig.setSumfilter(settingData);
        }
        return printConfig;
    }

    private boolean checkContainAssgrp(List<String> entryFields) {
        return entryFields.stream().anyMatch(field -> field.equalsIgnoreCase(ASSGRP_ASSGRP));
    }

    private boolean containsCommonAssist(List<String> entryFields) {
        return entryFields.stream().anyMatch(field -> field.startsWith("comassist"));
    }

    private CommonAssistValueReplacer<DataRowSet> createCommonAssistValueReplacer(long voucherId) {
        long accountTableId = BusinessDataServiceHelper.loadSingle((Object)voucherId, (String)"gl_voucher", (String)"book").getDynamicObject("book").getLong(GLField.id_((String)"accounttable"));
        return new CommonAssistValueReplacer(accountTableId, (commonAssistProperties, dataRowSet) -> {
            for (CommonAssistValueReplacer.CommonAssistProperties commonAssistProperty : commonAssistProperties) {
                dataRowSet.put(commonAssistProperty.getCommonAssist().key + ".number", (Field)new TextField(commonAssistProperty.getNumber()));
                dataRowSet.put(commonAssistProperty.getCommonAssist().key + ".name", (Field)new TextField(commonAssistProperty.getName()));
            }
        });
    }

    private List<DataRowSet> sumData(List<DataRowSet> values, String sumType, MulLocalConfig[] configs) {
        String key = "";
        LinkedHashMap<String, DataRowSet> map = new LinkedHashMap<String, DataRowSet>();
        for (DataRowSet row : values) {
            switch (sumType) {
                case "1": {
                    key = this.getSumKey(row, "account.id", "currency.id", "measureunit.id", "entrydc");
                    break;
                }
                case "2": {
                    key = this.getSumKey(row, "account.id", ASSGRP_ASSGRP, "currency.id", "measureunit.id", "entrydc");
                    break;
                }
                case "3": {
                    key = this.getSumKey(row, "account.id", "maincfitem.id", "currency.id", "measureunit.id", "entrydc");
                    break;
                }
            }
            if (map.containsKey(key)) {
                DataRowSet newRow = (DataRowSet)map.get(key);
                newRow.put("creditori", (Field)new DecimalField(((DecimalField)row.getField("creditori")).getValue().add(((DecimalField)newRow.getField("creditori")).getValue())));
                newRow.put("debitori", (Field)new DecimalField(((DecimalField)row.getField("debitori")).getValue().add(((DecimalField)newRow.getField("debitori")).getValue())));
                newRow.put("creditlocal", (Field)new DecimalField(((DecimalField)row.getField("creditlocal")).getValue().add(((DecimalField)newRow.getField("creditlocal")).getValue())));
                newRow.put("debitlocal", (Field)new DecimalField(((DecimalField)row.getField("debitlocal")).getValue().add(((DecimalField)newRow.getField("debitlocal")).getValue())));
                newRow.put("quantity", (Field)new DecimalField(this.sumQty(newRow, row)));
                for (MulLocalConfig config : configs) {
                    if (row.containerKey(config.getDebitField())) {
                        newRow.put(config.getDebitField(), (Field)new DecimalField(((DecimalField)row.getField(config.getDebitField())).getValue().add(((DecimalField)newRow.getField(config.getDebitField())).getValue())));
                    }
                    if (!row.containerKey(config.getCreditField())) continue;
                    newRow.put(config.getCreditField(), (Field)new DecimalField(((DecimalField)row.getField(config.getCreditField())).getValue().add(((DecimalField)newRow.getField(config.getCreditField())).getValue())));
                }
                map.put(key, newRow);
                continue;
            }
            if (sumType.equals(SUMBYACCT)) {
                row.put("assgrp", null);
                row.put(ASSGRP_ASSGRP, null);
                row.put("maincfitem", null);
            } else if (sumType.equals(SUMBYACCTWTIHCF)) {
                row.put("assgrp", null);
                row.put(ASSGRP_ASSGRP, null);
            }
            map.put(key, row);
        }
        return new ArrayList<DataRowSet>(map.values());
    }

    private List<DataRowSet> addCustomColumns(List<DataRowSet> valueList, QFilter vchId) {
        DynamicObjectCollection entryCollection = QueryServiceHelper.query((String)"gl_voucher", (String)String.join((CharSequence)",", "entries.assgrp", "entries.id"), (QFilter[])vchId.toArray());
        Map<Long, Long> entryIdToAssgrp = entryCollection.stream().collect(Collectors.toMap(entry -> entry.getLong("entries.id"), entry -> entry.getLong("entries.assgrp")));
        return valueList.stream().peek(entry -> {
            ((LongField)entry.getField("id")).getValue();
            entry.put("assgrp.id", (Field)new LongField((Long)entryIdToAssgrp.get(((LongField)entry.getField("id")).getValue())));
        }).collect(Collectors.toList());
    }

    private String getSumKey(DataRowSet row, String ... fieldKeys) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String fieldKey : fieldKeys) {
            stringBuilder.append(row.getField(fieldKey).getValue()).append("-");
        }
        return stringBuilder.substring(0, stringBuilder.length() - 1);
    }

    private BigDecimal sumQty(DataRowSet e1, DataRowSet e2) {
        BigDecimal qty1 = PrintUtil.safeGetDecimalFieldValue(e1.getField("quantity"));
        BigDecimal qty2 = PrintUtil.safeGetDecimalFieldValue(e2.getField("quantity"));
        if (qty1 == null) {
            return qty2;
        }
        if (qty2 == null) {
            return qty1;
        }
        return qty1.add(qty2);
    }

    private static class PrintConfig {
        private String sumfilter;
        private String excludezero;

        private PrintConfig() {
        }

        public String getSumfilter() {
            return this.sumfilter;
        }

        public void setSumfilter(String sumfilter) {
            this.sumfilter = sumfilter;
        }

        public String getExcludezero() {
            return this.excludezero;
        }

        public void setExcludezero(String excludezero) {
            this.excludezero = excludezero;
        }
    }
}

