/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.voucher;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.basedata.query.BillTypeQueryHelper;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.plugin.print.ComplexSettingItem;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserConfigServiceHelper;
import kd.bos.template.orgctrl.service.PrintTemplateServiceFactory;
import kd.bos.template.orgctrl.utils.ParamUtils;
import kd.fi.gl.util.QFBuilder;

public class VoucherPrintSettingPlugin
extends AbstractFormPlugin {
    private static final String CONFIG_CUSTOM_SUFFIX = "_customprintsetting";
    private static final String Key_ADVGrid = "adventryentity";
    private static final String Key_BaseGrid = "baseentryentity";
    private static final String FormID_Formmeta = "bos_formmeta";
    private static final String CONFIG_COMMON_SUFFIX = "_printsetting";
    private static final String SUMFILTER = "sumfilter";
    private static final String EXCLUSEZERO = "excludezero";
    private static final String BILLFORMID = "billformid";
    private static final String BOS_MANAGEPRINTTPL = "bos_manageprinttpl";
    private static final String ENABLE = "enable";
    private static final String TYPE = "type";
    private static final String PRINTTPLID = "printtplid";
    private static final String PRINTTPLID_ID = "printtplid_id";
    private static final char DISABLE = '0';
    private static final String NEW_TPL_TYPE = "B";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"btnok", "btncancel", "btnreset", "filtername"});
        String formType = (String)this.getView().getFormShowParameter().getCustomParam("formtype");
        if ("IReportView".equals(formType)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"tabpageap", "tabpageap1"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (name.equals("defaulttemplate")) {
            this.getModel().setValue(SUMFILTER, null);
        }
    }

    public void afterCreateNewData(EventObject e) {
        String settingData;
        String key;
        super.afterCreateNewData(e);
        String formId = (String)this.getView().getFormShowParameter().getCustomParam("formid");
        if (StringUtils.isBlank((CharSequence)formId)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5355\u636e\u6807\u8bc6\u4e3a\u7a7a\u3002", (String)"VoucherPrintSettingPlugin_0", (String)"bos-form-business", (Object[])new Object[0]));
            return;
        }
        Map<String, String> templates = this.getTemplates(formId);
        if (templates != null && templates.size() > 0) {
            this.initDefaultCombo("defaulttemplate", templates, false);
            this.initDefaultCombo("templateid", templates, false);
            this.initDefaultCombo("filtertemplateid", templates, true);
        }
        Long userId = RequestContext.get().getCurrUserId();
        if (StringUtils.isNotBlank((CharSequence)formId)) {
            this.initBaseGrid(formId);
            key = formId + CONFIG_COMMON_SUFFIX;
            settingData = UserConfigServiceHelper.getSetting((long)userId, (String)key);
            if (StringUtils.isNotBlank((CharSequence)settingData)) {
                this.initSetting(settingData);
            }
        }
        key = formId + CONFIG_CUSTOM_SUFFIX;
        settingData = UserConfigServiceHelper.getSetting((long)userId, (String)key);
        if (StringUtils.isNotBlank((CharSequence)settingData)) {
            try {
                Map cusData = (Map)SerializationUtils.fromJsonString((String)settingData, Map.class);
                String sumFilter = (String)cusData.get(SUMFILTER);
                String excludeZero = (String)cusData.get(EXCLUSEZERO);
                this.getModel().setValue(SUMFILTER, (Object)sumFilter);
                if (EXCLUSEZERO != null) {
                    this.getModel().setValue(EXCLUSEZERO, (Object)excludeZero);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void click(EventObject evt) {
        String controlKey;
        Control control = (Control)evt.getSource();
        switch (controlKey = control.getKey()) {
            case "btnok": {
                String message = this.validAdvSetting();
                if (StringUtils.isEmpty((CharSequence)message)) {
                    this.saveSetting();
                    break;
                }
                this.getView().showErrorNotification(message);
                break;
            }
            case "filtername": {
                this.showFilterEditer();
                break;
            }
            case "btncancel": {
                this.getView().close();
                break;
            }
            case "btnreset": {
                this.getModel().setValue("defaulttemplate", (Object)"");
                int count = this.getModel().getEntryRowCount(Key_BaseGrid);
                for (int i = 0; i < count; ++i) {
                    this.getModel().setValue("templateid", (Object)"", i);
                }
                this.getModel().deleteEntryData(Key_ADVGrid);
                this.getModel().setValue(SUMFILTER, null);
                this.getModel().setValue(EXCLUSEZERO, (Object)false);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Map retData;
        super.closedCallBack(evt);
        if ("filtername".equals(evt.getActionId()) && (retData = (Map)evt.getReturnData()) != null) {
            int currentRowIndex = this.getModel().getEntryCurrentRowIndex(Key_ADVGrid);
            this.getModel().setValue("filtername", retData.get("name"), currentRowIndex);
            this.getModel().setValue("filtercondition", retData.get("condition"), currentRowIndex);
        }
    }

    private void initBaseGrid(String formId) {
        DynamicObjectCollection billtypeObjs = BillTypeQueryHelper.queryAllBillType((String)formId, (String)"id,name,defprinttemplate");
        if (billtypeObjs != null && !billtypeObjs.isEmpty()) {
            this.getModel().batchCreateNewEntryRow(Key_BaseGrid, billtypeObjs.size());
            for (int i = 0; i < billtypeObjs.size(); ++i) {
                String templateId;
                DynamicObject billtypeObj = (DynamicObject)billtypeObjs.get(i);
                Long id = (Long)billtypeObj.getPkValue();
                ILocaleString localeName = billtypeObj.getLocaleString("name");
                String name = localeName.getLocaleValue();
                String defprinttemplate = billtypeObj.getString("defprinttemplate");
                this.getModel().setValue("billtypename", (Object)name, i);
                this.getModel().setValue("billtypeid", (Object)id, i);
                if (!StringUtils.isNotBlank((CharSequence)defprinttemplate) || !this.isExistEnableTpl(templateId = MetadataDao.getIdByNumber((String)defprinttemplate, (MetaCategory)MetaCategory.Form))) continue;
                this.getModel().setValue("templateid", (Object)templateId, i);
            }
        }
    }

    private void initSetting(String settingData) {
        Object pageSeparation;
        Object pageNumType;
        Object vSavePage;
        Object hSavePage;
        Object complexSetting;
        Map jsonData = (Map)SerializationUtils.fromJsonString((String)settingData, Map.class);
        Object defaultTemplate = jsonData.get("template");
        Object defaultTemplateId = jsonData.get("templateid");
        Object printerId = jsonData.get("printerid");
        if (StringUtils.isBlank(defaultTemplateId) && StringUtils.isNotBlank(defaultTemplate)) {
            String templateId = MetadataDao.getIdByNumber((String)defaultTemplate.toString(), (MetaCategory)MetaCategory.Form);
            defaultTemplateId = templateId;
        }
        if (this.isExistEnableTpl(defaultTemplateId)) {
            this.getModel().setValue("defaulttemplate", defaultTemplateId);
        }
        this.getModel().setValue("defaultprinter", printerId);
        List baseEntity = (List)jsonData.get("basesetting");
        if (baseEntity != null && !baseEntity.isEmpty()) {
            for (Map map : baseEntity) {
                String billtypeid = (String)map.get("billtypeid");
                String templateid = (String)map.get("templateid");
                if (billtypeid == null || templateid == null) continue;
                int entryRowCount = this.getModel().getEntryRowCount(Key_BaseGrid);
                for (int i = 0; i < entryRowCount; ++i) {
                    if (!billtypeid.equals(this.getModel().getValue("billtypeid", i)) || !this.isExistEnableTpl(templateid)) continue;
                    this.getModel().setValue("templateid", (Object)templateid, i);
                }
            }
        }
        if (StringUtils.isNotBlank(complexSetting = jsonData.get("complexsetting"))) {
            List objs = new ArrayList();
            objs = complexSetting instanceof String ? SerializationUtils.fromJsonStringToList((String)complexSetting.toString(), ComplexSettingItem.class) : SerializationUtils.fromJsonStringToList((String)SerializationUtils.toJsonString(complexSetting), ComplexSettingItem.class);
            if (objs != null && objs.size() > 0) {
                this.getModel().batchCreateNewEntryRow(Key_ADVGrid, objs.size());
                for (int i = 0; i < objs.size(); ++i) {
                    ComplexSettingItem filterItem = (ComplexSettingItem)objs.get(i);
                    this.getModel().setValue(ENABLE, (Object)filterItem.isEnable(), i);
                    this.getModel().setValue("filtertype", (Object)filterItem.getFiltertype(), i);
                    this.getModel().setValue("filtername", (Object)filterItem.getFiltername(), i);
                    this.getModel().setValue("filtercondition", filterItem.getFiltercondition(), i);
                    if (!this.isExistEnableTpl(filterItem.getFiltertemplateid())) continue;
                    this.getModel().setValue("filtertemplateid", (Object)filterItem.getFiltertemplateid(), i);
                }
            }
        }
        if ((hSavePage = jsonData.get("hSavePage")) instanceof Boolean) {
            this.getModel().setValue("hsavepage", hSavePage);
        }
        if ((vSavePage = jsonData.get("vSavePage")) instanceof Boolean) {
            this.getModel().setValue("vsavepage", vSavePage);
        }
        if (StringUtils.isNotBlank(pageNumType = jsonData.get("pageNumType"))) {
            this.getModel().setValue("pagenumtype", pageNumType);
        }
        if (StringUtils.isNotBlank(pageSeparation = jsonData.get("pageSeparation"))) {
            this.getModel().setValue("pageseparation", pageSeparation);
        }
    }

    private Map<String, String> getTemplates(String formNumber) {
        return ParamUtils.isTemplateOrgIsolated() ? PrintTemplateServiceFactory.getService().getUserPermPrintTemplateMap(formNumber) : this.getNewTemplates(formNumber);
    }

    private Map<String, String> getNewTemplates(String formNumber) {
        DynamicObject[] printTplMetaDynObjArray;
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add(BILLFORMID, "=", (Object)formNumber);
        qfBuilder.add(ENABLE, "!=", (Object)Character.valueOf('0'));
        DynamicObject[] printTplDynObjArray = BusinessDataServiceHelper.load((String)BOS_MANAGEPRINTTPL, (String)String.join((CharSequence)",", TYPE, PRINTTPLID), (QFilter[])qfBuilder.toArray());
        LinkedHashMap<String, String> templateMap = new LinkedHashMap<String, String>(printTplDynObjArray.length);
        ArrayList<Object> oldPrintMeatIdList = new ArrayList<Object>(printTplDynObjArray.length);
        for (DynamicObject printTplDynObj : printTplDynObjArray) {
            String type = printTplDynObj.getString(TYPE);
            DynamicObject printTplMetaDynObj = printTplDynObj.getDynamicObject(PRINTTPLID);
            Object printTplId = printTplDynObj.get(PRINTTPLID_ID);
            if (printTplMetaDynObj == null) {
                oldPrintMeatIdList.add(printTplId);
                continue;
            }
            String name = printTplMetaDynObj.getString("name");
            if (!NEW_TPL_TYPE.equals(type)) {
                if (StringUtils.isBlank((CharSequence)name)) {
                    oldPrintMeatIdList.add(printTplId);
                    continue;
                }
                templateMap.put(String.valueOf(printTplId), name);
                continue;
            }
            templateMap.put(String.valueOf(printTplId), name);
        }
        if (oldPrintMeatIdList.isEmpty()) {
            return templateMap;
        }
        qfBuilder.clear();
        qfBuilder.add("id", "in", oldPrintMeatIdList);
        for (DynamicObject printTplMetaDynObj : printTplMetaDynObjArray = BusinessDataServiceHelper.load((String)FormID_Formmeta, (String)String.join((CharSequence)",", "id", "name"), (QFilter[])qfBuilder.toArray(), null)) {
            templateMap.put(printTplMetaDynObj.getString("id"), printTplMetaDynObj.getString("name"));
        }
        return templateMap;
    }

    private void initDefaultCombo(String controlKey, Map<String, String> templatesMap, boolean notEmpty) {
        String formId;
        String defaulttpId;
        ComboEdit defaultCombo = (ComboEdit)this.getView().getControl(controlKey);
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(templatesMap.size());
        for (Map.Entry<String, String> entry : templatesMap.entrySet()) {
            ComboItem item = new ComboItem();
            item.setValue(entry.getKey());
            item.setCaption(new LocaleString(entry.getValue()));
            comboItems.add(item);
        }
        defaultCombo.setComboItems(comboItems);
        if ("defaulttemplate".equals(controlKey) && StringUtils.isNotBlank((CharSequence)(defaulttpId = this.getDefaulttplInManangeTool(formId = (String)this.getView().getFormShowParameter().getCustomParam("formid"))))) {
            this.getModel().setValue("defaulttemplate", (Object)defaulttpId);
        }
    }

    private void saveSetting() {
        String settingData = this.buildSettingData();
        String formId = (String)this.getView().getFormShowParameter().getCustomParam("formid");
        String userId = RequestContext.get().getUserId();
        String key = formId + CONFIG_COMMON_SUFFIX;
        if (StringUtils.isBlank((CharSequence)settingData)) {
            UserConfigServiceHelper.clearSetting((long)Long.parseLong(userId), (String)key);
        } else {
            UserConfigServiceHelper.setSetting((long)Long.parseLong(userId), (String)key, (String)settingData);
        }
        HashMap<String, String> cusData = new HashMap<String, String>();
        String sumfilter = (String)this.getModel().getValue(SUMFILTER);
        String excludezero = (Boolean)this.getModel().getValue(EXCLUSEZERO) != false ? "1" : "0";
        cusData.put(SUMFILTER, sumfilter);
        cusData.put(EXCLUSEZERO, excludezero);
        key = formId + CONFIG_CUSTOM_SUFFIX;
        UserConfigServiceHelper.setSetting((long)Long.parseLong(userId), (String)key, (String)SerializationUtils.toJsonString(cusData));
        this.getView().close();
    }

    private String buildSettingData() {
        Object pageSeparation;
        Object pageNumType;
        Object vSavePage;
        Object printerObj;
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
        String defaulttemplate = (String)this.getModel().getValue("defaulttemplate");
        if (StringUtils.isNotBlank((CharSequence)defaulttemplate)) {
            data.put("templateid", defaulttemplate);
        }
        if ((printerObj = this.getModel().getValue("defaultprinter")) != null) {
            data.put("printerid", ((DynamicObject)printerObj).getPkValue());
        }
        int entryRowCount = this.getModel().getEntryRowCount(Key_BaseGrid);
        ArrayList baseEntity = new ArrayList(entryRowCount);
        for (int i = 0; i < entryRowCount; ++i) {
            String billtypeid = (String)this.getModel().getValue("billtypeid", i);
            String templateid = (String)this.getModel().getValue("templateid", i);
            HashMap<String, String> billtypeprint = new HashMap<String, String>();
            billtypeprint.put("billtypeid", billtypeid);
            billtypeprint.put("templateid", templateid);
            baseEntity.add(billtypeprint);
        }
        if (!baseEntity.isEmpty()) {
            data.put("basesetting", baseEntity);
        }
        DynamicObjectCollection objs = this.getModel().getEntryEntity(Key_ADVGrid);
        data.put("complexsetting", objs);
        Object hSavePage = this.getModel().getValue("hsavepage");
        if (StringUtils.isNotBlank((Object)hSavePage)) {
            data.put("hSavePage", hSavePage);
        }
        if (StringUtils.isNotBlank((Object)(vSavePage = this.getModel().getValue("vsavepage")))) {
            data.put("vSavePage", vSavePage);
        }
        if (StringUtils.isNotBlank((Object)(pageNumType = this.getModel().getValue("pagenumtype")))) {
            data.put("pageNumType", pageNumType);
        }
        if (StringUtils.isNotBlank((Object)(pageSeparation = this.getModel().getValue("pageseparation")))) {
            data.put("pageSeparation", pageSeparation);
        }
        if (data.isEmpty()) {
            return "";
        }
        return SerializationUtils.toJsonString(data);
    }

    private void showFilterEditer() {
        FormMetadata formMeta;
        String entityId;
        int currentRowIndex = this.getModel().getEntryCurrentRowIndex(Key_ADVGrid);
        Object name = this.getModel().getValue("filtername", currentRowIndex);
        Object condition = this.getModel().getValue("filtercondition", currentRowIndex);
        Object type = this.getModel().getValue("filtertype", currentRowIndex);
        if (Integer.parseInt(type.toString()) == 2) {
            return;
        }
        String formId = (String)this.getView().getFormShowParameter().getCustomParam("formid");
        String id = MetadataDao.getIdByNumber((String)formId, (MetaCategory)MetaCategory.Form);
        if (!id.equals(entityId = (formMeta = (FormMetadata)MetadataDao.readMeta((String)id, (MetaCategory)MetaCategory.Form)).getEntityId())) {
            formId = MetadataDao.getNumberById((String)entityId);
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bos_printfilterediter");
        showParameter.setCustomParam("formid", (Object)formId);
        showParameter.setCustomParam("name", name);
        showParameter.setCustomParam("condition", condition);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "filtername");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    private String validAdvSetting() {
        String message = "";
        DynamicObjectCollection objs = this.getModel().getEntryEntity(Key_ADVGrid);
        int filtertypecount = 0;
        boolean existTemplateid = true;
        for (DynamicObject obj : objs) {
            if (Integer.parseInt(obj.getString("filtertype")) == 2) {
                ++filtertypecount;
            }
            if (!obj.getBoolean(ENABLE) || !StringUtils.isEmpty((CharSequence)obj.getString("filtertemplateid"))) continue;
            existTemplateid = false;
        }
        if (filtertypecount > 1) {
            message = ResManager.loadKDString((String)"\u4ec5\u5141\u8bb8\u6dfb\u52a0\u4e00\u6761\u7c7b\u578b\u4e3a\u201c\u5176\u5b83\u201d\u7684\u6761\u4ef6\u3002", (String)"VoucherPrintSettingPlugin_1", (String)"bos-form-business", (Object[])new Object[0]);
        } else if (!existTemplateid) {
            message = ResManager.loadKDString((String)"\u542f\u7528\u6761\u4ef6\u65f6\uff0c\u6253\u5370\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"VoucherPrintSettingPlugin_2", (String)"bos-form-business", (Object[])new Object[0]);
        }
        return message;
    }

    protected String getDefaulttplInManangeTool(String formId) {
        String tplId = null;
        QFilter[] qFilters = new QFilter[]{new QFilter(BILLFORMID, "=", (Object)formId), new QFilter("isdefault", "=", (Object)Boolean.TRUE)};
        Map cacheDatas = BusinessDataServiceHelper.loadFromCache((String)"bas_manageprinttpl", (String)"printtplid.id", (QFilter[])qFilters);
        if (!cacheDatas.isEmpty()) {
            for (Map.Entry cacheData : cacheDatas.entrySet()) {
                DynamicObject manageToolObj = (DynamicObject)cacheData.getValue();
                DynamicObject printtplObj = (DynamicObject)manageToolObj.get(PRINTTPLID);
                if (printtplObj == null) continue;
                tplId = (String)printtplObj.getPkValue();
                break;
            }
        }
        return tplId;
    }

    private boolean isExistEnableTpl(Object tplId) {
        boolean isExist = false;
        QFilter[] qFilters = new QFilter[]{new QFilter(PRINTTPLID, "=", tplId), new QFilter(ENABLE, "=", (Object)"1")};
        isExist = QueryServiceHelper.exists((String)"bas_manageprinttpl", (QFilter[])qFilters);
        return isExist;
    }
}

