/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.voucher.ipt;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.flex.FlexProperty;
import kd.bos.ext.fi.accountref.AccountRefUtils;
import kd.bos.ext.fi.flex.FlexFilterUtil;
import kd.bos.ext.fi.gl.flexplugin.FilterInfo;
import kd.bos.ext.fi.gl.flexplugin.SourceType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.bd.business.vo.CashFlowItemVO;
import kd.fi.bd.helper.CashFlowItemHelper;
import kd.fi.bd.util.BillParamUtil;
import kd.fi.gl.enums.voucher.VoucherExpireDateOption;
import kd.fi.gl.formplugin.voucher.VoucherEditArgHelper;
import kd.fi.gl.formplugin.voucher.ipt.VoucherImportAccountInfo;
import kd.fi.gl.formplugin.voucher.ipt.VoucherImportBookInfo;
import kd.fi.gl.formplugin.voucher.ipt.VoucherImportContext;
import kd.fi.gl.formplugin.voucher.ipt.VoucherImportDataCollection;
import kd.fi.gl.formplugin.voucher.ipt.VoucherImportEntryInfo;
import kd.fi.gl.formplugin.voucher.ipt.VoucherImportEntryInfoCollection;
import kd.fi.gl.formplugin.voucher.ipt.VoucherImportInfo;
import kd.fi.gl.formplugin.voucher.ipt.VoucherImportPeriodInfo;
import kd.fi.gl.util.AccountUtils;
import kd.fi.gl.util.DateUtil;
import kd.fi.gl.util.FlexUtils;
import kd.fi.gl.util.SystemParamHelper;

public class VoucherImportHandler {
    private static final Log LOG = LogFactory.getLog(VoucherImportHandler.class);
    public static final String FI_GL_FORMPLUGIN = "fi-gl-formplugin";
    public final Boolean isEnableAccountBankNumberToId = BillParamUtil.getBooleanValue((String)"83bfebc8000017ac", (String)"fi.gl.voucher.import.accountBankTransId.enable", (boolean)true);

    public VoucherImportHandler() {
        LOG.info("voucher_import account bank trans id enable:" + this.isEnableAccountBankNumberToId);
    }

    public void afterImportData(ImportDataEventArgs e, IDataModel voucherEditModel) {
        if (!voucherEditModel.getDataEntity().getDataEntityState().getFromDatabase()) {
            voucherEditModel.setValue("sourcetype", (Object)"8");
        }
        if (StringUtils.isBlank((Object)voucherEditModel.getValue("sourcetype"))) {
            voucherEditModel.setValue("sourcetype", (Object)"0");
        }
        if (StringUtils.isBlank((Object)voucherEditModel.getValue("sourcebilltype"))) {
            voucherEditModel.setValue("sourcebilltype", (Object)"gl_voucher");
        }
        if (StringUtils.isBlank((Object)voucherEditModel.getValue("sourcesys"))) {
            voucherEditModel.setValue("sourcesys", (Object)"83bfebc8000017ac");
        }
    }

    public List<String> beforeImportData(BeforeImportDataEventArgs e) {
        long bookId;
        long bookTypeId;
        ArrayList<String> errorMsgList = new ArrayList<String>(10);
        Map sourceData = e.getSourceData();
        VoucherImportInfo voucherImportInfo = new VoucherImportInfo(sourceData);
        if (Boolean.FALSE.equals(voucherImportInfo.isInited())) {
            this.initImportData(Collections.singletonList(sourceData));
            voucherImportInfo = new VoucherImportInfo(sourceData);
        }
        LOG.info("vch_ipt before data is : " + sourceData);
        long orgId = voucherImportInfo.getOrgId();
        if (orgId == 0L) {
            errorMsgList.add(String.format(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u7f16\u7801\u4e3a\uff1a%s\u7684\u7ec4\u7ec7\uff0c\u6216\u8005\u8be5\u7ec4\u7ec7\u6ca1\u6709\u51ed\u8bc1\u7684\u67e5\u770b\u6743\u9650\u3002", (String)"VoucherImportHandler_0", (String)FI_GL_FORMPLUGIN, (Object[])new Object[0]), voucherImportInfo.getOrgNumber()));
        }
        if ((bookTypeId = voucherImportInfo.getBookTypeId()) == 0L) {
            errorMsgList.add(String.format(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u7f16\u7801\u4e3a\uff1a%s\u7684\u8d26\u7c3f\u7c7b\u578b\u3002", (String)"VoucherImportHandler_1", (String)FI_GL_FORMPLUGIN, (Object[])new Object[0]), voucherImportInfo.getBookTypeNumber()));
        }
        if ((bookId = voucherImportInfo.getBookId()) == 0L) {
            errorMsgList.add(String.format(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u7ec4\u7ec7\uff1a%1$s,\u8d26\u7c3f\u7c7b\u578b\uff1a%2$s\u5bf9\u5e94\u7684\u5b9e\u4f53\u8d26\u7c3f\uff0c\u8bf7\u524d\u5f80\u57fa\u7840\u8d44\u6599\u7ef4\u62a4\u8d26\u7c3f\u3002", (String)"VoucherImportHandler_2", (String)FI_GL_FORMPLUGIN, (Object[])new Object[0]), voucherImportInfo.getOrgNumber(), voucherImportInfo.getBookTypeNumber()));
        }
        if (!errorMsgList.isEmpty()) {
            return errorMsgList;
        }
        VoucherImportPeriodInfo periodInfo = voucherImportInfo.getPeriodInfo();
        if (null == periodInfo) {
            errorMsgList.add(ResManager.loadKDString((String)"\u6839\u636e\u8bb0\u8d26\u65e5\u671f\u6216\u671f\u95f4\u7f16\u7801\u672a\u627e\u5230\u53ef\u7528\u7684\u671f\u95f4\uff0c\u6216\u8005\u671f\u95f4\u5df2\u7ed3\u8d26\u3002", (String)"VoucherImportHandler_3", (String)FI_GL_FORMPLUGIN, (Object[])new Object[0]));
        } else if (periodInfo.getId() == 0L) {
            errorMsgList.add(ResManager.loadKDString((String)"\u6839\u636e\u8bb0\u8d26\u65e5\u671f\u6216\u671f\u95f4\u7f16\u7801\u672a\u627e\u5230\u53ef\u7528\u7684\u671f\u95f4\uff0c\u6216\u8005\u671f\u95f4\u5df2\u7ed3\u8d26\u3002", (String)"VoucherImportHandler_3", (String)FI_GL_FORMPLUGIN, (Object[])new Object[0]));
        } else {
            Date bookedDate = voucherImportInfo.getBookedDate();
            if (null == bookedDate) {
                errorMsgList.add(ResManager.loadKDString((String)"\u8bb0\u8d26\u65e5\u671f\u672a\u586b\u5199\u3002", (String)"VoucherImportHandler_4", (String)FI_GL_FORMPLUGIN, (Object[])new Object[0]));
            } else {
                Date beginDate = periodInfo.getBeginDate();
                Date endDate = periodInfo.getEndDate();
                if (beginDate != null && endDate != null && (bookedDate.compareTo(beginDate) < 0 || bookedDate.compareTo(endDate) > 0)) {
                    errorMsgList.add(ResManager.loadKDString((String)"\u8bb0\u8d26\u65e5\u671f\u4e0d\u5728\u671f\u95f4\u7684\u8303\u56f4\u5185\u3002", (String)"VoucherImportHandler_5", (String)FI_GL_FORMPLUGIN, (Object[])new Object[0]));
                }
            }
        }
        if (!errorMsgList.isEmpty()) {
            return errorMsgList;
        }
        boolean checkAssistMustInput = SystemParamHelper.getBooleanParam((String)"checkassgrpinput", (long)orgId, (boolean)Boolean.FALSE);
        VoucherImportEntryInfoCollection voucherImportEntryInfoCollection = voucherImportInfo.getVoucherImportEntryInfoCollection();
        int index = 1;
        for (VoucherImportEntryInfo entryInfo : voucherImportEntryInfoCollection) {
            List<String> notFoundFlexKeys;
            long accountId = entryInfo.getAccountId();
            if (accountId == 0L) {
                errorMsgList.add(String.format(ResManager.loadKDString((String)"\u7b2c%1$d\u884c\u6839\u636e\u79d1\u76ee\u7f16\u7801\uff1a%2$s\u627e\u4e0d\u5230\u53ef\u4ee5\u4f7f\u7528\u7684\u660e\u7ec6\u79d1\u76ee\uff0c\u6216\u8005\u8be5\u79d1\u76ee\u4e0d\u652f\u6301\u624b\u5de5\u5f55\u5165\u3002", (String)"VoucherImportHandler_6", (String)FI_GL_FORMPLUGIN, (Object[])new Object[0]), index, entryInfo.getAccountNumber()));
            }
            if (entryInfo.getMainCFItemId() == 0L && StringUtils.isNotBlank((CharSequence)entryInfo.getMainCFItemNumber())) {
                errorMsgList.add(String.format(ResManager.loadKDString((String)"\u7b2c%1$d\u884c\u6839\u636e\u4e3b\u8868\u9879\u76ee\u7f16\u7801\uff1a%2$s\u627e\u4e0d\u5230\u53ef\u4ee5\u4f7f\u7528\u7684\u660e\u7ec6\u4e3b\u8868\u9879\u76ee\u3002", (String)"VoucherImportHandler_10", (String)FI_GL_FORMPLUGIN, (Object[])new Object[0]), index, entryInfo.getMainCFItemNumber()));
            }
            if (!(notFoundFlexKeys = entryInfo.getAssgrp().getNotFoundFlexKeys()).isEmpty()) {
                errorMsgList.add(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u6838\u7b97\u7ef4\u5ea6\u201c%2$s\u201d\uff0c\u65e0\u5339\u914d\u7684\u6838\u7b97\u7ef4\u5ea6\u7c7b\u578b\u3002", (String)"VoucherImportHandler_8", (String)FI_GL_FORMPLUGIN, (Object[])new Object[0]), index, String.join((CharSequence)"\u3001", notFoundFlexKeys)));
            }
            Map<String, Object> assgrpInfo = entryInfo.getAssgrp().getFlexFieldValueMap(entryInfo.getAccountInfo());
            for (Map.Entry<String, Object> entry : assgrpInfo.entrySet()) {
                Map valMap;
                Object id;
                Object v = entry.getValue();
                if (!(v instanceof Map) || !((id = (valMap = (Map)v).get("id")) instanceof Long) || (Long)id != 0L) continue;
                errorMsgList.add(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c%2$s\u6839\u636e\u7f16\u7801%3$s\u627e\u4e0d\u5230\u53ef\u4ee5\u4f7f\u7528\u7684\u503c\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u72b6\u6001\u662f\u5426\u53ef\u7528\u3002", (String)"VoucherImportHandler_9", (String)FI_GL_FORMPLUGIN, (Object[])new Object[0]), index, FlexUtils.getFlexPropertyLocalName((FlexProperty)FlexUtils.getFlexProperty((String)entry.getKey())), valMap.get("number")));
            }
            if (checkAssistMustInput) {
                Map<String, Boolean> flexMustInputMap = entryInfo.getAccountInfo().getFlexMustInputMap();
                for (Map.Entry<String, Boolean> flexMustInput : flexMustInputMap.entrySet()) {
                    Object assgrpValue;
                    String flexField = flexMustInput.getKey();
                    boolean mustInput = flexMustInput.getValue();
                    if (!mustInput || null != (assgrpValue = assgrpInfo.get(flexField))) continue;
                    FlexProperty flexProperty = FlexUtils.getFlexProperty((String)flexField);
                    errorMsgList.add(String.format(ResManager.loadKDString((String)"\u7b2c%1$d\u884c\u6838\u7b97\u7ef4\u5ea6%2$s\u4e3a\u5fc5\u5f55\u9879\u3002", (String)"VoucherImportHandler_7", (String)FI_GL_FORMPLUGIN, (Object[])new Object[0]), index, flexProperty == null ? flexField : FlexUtils.getFlexPropertyLocalName((FlexProperty)flexProperty)));
                }
            }
            ++index;
        }
        return errorMsgList;
    }

    public List<Map<String, Object>> initImportData(List<Map<String, Object>> sourceDataList) {
        VoucherImportDataCollection voucherImportDataCollection = new VoucherImportDataCollection(sourceDataList);
        VoucherImportContext voucherImportContext = VoucherImportContext.getOrCreate();
        voucherImportContext.init(voucherImportDataCollection);
        Map<String, Set<String>> bankFlexValueNumberSet = this.getBankFlexValueNumberSet(voucherImportDataCollection);
        HashMap<Long, Map<String, Long>> bankAccountNumberIdMap = new HashMap<Long, Map<String, Long>>();
        HashMap<String, Set<String>> accountNumberMap = new HashMap<String, Set<String>>(voucherImportContext.getOrgNumberIdMap().size());
        HashMultimap mainCFItemNumberMap = HashMultimap.create();
        for (VoucherImportInfo voucherImportInfo : voucherImportDataCollection) {
            voucherImportInfo.setInited();
            this.initHeadInfo(voucherImportInfo);
            long orgId = voucherImportInfo.getOrgId();
            String accountInfoMapKey = this.getAccountInfoMapKey(voucherImportInfo.getOrgId(), voucherImportInfo.getAccountTableId(), voucherImportInfo.getPeriodId());
            mainCFItemNumberMap.putAll((Object)this.getMainCFItemInfoMapKey(orgId, voucherImportInfo.getPeriodId()), voucherImportInfo.getVoucherImportEntryInfoCollection().getMainCFItemNumberSet());
            accountNumberMap.compute(accountInfoMapKey, (k, v) -> {
                if (null == v) {
                    v = new HashSet<String>(voucherImportInfo.getVoucherImportEntryInfoCollection().getAccountNumberSet().size());
                }
                v.addAll(voucherImportInfo.getVoucherImportEntryInfoCollection().getAccountNumberSet());
                return v;
            });
            Map<String, Long> numberIdMap = VoucherImportHandler.getBankAccountNumberIdMap(bankFlexValueNumberSet.get(voucherImportInfo.getOrgNumber()), voucherImportInfo.getOrgId(), voucherImportInfo.getBookTypeId());
            bankAccountNumberIdMap.put(voucherImportInfo.getOrgId(), numberIdMap);
        }
        boolean isHandleBankAccount = !bankAccountNumberIdMap.isEmpty();
        Map<String, Map<String, VoucherImportAccountInfo>> accountInfoMap = this.getAccountInfoMap(accountNumberMap, voucherImportContext.getPeriodIdEndDateMap());
        Set<String> bankAccountFlexFields = this.getBankAccountFlexFields();
        Map<String, Map<String, CashFlowItemVO>> mainCFItemInfoMap = this.getMainCFItemInfoMap((Multimap<String, String>)mainCFItemNumberMap);
        for (VoucherImportInfo voucherImportInfo : voucherImportDataCollection) {
            String accountInfoMapKey = this.getAccountInfoMapKey(voucherImportInfo.getOrgId(), voucherImportInfo.getAccountTableId(), voucherImportInfo.getPeriodId());
            Map<String, VoucherImportAccountInfo> accountNumberInfoMap = accountInfoMap.get(accountInfoMapKey);
            Map<String, CashFlowItemVO> curMainCFItemInfoMap = mainCFItemInfoMap.get(this.getMainCFItemInfoMapKey(voucherImportInfo.getOrgId(), voucherImportInfo.getPeriodId()));
            VoucherImportEntryInfoCollection voucherImportEntryInfoCollection = voucherImportInfo.getVoucherImportEntryInfoCollection();
            voucherImportEntryInfoCollection.setAccountInfo(accountNumberInfoMap);
            voucherImportEntryInfoCollection.setMainCFItemId(curMainCFItemInfoMap);
            for (VoucherImportEntryInfo entryInfo : voucherImportEntryInfoCollection) {
                this.initEntryInfo(voucherImportInfo, entryInfo, isHandleBankAccount, (Map)bankAccountNumberIdMap.get(voucherImportInfo.getOrgId()), bankAccountFlexFields);
            }
            LOG.info("vch_ipt init data is : " + voucherImportInfo.getSourceDataInfoMap());
        }
        return voucherImportDataCollection.getSourceDataList();
    }

    private void initHeadInfo(VoucherImportInfo voucherImportInfo) {
        VoucherImportContext voucherImportContext = VoucherImportContext.get();
        Long orgId = voucherImportContext.getOrgNumberIdMap().getOrDefault(voucherImportInfo.getOrgNumber(), 0L);
        voucherImportInfo.setOrgId(orgId);
        String bookTypeNumber = voucherImportInfo.getBookTypeNumber();
        long bookTypeId = 0L;
        if (StringUtils.isBlank((CharSequence)bookTypeNumber)) {
            Tuple<String, Long> mainBookType = voucherImportContext.getMainBookType();
            if (mainBookType != null) {
                voucherImportInfo.setBookTypeNumber((String)mainBookType.item1);
                bookTypeId = (Long)mainBookType.item2;
            }
        } else {
            bookTypeId = voucherImportContext.getBookTypeNumberIdMap().getOrDefault(bookTypeNumber, 0L);
        }
        voucherImportInfo.setBookTypeId(bookTypeId);
        voucherImportInfo.setBookInfo((VoucherImportBookInfo)voucherImportContext.getBookInfoMap().getOrDefault(orgId, Collections.emptyMap()).get(bookTypeId));
        VoucherImportPeriodInfo periodInfo = (VoucherImportPeriodInfo)voucherImportContext.getPeriodNumberTypeInfoMap().getOrDefault(voucherImportInfo.getPeriodNumber(), Collections.emptyMap()).get(voucherImportInfo.getPeriodTypeId());
        VoucherImportBookInfo bookInfo = voucherImportInfo.getBookInfo();
        Set<Long> openPeriodIdSet = voucherImportContext.getOpenedPeriodIdMap().getOrDefault(orgId, Collections.emptyMap()).getOrDefault(bookTypeId, Collections.emptySet());
        if (periodInfo == null) {
            List<VoucherImportPeriodInfo> importPeriodInfoList = voucherImportContext.getPeriodTypePeriodInfoMap().get(voucherImportInfo.getPeriodTypeId());
            VoucherImportPeriodInfo actualPeriodInfo = this.matchActualPeriod(importPeriodInfoList, openPeriodIdSet, bookInfo, voucherImportInfo.getBookedDate());
            voucherImportInfo.setPeriodInfo(actualPeriodInfo);
        } else {
            long curPeriodId = bookInfo.getCurPeriodId();
            if (periodInfo.getId() >= curPeriodId || openPeriodIdSet.contains(periodInfo.getId())) {
                voucherImportInfo.setPeriodInfo(periodInfo);
            } else {
                voucherImportInfo.setPeriodInfo(null);
            }
        }
        voucherImportInfo.setAccountTableId(AccountRefUtils.getCurPeriodAccountTableId((long)voucherImportInfo.getOrgId(), (long)voucherImportInfo.getBookTypeId(), (long)voucherImportInfo.getPeriodId()));
    }

    private void initEntryInfo(VoucherImportInfo voucherImportInfo, VoucherImportEntryInfo entryInfo, boolean isHandleBankAccount, Map<String, Long> bankAccountNumberIdMap, Set<String> bankAccountFlexFields) {
        Map<String, Object> assgrpInfo;
        boolean isNeedDueDate;
        boolean isBaseCurrency;
        boolean isCurrencyEmpty;
        boolean bl = isCurrencyEmpty = entryInfo.getCurrencyId() == 0L && StringUtils.isBlank((CharSequence)entryInfo.getCurrencyNumber());
        if (isCurrencyEmpty) {
            entryInfo.setCurrencyId(voucherImportInfo.getBaseCurrencyId());
            entryInfo.setCurrencyNumber(voucherImportInfo.getBaseCurrcncyNumber());
        }
        boolean bl2 = isBaseCurrency = entryInfo.getCurrencyId() == voucherImportInfo.getBaseCurrencyId() || entryInfo.getCurrencyNumber().equals(voucherImportInfo.getBaseCurrcncyNumber());
        if (isBaseCurrency) {
            entryInfo.setRate(BigDecimal.ONE);
        }
        boolean bl3 = isNeedDueDate = entryInfo.getAccountInfo().isAccheck() && entryInfo.getDueDate() == null;
        if (isNeedDueDate) {
            VoucherExpireDateOption dueDateOption = VoucherEditArgHelper.getExpireDateOption((long)voucherImportInfo.getOrgId());
            entryInfo.setDueDate(this.parseDateByOption(dueDateOption, voucherImportInfo));
        }
        if (isHandleBankAccount && (assgrpInfo = entryInfo.getAssgrp().getFlexFieldValueMap()) != null) {
            for (Map.Entry<String, Object> assgrpEntry : assgrpInfo.entrySet()) {
                Map valueMap;
                Object numberValue;
                Object value;
                if (!bankAccountFlexFields.contains(assgrpEntry.getKey()) || !((value = assgrpEntry.getValue()) instanceof Map) || !((numberValue = (valueMap = (Map)value).get("number")) instanceof String)) continue;
                String number = (String)numberValue;
                valueMap.put("id", bankAccountNumberIdMap.getOrDefault(number, 0L));
            }
        }
    }

    private VoucherImportPeriodInfo matchActualPeriod(List<VoucherImportPeriodInfo> periodInfoList, Set<Long> openedPeriodIds, VoucherImportBookInfo bookInfo, Date bookedDate) {
        Optional<VoucherImportPeriodInfo> result;
        if (CollectionUtils.isEmpty(periodInfoList) || bookedDate == null || bookInfo == null) {
            return null;
        }
        if (CollectionUtils.isNotEmpty(openedPeriodIds) && (result = periodInfoList.stream().filter(periodInfo -> openedPeriodIds.contains(periodInfo.getId()) && periodInfo.getBeginDate().compareTo(bookedDate) <= 0 && periodInfo.getEndDate().compareTo(bookedDate) >= 0).findFirst()).isPresent()) {
            return result.get();
        }
        result = periodInfoList.stream().filter(periodInfo -> periodInfo.getId() >= bookInfo.getCurPeriodId() && periodInfo.getBeginDate().compareTo(bookedDate) <= 0 && periodInfo.getEndDate().compareTo(bookedDate) >= 0).findFirst();
        if (result.isPresent()) {
            return result.get();
        }
        return null;
    }

    private Map<String, Map<String, VoucherImportAccountInfo>> getAccountInfoMap(Map<String, Set<String>> accountNumberMap, Map<Long, Date> periodIdEndDateMap) {
        HashMap<String, Map<String, VoucherImportAccountInfo>> accountInfoMap = new HashMap<String, Map<String, VoucherImportAccountInfo>>(accountNumberMap.size());
        for (Map.Entry<String, Set<String>> entry : accountNumberMap.entrySet()) {
            Set<String> accountNumberSet;
            String[] keySplit = entry.getKey().split("-");
            if (keySplit.length != 3) continue;
            long orgId = Long.parseLong(keySplit[0]);
            long accountTableId = Long.parseLong(keySplit[1]);
            long periodId = Long.parseLong(keySplit[2]);
            Date endDate = periodIdEndDateMap.get(periodId);
            if (orgId == 0L || accountTableId == 0L || periodId == 0L || endDate == null || (accountNumberSet = entry.getValue()).isEmpty()) continue;
            QFilter customFilter = new QFilter("number", "in", accountNumberSet).and(new QFilter("ismanual", "=", (Object)Boolean.TRUE));
            String flexKey = String.join((CharSequence)".", "checkitementry", "asstactitem", "flexfield");
            String flexMustInput = String.join((CharSequence)".", "checkitementry", "isrequire");
            DataSet accountDataSet = AccountUtils.getAccountDataSet((long)orgId, (long)accountTableId, (Date)endDate, (boolean)Boolean.TRUE, (QFilter)customFilter, (String[])new String[]{"id", "number", "accheck", flexKey, flexMustInput});
            Throwable throwable = null;
            try {
                HashMap<String, VoucherImportAccountInfo> accountNumberInfoMap = new HashMap<String, VoucherImportAccountInfo>(accountNumberSet.size());
                for (Row row : accountDataSet) {
                    VoucherImportAccountInfo accountInfo = (VoucherImportAccountInfo)accountNumberInfoMap.get(row.getString("number"));
                    Long accountId = row.getLong("id");
                    String flexField = row.getString(flexKey);
                    Boolean mustInput = row.getBoolean(flexMustInput);
                    if (accountInfo == null) {
                        HashMap<String, Boolean> flexMustInputMap = new HashMap<String, Boolean>(1);
                        if (StringUtils.isNotBlank((CharSequence)flexField)) {
                            flexMustInputMap.put(flexField, mustInput);
                        }
                        accountNumberInfoMap.put(row.getString("number"), new VoucherImportAccountInfo(accountId, row.getBoolean("accheck"), flexMustInputMap));
                        continue;
                    }
                    if (accountInfo.getId() != accountId.longValue() || !StringUtils.isNotBlank((CharSequence)flexField)) continue;
                    accountInfo.getFlexMustInputMap().put(flexField, mustInput);
                }
                accountInfoMap.put(entry.getKey(), accountNumberInfoMap);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (accountDataSet == null) continue;
                if (throwable != null) {
                    try {
                        accountDataSet.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                accountDataSet.close();
            }
        }
        return accountInfoMap;
    }

    private Map<String, Map<String, CashFlowItemVO>> getMainCFItemInfoMap(Multimap<String, String> mainCFItemNumberMap) {
        HashMap<String, Map<String, CashFlowItemVO>> result = new HashMap<String, Map<String, CashFlowItemVO>>(mainCFItemNumberMap.size());
        for (Map.Entry entry : mainCFItemNumberMap.asMap().entrySet()) {
            String[] keySplit = ((String)entry.getKey()).split("-");
            long orgId = Long.parseLong(keySplit[0]);
            long periodId = Long.parseLong(keySplit[1]);
            if (orgId == 0L || periodId == 0L) continue;
            result.put((String)entry.getKey(), CashFlowItemHelper.loadForVersion((String[])((Collection)entry.getValue()).toArray(new String[0]), (Long)orgId, (Long)periodId, CashFlowItemVO::getLeaf));
        }
        return result;
    }

    private Set<String> getBankAccountFlexFields() {
        if (!this.isEnableAccountBankNumberToId.booleanValue()) {
            return Collections.emptySet();
        }
        return (Set)ThreadCache.get((Object)(VoucherImportHandler.class.getName() + "#getBankAccountFlexFields"), () -> FlexUtils.getAllFlexType().stream().filter(x -> "am_accountbank".equals(x.getValueSource()) || "bd_accountbanks".equals(x.getValueSource())).map(FlexProperty::getFlexField).collect(Collectors.toSet()));
    }

    private Map<String, Set<String>> getBankFlexValueNumberSet(VoucherImportDataCollection voucherImportDataCollection) {
        if (!this.isEnableAccountBankNumberToId.booleanValue()) {
            return Collections.emptyMap();
        }
        Set<String> bankAccountFlexFields = this.getBankAccountFlexFields();
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>(voucherImportDataCollection.getOrgNumberSet().size());
        bankAccountFlexFields.stream().map(x -> voucherImportDataCollection.getFlex_org_baseDataNums().row(x)).filter(x -> x != null && !x.isEmpty()).forEach(x -> x.forEach((k, v) -> result.merge((String)k, (Set<String>)v, (v1, v2) -> {
            v1.addAll(v2);
            return v1;
        })));
        return result;
    }

    public static Map<String, Long> getBankAccountNumberIdMap(Set<String> bankAccountNumberSet, long orgId, long bookTypeId) {
        if (CollectionUtils.isEmpty(bankAccountNumberSet)) {
            return Collections.emptyMap();
        }
        QFilter numberFilter = new QFilter("number", "in", bankAccountNumberSet);
        FilterInfo filterInfo = FlexFilterUtil.getBankQFilter((long)orgId, (long)bookTypeId, (String)"bd_accountbanks", (SourceType)SourceType.bill, null, Collections.emptyList());
        if (filterInfo != null) {
            numberFilter.and(filterInfo.getFilter());
        }
        Map bankAccountFromDb = BusinessDataServiceHelper.loadFromCache((String)"bd_accountbanks", (String)"id,number,masterid", (QFilter[])numberFilter.toArray());
        return bankAccountFromDb.values().stream().collect(Collectors.toMap(x -> x.getString("number"), x -> {
            long masterId = x.getLong("masterid");
            if (masterId > 0L) {
                return masterId;
            }
            return x.getLong("id");
        }, (oldVal, newVal) -> newVal));
    }

    private String getAccountInfoMapKey(long orgId, long accountTableId, long periodId) {
        return StringUtils.join((Object[])new Object[]{orgId, accountTableId, periodId}, (String)"-");
    }

    private Date parseDateByOption(VoucherExpireDateOption option, VoucherImportInfo voucherImportInfo) {
        switch (option) {
            case FROM_BIZDATE: {
                return voucherImportInfo.getBizDate();
            }
            case FROM_SYSDATE: {
                return DateUtil.makeDateOnDayStrart((Date)new Date());
            }
        }
        return voucherImportInfo.getBookedDate();
    }

    private String getMainCFItemInfoMapKey(long orgId, long periodId) {
        return StringUtils.join((Object[])new Object[]{orgId, periodId}, (String)"-");
    }
}

