/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.voucher.list.enhancer;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import kd.bos.logging.Log;
import kd.fi.bd.logger.ExtLogFactory;
import kd.fi.gl.formplugin.voucher.list.ctx.VoucherListContext;
import kd.fi.gl.formplugin.voucher.list.enhancer.IContextEnhancer;
import kd.fi.gl.formplugin.voucher.list.enhancer.impl.CommonFiltersEnhancer;
import kd.fi.gl.formplugin.voucher.list.enhancer.impl.CommonOrderByEnhancer;
import kd.fi.gl.formplugin.voucher.list.enums.QueryType;

public class VoucherListContextEnhancer {
    private static final Log LOG = ExtLogFactory.getLog(VoucherListContextEnhancer.class);
    private static final Map<QueryType, Supplier<List<IContextEnhancer>>> FACTORY_MAP = new HashMap<QueryType, Supplier<List<IContextEnhancer>>>(8);

    public static List<IContextEnhancer> getEnhancers(QueryType queryType) {
        if (queryType == null) {
            return Collections.emptyList();
        }
        return FACTORY_MAP.getOrDefault((Object)queryType, Collections::emptyList).get();
    }

    public static void enhance(QueryType queryType, VoucherListContext ctx) {
        List<IContextEnhancer> enhancers = VoucherListContextEnhancer.getEnhancers(queryType);
        for (IContextEnhancer enhancer : enhancers) {
            if (!enhancer.enable(ctx)) continue;
            enhancer.enhance(ctx);
            LOG.info("voucher_list_ctx enhance by {},{}", (Object)enhancer.getClass().getSimpleName(), (Object)ctx);
        }
    }

    static {
        FACTORY_MAP.put(QueryType.SEARCH, () -> ImmutableList.of((Object)new CommonFiltersEnhancer(), (Object)new CommonOrderByEnhancer()));
        FACTORY_MAP.put(QueryType.EXPORT, () -> ImmutableList.of((Object)new CommonFiltersEnhancer(), (Object)new CommonOrderByEnhancer()));
        FACTORY_MAP.put(QueryType.SELECT_ALL, () -> ImmutableList.of((Object)new CommonFiltersEnhancer(), (Object)new CommonOrderByEnhancer()));
        FACTORY_MAP.put(QueryType.GET_REAL_COUNT, () -> ImmutableList.of((Object)new CommonFiltersEnhancer()));
        FACTORY_MAP.put(QueryType.GET_BILL_DATA_COUNT, () -> ImmutableList.of((Object)new CommonFiltersEnhancer()));
        FACTORY_MAP.put(QueryType.GET_SUMMARY_RESULTS, () -> ImmutableList.of((Object)new CommonFiltersEnhancer()));
    }
}

