/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.voucher.list.query;

import java.util.Iterator;
import java.util.function.Function;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.Consumer;

public class BatchPageQuery<P> {
    private final Iterator<P> batchParamIterator;
    private final Consumer<Row> beforePageRowConsumer;
    private final Consumer<Row> onPageRowConsumer;
    private final Function<BatchQueryParam<P>, DataSet> query;

    public BatchPageQuery(Iterator<P> batchParamIterator, Consumer<Row> beforePageRowConsumer, Consumer<Row> onPageRowConsumer, Function<BatchQueryParam<P>, DataSet> query) {
        this.batchParamIterator = batchParamIterator;
        this.beforePageRowConsumer = beforePageRowConsumer;
        this.onPageRowConsumer = onPageRowConsumer;
        this.query = query;
    }

    public void query(int start, int pageSize) {
        int totalLimit = start + pageSize;
        int dataCount = 0;
        BatchQueryParam<P> param = new BatchQueryParam<P>();
        param.setLimit(totalLimit);
        while (this.batchParamIterator.hasNext() && param.getLimit() > 0) {
            param.setStart(0);
            param.setParam(this.batchParamIterator.next());
            DataSet dataSet = this.query.apply(param);
            Throwable throwable = null;
            try {
                for (Row row : dataSet) {
                    if (++dataCount > start) {
                        this.onPageRowConsumer.accept((Object)row);
                        continue;
                    }
                    this.beforePageRowConsumer.accept((Object)row);
                }
                param.setLimit(totalLimit - dataCount);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (dataSet == null) continue;
                if (throwable != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                dataSet.close();
            }
        }
    }

    public static class BatchQueryParam<P> {
        private int start;
        private int limit;
        private P param;

        public int getStart() {
            return this.start;
        }

        public void setStart(int start) {
            this.start = start;
        }

        public int getLimit() {
            return this.limit;
        }

        public void setLimit(int limit) {
            this.limit = limit;
        }

        public P getParam() {
            return this.param;
        }

        public void setParam(P param) {
            this.param = param;
        }
    }
}

