/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.voucher.list.query.impl;

import java.util.function.Function;
import kd.bos.algo.DataSet;
import kd.bos.context.OperationContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.QueryEntityType;
import kd.fi.gl.enums.GLBillParamEnum;
import kd.fi.gl.formplugin.voucher.list.query.QueryBuilderWrapper;

public class WithoutEntryOrderQuery {
    private static final String COMMA = ",";
    private static final String ENTRY_PREF = "entries.";

    public static DataSet query(QueryBuilderWrapper queryBuilder, Function<QueryBuilderWrapper, DataSet> queryFunc) {
        if (queryBuilder == null || queryBuilder.getQueryBuilder().getEntityType() instanceof QueryEntityType) {
            return queryFunc.apply(queryBuilder);
        }
        if (OperationContext.get() != null && "kd.bos.mvc.export.ExportListTask".equals(OperationContext.get().getFormName())) {
            return queryFunc.apply(queryBuilder);
        }
        if (!GLBillParamEnum.VOUCHER_QUERY_WITHOUT_ENTRY_ORDER_ENABLE.getBooleanValue()) {
            return queryFunc.apply(queryBuilder);
        }
        String orderBys = queryBuilder.getTempOrderBys();
        String withoutEntryOrderBys = WithoutEntryOrderQuery.removeEntryOrderBys(orderBys);
        queryBuilder.setTempOrderBys(withoutEntryOrderBys);
        DataSet dataSet = queryFunc.apply(queryBuilder);
        if (StringUtils.isNotBlank((CharSequence)orderBys) && withoutEntryOrderBys.length() != orderBys.length()) {
            dataSet = dataSet.orderBy(orderBys.split(COMMA));
        }
        return dataSet;
    }

    protected static String removeEntryOrderBys(String orderBys) {
        String[] orderByArray;
        StringBuilder withoutEntryOrderBys = new StringBuilder();
        if (StringUtils.isBlank((CharSequence)orderBys)) {
            return orderBys;
        }
        for (String orderBy : orderByArray = orderBys.split(COMMA)) {
            if (orderBy.trim().startsWith(ENTRY_PREF)) continue;
            if (withoutEntryOrderBys.length() > 0) {
                withoutEntryOrderBys.append(COMMA);
            }
            withoutEntryOrderBys.append(orderBy);
        }
        return withoutEntryOrderBys.toString();
    }
}

