/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.voucher.list.range;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoContext;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.logging.Log;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.fi.bd.logger.ExtLogFactory;
import kd.fi.gl.formplugin.voucher.list.range.VoucherRangeProperty;
import kd.fi.gl.formplugin.voucher.list.range.VoucherRanges;
import kd.fi.gl.formplugin.voucher.list.range.VoucherRangesParam;
import kd.fi.gl.voucher.count.VoucherCountHelper;

public class VoucherRangeQuery {
    private static final Log LOG = ExtLogFactory.getLog(VoucherRangeQuery.class);
    private static final Set<String> VOUCHER_COUNT_KEYS = ImmutableSet.of((Object)"org", (Object)"booktype", (Object)"period", (Object)"bookeddate", (Object)"billstatus", (Object)"ischeck", (Object[])new String[]{"ispost", "sourcetype", "mainstatus", "suppstatus"});

    public static Optional<VoucherRanges> query(VoucherRangesParam param) {
        try {
            if (!VoucherCountHelper.checkFilterOptEnable((QFilter[])param.getFilters())) {
                return Optional.empty();
            }
            ArrayList<String> countOrderByList = null;
            String countOrderBy = null;
            String voucherOrderBy = param.getOrderBy();
            if (StringUtils.isNotEmpty((String)voucherOrderBy)) {
                String order;
                List voucherOrderByList = Arrays.stream(voucherOrderBy.split(",")).collect(Collectors.toList());
                countOrderByList = new ArrayList<String>(voucherOrderByList.size());
                Iterator iterator = voucherOrderByList.iterator();
                while (iterator.hasNext() && VOUCHER_COUNT_KEYS.contains((order = (String)iterator.next()).split(" ")[0].toLowerCase())) {
                    countOrderByList.add(order);
                }
                countOrderBy = String.join((CharSequence)",", countOrderByList);
            }
            LOG.info("orderBy voucherOrderBy: {}, countOrderBy: {}", (Object)voucherOrderBy, countOrderBy);
            if (countOrderBy == null || CollectionUtils.isEmpty(countOrderByList) || !countOrderBy.contains("org") || !countOrderBy.contains("period") && !countOrderBy.contains("bookeddate")) {
                return Optional.empty();
            }
            boolean isEntryCounted = param.isEntryCounted();
            List filters = VoucherCountHelper.optimizeVoucherFilters((QFilter[])param.getFilters());
            ArrayList groupBys = Lists.newArrayList((Object[])new String[]{"org", "period", "bookeddate"});
            groupBys.addAll(countOrderByList.stream().map(x -> x.split(" ")[0]).filter(x -> !groupBys.contains(x)).collect(Collectors.toSet()));
            ArrayList<String> countSelects = new ArrayList<String>(groupBys);
            ArrayList<String> logSelects = new ArrayList<String>(groupBys);
            if (isEntryCounted) {
                countSelects.add("entrycount cnt");
                logSelects.add("count cnt");
            } else {
                countSelects.add("vouchercount cnt");
                logSelects.add("case when count > 0 then 1 else -1 end as cnt");
            }
            VoucherRanges.Builder rangesBuilder = new VoucherRanges.Builder();
            try (AlgoContext ignored = Algo.newContext();){
                DataSet countSet = QueryServiceHelper.queryDataSet((String)VoucherRangeQuery.class.getName(), (String)"gl_vouchercount", (String)String.join((CharSequence)",", countSelects), (QFilter[])filters.toArray(new QFilter[0]), (String)countOrderBy);
                filters.add(new QFilter("calculated", "=", (Object)false));
                filters.add(new QFilter("count", "!=", (Object)0));
                DataSet logSet = QueryServiceHelper.queryDataSet((String)VoucherRangeQuery.class.getName(), (String)"gl_vouchercount_log", (String)String.join((CharSequence)",", logSelects), (QFilter[])filters.toArray(new QFilter[0]), (String)countOrderBy);
                if (!logSet.isEmpty()) {
                    countSet = logSet.union(countSet).groupBy(groupBys.toArray(new String[0])).sum("cnt").finish().orderBy(countOrderByList.toArray(new String[0]));
                }
                int cntIndex = groupBys.size();
                for (Row row : countSet) {
                    rangesBuilder.add(new VoucherRangeProperty(row.getLong(0), row.getLong(1), row.getDate(2)), row.getInteger(cntIndex));
                    if (rangesBuilder.getTotalCount() < param.getMaxLimit()) continue;
                    break;
                }
            }
            VoucherRanges ranges = rangesBuilder.build();
            return Optional.of(ranges);
        }
        catch (Exception e) {
            LOG.error("error", (Throwable)e);
            return Optional.empty();
        }
    }
}

