/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.voucher.list.utils;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.orm.query.QEmptyValue;
import kd.bos.orm.query.QFilter;
import kd.fi.bd.service.balance.VoucherQueryUtils;
import kd.fi.bd.util.filter.QFilterBuilder;

public class QFilterUtil {
    private static final Predicate<QFilter> ORG_ID_FILTER_PREDICATE = f -> !(!"org".equalsIgnoreCase(f.getProperty()) && !"org.id".equalsIgnoreCase(f.getProperty()) || !"=".equalsIgnoreCase(f.getCP()) && !"in".equalsIgnoreCase(f.getCP()) || f.getValue() == null || f.getValue() instanceof QEmptyValue);

    public static List<QFilter> getOrgIdFilters(List<QFilter> filters) {
        return VoucherQueryUtils.getFilterMatchAndNestsAllMatchFilterList(filters, ORG_ID_FILTER_PREDICATE);
    }

    public static QFilterBuilder removeOrgIdFilters(List<QFilter> filters) {
        return new QFilterBuilder((Collection)VoucherQueryUtils.removeFilterMatchAndNestsAllMatchFilterList(filters, ORG_ID_FILTER_PREDICATE));
    }

    public static Set<Long> getFilterOrgIds(List<QFilter> filters) {
        Set filterOrgIds = null;
        List<QFilter> orgIdFilters = QFilterUtil.getOrgIdFilters(filters);
        for (QFilter orgIdFilter : orgIdFilters) {
            Set orgIds = VoucherQueryUtils.convertFilterValue((Object)orgIdFilter.getValue()).stream().filter(Objects::nonNull).map(x -> Long.valueOf(x.toString())).collect(Collectors.toSet());
            if (filterOrgIds == null) {
                filterOrgIds = orgIds;
                continue;
            }
            filterOrgIds.retainAll(orgIds);
        }
        if (filterOrgIds == null) {
            return new HashSet<Long>(2);
        }
        return filterOrgIds;
    }
}

