/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.voucher.list.utils;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.util.StringUtils;
import kd.fi.gl.formplugin.voucher.list.enums.SortType;

public class SortUtil {
    public static Optional<SortType> tryGetSortType(String orderByExpr, String field) {
        if (StringUtils.isEmpty((String)orderByExpr)) {
            return Optional.empty();
        }
        Optional<String[]> orderBy = Arrays.stream(orderByExpr.split(",")).map(x -> x.split(" ")).filter(x -> ((String[])x).length > 0 && x[0].equalsIgnoreCase(field)).findAny();
        if (!orderBy.isPresent()) {
            return Optional.empty();
        }
        String[] split = orderBy.get();
        if (split.length <= 1) {
            return Optional.of(SortType.ASC);
        }
        if (SortType.DESC.name().equalsIgnoreCase(split[1])) {
            return Optional.of(SortType.DESC);
        }
        return Optional.of(SortType.ASC);
    }

    public static <T> List<T> sort(Set<T> originalSet, Comparator<T> comparator, T startValue) {
        List sortedList = startValue != null ? originalSet.stream().filter(x -> comparator.compare(x, startValue) >= 0).sorted(comparator).collect(Collectors.toList()) : originalSet.stream().sorted(comparator).collect(Collectors.toList());
        return sortedList;
    }
}

