/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.voucher.mc.backcalc;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Optional;
import kd.fi.bd.rate.RateType;
import kd.fi.gl.business.service.voucher.mc.MulLocalConfig;
import kd.fi.gl.business.vo.voucher.mc.IMCVoucherModel;
import kd.fi.gl.formplugin.voucher.backcalculate.BackCalculateChangedValue;
import kd.fi.gl.formplugin.voucher.backcalculate.BackCalculateResult;
import kd.fi.gl.formplugin.voucher.mc.backcalc.AbstractMulLocalBackCalculator;
import kd.fi.gl.formplugin.voucher.mc.service.MCVoucherFormService;

public class MulLocalExRateChanged
extends AbstractMulLocalBackCalculator {
    @Override
    public String[] applicableChangedFields() {
        return (String[])Arrays.stream(MulLocalConfig.enabledConfigs()).map(MulLocalConfig::getExRateField).toArray(String[]::new);
    }

    @Override
    public Optional<BackCalculateResult> backCalculateEmptyValue(BackCalculateChangedValue emptyValue, MulLocalConfig config) {
        return Optional.of(new BackCalculateResult(config.getLocalAmountField(emptyValue.getVoucherEditView().getValueGetter().getEntryDC(emptyValue.getRowIndex())), BigDecimal.ZERO));
    }

    @Override
    public Optional<BackCalculateResult> backCalculateNormalValue(BackCalculateChangedValue normalValue, MulLocalConfig config) {
        IMCVoucherModel voucherModel = MCVoucherFormService.get(normalValue.getVoucherEditView()).getMCVoucherModel();
        int rowIndex = normalValue.getRowIndex();
        BigDecimal originalAmount = voucherModel.getMCOriAmt(config, rowIndex);
        RateType exRateType = voucherModel.getMCExRateType(config, rowIndex);
        BigDecimal localAmount = exRateType.getRateCalculator().calLocAmount(normalValue.getValue(), originalAmount, voucherModel.getMCLocalCurAmtPrecision(config));
        return Optional.of(new BackCalculateResult(config.getLocalAmountField(voucherModel.getEntryDC(rowIndex)), localAmount));
    }

    @Override
    public boolean applicable(String changedField, MulLocalConfig config) {
        return changedField.equalsIgnoreCase(config.getExRateField());
    }
}

