/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.voucher.mc.service.handler;

import java.math.BigDecimal;
import java.math.RoundingMode;
import kd.bos.dataentity.entity.DynamicObject;
import kd.fi.gl.business.service.voucher.mc.MulLocalConfig;
import kd.fi.gl.business.vo.voucher.mc.IMCVoucherModel;
import kd.fi.gl.formplugin.voucher.args.AutoBalanceArg;
import kd.fi.gl.formplugin.voucher.mc.service.handler.AbstractMCFormEventHandler;

public class AutoBalanceHandler
extends AbstractMCFormEventHandler {
    public void autoBalance(AutoBalanceArg arg) {
        MulLocalConfig[] configs = this.getEnabledConfigs();
        IMCVoucherModel voucherModel = this.getMCVoucherModel();
        for (MulLocalConfig config : configs) {
            int rowIndex;
            String entryDC;
            String focusField = arg.getFocusField();
            if (!focusField.equalsIgnoreCase(config.getDebitField()) && !focusField.equalsIgnoreCase(config.getCreditField()) || !focusField.equalsIgnoreCase(config.getLocalAmountField(entryDC = voucherModel.getEntryDC(rowIndex = arg.getRowIndex())))) continue;
            int currentSeq = rowIndex + 1;
            BigDecimal debitTotal = BigDecimal.ZERO;
            BigDecimal creditTotal = BigDecimal.ZERO;
            for (DynamicObject entry : arg.getEntries()) {
                if (entry.getInt("seq") == currentSeq) continue;
                debitTotal = debitTotal.add(entry.getBigDecimal(config.getDebitField()));
                creditTotal = creditTotal.add(entry.getBigDecimal(config.getCreditField()));
            }
            BigDecimal amount = debitTotal.subtract(creditTotal).setScale(voucherModel.getMCLocalCurAmtPrecision(config), RoundingMode.HALF_UP);
            if ("1".equals(entryDC)) {
                amount = amount.multiply(new BigDecimal(-1));
            }
            arg.getView().getVoucherEditModel().setValue(focusField, (Object)amount, rowIndex);
        }
    }
}

