/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.voucher.mc.service.handler;

import java.math.BigDecimal;
import kd.fi.gl.business.service.voucher.mc.MulLocalConfig;
import kd.fi.gl.business.vo.voucher.mc.IMCVoucherModel;
import kd.fi.gl.formplugin.voucher.backcalculate.BackCalculateServiceHelper;
import kd.fi.gl.formplugin.voucher.mc.service.handler.AbstractMCFormEventHandler;
import kd.fi.gl.formplugin.voucher.valuechange.events.UpdateRowEventArgs;

public class EntryDCChangedHandler
extends AbstractMCFormEventHandler {
    public void onEntryDCChanged(UpdateRowEventArgs args) {
        MulLocalConfig[] configs = this.getEnabledConfigs();
        IMCVoucherModel voucherModel = this.getMCVoucherModel();
        for (MulLocalConfig config : configs) {
            BigDecimal updateCredit;
            BigDecimal updateDebit;
            String dc = (String)args.getNewValue();
            int rowIndex = args.getRowIndex();
            BigDecimal debit = voucherModel.getMCDebitAmount(config, rowIndex);
            BigDecimal credit = voucherModel.getMCCreditAmount(config, rowIndex);
            if ("1".equalsIgnoreCase(dc)) {
                updateDebit = debit.signum() == 0 ? credit : debit;
                updateCredit = BigDecimal.ZERO;
            } else {
                updateCredit = credit.signum() == 0 ? debit : credit;
                updateDebit = BigDecimal.ZERO;
            }
            if (updateDebit.compareTo(debit) != 0) {
                BackCalculateServiceHelper.setIgnore(rowIndex, config.getDebitField());
                voucherModel.setMCDebitAmount(config, updateDebit, rowIndex);
            }
            if (updateCredit.compareTo(credit) == 0) continue;
            BackCalculateServiceHelper.setIgnore(rowIndex, config.getCreditField());
            voucherModel.setMCCreditAmount(config, updateCredit, rowIndex);
        }
    }
}

