/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.init;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.util.Tuple2;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.flex.FlexProperty;
import kd.bos.entity.property.CurrencyProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.BillView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.JSONUtils;
import kd.fi.bd.business.service.LocalCurrencyConfigService;
import kd.fi.bd.business.vo.LocalCurrencyConfigVO;
import kd.fi.bd.business.vo.MetaField;
import kd.fi.bd.consts.MCT;
import kd.fi.bd.util.AccountUtils;
import kd.fi.bd.util.BillParamUtil;
import kd.fi.bd.vo.CommonAssist;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.accsys.AccountInfo;
import kd.fi.gl.comassist.model.ComAssistTable;
import kd.fi.gl.comassist.service.ComAssistService;
import kd.fi.gl.comassist.service.ComAssistTableService;
import kd.fi.gl.common.Tuple;
import kd.fi.gl.constant.GLField;
import kd.fi.gl.formplugin.comassist.ComAssistImportPlugin;
import kd.fi.gl.formplugin.voucher.ipt.VoucherImportAssgrp;
import kd.fi.gl.formplugin.voucher.ipt.VoucherImportHandler;
import kd.fi.gl.util.CommonAssistUtil;
import kd.fi.gl.util.FlexUtils;
import kd.fi.gl.util.GLApp;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.GlFormUtil;
import kd.fi.gl.util.VoucherUtil;

public class InitBalanceEdit
extends AbstractBillPlugIn
implements IBillWebApiPlugin {
    private static final Log LOG = LogFactory.getLog(InitBalanceEdit.class);
    private static final String NUMBER = "number";
    private static final String CACHE_KEY_ORG = "initbalance-import-org";
    private static final String CACHE_KEY_AT = "initbalance-import-accounttable";
    private static final String ACCTKEY = "initbalacctkey";
    private static final String FLEXPROPERTY = "initbalance-import-flex";
    private static final String PARENTDATA = "initbalance-import-parent";
    private static final String[] debits = new String[]{"begindebitlocal", "begindebitqty", "begindebitfor"};
    private static final String[] credits = new String[]{"begincreditqty", "begincreditlocal", "begincreditfor"};
    private final Map<String, Long> treeComAssistNum2Id = new HashMap<String, Long>();
    private final Map<String, QFilter> treeFilterCache = new HashMap<String, QFilter>();
    private final Map<String, QFilter> rangeFilterCache = new HashMap<String, QFilter>();

    public void registerListener(EventObject e) {
        BasedataEdit accEdit = (BasedataEdit)this.getControl("account");
        Object at = this.getModel().getValue(GLField.id_((String)"accounttable"));
        accEdit.addBeforeF7SelectListener(evt -> {
            AccountBookInfo bookInfo;
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            List qFilters = param.getListFilterParameter().getQFilters();
            QFilter atF = new QFilter("accounttable", "=", at);
            QFilter isLeaf = new QFilter("isleaf", "=", (Object)true);
            String bookInfoStr = (String)this.getView().getFormShowParameter().getCustomParam("accountBookInfo");
            if (bookInfoStr != null && !(bookInfo = (AccountBookInfo)GLUtil.fromSerializedString((String)bookInfoStr)).isBudget()) {
                qFilters.add(new QFilter("accounttype.accounttype", "not in", (Object)GLUtil.getBudgetTypes()));
            }
            qFilters.add(atF);
            qFilters.add(isLeaf);
        });
        BasedataEdit measureUnit = (BasedataEdit)this.getControl("measureunit");
        measureUnit.addBeforeF7SelectListener(evt -> {
            DynamicObject account = (DynamicObject)this.getModel().getValue("account");
            if (account == null) {
                return;
            }
            long measureunitgroupid = account.getLong(GLField.join((String[])new String[]{"measureunitgroup", "id"}));
            if (measureunitgroupid != 0L) {
                ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
                List qFilters = param.getListFilterParameter().getQFilters();
                qFilters.add(new QFilter("group", "=", (Object)measureunitgroupid));
            }
        });
        this.getCommonAssistTable().ifPresent(commonAssistTable -> {
            ComAssistTableService.modifyCommonAssistFields((ComAssistTable)commonAssistTable, (IFormView)this.getView());
            ComAssistTableService.registerF7Listener((ComAssistTable)commonAssistTable, (BillView)((BillView)this.getView()));
        });
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        Object value = e.getChangeSet()[0].getNewValue();
        IDataModel model = this.getModel();
        if (value == null || value instanceof BigDecimal && ((BigDecimal)value).signum() == 0) {
            return;
        }
        if ("account".equals(name)) {
            long accId = ((DynamicObject)value).getLong("id");
            this.styleRefAccount(accId, false);
        } else if (name.startsWith("begindebit")) {
            if (((BigDecimal)value).compareTo(BigDecimal.ZERO) == 0) {
                return;
            }
            this.clearCreditValue();
            this.clearMcCreditValue();
        } else if (name.startsWith("begincredit")) {
            if (((BigDecimal)value).compareTo(BigDecimal.ZERO) == 0) {
                return;
            }
            this.clearDebitValue();
            this.clearMcDebitValue();
        } else if (name.startsWith("$$")) {
            VoucherUtil.setAssgrpByRelation(this, e.getProperty().getAlias(), e.getChangeSet()[0].getNewValue(), name, model);
        }
        this.clearTheOtherHandValue(name);
        this.setMulCurAmtOnSameCur(this.getView(), this.getEnabledLocalCurConfig(), name, value);
    }

    void clearTheOtherHandValue(String name) {
        Collection<LocalCurrencyConfigVO> configs = this.getEnabledLocalCurConfig();
        HashMap<String, MCT> mcBeginFieldMap = new HashMap<String, MCT>(8);
        for (LocalCurrencyConfigVO config : configs) {
            mcBeginFieldMap.put(config.getInitBalanceField(MCT.BEGIN_DEBIT).getMetaId(), MCT.BEGIN_DEBIT);
            mcBeginFieldMap.put(config.getInitBalanceField(MCT.BEGIN_CREDIT).getMetaId(), MCT.BEGIN_CREDIT);
        }
        if (mcBeginFieldMap.containsKey(name)) {
            MCT mct = (MCT)mcBeginFieldMap.get(name);
            if (mct == MCT.BEGIN_DEBIT) {
                this.clearMcCreditValue();
                this.clearCreditValue();
            } else {
                this.clearMcDebitValue();
                this.clearDebitValue();
            }
        }
    }

    void setMulCurAmtOnSameCur(IFormView view, Collection<LocalCurrencyConfigVO> mulCurConfig, String name, Object value) {
        String curLocalKey;
        HashMap mulCurField2Config = new HashMap(16);
        for (LocalCurrencyConfigVO config : mulCurConfig) {
            config.getAllInitBalanceFields().forEach(field -> mulCurField2Config.put(field.getMetaId(), config));
        }
        if (name.endsWith("local")) {
            curLocalKey = "curlocal";
            String forStr = name.replace("local", "for");
            if (mulCurField2Config.containsKey(name)) {
                LocalCurrencyConfigVO config = (LocalCurrencyConfigVO)mulCurField2Config.get(name);
                curLocalKey = config.getCurrencyField();
                forStr = name.substring(3).replace("local", "for");
            }
            this.setAmtOnSameCur(view, curLocalKey, forStr, value);
        } else if (name.endsWith("for")) {
            curLocalKey = "curlocal";
            String localAmtKey = name.replace("for", "local");
            this.setAmtOnSameCur(view, curLocalKey, localAmtKey, value);
            for (LocalCurrencyConfigVO config : mulCurConfig) {
                String prefix = config.getCurrencyField().substring(0, 3);
                String localAmtStr = prefix + name.replace("for", "local");
                if (!mulCurField2Config.containsKey(localAmtStr)) continue;
                localAmtKey = localAmtStr;
                curLocalKey = ((LocalCurrencyConfigVO)mulCurField2Config.get(localAmtStr)).getCurrencyField();
                this.setAmtOnSameCur(view, curLocalKey, localAmtKey, value);
            }
        }
    }

    void setAmtOnSameCur(IFormView view, String localCurKey, String key, Object value) {
        long currencyId;
        long curlocalId;
        IDataModel model = view.getModel();
        DynamicObject curlocal = (DynamicObject)model.getValue(localCurKey);
        DynamicObject currency = (DynamicObject)model.getValue("currency");
        if (curlocal != null && currency != null && (curlocalId = curlocal.getLong("id")) == (currencyId = currency.getLong("id"))) {
            model.beginInit();
            model.setValue(key, value);
            model.endInit();
            view.updateView(key);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.getCommonAssistTable().ifPresent(commonAssistTable -> ComAssistTableService.modifyCommonAssistFields((ComAssistTable)commonAssistTable, (IFormView)this.getView()));
    }

    private Optional<ComAssistTable> getCommonAssistTable() {
        String bookInfoStr = (String)this.getView().getFormShowParameter().getCustomParam("accountBookInfo");
        return Optional.ofNullable(bookInfoStr).map(GLUtil::fromSerializedString).map(AccountBookInfo.class::cast).map(AccountBookInfo::getAccountTableId).map(ComAssistTable::get);
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        super.getEntityType(e);
        if (CommonAssistUtil.isCommonAssistEnabled()) {
            e.setNewEntityType(ComAssistImportPlugin.ImportHandler.getEntityType(e.getOriginalEntityType()));
            if (e.getOriginalEntityType() != e.getNewEntityType()) {
                return;
            }
            this.getCommonAssistTable().ifPresent(commonAssistTable -> e.setNewEntityType((MainEntityType)ComAssistTableService.modifyEntityType((ComAssistTable)commonAssistTable, (EntityType)e.getOriginalEntityType())));
        }
    }

    void clearDebitValue() {
        IDataModel model = this.getView().getModel();
        for (String credit : debits) {
            model.setValue(credit, null);
        }
    }

    void clearMcCreditValue() {
        for (LocalCurrencyConfigVO config : this.getEnabledLocalCurConfig()) {
            String metaId = config.getInitBalanceField(MCT.BEGIN_CREDIT).getMetaId();
            this.getView().getModel().setValue(metaId, null);
        }
    }

    void clearMcDebitValue() {
        for (LocalCurrencyConfigVO config : this.getEnabledLocalCurConfig()) {
            String metaId = config.getInitBalanceField(MCT.BEGIN_DEBIT).getMetaId();
            this.getView().getModel().setValue(metaId, null);
        }
    }

    void clearCreditValue() {
        IDataModel model = this.getView().getModel();
        for (String credit : credits) {
            model.setValue(credit, null);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getModel().setDataChanged(false);
    }

    public void afterCreateNewData(EventObject e) {
        this.setFieldName();
        this.hideField();
        this.setBookInfoRefValue();
        this.getCommonAssistTable().ifPresent(commonAssistTable -> commonAssistTable.getBalancedCommonAssistKeys().forEach(comAssistKey -> {
            List comAssistFilterIds = GLUtil.getCustomFilterIds((IFormView)this.getView().getParentView(), (String)(comAssistKey + ".id"));
            if (!CollectionUtils.isEmpty((Collection)comAssistFilterIds)) {
                this.getModel().setValue(comAssistKey, comAssistFilterIds.get(0));
            }
        }));
        this.handleLocalCurField();
    }

    void handleLocalCurField() {
        Collection<LocalCurrencyConfigVO> enabledLocalCurConfigs = this.getEnabledLocalCurConfig();
        this.setLocalCurFieldCaption(enabledLocalCurConfigs);
        this.hideLocalCurField(this.getView(), enabledLocalCurConfigs);
        this.setLocalCur(this.getView().getModel(), enabledLocalCurConfigs);
    }

    void setLocalCur(IDataModel model, Collection<LocalCurrencyConfigVO> enabledLocalCurConfigs) {
        Long org = (Long)model.getValue("org_id");
        Long bookType = (Long)model.getValue("booktype_id");
        for (LocalCurrencyConfigVO config : enabledLocalCurConfigs) {
            String curFieldKey = config.getCurrencyField();
            IDataEntityProperty property = model.getProperty(curFieldKey);
            if (property == null) continue;
            long currencyId = config.getCurrencyId(org.longValue(), bookType.longValue());
            model.setValue(curFieldKey, (Object)BusinessDataServiceHelper.loadSingleFromCache((Object)currencyId, (DynamicObjectType)((CurrencyProp)property).getDynamicComplexPropertyType()));
            model.setValue(curFieldKey + "_id", (Object)currencyId);
        }
    }

    void hideLocalCurField(IFormView view, Collection<LocalCurrencyConfigVO> localCurConfigs) {
        LinkedList hidedCurConfigs = new LinkedList(LocalCurrencyConfigService.queryEnableCurrencies());
        hidedCurConfigs.removeAll(localCurConfigs);
        for (LocalCurrencyConfigVO hidedCurConfig : hidedCurConfigs) {
            String[] allFields = (String[])hidedCurConfig.getAllInitBalanceFields().stream().map(MetaField::getMetaId).toArray(String[]::new);
            view.setVisible(Boolean.valueOf(false), allFields);
        }
    }

    Collection<LocalCurrencyConfigVO> getEnabledLocalCurConfig() {
        IDataModel model = this.getView().getModel();
        Long org = (Long)model.getValue("org_id");
        Long bookType = (Long)model.getValue("booktype_id");
        return LocalCurrencyConfigService.queryEnableCurrencies((long)org, (long)bookType);
    }

    void setLocalCurFieldCaption(Collection<LocalCurrencyConfigVO> enabledLocalCurConfigs) {
        for (LocalCurrencyConfigVO localCurConfig : enabledLocalCurConfigs) {
            Tuple<LocaleString, LocaleString> debitAndCredit = this.getFieldCation(localCurConfig.getNumber());
            if (debitAndCredit == null) continue;
            localCurConfig.getInitBalanceFields(new MCT[]{MCT.BEGIN_DEBIT, MCT.YEAR_DEBIT, MCT.YEAR_PROFIT_DEBIT}).forEach(field -> this.setFieldCaptionIfExist(field.getMetaId(), (LocaleString)debitAndCredit.item1));
            localCurConfig.getInitBalanceFields(new MCT[]{MCT.BEGIN_CREDIT, MCT.YEAR_CREDIT, MCT.YEAR_PROFIT_CREDIT}).forEach(field -> this.setFieldCaptionIfExist(field.getMetaId(), (LocaleString)debitAndCredit.item2));
        }
    }

    Tuple<LocaleString, LocaleString> getFieldCation(String localCurConfigNumber) {
        LocaleString debitName = null;
        LocaleString creditName = null;
        if ("GrpLocalCurrency".equals(localCurConfigNumber)) {
            debitName = ResManager.getLocaleString((String)"\u501f\u65b9\u96c6\u56e2\u672c\u4f4d\u5e01", (String)"InitBalanceEdit_101", (String)"fi-gl-formplugin");
            creditName = ResManager.getLocaleString((String)"\u8d37\u65b9\u96c6\u56e2\u672c\u4f4d\u5e01", (String)"InitBalanceEdit_104", (String)"fi-gl-formplugin");
        } else if ("SecLocalCurrency".equals(localCurConfigNumber)) {
            debitName = ResManager.getLocaleString((String)"\u501f\u65b9\u7b2c\u4e8c\u672c\u4f4d\u5e01", (String)"InitBalanceEdit_102", (String)"fi-gl-formplugin");
            creditName = ResManager.getLocaleString((String)"\u8d37\u65b9\u7b2c\u4e8c\u672c\u4f4d\u5e01", (String)"InitBalanceEdit_105", (String)"fi-gl-formplugin");
        } else if ("TrdLocalCurrency".equals(localCurConfigNumber)) {
            debitName = ResManager.getLocaleString((String)"\u501f\u65b9\u7b2c\u4e09\u672c\u4f4d\u5e01", (String)"InitBalanceEdit_103", (String)"fi-gl-formplugin");
            creditName = ResManager.getLocaleString((String)"\u8d37\u65b9\u7b2c\u4e09\u672c\u4f4d\u5e01", (String)"InitBalanceEdit_106", (String)"fi-gl-formplugin");
        }
        return debitName != null ? new Tuple((Object)debitName, (Object)creditName) : null;
    }

    void setFieldCaptionIfExist(String fieldKey, LocaleString fieldCaption) {
        TextEdit control = (TextEdit)this.getControl(fieldKey);
        if (control != null) {
            control.setCaption(fieldCaption);
        }
    }

    private void hideField() {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"currency", "assgrp", "measureunit", "begindebitqty", "begincreditqty", "yeardebitqty", "yearcreditqty", "yearprofitdebitqty", "yearprofitcreditqty"});
    }

    private void setBookInfoRefValue() {
        String bookInfoStr = (String)this.getView().getFormShowParameter().getCustomParam("accountBookInfo");
        if (bookInfoStr != null) {
            AccountBookInfo bookInfo = (AccountBookInfo)GLUtil.fromSerializedString((String)bookInfoStr);
            IDataModel model = this.getModel();
            model.setValue("org", (Object)bookInfo.getOrgId());
            model.setValue("booktype", (Object)bookInfo.getBookTypeId());
            long acctTableId = AccSysUtil.getCurPeriodAccountTableId((long)bookInfo.getOrgId(), (long)bookInfo.getBookTypeId(), (long)bookInfo.getStartPeriodId());
            model.setValue("accounttable", (Object)acctTableId);
            model.setValue("curlocal", (Object)bookInfo.getBaseCurrencyId());
            model.setValue("currency", (Object)bookInfo.getBaseCurrencyId());
            model.setValue("period", (Object)bookInfo.getCurPeriodId());
            this.styleRefCurPeriod(bookInfo.getCurPeriodId());
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate formOp;
        String operateKey;
        super.beforeDoOperation(args);
        if (args.getSource() instanceof FormOperate && (operateKey = (formOp = (FormOperate)args.getSource()).getOperateKey()).equals("save")) {
            if (!"yes".equalsIgnoreCase(this.getPageCache().get("save"))) {
                IDataModel model = this.getModel();
                QFilter forg = new QFilter("org", "=", (Object)((DynamicObject)model.getValue("org")).getLong("id"));
                QFilter fbt = new QFilter("booktype", "=", (Object)((DynamicObject)model.getValue("booktype")).getLong("id"));
                long facctId = model.getValue("account") == null ? 0L : ((DynamicObject)model.getValue("account")).getLong("id");
                QFilter facct = new QFilter("account", "=", (Object)facctId);
                Object currency = model.getValue("currency");
                if (currency == null) {
                    args.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5e01\u79cd\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InitBalanceEdit_100", (String)GLApp.instance.formpluginModule(), (Object[])new Object[0]));
                    return;
                }
                QFilter fcur = new QFilter("currency", "=", (Object)((DynamicObject)currency).getLong("id"));
                long fassgrpId = model.getValue("assgrp") == null ? 0L : ((DynamicObject)model.getValue("assgrp")).getLong("id");
                QFilter fassgrp = new QFilter("assgrp", "=", (Object)fassgrpId);
                long funitId = model.getValue("measureunit") == null ? 0L : ((DynamicObject)model.getValue("measureunit")).getLong("id");
                QFilter funit = new QFilter("measureunit", "=", (Object)funitId);
                QFilter fisDel = new QFilter("isdeleted", "=", (Object)"0");
                this.getCommonAssistTable().ifPresent(commonAssistTable -> commonAssistTable.getCommonAssists().stream().map(commonAssist -> {
                    DynamicObject value = (DynamicObject)this.getModel().getValue(commonAssist.key);
                    return new QFilter(commonAssist.key, "=", value != null ? value.getPkValue() : Integer.valueOf(commonAssist.isRequired ? -1 : 0));
                }).forEach(arg_0 -> ((QFilter)forg).and(arg_0)));
                if (QueryServiceHelper.exists((String)"gl_initbalance", (QFilter[])new QFilter[]{forg, fbt, facct, fcur, fassgrp, funit, fisDel})) {
                    this.getPageCache().put("save", "yes");
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u201c\u7ec4\u7ec7\u3001\u79d1\u76ee\u3001\u5e01\u79cd\u3001\u6838\u7b97\u7ef4\u5ea6\u3001\u8ba1\u91cf\u5355\u4f4d\u201d\u7ec4\u5408\u503c\u5df2\u5b58\u5728\uff0c\u662f\u5426\u8986\u76d6\uff1f", (String)"InitBalanceEdit_7", (String)"fi-gl-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("save", (IFormPlugin)this));
                    args.setCancel(true);
                }
            } else {
                this.getPageCache().put("save", "no");
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (callBackId.equalsIgnoreCase("save")) {
            if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                this.getPageCache().put("save", "yes");
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("cover", "true");
                this.getView().invokeOperation("save", operateOption);
            } else {
                this.getPageCache().put("save", "no");
            }
        }
    }

    public void afterLoadData(EventObject e) {
        this.editStyle();
    }

    private void editStyle() {
        this.setFieldName();
        IBillModel m = (IBillModel)this.getModel();
        DynamicObject account = (DynamicObject)m.getValue("account");
        AccountBookInfo accountBook = AccSysUtil.getBookFromAccSys((long)((Long)m.getValue(GLField.id_((String)"org"))), (long)((Long)m.getValue(GLField.id_((String)"booktype"))));
        if (accountBook == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u8d26\u7c3f\u4fe1\u606f\u3002", (String)"InitBalanceEdit_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        }
        m.setValue("period", (Object)accountBook.getCurPeriodId());
        this.styleRefCurPeriod(accountBook.getCurPeriodId());
        this.styleRefAccount(account.getLong("id"), true);
        this.handleLocalCurField();
    }

    private void styleRefAccount(long accountId, boolean isEdit) {
        IBillModel model = (IBillModel)this.getModel();
        IFormView view = this.getView();
        DynamicObject account = BusinessDataServiceHelper.loadSingle((Object)accountId, (String)"bd_accountview");
        view.setVisible(Boolean.valueOf(account.getBoolean("isassist")), new String[]{"assgrp"});
        boolean isqty = account.getBoolean("isqty");
        view.setVisible(Boolean.valueOf(isqty), new String[]{"measureunit", "begindebitqty", "begincreditqty", "yeardebitqty", "yearcreditqty", "yearprofitdebitqty", "yearprofitcreditqty"});
        if (isqty) {
            long measureUnitId = account.getLong(GLField.id_((String)"measureunit"));
            if (measureUnitId == 0L) {
                if (!isEdit) {
                    model.setValue("measureunit", null);
                }
                BasedataEdit measureUnit = (BasedataEdit)this.getControl("measureunit");
                long measureunitgroupid = account.getLong(GLField.join((String[])new String[]{"measureunitgroup", "id"}));
                if (measureunitgroupid != 0L) {
                    QFilter filter = new QFilter("group", "=", (Object)measureunitgroupid);
                    GlFormUtil.setF7ClickFilter(measureUnit, filter);
                }
            } else {
                model.setValue("measureunit", (Object)measureUnitId);
            }
        } else {
            model.setValue("measureunit", null);
        }
        String acctCurrency = account.getString("acctcurrency");
        long curLocalId = (Long)model.getValue(GLField.id_((String)"curlocal"));
        BasedataEdit currencyEdit = (BasedataEdit)this.getControl("currency");
        this.getView().setVisible(Boolean.valueOf(!"nocurrency".equals(acctCurrency)), new String[]{"currency"});
        if ("descurrency".equals(acctCurrency)) {
            DynamicObjectCollection currencyentry = account.getDynamicObjectCollection("currencyentry");
            ArrayList<Long> desCurs = new ArrayList<Long>();
            for (DynamicObject cur : currencyentry) {
                desCurs.add(cur.getLong(GLField.id((String)"currency")));
            }
            if (desCurs.contains(curLocalId)) {
                model.setValue("currency", (Object)curLocalId);
            } else if (desCurs.size() > 0) {
                model.setValue("currency", desCurs.get(0));
            } else {
                model.setValue("currency", null);
            }
            GlFormUtil.setF7ClickFilter(currencyEdit, new QFilter("id", "in", desCurs));
        } else if ("nocurrency".equalsIgnoreCase(acctCurrency)) {
            model.setValue("currency", (Object)curLocalId);
        } else {
            GlFormUtil.setF7ClickFilter(currencyEdit, null);
        }
        if ("4".equals(account.getString("accounttype.accounttype"))) {
            view.setVisible(Boolean.valueOf(true), new String[]{"tabyearprofit"});
        } else {
            view.setVisible(Boolean.valueOf(false), new String[]{"tabyearprofit"});
            model.setValue("yearprofitdebitqty", null);
            model.setValue("yearprofitdebitfor", null);
            model.setValue("yearprofitdebitlocal", null);
            model.setValue("yearprofitcreditqty", null);
            model.setValue("yearprofitcreditfor", null);
            model.setValue("yearprofitcreditlocal", null);
            this.clearLocalCurYearProfit(this.getModel());
        }
    }

    void clearLocalCurYearProfit(IDataModel model) {
        for (LocalCurrencyConfigVO localCurrencyConfigVO : this.getEnabledLocalCurConfig()) {
            localCurrencyConfigVO.getInitBalanceFields(new MCT[]{MCT.YEAR_PROFIT_CREDIT, MCT.YEAR_PROFIT_DEBIT}).forEach(field -> {
                IDataEntityProperty property = model.getProperty(field.getMetaId());
                if (property != null) {
                    model.setValue(field.getMetaId(), null);
                }
            });
        }
    }

    private void styleRefCurPeriod(long curPeriod) {
        IFormView view = this.getView();
        if (curPeriod % GLUtil.YEAR_PERIOD_L / 10L == 1L) {
            view.setVisible(Boolean.valueOf(false), new String[]{"tabyear", "tabyearprofit"});
        }
    }

    private void setFieldName() {
        ((TextEdit)this.getControl("begindebitqty")).setCaption(new LocaleString(ResManager.loadKDString((String)"\u501f\u65b9\u6570\u91cf", (String)"InitBalanceEdit_1", (String)"fi-gl-formplugin", (Object[])new Object[0])));
        ((TextEdit)this.getControl("begincreditqty")).setCaption(new LocaleString(ResManager.loadKDString((String)"\u8d37\u65b9\u6570\u91cf", (String)"InitBalanceEdit_2", (String)"fi-gl-formplugin", (Object[])new Object[0])));
        ((TextEdit)this.getControl("yeardebitqty")).setCaption(new LocaleString(ResManager.loadKDString((String)"\u501f\u65b9\u6570\u91cf", (String)"InitBalanceEdit_1", (String)"fi-gl-formplugin", (Object[])new Object[0])));
        ((TextEdit)this.getControl("yearcreditqty")).setCaption(new LocaleString(ResManager.loadKDString((String)"\u8d37\u65b9\u6570\u91cf", (String)"InitBalanceEdit_2", (String)"fi-gl-formplugin", (Object[])new Object[0])));
        ((TextEdit)this.getControl("begindebitfor")).setCaption(new LocaleString(ResManager.loadKDString((String)"\u501f\u65b9\u539f\u5e01", (String)"InitBalanceEdit_3", (String)"fi-gl-formplugin", (Object[])new Object[0])));
        ((TextEdit)this.getControl("begincreditfor")).setCaption(new LocaleString(ResManager.loadKDString((String)"\u8d37\u65b9\u539f\u5e01", (String)"InitBalanceEdit_4", (String)"fi-gl-formplugin", (Object[])new Object[0])));
        ((TextEdit)this.getControl("begindebitlocal")).setCaption(new LocaleString(ResManager.loadKDString((String)"\u501f\u65b9\u672c\u4f4d\u5e01", (String)"InitBalanceEdit_5", (String)"fi-gl-formplugin", (Object[])new Object[0])));
        ((TextEdit)this.getControl("begincreditlocal")).setCaption(new LocaleString(ResManager.loadKDString((String)"\u8d37\u65b9\u672c\u4f4d\u5e01", (String)"InitBalanceEdit_6", (String)"fi-gl-formplugin", (Object[])new Object[0])));
        ((TextEdit)this.getControl("yeardebitfor")).setCaption(new LocaleString(ResManager.loadKDString((String)"\u501f\u65b9\u539f\u5e01", (String)"InitBalanceEdit_3", (String)"fi-gl-formplugin", (Object[])new Object[0])));
        ((TextEdit)this.getControl("yeardebitlocal")).setCaption(new LocaleString(ResManager.loadKDString((String)"\u501f\u65b9\u672c\u4f4d\u5e01", (String)"InitBalanceEdit_5", (String)"fi-gl-formplugin", (Object[])new Object[0])));
        ((TextEdit)this.getControl("yearcreditfor")).setCaption(new LocaleString(ResManager.loadKDString((String)"\u8d37\u65b9\u539f\u5e01", (String)"InitBalanceEdit_4", (String)"fi-gl-formplugin", (Object[])new Object[0])));
        ((TextEdit)this.getControl("yearcreditlocal")).setCaption(new LocaleString(ResManager.loadKDString((String)"\u8d37\u65b9\u672c\u4f4d\u5e01", (String)"InitBalanceEdit_6", (String)"fi-gl-formplugin", (Object[])new Object[0])));
        ((TextEdit)this.getControl("yearprofitdebitqty")).setCaption(new LocaleString(ResManager.loadKDString((String)"\u501f\u65b9\u6570\u91cf", (String)"InitBalanceEdit_1", (String)"fi-gl-formplugin", (Object[])new Object[0])));
        ((TextEdit)this.getControl("yearprofitdebitfor")).setCaption(new LocaleString(ResManager.loadKDString((String)"\u501f\u65b9\u539f\u5e01", (String)"InitBalanceEdit_3", (String)"fi-gl-formplugin", (Object[])new Object[0])));
        ((TextEdit)this.getControl("yearprofitdebitlocal")).setCaption(new LocaleString(ResManager.loadKDString((String)"\u501f\u65b9\u672c\u4f4d\u5e01", (String)"InitBalanceEdit_5", (String)"fi-gl-formplugin", (Object[])new Object[0])));
        ((TextEdit)this.getControl("yearprofitcreditqty")).setCaption(new LocaleString(ResManager.loadKDString((String)"\u8d37\u65b9\u6570\u91cf", (String)"InitBalanceEdit_2", (String)"fi-gl-formplugin", (Object[])new Object[0])));
        ((TextEdit)this.getControl("yearprofitcreditfor")).setCaption(new LocaleString(ResManager.loadKDString((String)"\u8d37\u65b9\u539f\u5e01", (String)"InitBalanceEdit_4", (String)"fi-gl-formplugin", (Object[])new Object[0])));
        ((TextEdit)this.getControl("yearprofitcreditlocal")).setCaption(new LocaleString(ResManager.loadKDString((String)"\u8d37\u65b9\u672c\u4f4d\u5e01", (String)"InitBalanceEdit_6", (String)"fi-gl-formplugin", (Object[])new Object[0])));
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        long accountTableId;
        Map data = e.getSourceData();
        Map orgMap = (Map)data.get("org");
        if (orgMap == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5bfc\u5165\u6838\u7b97\u7ec4\u7ec7", (String)"InitBalanceEdit_8", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        }
        Map bookTypeMap = (Map)data.get("booktype");
        if (bookTypeMap == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5bfc\u5165\u8d26\u7c3f\u7c7b\u578b", (String)"InitBalanceEdit_9", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        }
        Map accountMap = (Map)data.get("account");
        if (accountMap == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5bfc\u5165\u79d1\u76ee", (String)"InitBalanceEdit_10", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        }
        String orgNumber = ((String)orgMap.get(NUMBER)).trim();
        String btNumber = ((String)bookTypeMap.get(NUMBER)).trim();
        String accNumber = ((String)accountMap.get(NUMBER)).trim();
        AccountBookInfo bookInfo = AccSysUtil.getBookFromAccSys((String)orgNumber, (String)btNumber);
        if (bookInfo == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u7ec7\uff1a%1$s\uff0c\u8d26\u7c3f\u7c7b\u578b:%2$s\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u4f1a\u8ba1\u8d26\u7c3f", (String)"InitBalanceEdit_11", (String)"fi-gl-formplugin", (Object[])new Object[]{orgNumber, btNumber}));
        }
        if (!bookInfo.isIsbizunit()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u7ec7\uff1a%1$s\uff0c\u8d26\u7c3f\u7c7b\u578b:%2$s\u4e0d\u662f\u5b9e\u4f53\u8d26\u7c3f\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165", (String)"InitBalanceEdit_12", (String)"fi-gl-formplugin", (Object[])new Object[]{orgNumber, btNumber}));
        }
        if (bookInfo.isIsendinit()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%1$s\u201d\uff0c\u8d26\u7c3f\u7c7b\u578b\u201c%2$s\u201d\u5df2\u7ed3\u675f\u521d\u59cb\u5316\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u3002", (String)"InitBalanceEdit_13", (String)"fi-gl-formplugin", (Object[])new Object[]{orgNumber, btNumber}));
        }
        long orgId = bookInfo.getOrgId();
        Map<String, Tuple2<Long, Boolean>> accMap = this.getAccFromCache(orgId, accountTableId = AccSysUtil.getCurPeriodAccountTableId((long)bookInfo.getOrgId(), (long)bookInfo.getBookTypeId(), (long)bookInfo.getStartPeriodId()), bookInfo.getStartPeriodId());
        Tuple2<Long, Boolean> idIsLeaf = accMap.get(accNumber);
        if (idIsLeaf == null || !((Boolean)idIsLeaf.t2).booleanValue()) {
            String atNumber = (String)ThreadCache.get((Object)CACHE_KEY_AT, () -> {
                DynamicObject dyn = QueryServiceHelper.queryOne((String)"bd_accounttable", (String)NUMBER, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)accountTableId)});
                return dyn == null ? "" : dyn.getString(NUMBER);
            });
            if (idIsLeaf == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u7ec7\uff1a%1$s\uff0c\u79d1\u76ee\u8868\uff1a%2$s\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u79d1\u76ee\uff1a%3$s", (String)"InitBalanceEdit_14", (String)"fi-gl-formplugin", (Object[])new Object[]{orgNumber, atNumber, accNumber}));
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7ec4\u7ec7\u201c%2$s\u201d\u79d1\u76ee\u8868\u7684\u201c%3$s\u201d\u4e0d\u662f\u660e\u7ec6\u79d1\u76ee\u3002", (String)"InitBalanceEdit_15", (String)"fi-gl-formplugin", (Object[])new Object[]{orgNumber, atNumber, accNumber}));
        }
        accountMap.remove(NUMBER);
        Long acctId = (Long)idIsLeaf.t1;
        accountMap.put("id", String.valueOf(acctId));
        orgMap.put(NUMBER, orgNumber);
        bookTypeMap.put(NUMBER, btNumber);
        this.checkComAssistIsLeaf(e, bookInfo);
    }

    public void initImportData(InitImportDataEventArgs e) {
        super.initImportData(e);
        boolean isEnableAccountBankNumberToId = BillParamUtil.getBooleanValue((String)"83bfebc8000017ac", (String)"fi.gl.initbal.import.accountBankTransId.enable", (boolean)true);
        if (isEnableAccountBankNumberToId) {
            HashBasedTable orgNum2BtNum2BankNums = HashBasedTable.create((int)32, (int)2);
            Set<String> bankAccountFlexFields = this.getBankAccountFlexFields();
            HashMap data2AssgrpMap = new HashMap(128);
            e.getSourceDataList().stream().filter(x -> InitBalanceEdit.containsValue(x, "org") && InitBalanceEdit.containsValue(x, "booktype") && InitBalanceEdit.containsValue(x, "assgrp")).forEach(arg_0 -> this.lambda$initImportData$17(data2AssgrpMap, bankAccountFlexFields, (Table)orgNum2BtNum2BankNums, arg_0));
            HashBasedTable orgNum2BtNum2BankNumId = HashBasedTable.create((int)32, (int)2);
            orgNum2BtNum2BankNums.cellSet().forEach(arg_0 -> InitBalanceEdit.lambda$initImportData$18((Table)orgNum2BtNum2BankNumId, arg_0));
            e.getSourceDataList().stream().filter(x -> InitBalanceEdit.containsValue(x, "org") && InitBalanceEdit.containsValue(x, "booktype") && InitBalanceEdit.containsValue(x, "assgrp")).forEach(arg_0 -> InitBalanceEdit.lambda$initImportData$21(data2AssgrpMap, bankAccountFlexFields, (Table)orgNum2BtNum2BankNumId, arg_0));
        }
    }

    VoucherImportAssgrp getAssgrp(Map<String, Object> assgrpData) {
        return new VoucherImportAssgrp(assgrpData);
    }

    private static boolean containsValue(Map<String, Object> x, String key) {
        return x.containsKey(key) && x.get(key) != null;
    }

    Set<String> getBankAccountFlexFields() {
        return (Set)ThreadCache.get((Object)(VoucherImportHandler.class.getName() + "#getBankAccountFlexFields"), () -> FlexUtils.getAllFlexType().stream().filter(x -> "am_accountbank".equals(x.getValueSource()) || "bd_accountbanks".equals(x.getValueSource())).map(FlexProperty::getFlexField).collect(Collectors.toSet()));
    }

    private void checkComAssistIsLeaf(BeforeImportDataEventArgs e, AccountBookInfo bookInfo) {
        Map data = e.getSourceData();
        ComAssistTable comAssistTable = ComAssistTable.get((Long)bookInfo.getAccountTableId());
        comAssistTable.getCommonAssists().forEach(commonAssist -> {
            QFilter treeFilter;
            Map comAssistData = (Map)data.get(commonAssist.key);
            if (comAssistData == null || comAssistData.isEmpty()) {
                return;
            }
            String number = (String)comAssistData.get(NUMBER);
            if (number == null) {
                number = "";
            }
            if ("1 = 1".equals((treeFilter = this.treeFilterCache.computeIfAbsent(commonAssist.valueSource, source -> {
                MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)commonAssist.valueSource);
                return ComAssistService.generateQFilter((CommonAssist)commonAssist, (IDataEntityType)dataEntityType);
            })).toString())) {
                return;
            }
            QFilter rangeFilter = this.rangeFilterCache.computeIfAbsent(commonAssist.valueSource + bookInfo.getOrgId(), key -> {
                QFilter dataFilter = BaseDataServiceHelper.getBaseDataFilter((String)commonAssist.valueSource, (Long)bookInfo.getOrgId());
                return dataFilter == null ? QFilter.of((String)"1=1", (Object[])new Object[0]) : dataFilter;
            });
            QFilter numFilter = new QFilter(NUMBER, "=", (Object)number).and(treeFilter).and(rangeFilter);
            String cacheKey = commonAssist.valueSource + "-" + bookInfo.getOrgId() + "-" + number;
            Long id = this.treeComAssistNum2Id.computeIfAbsent(cacheKey, key -> Optional.ofNullable(BusinessDataServiceHelper.loadSingleFromCache((String)commonAssist.valueSource, (String)"id", (QFilter[])numFilter.toArray())).map(dyo -> dyo.getLong("id")).orElse(0L));
            if (id == 0L) {
                e.setCancel(true);
                String cancelMsg = String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%1$s\u7684%2$s\u6570\u636e\u4e0d\u5b58\u5728\u6216\u8005\u662f\u975e\u660e\u7ec6\u3002", (String)"InitBalanceEdit_21", (String)GLApp.instance.formpluginModule(), (Object[])new Object[0]), number, commonAssist.getName());
                e.setCancelMessages(Integer.valueOf(-1), Integer.valueOf(-1), Collections.singletonList(cancelMsg));
            } else {
                comAssistData.put("importprop", "id");
                comAssistData.put("id", id.toString());
            }
        });
    }

    private Map<String, Tuple2<Long, Boolean>> getAccFromCache(long orgId, long accountTableId, long startPeriod) {
        return (Map)ThreadCache.get((Object)(CACHE_KEY_ORG + String.format("{%s,%s,%s}", orgId, accountTableId, startPeriod)), () -> {
            HashMap<String, Tuple2> result = new HashMap<String, Tuple2>();
            DynamicObject period = QueryServiceHelper.queryOne((String)"bd_period", (String)"enddate", (QFilter[])new QFilter("id", "=", (Object)startPeriod).toArray());
            QFilter dateFilter = new QFilter("startdate", "<=", (Object)period.getDate("enddate"));
            dateFilter.and(new QFilter("enddate", ">=", (Object)period.getDate("enddate")));
            ArrayList<QFilter> otherFilters = new ArrayList<QFilter>(10);
            otherFilters.add(dateFilter);
            try (DataSet dataSet = AccountUtils.queryAccountDataSet((long)orgId, (long)accountTableId, (String)"id,number,isleaf", otherFilters);){
                for (Row row : dataSet) {
                    result.put(row.getString(NUMBER), new Tuple2((Object)row.getLong("id"), (Object)row.getBoolean("isleaf")));
                }
            }
            return result;
        });
    }

    public void afterImportData(ImportDataEventArgs e) {
        IDataModel m = this.getModel();
        DynamicObject acct = (DynamicObject)m.getValue("account");
        DynamicObject act = this.getAcct(acct.getLong("id"));
        m.setValue("accounttable", (Object)act.getDynamicObject("accounttable"));
        AccountInfo accountInfo = new AccountInfo(act);
        DynamicObject assgrp = (DynamicObject)m.getValue("assgrp");
        if (accountInfo.isAssist() && Objects.nonNull(assgrp)) {
            try {
                Map json = (Map)JSONUtils.cast((String)assgrp.getString("value"), Map.class);
                for (Map.Entry entry : json.entrySet()) {
                    boolean isNotleaf;
                    Map flex;
                    String valueSource;
                    String flexField = (String)entry.getKey();
                    if (!Objects.nonNull(accountInfo.getFlexToIsLeaf().get(flexField)) || !((Boolean)accountInfo.getFlexToIsLeaf().get(flexField)).booleanValue() || !Objects.nonNull(valueSource = (String)(flex = FlexUtils.getFlex()).get(flexField)) || !(isNotleaf = FlexUtils.isNotLeafData((String)valueSource, (Long)Long.parseLong(entry.getValue().toString())))) continue;
                    throw new KDBizException(ResManager.loadKDString((String)"\u6838\u7b97\u7ef4\u5ea6%s\u4e0d\u80fd\u4e3a\u975e\u660e\u7ec6\u6570\u636e", (String)"InitBalanceEdit_18", (String)"fi-gl-formplugin", (Object[])new Object[]{accountInfo.getAssFlexToNameMap().get(flexField)}));
                }
            }
            catch (IOException ioException) {
                LOG.error(ioException.getMessage(), (Throwable)ioException);
                throw new KDBizException((Throwable)ioException, BosErrorCode.systemError, new Object[0]);
            }
        }
    }

    private DynamicObject getAcct(long acctId) {
        HashMap<Long, DynamicObject> acctMap = (HashMap<Long, DynamicObject>)ThreadCache.get((Object)ACCTKEY);
        if (acctMap == null) {
            acctMap = new HashMap<Long, DynamicObject>(16);
            DynamicObject acct = BusinessDataServiceHelper.loadSingleFromCache((Object)acctId, (String)"bd_accountview");
            acctMap.put(acctId, acct);
            ThreadCache.put((Object)ACCTKEY, acctMap);
            return acct;
        }
        if (acctMap.containsKey(acctId)) {
            return (DynamicObject)acctMap.get(acctId);
        }
        DynamicObject acct = BusinessDataServiceHelper.loadSingleFromCache((Object)acctId, (String)"bd_accountview");
        acctMap.put(acctId, acct);
        ThreadCache.put((Object)ACCTKEY, acctMap);
        return acct;
    }

    private static /* synthetic */ void lambda$initImportData$21(Map data2AssgrpMap, Set bankAccountFlexFields, Table orgNum2BtNum2BankNumId, Map data) {
        String orgNum = (String)((Map)data.get("org")).get(NUMBER);
        String btNum = (String)((Map)data.get("booktype")).get(NUMBER);
        Object assgrpData = data.get("assgrp");
        VoucherImportAssgrp assgrp = (VoucherImportAssgrp)data2AssgrpMap.get(assgrpData);
        if (assgrp != null) {
            Map<String, Object> flexFieldValueMap = assgrp.getFlexFieldValueMap();
            bankAccountFlexFields.stream().filter(flexFieldValueMap::containsKey).forEach(ff -> {
                Map bankNum2Id;
                String bankNum;
                Map val = (Map)flexFieldValueMap.get(ff);
                if (val != null && (bankNum = (String)val.get(NUMBER)) != null && (bankNum2Id = (Map)orgNum2BtNum2BankNumId.get((Object)orgNum, (Object)btNum)) != null && bankNum2Id.containsKey(bankNum)) {
                    val.put("id", bankNum2Id.get(bankNum));
                    val.put("importprop", "id");
                }
            });
        }
    }

    private static /* synthetic */ void lambda$initImportData$18(Table orgNum2BtNum2BankNumId, Table.Cell c) {
        String btNum;
        String orgNumm = (String)c.getRowKey();
        AccountBookInfo book = AccSysUtil.getBookFromAccSys((String)orgNumm, (String)(btNum = (String)c.getColumnKey()));
        if (book != null && book.isIsbizunit()) {
            Map<String, Long> bankNumIdMap = VoucherImportHandler.getBankAccountNumberIdMap((Set)c.getValue(), book.getOrgId(), book.getBookTypeId());
            orgNum2BtNum2BankNumId.put((Object)orgNumm, (Object)btNum, bankNumIdMap);
        }
    }

    private /* synthetic */ void lambda$initImportData$17(Map data2AssgrpMap, Set bankAccountFlexFields, Table orgNum2BtNum2BankNums, Map data) {
        String orgNum = (String)((Map)data.get("org")).get(NUMBER);
        String btNum = (String)((Map)data.get("booktype")).get(NUMBER);
        Object assgrpData = data.get("assgrp");
        VoucherImportAssgrp assgrp = this.getAssgrp((Map)assgrpData);
        data2AssgrpMap.put(assgrpData, assgrp);
        Map<String, Object> flexFieldValueMap = assgrp.getFlexFieldValueMap();
        bankAccountFlexFields.stream().filter(flexFieldValueMap::containsKey).forEach(ff -> {
            String bankNum;
            Map val = (Map)flexFieldValueMap.get(ff);
            if (val != null && (bankNum = (String)val.get(NUMBER)) != null) {
                HashSet<String> bankNums = (HashSet<String>)orgNum2BtNum2BankNums.get((Object)orgNum, (Object)btNum);
                if (bankNums == null) {
                    bankNums = new HashSet<String>(32);
                    orgNum2BtNum2BankNums.put((Object)orgNum, (Object)btNum, bankNums);
                }
                bankNums.add(bankNum);
            }
        });
    }
}

