/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.init;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.LongProp;
import kd.bos.ext.fi.entity.property.AccountProp;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.bd.model.schema.property.BaseDataProp;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.cache.CacheHelper;
import kd.fi.gl.cache.CacheModule;
import kd.fi.gl.cache.DistributeCache;
import kd.fi.gl.reciprocal.ReciprocalInitUtils;
import kd.fi.gl.reciprocal.ReciprocalUtils;
import kd.fi.gl.util.GLUtil;

public class ReciprocalInitEndInitPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    public static final String BATCHENDINIT = "batchEndInit";
    public static final String IS_FINISH = "batchEndInitisFinish";
    public static final String IS_SUCCESS = "batchEndInitisSuccess";
    public static final String TOTAL_COUNT = "batchEndInittotalCount";
    private DistributeCache cache = CacheHelper.getDistributeCache((CacheModule)CacheModule.reciEndInit);
    private static final String ENDINITPERIOD = "endinitperiod";
    private static final String ANTIENDINIT = "antiendinit";
    private static final String ENDINIT = "endinit";
    private static final String BTNOK = "btnok";
    private static final String ENTRYENTITY = "entryentity";
    public static final String PROGRESSBARAP = "progressbarap";
    private static final Log logger = LogFactory.getLog(ReciprocalInitEndInitPlugin.class);

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        FormShowParameter param = this.getView().getFormShowParameter();
        Long bookId = (Long)param.getCustomParam("book");
        model.setValue("book", (Object)bookId);
        Long acctTblId = (Long)param.getCustomParam("accounttable");
        model.setValue("accounttable", (Object)acctTblId);
        AccountBookInfo accountBookInfo = new AccountBookInfo(bookId.longValue());
        this.getPageCache().put("book", GLUtil.toSerializedString((Object)accountBookInfo));
        Long accountTableId = (Long)param.getCustomParam("accounttable");
        this.refreshEntryEntity(param, accountBookInfo, accountTableId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshEntryEntity(FormShowParameter param, AccountBookInfo accountBookInfo, Long accountTblId) {
        IFormView view = this.getView();
        Boolean needEndInit = (Boolean)param.getCustomParam("needEndInit");
        IDataModel model = this.getModel();
        model.beginInit();
        DataSet dSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_accountview", (String)"id acct", (QFilter[])ReciprocalUtils.getAccAccountFilter((Long)accountBookInfo.getOrgId(), (Long)accountBookInfo.getBookTypeId(), (Long)accountTblId).toArray(new QFilter[0]), null);
        DataSet endInitSet = ReciprocalInitUtils.queryIsEndInitReciprocalInit((boolean)needEndInit, (Long)accountBookInfo.getOrgId(), (Long)accountBookInfo.getBookTypeId(), (Long)accountTblId);
        try (DataSet ds = endInitSet.join(dSet, JoinType.INNER).on("id", "acct").select(new String[]{"id", ENDINITPERIOD}).finish();){
            if (ds != null) {
                model.deleteEntryData(ENTRYENTITY);
                HashMap<Long, DynamicObject> acctIds = new HashMap<Long, DynamicObject>(32);
                HashMap<Long, DynamicObject> periodIds = new HashMap<Long, DynamicObject>(32);
                HashMap<Long, Long> acctToPeriod = new HashMap<Long, Long>(32);
                periodIds.put(accountBookInfo.getCurPeriodId(), null);
                for (Row row : ds) {
                    Long acctId = row.getLong("id");
                    Long endInitPeriodId = row.getLong(ENDINITPERIOD);
                    acctIds.put(acctId, null);
                    periodIds.put(endInitPeriodId, null);
                    acctToPeriod.put(acctId, endInitPeriodId);
                }
                this.setDynamicObjectById("bd_accountview", "id,name,fullname,number,longnumber,masterid", acctIds);
                this.setDynamicObjectById("bd_period", "id,name,number,periodyear", periodIds);
                int count = acctToPeriod.size();
                if (count == 0) {
                    return;
                }
                this.getModel().batchCreateNewEntryRow(ENTRYENTITY, count);
                int index = 0;
                for (Map.Entry entry : acctToPeriod.entrySet()) {
                    Long endInitPeriodId;
                    if (Objects.nonNull(acctIds.get(entry.getKey()))) {
                        model.setValue("account", acctIds.get(entry.getKey()), index);
                    }
                    if (needEndInit.booleanValue()) {
                        view.setEnable(needEndInit, index, new String[]{"period"});
                        model.setValue("period", periodIds.get(accountBookInfo.getCurPeriodId()), index);
                    }
                    if ((endInitPeriodId = (Long)entry.getValue()) != null) {
                        model.setValue("period", periodIds.get(endInitPeriodId), index);
                    }
                    ++index;
                }
            }
        }
        finally {
            model.endInit();
            this.getView().updateView(ENTRYENTITY);
        }
    }

    private void setDynamicObjectById(String entityName, String selectProperties, Map<Long, DynamicObject> dynIdMap) {
        DynamicObject[] dyns;
        QFilter filter = new QFilter("id", "in", dynIdMap.keySet());
        for (DynamicObject dyn : dyns = BusinessDataServiceHelper.load((String)entityName, (String)selectProperties, (QFilter[])filter.toArray())) {
            dynIdMap.put(dyn.getLong("id"), dyn);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter param = this.getView().getFormShowParameter();
        Object oAcct = param.getCustomParam("account");
        Long acct = oAcct != null ? Long.valueOf(oAcct.toString()) : Long.valueOf(0L);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRYENTITY);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject dyObj = (DynamicObject)entryEntity.get(i);
            if (!acct.equals(dyObj.get("account.id"))) continue;
            entryGrid.selectRows(i);
            break;
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTNOK});
        ProgressBar bar = (ProgressBar)this.getView().getControl(PROGRESSBARAP);
        bar.addProgressListener((ProgresssListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctrl = (Control)evt.getSource();
        String key = ctrl.getKey();
        if (BTNOK.equals(key)) {
            EntryGrid entry = (EntryGrid)this.getView().getControl(ENTRYENTITY);
            int[] selectedIndex = entry.getSelectRows();
            if (selectedIndex.length == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u3002", (String)"ReciprocalInitEndInitPlugin_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                return;
            }
            FormShowParameter param = this.getView().getFormShowParameter();
            Boolean needEndInit = (Boolean)param.getCustomParam("needEndInit");
            AccountBookInfo accountBookInfo = this.getAccountBookCache();
            if (null == accountBookInfo) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u8d26\u7c3f\u4fe1\u606f\u3002", (String)"ReciprocalInitEndInitPlugin_11", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                return;
            }
            ((ProgressBar)this.getControl(PROGRESSBARAP)).start();
            this.getPageCache().put(TOTAL_COUNT, String.valueOf(selectedIndex.length));
            ThreadService.execute(() -> {
                AccountBookInfo acctBook = this.updateAccountBookInfoCache(accountBookInfo);
                if (needEndInit.booleanValue()) {
                    this.handleEndInit(acctBook, selectedIndex);
                } else {
                    this.handleAntiEndInit(acctBook, selectedIndex);
                }
            }, (TaskType)TaskType.GL_ACCOUNT_CURRENT_END_INIT);
        }
    }

    public void handleEndInit(AccountBookInfo accountBookInfo, int[] selectedIndex) {
        this.executeOperate(accountBookInfo, selectedIndex, ENDINIT);
    }

    private void handleAntiEndInit(AccountBookInfo accountBookInfo, int[] selectedIndex) {
        this.executeOperate(accountBookInfo, selectedIndex, ANTIENDINIT);
    }

    private void executeOperate(AccountBookInfo accountBookInfo, int[] selectedIndex, String operationKey) {
        int size = selectedIndex.length;
        if (ENDINIT.equals(operationKey)) {
            this.getView().showLoading(new LocaleString(String.format(ResManager.loadKDString((String)"\u7ed3\u675f\u521d\u59cb\u5316\u5f80\u6765\u79d1\u76ee:%1$s,\u5df2\u5b8c\u6210:%2$s,\u8fdb\u5ea6:%3$s%%", (String)"ReciprocalInitEndInitPlugin_14", (String)"fi-gl-formplugin", (Object[])new Object[0]), size, 0, 0)));
        } else {
            this.getView().showLoading(new LocaleString(String.format(ResManager.loadKDString((String)"\u53cd\u7ed3\u675f\u521d\u59cb\u5316\u5f80\u6765\u79d1\u76ee:%1$s,\u5df2\u5b8c\u6210:%2$s,\u8fdb\u5ea6:%3$s%%", (String)"ReciprocalInitEndInitPlugin_15", (String)"fi-gl-formplugin", (Object[])new Object[0]), size, 0, 0)));
        }
        IDataModel model = this.getModel();
        IDataEntityType dataEntityType = BusinessDataServiceHelper.newDynamicObject((String)"gl_initacccurrent").getDataEntityType();
        MainEntityType mainEntityType = new MainEntityType();
        mainEntityType.setName("gl_initacccurrent");
        mainEntityType.setDisplayName(dataEntityType.getDisplayName());
        LongProp pkProp = new LongProp();
        pkProp.setPrimaryKey(Boolean.TRUE.booleanValue());
        pkProp.setName("id");
        mainEntityType.registerSimpleProperty((DynamicSimpleProperty)pkProp);
        mainEntityType.registerProperty("account", AccountProp.class, null, false);
        mainEntityType.registerProperty("period", BaseDataProp.class, null, false);
        ArrayList<DynamicObject> reciprocalInitStates = new ArrayList<DynamicObject>(size);
        OperationResult operationResultAll = new OperationResult();
        int finishSize = 0;
        int batchSize = 10;
        for (int j = 0; j < size; ++j) {
            ++finishSize;
            DynamicObject rowEntity = model.getEntryRowEntity(ENTRYENTITY, selectedIndex[j]);
            DynamicObject reciprocalInitState = (DynamicObject)mainEntityType.createInstance();
            DynamicObject dynAcct = rowEntity.getDynamicObject("account");
            reciprocalInitState.set("id", (Object)dynAcct.getLong("id"));
            reciprocalInitState.set("account", (Object)dynAcct);
            reciprocalInitState.set("period", (Object)rowEntity.getDynamicObject("period"));
            reciprocalInitStates.add(reciprocalInitState);
            if (reciprocalInitStates.size() % batchSize != 0 && j != size - 1) continue;
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("org", String.valueOf(accountBookInfo.getOrgId()));
            operateOption.setVariableValue("bookstype", String.valueOf(accountBookInfo.getBookTypeId()));
            operateOption.setVariableValue("finishedCountKey", this.finishedCountKey());
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)operationKey, (String)"gl_initacccurrent", (DynamicObject[])reciprocalInitStates.toArray(new DynamicObject[0]), (OperateOption)operateOption);
            if (operationResultAll.isSuccess()) {
                operationResultAll.setSuccess(operationResult.isSuccess());
            }
            operationResultAll.mergeOperateResult(operationResult);
            reciprocalInitStates.clear();
            this.cache.put(this.finishedCountKey(), String.valueOf(finishSize));
        }
        if (operationResultAll.isSuccess()) {
            this.getPageCache().put(IS_FINISH, "true");
            this.getPageCache().put(IS_SUCCESS, "true");
        } else {
            this.getPageCache().put(IS_FINISH, "true");
            this.getPageCache().put(IS_SUCCESS, "false");
            this.getView().getPageCache().put("accountBookInfo", SerializationUtils.serializeToBase64((Object)accountBookInfo));
            this.getView().getPageCache().put("operationResultAll", SerializationUtils.serializeToBase64((Object)operationResultAll));
        }
    }

    private String finishedCountKey() {
        return this.getView().getPageId() + "finishedCount";
    }

    public void onProgress(ProgressEvent progressEvent) {
        int progress;
        int totalCount = StringUtils.isEmpty((CharSequence)this.getPageCache().get(TOTAL_COUNT)) ? 0 : Integer.parseInt(this.getPageCache().get(TOTAL_COUNT));
        int finishedCount = StringUtils.isEmpty((CharSequence)this.cache.get(this.finishedCountKey())) ? 0 : Integer.parseInt(this.cache.get(this.finishedCountKey()));
        boolean isFinish = Boolean.parseBoolean(this.getPageCache().get(IS_FINISH));
        boolean isSuccess = Boolean.parseBoolean(this.getPageCache().get(IS_SUCCESS));
        ProgressBar bar = (ProgressBar)this.getControl(PROGRESSBARAP);
        if (isFinish) {
            bar.stop();
            if (isSuccess) {
                this.getView().hideLoading();
                this.getView().returnDataToParent((Object)"success");
                this.getView().close();
            } else {
                this.getView().hideLoading(Boolean.TRUE.booleanValue());
                try {
                    FormShowParameter param = this.getView().getFormShowParameter();
                    Long accountTableId = (Long)param.getCustomParam("accounttable");
                    AccountBookInfo accountBookInfo = (AccountBookInfo)SerializationUtils.deSerializeFromBase64((String)this.getView().getPageCache().get("accountBookInfo"));
                    OperationResult operationResultAll = (OperationResult)SerializationUtils.deSerializeFromBase64((String)this.getView().getPageCache().get("operationResultAll"));
                    this.refreshEntryEntity(param, accountBookInfo, accountTableId);
                    List successPkIds = operationResultAll.getSuccessPkIds();
                    if (!successPkIds.isEmpty()) {
                        HashMap acctIdNumMap = new HashMap(successPkIds.size());
                        DataSet acctDt = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_accountview", (String)"id, number", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)successPkIds)}, null);
                        acctDt.forEach(a -> acctIdNumMap.put(a.getLong("id"), a.getString("number")));
                        HashMap billNos = new HashMap(successPkIds.size());
                        for (Object successPkId : successPkIds) {
                            billNos.put(successPkId, acctIdNumMap.get(successPkId));
                        }
                        operationResultAll.setBillNos(billNos);
                    }
                    this.getView().showOperationResult(operationResultAll);
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                    this.getView().close();
                }
            }
        } else if (totalCount != 0 && (progress = finishedCount * 100 / totalCount) < 100) {
            this.getView().showLoading(new LocaleString(String.format(ResManager.loadKDString((String)"\u7ed3\u675f\u521d\u59cb\u5316\u5f80\u6765\u79d1\u76ee:%1$s,\u5df2\u5b8c\u6210:%2$s,\u8fdb\u5ea6:%3$s%%", (String)"AccountviewEdit_27", (String)"fi-bd-formplugin", (Object[])new Object[0]), totalCount, finishedCount, progress)));
        }
    }

    private AccountBookInfo updateAccountBookInfoCache(AccountBookInfo accountBookInfo) {
        accountBookInfo = new AccountBookInfo(accountBookInfo.getId());
        this.getPageCache().put("book", GLUtil.toSerializedString((Object)accountBookInfo));
        return accountBookInfo;
    }

    private AccountBookInfo getAccountBookCache() {
        String book = this.getPageCache().get("book");
        if (book != null) {
            return (AccountBookInfo)GLUtil.fromSerializedString((String)book);
        }
        return null;
    }
}

