/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.init;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.exception.KDBizException;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.FlexEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.gl.accountref.utils.BalanceTransferUtils;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.constant.GLField;
import kd.fi.gl.reciprocal.ReciprocalInitUtils;
import kd.fi.gl.reciprocal.ReciprocalUtils;
import kd.fi.gl.util.AssgrpDetailF7Handler;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.PermissonType;

public class ReciprocalInitListPlugin
extends AbstractListPlugin
implements BeforeF7SelectListener {
    private static final String NEED_END_INIT = "needEndInit";
    private static final String ANTIENDINIT = "antiendinit";
    private static final String ENDINIT = "endinit";
    private static final String DIFFDISPLAY = "diffdisplay";
    private static final String IMPORTBAL = "importbal";
    private static final String IMPORTBALALL = "importbalall";
    private static final String EXPORTDATAALL = "exportdataall";
    private static final String DELETEALL = "deleteall";
    private static final String EXPORTLIST = "exportlist";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addBeforeF7Select("account", "endinitperiod", "currency");
        this.addItemClickListeners(new String[]{IMPORTBAL, EXPORTDATAALL, DELETEALL});
        FlexEdit flex = (FlexEdit)this.getControl("assgrp");
        flex.registerBeforeF7SelectListener(new BeforeF7SelectListener(){

            public void beforeF7Select(BeforeF7SelectEvent e) {
                AssgrpDetailF7Handler handler = new AssgrpDetailF7Handler(ReciprocalInitListPlugin.this.getModel());
                handler.handleAssgrpDetail(e);
            }
        });
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        Map filValues = args.getFilterValues();
        List customFils = (List)filValues.get("customfilter");
        if (customFils == null || customFils.size() == 0) {
            return;
        }
        boolean isClear = true;
        Long orgIds = GLUtil.getCustomFilterId((IFormView)this.getView(), (String)"org.id");
        if (null == orgIds) {
            return;
        }
        List comboItems = AccSysUtil.getBookTypeComboByOrg((long)orgIds);
        Long bookTypeId = 0L;
        Long accountTableId = 0L;
        for (Map map : customFils) {
            String fieldName = (String)((List)map.get("FieldName")).get(0);
            List val = (List)map.get("Value");
            if (!"booktype.id".equals(fieldName)) continue;
            if (Objects.isNull(val) || val.isEmpty() || val.get(0).equals("")) break;
            for (ComboItem ci : comboItems) {
                if (!ci.getValue().equals(val.get(0).toString())) continue;
                isClear = false;
                break;
            }
            if (!isClear) continue;
            val.clear();
            if (comboItems.size() > 0) {
                String value = ((ComboItem)comboItems.get(0)).getValue();
                val.add(value);
                this.setPageCache("booktype", value);
                bookTypeId = Long.parseLong(value);
                continue;
            }
            val.add("");
        }
        if (!bookTypeId.equals(0L) && !accountTableId.equals(0L)) {
            this.initData(orgIds, bookTypeId, accountTableId);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "endinit": {
                this.showEndInitForm(true);
                break;
            }
            case "antiendinit": {
                this.showEndInitForm(false);
                break;
            }
            case "importbal": {
                if (this.checkHasInitData(key)) {
                    this.showConfirm(key);
                    break;
                }
                this.importBalance();
                break;
            }
            case "importbalall": {
                if (this.checkHasInitData(key)) {
                    this.showConfirm(key);
                    break;
                }
                this.importBalanceAll();
                break;
            }
            case "exportdataall": {
                if (!EXPORTDATAALL.equals(key)) break;
                this.keyExportDataAllCache(true, EXPORTDATAALL);
                this.getView().invokeOperation(EXPORTLIST);
                break;
            }
            case "deleteall": {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5df2\u53d1\u751f\u6838\u9500\u7684\u521d\u59cb\u5316\u8bb0\u5f55\u4f1a\u81ea\u52a8\u53cd\u6838\u9500\uff0c\u786e\u8ba4\u5168\u90e8\u5220\u9664\uff1f", (String)"ReciprocalInitListPlugin_0", (String)"fi-gl-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(DELETEALL, (IFormPlugin)this));
                break;
            }
        }
        if (!EXPORTDATAALL.equals(key)) {
            this.keyExportDataAllCache(true, null);
        }
    }

    private void deleteAllReciInit() {
        DynamicObject[] loadData = this.getInitAllAccount();
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"delete", (String)"gl_initacccurrent", (DynamicObject[])loadData, (OperateOption)OperateOption.create());
        if (operationResult.getBillCount() == 1) {
            if (operationResult.getSuccessPkIds().size() == 1) {
                operationResult.setMessage(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"ReciprocalInitListPlugin_27", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            } else {
                operationResult.setMessage(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\u3002", (String)"ReciprocalInitListPlugin_28", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            }
        }
        if (operationResult.getBillCount() > 0) {
            this.getView().showOperationResult(operationResult);
        }
        this.getView().invokeOperation("refresh");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate source = (AbstractOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if (!EXPORTLIST.equals(operateKey)) {
            this.keyExportDataAllCache(true, null);
        }
        switch (operateKey) {
            case "modify": {
                ListSelectedRowCollection data = args.getListSelectedData();
                if (data.size() == 1) break;
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u6761\u6570\u636e\u3002", (String)"ReciprocalInitListPlugin_1", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void showConfirm(String operateKey) {
        this.getView().showConfirm(ResManager.loadKDString((String)"\u5bfc\u5165\u6838\u7b97\u7ef4\u5ea6\u4f59\u989d\u5c06\u5220\u9664\u79d1\u76ee\u4e0b\u539f\u6709\u5f80\u6765\u521d\u59cb\u5316\u6570\u636e\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ReciprocalInitListPlugin_2", (String)"fi-gl-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(operateKey, (IFormPlugin)this));
    }

    private boolean checkHasInitData(String opKey) {
        IDataModel model = this.getModel();
        AccountBookInfo accountBookInfo = this.getAccountBookCache();
        Set<Long> assIdSet = this.handleMainAssgrp(model);
        DynamicObject currency = (DynamicObject)model.getValue("currency");
        boolean existInit = false;
        if (IMPORTBAL.equals(opKey)) {
            DynamicObject account = (DynamicObject)model.getValue("account");
            if (account == null) {
                return false;
            }
            existInit = this.existReciInitData(account, assIdSet, currency, accountBookInfo);
        } else {
            DynamicObject[] dyAccounts;
            for (DynamicObject account : dyAccounts = this.getAllAccount()) {
                existInit = this.existReciInitData(account, assIdSet, currency, accountBookInfo);
                if (existInit) continue;
                return existInit;
            }
        }
        return existInit;
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String result = e.getResultValue();
        String callBackId = e.getCallBackId();
        if ("Yes".equals(result)) {
            switch (callBackId) {
                case "importbal": {
                    this.importBalance();
                    break;
                }
                case "importbalall": {
                    this.importBalanceAll();
                    break;
                }
                case "deleteall": {
                    this.deleteAllReciInit();
                    break;
                }
            }
        }
    }

    private void showEndInitForm(boolean needEndInit) {
        DynamicObject account;
        String appId;
        String orgId = this.getPageCache("org");
        if (Objects.isNull(orgId) || "".equals(orgId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u8d26\u7c3f\u4fe1\u606f\u3002", (String)"ReciprocalInitListPlugin_21", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        }
        if (needEndInit) {
            appId = this.getView().getFormShowParameter().getAppId();
            if (PermissionServiceHelper.checkPermission((long)RequestContext.get().getCurrUserId(), (String)"DIM_ORG", (long)Long.parseLong(orgId), (String)appId, (String)"gl_initacccurrent", (String)"4730fc9f000005ae") == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u7ed3\u675f\u521d\u59cb\u5316\u201d\u7684\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ReciprocalInitEndInitPlugin_12", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                return;
            }
        } else {
            appId = this.getView().getFormShowParameter().getAppId();
            if (PermissionServiceHelper.checkPermission((long)RequestContext.get().getCurrUserId(), (String)"DIM_ORG", (long)Long.parseLong(orgId), (String)appId, (String)"gl_initacccurrent", (String)"4730fc9f000006ae") == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u53cd\u521d\u59cb\u5316\u201d\u7684\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ReciprocalInitEndInitPlugin_13", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        FormShowParameter param = new FormShowParameter();
        param.setFormId("gl_reciprocal_endinit");
        param.setCaption(ResManager.loadKDString((String)"\u5f80\u6765\u79d1\u76ee\u521d\u59cb\u5316\u671f\u95f4", (String)"ReciprocalInitListPlugin_4", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        param.setCustomParam(NEED_END_INIT, (Object)needEndInit);
        Long accountTableId = this.getAccountTableId();
        param.setCustomParam("accounttable", (Object)accountTableId);
        AccountBookInfo accountBookInfo = this.getAccountBookCache();
        if (accountBookInfo == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u521b\u5efa\u7ec4\u7ec7\u5bf9\u5e94\u8d26\u7c3f\u3002", (String)"ReciprocalInitListPlugin_5", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!needEndInit && BalanceTransferUtils.isAccountTableVersion((Long)accountBookInfo.getOrgId(), (Long)accountBookInfo.getBookTypeId()) && !accountTableId.equals(accountBookInfo.getAccountTableId())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d26\u7c3f\u5df2\u8fdb\u884c\u79d1\u76ee\u8868\u7248\u672c\u5316\uff0c\u65e0\u6cd5\u53cd\u521d\u59cb\u5316\u3002", (String)"ReciprocalInitListPlugin_6", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        if ((accountBookInfo = this.updateAccountBookInfoCache(accountBookInfo)) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u521b\u5efa\u7ec4\u7ec7\u5bf9\u5e94\u8d26\u7c3f\u3002", (String)"ReciprocalInitListPlugin_5", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        String enable = accountBookInfo.getEnable();
        if ("0".equals(enable)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d26\u7c3f\u5df2\u7981\u7528\uff0c\u65e0\u6cd5\u8fdb\u884c\u6b64\u64cd\u4f5c\u3002", (String)"ReciprocalInitListPlugin_7", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        Long bookId = accountBookInfo.getId();
        param.setCustomParam("book", (Object)bookId);
        DynamicObject curAccount = (DynamicObject)this.getModel().getValue("account");
        if (curAccount != null) {
            param.setCustomParam("account", (Object)curAccount.getLong("id"));
        } else {
            param.setCustomParam("account", null);
        }
        DynamicObjectCollection accountColl = this.getAccheckAccount(accountBookInfo.getOrgId(), accountBookInfo.getBookTypeId(), accountTableId, true);
        DynamicObject dynamicObject = account = accountColl.size() > 0 ? (DynamicObject)accountColl.get(0) : null;
        if (account == null && needEndInit) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981\u7ed3\u675f\u521d\u59cb\u5316\u7684\u5f80\u6765\u6838\u7b97\u7684\u79d1\u76ee\u3002", (String)"ReciprocalInitListPlugin_8", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<QFilter> acctQFilters = new ArrayList<QFilter>(6);
        acctQFilters.addAll(ReciprocalUtils.getAccAccountFilter((Long)accountBookInfo.getOrgId(), (Long)accountBookInfo.getBookTypeId(), (Long)accountTableId));
        acctQFilters.add(new QFilter("enable", "=", (Object)"1"));
        DataSet dSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_accountview", (String)"id acct", (QFilter[])acctQFilters.toArray(new QFilter[0]), null);
        DataSet endInitSet = ReciprocalInitUtils.queryIsEndInitReciprocalInit((boolean)needEndInit, (Long)accountBookInfo.getOrgId(), (Long)accountBookInfo.getBookTypeId(), (Long)accountTableId);
        try (DataSet ds = endInitSet.join(dSet, JoinType.INNER).on("id", "acct").select(new String[]{"id", "endinitperiod"}).finish();){
            int count;
            if (ds != null && (count = ds.copy().count("id", true)) == 0) {
                String msg = needEndInit ? ResManager.loadKDString((String)"\u7ed3\u675f", (String)"ReciprocalInitListPlugin_9", (String)"fi-gl-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u53cd", (String)"ReciprocalInitListPlugin_10", (String)"fi-gl-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981%s\u521d\u59cb\u5316\u7684\u5f80\u6765\u6838\u7b97\u79d1\u76ee\u3002", (String)"ReciprocalInitListPlugin_11", (String)"fi-gl-formplugin", (Object[])new Object[]{msg}));
                return;
            }
        }
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ENDINIT));
        this.setPageCache(NEED_END_INIT, needEndInit);
        this.getView().showForm(param);
    }

    private Long getAccountTableId() {
        String strAcctTbl = this.getPageCache("accounttable");
        Long accountTableId = 0L;
        if (!StringUtils.isEmpty((String)strAcctTbl)) {
            accountTableId = Long.parseLong(strAcctTbl);
        }
        return accountTableId;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "endinit": {
                DynamicObject account = (DynamicObject)this.getModel().getValue("account");
                if ("success".equals(closedCallBackEvent.getReturnData())) {
                    String needEndInit = this.getPageCache(NEED_END_INIT);
                    String msg = "true".equals(needEndInit) ? ResManager.loadKDString((String)"\u7ed3\u675f", (String)"ReciprocalInitListPlugin_9", (String)"fi-gl-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u53cd", (String)"ReciprocalInitListPlugin_10", (String)"fi-gl-formplugin", (Object[])new Object[0]);
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"%s\u521d\u59cb\u5316\u6210\u529f\u3002", (String)"ReciprocalInitListPlugin_13", (String)"fi-gl-formplugin", (Object[])new Object[]{msg}));
                }
                this.handleToolbarByAccount(account);
                break;
            }
        }
    }

    private void getBalanceToCompare() {
        IDataModel model = this.getModel();
        DynamicObject account = (DynamicObject)model.getValue("account");
        Long[] currencyIds = this.getCurrencyIds(model);
        Long periodId = this.getPeriodId(model, false);
        boolean hideFlexPanel = account == null || currencyIds == null || periodId == null;
        this.getView().setVisible(Boolean.valueOf(!hideFlexPanel), new String[]{DIFFDISPLAY});
        if (hideFlexPanel) {
            return;
        }
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        DynamicObject assgrp = (DynamicObject)model.getValue("assgrp");
        if (assgrp != null && assgrp.getLong("id") != 0L) {
            String assgrpValue = assgrp.getString("value");
            customParams.put("assgrp", assgrpValue);
        }
        customParams.put("account", account.getLong("id"));
        customParams.put("currency", currencyIds[0].toString());
        customParams.put("period", periodId.toString());
        AccountBookInfo accountBookInfo = this.getAccountBookCache();
        if (accountBookInfo != null) {
            customParams.put("book", accountBookInfo.getId());
        }
        this.showInContainerView(DIFFDISPLAY, "gl_reci_initdiff", customParams);
    }

    private void showInContainerView(String tab, String form, Map<String, Object> customParams) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        formShowParameter.getOpenStyle().setTargetKey(tab);
        formShowParameter.setFormId(form);
        formShowParameter.setCustomParams(customParams);
        this.getView().showForm(formShowParameter);
    }

    private void importBalance() {
        DynamicObject account = (DynamicObject)this.getModel().getValue("account");
        if (account == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5165\u79d1\u76ee\u3002", (String)"ReciprocalInitListPlugin_3", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        Long periodId = (Long)this.getModel().getValue(GLField.id_((String)"endinitperiod"));
        if (periodId == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u586b\u5165\u521d\u59cb\u5316\u671f\u95f4\u3002", (String)"ReciprocalInitListPlugin_16", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        }
        String appId = this.getView().getFormShowParameter().getAppId();
        if (PermissionServiceHelper.checkPermission((long)RequestContext.get().getCurrUserId(), (String)"DIM_ORG", (long)Long.parseLong(this.getPageCache("org")), (String)appId, (String)"gl_initacccurrent", (String)"4730fc9f000003ae") == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u5bfc\u5165\u6838\u7b97\u7ef4\u5ea6\u4f59\u989d\u201d\u7684\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ReciprocalInitListPlugin_25", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        this.importBalance(new DynamicObject[]{account});
    }

    private void importBalanceAll() {
        Long periodId = (Long)this.getModel().getValue(GLField.id_((String)"endinitperiod"));
        if (periodId == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u586b\u5165\u521d\u59cb\u5316\u671f\u95f4\u3002", (String)"ReciprocalInitListPlugin_16", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        }
        String appId = this.getView().getFormShowParameter().getAppId();
        String orgID = this.getPageCache("org");
        if (Objects.isNull(orgID)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u586b\u5165\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"ReciprocalInitListPlugin_29", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        }
        if (PermissionServiceHelper.checkPermission((long)Long.parseLong(RequestContext.get().getUserId()), (String)"DIM_ORG", (long)Long.parseLong(orgID), (String)appId, (String)"gl_initacccurrent", (String)"4730fc9f000003ae") == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u5bfc\u5165\u5168\u90e8\u6838\u7b97\u7ef4\u5ea6\u201d\u7684\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ReciprocalInitListPlugin_26", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject[] accounts = this.getAllAccount();
        this.importBalance(accounts);
    }

    private void importBalance(DynamicObject[] accounts) {
        AccountBookInfo accountBookCache = this.getAccountBookCache();
        if (accountBookCache == null || this.updateAccountBookInfoCache(accountBookCache) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u521b\u5efa\u7ec4\u7ec7\u5bf9\u5e94\u8d26\u7c3f\u3002", (String)"ReciprocalInitListPlugin_5", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        IDataModel model = this.getModel();
        ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>(8);
        DynamicObject assgrp = (DynamicObject)model.getValue("assgrp");
        DynamicObject currency = (DynamicObject)model.getValue("currency");
        for (DynamicObject account : accounts) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"gl_initacccurrent");
            dynamicObject.set("account", (Object)account);
            dynamicObject.set("currency", (Object)currency);
            dynamicObject.set("assgrp", (Object)assgrp);
            dynamicObjects.add(dynamicObject);
        }
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("org", this.getPageCache("org"));
        operateOption.setVariableValue("bookstype", this.getPageCache("booktype"));
        operateOption.setVariableValue("period", String.valueOf(model.getValue(GLField.id_((String)"endinitperiod"))));
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)IMPORTBAL, (String)"gl_initacccurrent", (DynamicObject[])dynamicObjects.toArray(new DynamicObject[0]), (OperateOption)operateOption);
        ValidateResultCollection validateResult = operationResult.getValidateResult();
        if (!validateResult.isSuccess()) {
            this.getView().showOperationResult(operationResult);
        } else {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6838\u7b97\u7ef4\u5ea6\u4f59\u989d\u6210\u529f\u3002", (String)"ReciprocalInitListPlugin_15", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        }
        this.updateReciprocalList();
    }

    private boolean existReciInitData(DynamicObject account, Set<Long> assIdSet, DynamicObject currency, AccountBookInfo accountBookInfo) {
        List<QFilter> filter = this.genExistInitFilter(account, assIdSet, currency, accountBookInfo);
        boolean existInit = QueryServiceHelper.exists((String)"gl_initacccurrent", (QFilter[])filter.toArray(new QFilter[0]));
        return existInit;
    }

    public List<QFilter> genExistInitFilter(DynamicObject account, Set<Long> assIdSet, DynamicObject currency, AccountBookInfo accountBookInfo) {
        ArrayList<QFilter> filter = new ArrayList<QFilter>();
        QFilter orgFilter = new QFilter("org", "=", (Object)accountBookInfo.getOrgId());
        QFilter bookTypeFilter = new QFilter("booktype", "=", (Object)accountBookInfo.getBookTypeId());
        QFilter acctFilter = new QFilter("account.masterid", "=", account.get("masterid"));
        if (assIdSet != null) {
            acctFilter.and(new QFilter("assgrp", "in", assIdSet));
        }
        if (currency != null) {
            acctFilter.and(new QFilter("currency", "=", currency.get("id")));
        }
        filter.add(orgFilter);
        filter.add(bookTypeFilter);
        filter.add(acctFilter);
        return filter;
    }

    private Long[] getCurrencyIds(IDataModel model) {
        DynamicObject currency = (DynamicObject)model.getValue("currency");
        Long[] currencyIds = null;
        if (currency != null) {
            currencyIds = new Long[]{currency.getLong("id")};
        }
        return currencyIds;
    }

    private Long getPeriodId(IDataModel model, boolean isShowTip) {
        Long periodId = (Long)model.getValue(GLField.id_((String)"endinitperiod"));
        if (periodId == null) {
            if (isShowTip) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u586b\u5165\u521d\u59cb\u5316\u671f\u95f4\u3002", (String)"ReciprocalInitListPlugin_16", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            }
            return null;
        }
        return periodId;
    }

    private void addBeforeF7Select(String ... fieldNames) {
        for (int i = 0; i < fieldNames.length; ++i) {
            String fieldName = fieldNames[i];
            BasedataEdit baseEdit = (BasedataEdit)this.getControl(fieldName);
            baseEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        if ("org.name".equals(args.getFieldName())) {
            FilterColumn column = (FilterColumn)args.getSource();
            String entityId = column.getEntityType().getName();
            QFilter filter = AccSysUtil.getAccountingOrgFilter((String)entityId, (boolean)false, (PermissonType)PermissonType.VIEW);
            args.getQFilters().add(filter);
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        Long orgId = GLUtil.getCustomFilterId((IFormView)this.getView(), (String)"org.id");
        Long bookTypeId = GLUtil.getCustomFilterId((IFormView)this.getView(), (String)"booktype.id");
        Long acctTblId = GLUtil.getCustomFilterId((IFormView)this.getView(), (String)"accounttable.id");
        List listFilterColumns = args.getFilterContainerInitEvent().getCommonFilterColumns();
        Iterator listFilterIter = listFilterColumns.iterator();
        while (listFilterIter.hasNext()) {
            String fieldName;
            FilterColumn filterColumn = (FilterColumn)listFilterIter.next();
            CommonFilterColumn commFilter = (CommonFilterColumn)filterColumn;
            switch (fieldName = commFilter.getFieldName()) {
                case "org.name": {
                    Set comboOrgIds;
                    FormShowParameter showParameter = this.getView().getFormShowParameter();
                    String imicOrgId = (String)showParameter.getCustomParam("imicdimension_bos_org");
                    if (StringUtils.isNotEmpty((String)imicOrgId)) {
                        orgId = Long.parseLong(imicOrgId);
                    } else if (orgId == null && (comboOrgIds = AccSysUtil.getAllOrgIdByComboItems((Collection)commFilter.getComboItems())).size() > 0) {
                        long bussOrg = AccSysUtil.getDefaultOrgId((String)"gl_initacccurrent", (boolean)false, (PermissonType)PermissonType.VIEW);
                        orgId = comboOrgIds.contains(bussOrg) ? Long.valueOf(bussOrg) : (Long)new ArrayList(comboOrgIds).get(0);
                    }
                    if (orgId == null) break;
                    commFilter.setDefaultValue(orgId.toString());
                    this.setPageCache("org", orgId);
                    break;
                }
                case "booktype.name": {
                    Long defaultOrg = orgId;
                    if (defaultOrg == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u6709\u6743\u9650\u7684\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"ReciprocalInitListPlugin_17", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    List bookTypeCombos = AccSysUtil.getBookTypeComboByOrg((long)defaultOrg);
                    commFilter.setComboItems(bookTypeCombos);
                    if (!bookTypeCombos.isEmpty()) {
                        if (bookTypeId != null) {
                            boolean isMatch = false;
                            for (ComboItem comboItem : bookTypeCombos) {
                                if (!bookTypeId.equals(Long.parseLong(comboItem.getValue()))) continue;
                                isMatch = true;
                                break;
                            }
                            if (!isMatch) {
                                bookTypeId = Long.parseLong(((ComboItem)bookTypeCombos.get(0)).getValue());
                            }
                        } else {
                            bookTypeId = Long.parseLong(((ComboItem)bookTypeCombos.get(0)).getValue());
                        }
                    }
                    if (AccSysUtil.getAllBookTypeCount() == 1) {
                        listFilterIter.remove();
                    }
                    if (bookTypeId == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6838\u7b97\u7ec4\u7ec7\u4e0b\u65e0\u6709\u6743\u9650\u7684\u8d26\u7c3f\u3002", (String)"ReciprocalInitListPlugin_18", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    this.setPageCache("booktype", bookTypeId);
                    commFilter.setDefaultValue(bookTypeId.toString());
                    break;
                }
                case "accounttable.name": {
                    List<ComboItem> accTblComboItems = this.getAccountTableItems(orgId, bookTypeId);
                    commFilter.setComboItems(accTblComboItems);
                    if (accTblComboItems.size() == 1) {
                        listFilterIter.remove();
                    }
                    if (!accTblComboItems.isEmpty()) {
                        if (acctTblId != null) {
                            boolean isMatch = false;
                            for (ComboItem comboItem : accTblComboItems) {
                                if (!acctTblId.equals(Long.parseLong(comboItem.getValue()))) continue;
                                isMatch = true;
                                break;
                            }
                            if (!isMatch) {
                                acctTblId = Long.parseLong(accTblComboItems.get(0).getValue());
                            }
                        } else {
                            acctTblId = Long.parseLong(accTblComboItems.get(0).getValue());
                        }
                    }
                    if (acctTblId == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u7684\u8d26\u7c3f\u7c7b\u578b\u4e0b\u65e0\u53ef\u7528\u7684\u79d1\u76ee\u8868\u3002", (String)"ReciprocalInitListPlugin_19", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    commFilter.setDefaultValue(acctTblId.toString());
                    this.setPageCache("accounttable", acctTblId);
                }
            }
        }
        this.initData(orgId, bookTypeId, acctTblId);
    }

    private List<ComboItem> getAccountTableItems(Long orgId, Long bookTypeId) {
        Set accountTblIds = BalanceTransferUtils.queryAccountTableIds((Long)orgId, (Long)bookTypeId);
        ArrayList<ComboItem> accTblComboItems = new ArrayList<ComboItem>(accountTblIds.size());
        try (DataSet tableSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_accounttable", (String)"id,name", (QFilter[])new QFilter("id", "in", (Object)accountTblIds).toArray(), null);){
            for (Row row : tableSet) {
                ComboItem com = new ComboItem(new LocaleString(row.getString("name")), String.valueOf(row.getLong("id")));
                accTblComboItems.add(com);
            }
        }
        return accTblComboItems;
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        List orgIds;
        List ids;
        super.filterContainerBeforeF7Select(args);
        String field = args.getFieldName();
        if (field.startsWith("org.")) {
            List pkSet = AccSysUtil.getAcctOrgPkList((String)"gl_initacccurrent", (boolean)false, (PermissonType)PermissonType.VIEW);
            args.getQfilters().add(new QFilter("id", "in", (Object)pkSet));
        } else if (field.startsWith("booktype.") && null != (ids = AccSysUtil.getBookTypeIdList((List)(orgIds = GLUtil.getCustomFilterIds((IFormView)this.getView(), (String)"org.id"))))) {
            args.addCustomQFilter(new QFilter("id", "in", (Object)ids));
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        ListShowParameter list = (ListShowParameter)e.getFormShowParameter();
        if (list != null) {
            List lstFilters = list.getListFilterParameter().getQFilters();
            switch (key) {
                case "account": {
                    AccountBookInfo bookInfo = this.getAccountBookCache();
                    if (bookInfo == null) break;
                    Long accountTableId = this.getAccountTableId();
                    lstFilters.addAll(ReciprocalUtils.getAccAccountFilter((Long)bookInfo.getOrgId(), (Long)bookInfo.getBookTypeId(), (Long)accountTableId));
                    list.setCustomParam("acct_filter", (Object)true);
                    break;
                }
                case "endinitperiod": {
                    AccountBookInfo bookInfo = this.getAccountBookCache();
                    if (bookInfo == null) break;
                    lstFilters.add(new QFilter("periodtype", "=", (Object)bookInfo.getPeriodTypeId()));
                    break;
                }
                case "currency": {
                    DynamicObject account = (DynamicObject)this.getModel().getValue("account");
                    if (account == null) break;
                    ArrayList<Long> ids = new ArrayList<Long>();
                    AccountBookInfo accountBookInfo = this.getAccountBookCache();
                    if (accountBookInfo != null) {
                        Long currencyId = accountBookInfo.getBaseCurrencyId();
                        ids.add(currencyId);
                    }
                    if (!"descurrency".equals(account.get("acctcurrency"))) break;
                    DynamicObjectCollection coll = (DynamicObjectCollection)account.get("currencyentry");
                    for (DynamicObject dyn : coll) {
                        Long acctCur = dyn.getLong("currency_id");
                        ids.add(acctCur);
                    }
                    QFilter filter = new QFilter("id", "in", ids);
                    lstFilters.add(filter);
                    break;
                }
            }
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        switch (e.getParameter().getBillStatus()) {
            case ADDNEW: {
                this.openAddNew(e);
                break;
            }
            case EDIT: {
                this.openEdit(e);
                break;
            }
        }
    }

    private void openEdit(BeforeShowBillFormEvent e) {
        BillShowParameter showParam = e.getParameter();
        showParam.setCaption(ResManager.loadKDString((String)"\u5f80\u6765\u4f59\u989d\u521d\u59cb\u5316", (String)"ReciprocalInitListPlugin_20", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        OpenStyle openStyle = showParam.getOpenStyle();
        openStyle.setShowType(ShowType.Modal);
        showParam.setOpenStyle(openStyle);
    }

    private void openAddNew(BeforeShowBillFormEvent e) {
        AccountBookInfo bookInfo = this.getAccountBookCache();
        if (bookInfo == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u8d26\u7c3f\u4fe1\u606f\u3002", (String)"ReciprocalInitListPlugin_21", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        }
        BillShowParameter showParam = e.getParameter();
        IDataModel model = this.getModel();
        DynamicObject account = (DynamicObject)model.getValue("account");
        if (account == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u79d1\u76ee\u3002", (String)"ReciprocalInitListPlugin_22", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        }
        Long acctId = account.getLong("id");
        showParam.setCustomParam("account", (Object)acctId);
        Long accountTableId = this.getAccountTableId();
        showParam.setCustomParam("accounttable", (Object)accountTableId);
        String acctName = account.getString("number") + account.getString("fullname");
        showParam.setCustomParam("acctName", (Object)acctName);
        DynamicObject currency = (DynamicObject)model.getValue("currency");
        if (currency == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5e01\u79cd\u3002", (String)"ReciprocalInitListPlugin_23", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        }
        DynamicObject endInitPeriod = (DynamicObject)model.getValue("endinitperiod");
        if (endInitPeriod != null) {
            Date date = endInitPeriod.getDate("begindate");
            date = new Date(date.getTime() - 86400000L);
            showParam.setCustomParam("date", (Object)date);
        }
        Long currencyId = currency.getLong("id");
        showParam.setCustomParam("currency", (Object)currencyId);
        Long assgrpId = (Long)model.getValue(GLField.id_((String)"assgrp"));
        showParam.setCustomParam("assgrp", (Object)assgrpId);
        showParam.setCaption(ResManager.loadKDString((String)"\u5f80\u6765\u4f59\u989d\u521d\u59cb\u5316--%s", (String)"ReciprocalInitListPlugin_24", (String)"fi-gl-formplugin", (Object[])new Object[]{acctName}));
        OpenStyle openStyle = showParam.getOpenStyle();
        openStyle.setShowType(ShowType.Modal);
        showParam.setOpenStyle(openStyle);
        showParam.getPkId();
        showParam.setCustomParam("book", (Object)GLUtil.toSerializedString((Object)bookInfo));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataEntityProperty prop = e.getProperty();
        String key = prop.getName();
        Object value = e.getChangeSet()[0].getNewValue();
        switch (key) {
            case "account": {
                if (value == null) {
                    IDataModel model = this.getModel();
                    model.beginInit();
                    model.setValue(key, e.getChangeSet()[0].getOldValue());
                    model.endInit();
                    break;
                }
                DynamicObject acct = (DynamicObject)value;
                if ("nocurrency".equals(acct.get("acctcurrency"))) {
                    AccountBookInfo accountBookInfo = this.getAccountBookCache();
                    if (accountBookInfo != null) {
                        IDataModel model = this.getModel();
                        model.setValue("currency", (Object)accountBookInfo.getBaseCurrencyId());
                    }
                    this.getView().setEnable(Boolean.valueOf(false), new String[]{"currency"});
                    break;
                }
                if ("descurrency".equals(acct.get("acctcurrency"))) {
                    AccountBookInfo accountBookInfo = this.getAccountBookCache();
                    Long currencyId = null;
                    if (accountBookInfo != null) {
                        currencyId = accountBookInfo.getBaseCurrencyId();
                    }
                    DynamicObjectCollection coll = (DynamicObjectCollection)acct.get("currencyentry");
                    DynamicObject descurrencyDyn = (DynamicObject)coll.get(0);
                    Long acctCur = descurrencyDyn.getLong("currency_id");
                    for (DynamicObject dyn : coll) {
                        Long currency_id = dyn.getLong("currency_id");
                        if (!currency_id.equals(currencyId)) continue;
                        acctCur = currencyId;
                        break;
                    }
                    IDataModel model = this.getModel();
                    model.setValue("currency", (Object)acctCur);
                    this.getView().setEnable(Boolean.valueOf(true), new String[]{"currency"});
                    break;
                }
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"currency"});
                break;
            }
        }
        this.keyExportDataAllCache(true, null);
        this.updateReciprocalList();
    }

    private void handleToolbarByAccount(DynamicObject account) {
        DynamicObject accountOne;
        QFilter filter = new QFilter("account.masterid", "=", account.get("masterid"));
        filter.and(new QFilter("isendinit", "=", (Object)true));
        AccountBookInfo accountBookInfo = this.getAccountBookCache();
        if (null == accountBookInfo) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u521b\u5efa\u7ec4\u7ec7\u5bf9\u5e94\u8d26\u7c3f\u3002", (String)"ReciprocalInitListPlugin_5", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            this.getView().setEnable(Boolean.valueOf(false), new String[]{ENDINIT});
            return;
        }
        if (accountBookInfo != null) {
            filter.and(new QFilter("booktype", "=", (Object)accountBookInfo.getBookTypeId()));
            filter.and(new QFilter("org", "=", (Object)accountBookInfo.getOrgId()));
        }
        boolean isEndInit = QueryServiceHelper.exists((String)"gl_reci_init_state", (QFilter[])filter.toArray());
        Long accountTableId = this.getAccountTableId();
        if (!accountTableId.equals(accountBookInfo.getAccountTableId())) {
            isEndInit = true;
        }
        this.getView().setEnable(Boolean.valueOf(!isEndInit), new String[]{"new", "import", IMPORTBAL, "delete", "modify", DELETEALL, IMPORTBALALL});
        this.getView().setEnable(Boolean.valueOf(true), new String[]{ENDINIT});
        if (!accountTableId.equals(accountBookInfo.getAccountTableId())) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{ENDINIT});
        }
        if ((accountBookInfo = this.updateAccountBookInfoCache(accountBookInfo)) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u521b\u5efa\u7ec4\u7ec7\u5bf9\u5e94\u8d26\u7c3f\u3002", (String)"ReciprocalInitListPlugin_5", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        String enable = accountBookInfo.getEnable();
        if ("0".equals(enable)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{ENDINIT});
            return;
        }
        DynamicObjectCollection accountColl = this.getAccheckAccount(accountBookInfo.getOrgId(), accountBookInfo.getBookTypeId(), accountTableId, true);
        DynamicObject dynamicObject = accountOne = accountColl.size() > 0 ? (DynamicObject)accountColl.get(0) : null;
        if (null == accountOne) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{ENDINIT});
            return;
        }
        DataSet dSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_accountview", (String)"id acct", (QFilter[])ReciprocalUtils.getAccAccountFilter((Long)accountBookInfo.getOrgId(), (Long)accountBookInfo.getBookTypeId(), (Long)accountTableId).toArray(new QFilter[0]), null);
        DataSet endInitSet = ReciprocalInitUtils.queryIsEndInitReciprocalInit((boolean)true, (Long)accountBookInfo.getOrgId(), (Long)accountBookInfo.getBookTypeId(), (Long)accountTableId);
        try (DataSet ds = endInitSet.join(dSet, JoinType.INNER).on("id", "acct").select(new String[]{"id", "endinitperiod"}).finish();){
            int count;
            if (ds != null && (count = ds.copy().count("id", true)) == 0) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{ENDINIT});
                return;
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        String string;
        DynamicObject currency;
        super.setFilter(e);
        IDataModel model = this.getModel();
        DynamicObject account = (DynamicObject)model.getValue("account");
        if (account != null) {
            Object acctId = account.get("masterid");
            e.addCustomQFilter(new QFilter("account.masterid", "=", acctId));
            this.handleToolbarByAccount(account);
            AccountBookInfo bookInfo = this.getAccountBookCache();
            if (null != bookInfo) {
                this.setEndInitPeriodByAcct(bookInfo, model, acctId);
                this.getView().updateView("endinitperiod");
            }
        } else {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{ENDINIT});
        }
        Set<Long> assIdSet = this.handleMainAssgrp(model);
        if (assIdSet != null) {
            e.addCustomQFilter(new QFilter("assgrp", "in", assIdSet));
        }
        if ((currency = (DynamicObject)model.getValue("currency")) != null) {
            e.addCustomQFilter(new QFilter("currency", "=", currency.get("id")));
        }
        if (EXPORTDATAALL.equals(string = this.keyExportDataAllCache(false, null))) {
            e.getCustomQFilters().clear();
            BillList billList = (BillList)this.getControl("billlistap");
            AbstractGrid.GridState entryState = billList.getEntryState();
            entryState.setSelectAllRows(true);
        }
        this.getBalanceToCompare();
    }

    private Set<Long> handleMainAssgrp(IDataModel model) {
        DynamicObject assgrp = (DynamicObject)model.getValue("assgrp");
        HashSet<Long> assIdSet = null;
        if (assgrp != null && assgrp.getLong("id") != 0L) {
            assIdSet = new HashSet<Long>();
            String assgrpValue = assgrp.getString("value");
            JSONObject assistMap = JSON.parseObject((String)assgrpValue);
            try (DataSet assistDs = this.queryAssistSet((Map<String, Object>)assistMap);){
                if (assistDs != null) {
                    for (Row row : assistDs) {
                        Long assId = row.getLong("assistId");
                        assIdSet.add(assId);
                    }
                }
            }
        }
        return assIdSet;
    }

    private DataSet queryAssistSet(Map<String, Object> assistMap) {
        DataSet ds = null;
        String selectFields = "hg assistId";
        for (Map.Entry<String, Object> flexfield : assistMap.entrySet()) {
            Object value = flexfield.getValue();
            if (value == null || StringUtils.isEmpty((String)value.toString()) || "0".equals(value.toString())) continue;
            Long assval = Long.valueOf(value.toString());
            QFilter filter = new QFilter("asstype", "=", (Object)flexfield.getKey()).and("assval", "=", (Object)assval);
            DataSet bdDs = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "queryAssistSet"), (String)"gl_assist_bd", (String)selectFields, (QFilter[])filter.toArray(), null);
            if (ds == null) {
                ds = bdDs;
                continue;
            }
            ds = ds.join(bdDs, JoinType.INNER).on("assistId", "assistId").select(new String[]{"assistId"}).finish();
        }
        return ds;
    }

    private void updateReciprocalList() {
        BillList billList = (BillList)this.getControl("billlistap");
        billList.refresh();
        billList.clearSelection();
    }

    private void setPageCache(String key, Object value) {
        this.getPageCache().put(key, String.valueOf(value));
    }

    private String getPageCache(String key) {
        return this.getPageCache().get(key);
    }

    private AccountBookInfo getAccountBookCache() {
        String book = this.getPageCache("book");
        if (book != null) {
            return (AccountBookInfo)GLUtil.fromSerializedString((String)book);
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u8d26\u7c3f\u4fe1\u606f\u3002", (String)"ReciprocalInitListPlugin_21", (String)"fi-gl-formplugin", (Object[])new Object[0]));
    }

    private void initData(Long orgId, Long bookTypeId, Long accountTableId) {
        AccountBookInfo bookInfo = AccSysUtil.getBookFromAccSys((long)orgId, (long)bookTypeId);
        IDataModel model = this.getModel();
        model.setValue("org", (Object)orgId);
        model.setValue("booktype", (Object)bookTypeId);
        if (bookInfo != null) {
            DynamicObject account;
            this.setPageCache("book", GLUtil.toSerializedString((Object)bookInfo));
            IFormView view = this.getView();
            DynamicObjectCollection accountColl = this.getAccheckAccount(orgId, bookTypeId, accountTableId, true);
            DynamicObject dynamicObject = account = accountColl.size() > 0 ? (DynamicObject)accountColl.get(0) : null;
            if (account != null) {
                Object acctId = account.get("id");
                model.setValue("account", acctId);
                view.setEnable(Boolean.valueOf(true), new String[]{"account"});
                view.setEnable(Boolean.valueOf(true), new String[]{"assgrp"});
            } else {
                model.beginInit();
                model.setValue("account", null);
                model.setValue("assgrp", null);
                model.endInit();
                view.setEnable(Boolean.valueOf(false), new String[]{"account"});
                view.setEnable(Boolean.valueOf(false), new String[]{"assgrp"});
                this.getView().updateView("account");
                this.getView().updateView("assgrp");
            }
            model.setValue("endinitperiod", (Object)bookInfo.getCurPeriodId());
            model.setValue("currency", (Object)bookInfo.getBaseCurrencyId());
        }
    }

    private AccountBookInfo updateAccountBookInfoCache(AccountBookInfo accountBookInfo) {
        if ((accountBookInfo = new AccountBookInfo(accountBookInfo.getId())).getOrgId() == 0L || accountBookInfo.getBookTypeId() == 0L) {
            return null;
        }
        this.getPageCache().put("book", GLUtil.toSerializedString((Object)accountBookInfo));
        return accountBookInfo;
    }

    private void setEndInitPeriodByAcct(AccountBookInfo bookInfo, IDataModel model, Object acctId) {
        ArrayList<QFilter> filter = new ArrayList<QFilter>();
        filter.add(new QFilter("org", "=", (Object)bookInfo.getOrgId()));
        filter.add(new QFilter("booktype", "=", (Object)bookInfo.getBookTypeId()));
        filter.add(new QFilter("account.masterid", "=", acctId));
        DynamicObject initState = QueryServiceHelper.queryOne((String)"gl_reci_init_state", (String)"endinitperiod", (QFilter[])filter.toArray(new QFilter[0]));
        if (initState != null) {
            Long endInitPeriodId = initState.getLong("endinitperiod");
            if (endInitPeriodId != null && endInitPeriodId != 0L) {
                model.setValue("endinitperiod", (Object)endInitPeriodId);
            }
        } else {
            model.setValue("endinitperiod", (Object)bookInfo.getCurPeriodId());
        }
    }

    private DynamicObjectCollection getAccheckAccount(Long orgId, Long bookTypeId, Long accountTableId, boolean isFirst) {
        DynamicObjectCollection accountColl;
        List qFilters = ReciprocalUtils.getAccAccountFilter((Long)orgId, (Long)bookTypeId, (Long)accountTableId);
        if (isFirst) {
            DynamicObject account = QueryServiceHelper.queryOne((String)"bd_accountview", (String)"id", (QFilter[])qFilters.toArray(new QFilter[0]));
            accountColl = new DynamicObjectCollection();
            if (account != null) {
                accountColl.add(0, account);
            }
        } else {
            accountColl = QueryServiceHelper.query((String)"bd_accountview", (String)"id", (QFilter[])qFilters.toArray(new QFilter[0]));
        }
        return accountColl;
    }

    private String keyExportDataAllCache(boolean isSet, String value) {
        if (isSet) {
            this.getPageCache().put(EXPORTDATAALL, value);
            return null;
        }
        return this.getPageCache().get(EXPORTDATAALL);
    }

    private DynamicObject[] getInitAllAccount() {
        QFilter qfOrg = new QFilter("org", "=", this.getModel().getValue("org_id"));
        QFilter qfBooktype = new QFilter("booktype", "=", this.getModel().getValue("booktype_id"));
        QFilter qfEndInitAcct = new QFilter("account.masterid", "not in", this.endInitAccount());
        DynamicObject[] dyAccounts = BusinessDataServiceHelper.load((String)"gl_initacccurrent", (String)"id,reciprocalrecord", (QFilter[])new QFilter[]{qfOrg, qfBooktype, qfEndInitAcct});
        return dyAccounts == null ? new DynamicObject[]{} : dyAccounts;
    }

    private DynamicObject[] getAllAccount() {
        AccountBookInfo bookInfo = this.getAccountBookCache();
        if (bookInfo == null) {
            return new DynamicObject[0];
        }
        Long accountTableId = this.getAccountTableId();
        ArrayList<QFilter> lstFilters = new ArrayList<QFilter>();
        lstFilters.add(new QFilter("masterid", "not in", this.endInitAccount()));
        ReciprocalInitUtils.addReciprocalAccountF7Filter(lstFilters, (Long)bookInfo.getOrgId(), (Long)accountTableId, (boolean)true);
        DynamicObject[] dyAccounts = BusinessDataServiceHelper.load((String)"bd_accountview", (String)"id", (QFilter[])lstFilters.toArray(new QFilter[0]));
        return dyAccounts == null ? new DynamicObject[]{} : dyAccounts;
    }

    private Set<Long> endInitAccount() {
        QFilter filter = new QFilter("org", "=", this.getModel().getValue("org_id"));
        filter.and(new QFilter("booktype", "=", this.getModel().getValue("booktype_id")));
        filter.and(new QFilter("isendinit", "=", (Object)true));
        return QueryServiceHelper.query((String)"gl_reci_init_state", (String)"account.masterid", (QFilter[])filter.toArray()).stream().map(v -> v.getLong("account.masterid")).collect(Collectors.toSet());
    }
}

