/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.listfilter;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class FilterValues {
    private static final String FIELD_NAME = "FieldName";
    private static final String VALUE = "Value";
    private static final String COMPARE = "Compare";
    private static final String Id = "Id";
    private final Map<String, List<Object>> filterValuesMap;
    private final String fieldName;
    private final String compareType;
    private final List<Object> values;

    public FilterValues(Map<String, List<Object>> filterValuesMap) {
        this.filterValuesMap = filterValuesMap;
        List<Object> fieldNames = filterValuesMap.get(FIELD_NAME);
        this.fieldName = fieldNames == null || fieldNames.isEmpty() ? "" : fieldNames.get(0).toString();
        List<Object> compreTypes = filterValuesMap.get(COMPARE);
        this.compareType = compreTypes == null || compreTypes.isEmpty() ? "" : compreTypes.get(0).toString();
        this.values = filterValuesMap.getOrDefault(VALUE, new ArrayList());
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getCompareType() {
        return this.compareType;
    }

    public List<Object> getValues() {
        return this.values;
    }

    public void updateValue() {
        this.filterValuesMap.put(VALUE, this.values);
    }

    public boolean isValueSingle() {
        return this.values.size() == 1 && !"".equals(this.values.get(0));
    }

    public boolean unlimitedValue() {
        return !this.values.isEmpty() && "".equalsIgnoreCase(this.values.get(0).toString());
    }

    public void removeId() {
        this.filterValuesMap.remove(Id);
    }
}

